/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.ValidationRule;
import org.teiid.designer.core.validation.ValidationRuleSet;

public class ValidationRuleSetImpl
implements ValidationRuleSet {
    private static final String EXCEPTION_DURING_VALIDATION_MSG = ModelerCore.Util.getString("ValidationRuleSetImpl.An_exception_was_encountered_during_validation._Check_the_log_for_details._1", new Object[0]);
    private static final String EXCEPTION_DURING_VALIDATION_LOG_MSG = ModelerCore.Util.getString("ValidationRuleSetImpl.An_exception_was_encountered_during_validation._2", new Object[0]);
    private static final ValidationRule[] EMPTY_ARRAY = new ValidationRule[0];
    private ArrayList ruleSet;

    @Override
    public void addRule(ValidationRule rule) {
        if (rule == null) {
            return;
        }
        if (this.ruleSet == null) {
            this.ruleSet = new ArrayList(5);
        }
        boolean exists = false;
        for (Object existingRule : this.ruleSet) {
            if (existingRule != rule) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.ruleSet.add(rule);
        }
    }

    @Override
    public ValidationRule[] getRules() {
        if (!this.hasRules()) {
            return EMPTY_ARRAY;
        }
        ValidationRule[] result = new ValidationRule[this.ruleSet.size()];
        this.ruleSet.toArray(result);
        return result;
    }

    @Override
    public boolean hasRules() {
        return this.ruleSet != null && this.ruleSet.size() > 0;
    }

    @Override
    public void validate(IProgressMonitor progressMonitor, Object object, ValidationContext context) {
        if (!this.hasRules()) {
            return;
        }
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        try {
            int i = 0;
            int n = this.ruleSet.size();
            while (i < n) {
                Collection results;
                if (monitor.isCanceled()) {
                    return;
                }
                if (object instanceof EObject && (results = context.getTargetResults((EObject)object)) != null && !results.isEmpty()) {
                    for (ValidationResult result : results) {
                        if (!result.isFatalResource() && !result.isFatalObject(object)) continue;
                        return;
                    }
                }
                ValidationRule rule = (ValidationRule)this.ruleSet.get(i);
                if (object instanceof EObject) {
                    EObject target = (EObject)object;
                    if (rule instanceof ObjectValidationRule) {
                        ObjectValidationRule objRule = (ObjectValidationRule)rule;
                        objRule.validate(target, context);
                    } else if (rule instanceof StructuralFeatureValidationRule) {
                        StructuralFeatureValidationRule featureRule = (StructuralFeatureValidationRule)rule;
                        EList features = target.eClass().getEAllStructuralFeatures();
                        for (EStructuralFeature feature : features) {
                            if (feature.isVolatile() && feature.isTransient()) continue;
                            featureRule.validate(feature, target, target.eGet(feature), context);
                        }
                    }
                } else if (object instanceof Resource) {
                    Resource resource = (Resource)object;
                    if (rule instanceof ResourceValidationRule) {
                        ResourceValidationRule rscRule = (ResourceValidationRule)rule;
                        rscRule.validate(resource, context);
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            String errMsg = e.getMessage();
            if (errMsg != null && errMsg.length() > 0) {
                this.addProblem(object, 0, 4, e.getMessage(), context);
            }
            this.addProblem(object, 0, 4, EXCEPTION_DURING_VALIDATION_MSG, context);
            ModelerCore.Util.log(4, e, EXCEPTION_DURING_VALIDATION_LOG_MSG);
        }
    }

    private void addProblem(Object object, int code, int severity, String msg, ValidationContext context) {
        ValidationProblemImpl problem = new ValidationProblemImpl(code, severity, msg);
        ValidationResultImpl result = new ValidationResultImpl(object);
        result.addProblem(problem);
        context.addResult(result);
    }
}

