/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.StringNameValidator;

public class CoreValidationRulesUtil {
    public static void validateStringLength(ValidationResult result, int maxLength, String stringToValidate) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator(maxLength);
        String reasonInvalid = validator.checkNameLength(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateStringLength(ValidationResult result, String stringToValidate) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator();
        String reasonInvalid = validator.checkNameLength(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateStringNameChars(ValidationResult result, String stringToValidate, char[] validChars, int invalidCharacterSeverity) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator(validChars);
        CoreValidationRulesUtil.validateStringNameChars(result, stringToValidate, validator, invalidCharacterSeverity);
    }

    public static void validateStringNameChars(ValidationResult result, String stringToValidate, StringNameValidator validator, int invalidCharacterSeverity) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        String reasonInvalid = validator.checkNameCharacters(stringToValidate);
        if (reasonInvalid != null) {
            int severity = invalidCharacterSeverity;
            if (severity != 4 && severity != 1 && severity != 0 && severity != 2) {
                severity = 4;
            }
            ValidationProblemImpl problem = new ValidationProblemImpl(0, severity, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateStringNameChars(ValidationResult result, String stringToValidate, char[] validChars) {
        CoreValidationRulesUtil.validateStringNameChars(result, stringToValidate, validChars, 4);
    }

    public static void validateStringName(ValidationResult result, int maxLength, String stringToValidate, char[] invalidChars) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator(maxLength, invalidChars);
        String reasonInvalid = validator.checkValidName(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }

    public static void validateUniqueness(ValidationContext context, List siblings, int nameFeatureID) {
        StringNameValidator validator = new StringNameValidator();
        CoreValidationRulesUtil.validateUniqueness(context, validator, siblings, nameFeatureID);
    }

    public static void validateUniqueness(ValidationContext context, StringNameValidator validator, List siblings, int nameFeatureID) {
        Map objectCountMap = validator.getDuplicateNamesMap(siblings, nameFeatureID);
        if (objectCountMap.size() > 0) {
            for (EObject eObject : objectCountMap.keySet()) {
                EStructuralFeature eFeature = eObject.eClass().getEStructuralFeature(nameFeatureID);
                String name = (String)eObject.eGet(eFeature);
                Integer count = (Integer)objectCountMap.get(eObject);
                ValidationResultImpl result = new ValidationResultImpl(eObject);
                String msg = validator.isCaseSensitive() ? ModelerCore.Util.getString("StringNameValidator.sameNameCaseSensitive", new Object[]{name, count}) : ModelerCore.Util.getString("StringNameValidator.The_name_{0}_is_the_same_as_{1}_other_objects_under_the_same_parent", new Object[]{name, count});
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }

    public static Collection validateUniqueness(List features) {
        StringNameValidator validator = new StringNameValidator();
        Map objectCountMap = validator.getDuplicateNamesMap(features);
        if (objectCountMap.size() > 0) {
            ArrayList<Status> statusList = new ArrayList<Status>(objectCountMap.size());
            for (EObject eObject : objectCountMap.keySet()) {
                String name = ModelerCore.getModelEditor().getName(eObject);
                Integer count = (Integer)objectCountMap.get(eObject);
                Status status = new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("CoreValidationRulesUtil.The_name_of_feature_{0}_is_the_same_as_name_of_{1}_other_features._1", new Object[]{name, count}), null);
                statusList.add(status);
            }
            return statusList;
        }
        return Collections.EMPTY_LIST;
    }

    public static String getValidString(String name, char[] invalidChars, int maxLength) {
        StringNameValidator validator = new StringNameValidator(maxLength, invalidChars);
        return validator.createValidName(name);
    }

    public static void validateForNonQuotedNameWithDelimeter(ValidationResult result, String stringToValidate) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        if (stringToValidate.contains(".") && !CoreStringUtil.isDoubleQuoted((String)stringToValidate)) {
            String reasonInvalid = ModelerCore.Util.getString("StringNameValidator.unquotedNameWithDelimiter", (Object)stringToValidate);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem(problem);
        }
    }
}

