/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;

public class StringNameValidator {
    public static final char UNDERSCORE_CHARACTER = '_';
    public static final char[] DEFAULT_VALID_NON_LETTER_OR_DIGIT_CHARS = new char[]{'_'};
    public static final char DEFAULT_REPLACEMENT_CHARACTER = '_';
    public static final int MAXIMUM_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_MAXIMUM_LENGTH = 255;
    public static final int DEFAULT_MINIMUM_LENGTH = 1;
    public static final boolean DEFAULT_CASE_SENSITIVE_NAME_COMPARISON = false;
    private static final Integer INTEGER_ONE = new Integer(1);
    private final int maximumLength;
    private final int minimumLength;
    private final boolean caseSensitive;
    private final char replacementCharacter;
    private final char[] validNonLetterOrDigitChars;
    private final ExistingNames existingNames;

    public StringNameValidator(int minLength, int maxLength, boolean caseSensitive, char replacementCharacter, char[] validNonLetterOrDigitChars) {
        this.minimumLength = minLength < 0 ? 1 : minLength;
        this.maximumLength = maxLength < 0 ? Integer.MAX_VALUE : maxLength;
        this.caseSensitive = caseSensitive;
        this.replacementCharacter = replacementCharacter;
        if (this.minimumLength > this.maximumLength) {
            String msg = ModelerCore.Util.getString("StringNameValidator.The_minimum_length_may_not_exceed_the_maximum_length", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (validNonLetterOrDigitChars == null) {
            this.validNonLetterOrDigitChars = DEFAULT_VALID_NON_LETTER_OR_DIGIT_CHARS;
        } else {
            this.validNonLetterOrDigitChars = validNonLetterOrDigitChars;
            Arrays.sort(this.validNonLetterOrDigitChars);
        }
        this.existingNames = new ExistingNames(this.caseSensitive);
    }

    public boolean addExistingName(String name) {
        return this.existingNames.add(name);
    }

    public void clearExistingNames() {
        this.existingNames.clear();
    }

    public StringNameValidator(boolean caseSensitive) {
        this(1, 255, caseSensitive, '_', null);
    }

    public StringNameValidator(char[] validNonLetterOrDigitChars) {
        this(1, 255, false, '_', validNonLetterOrDigitChars);
    }

    public StringNameValidator(int maxLength, char[] validNonLetterOrDigitChars) {
        this(1, maxLength, false, '_', validNonLetterOrDigitChars);
    }

    public StringNameValidator(int minLength, int maxLength, char[] validNonLetterOrDigitChars) {
        this(minLength, maxLength, false, '_', validNonLetterOrDigitChars);
    }

    public StringNameValidator(int minLength, int maxLength, boolean caseSensitive, char replacementCharacter) {
        this(minLength, maxLength, caseSensitive, replacementCharacter, null);
    }

    public StringNameValidator(int minLength, int maxLength, boolean caseSensitive) {
        this(minLength, maxLength, caseSensitive, '_', null);
    }

    public StringNameValidator(int minLength, int maxLength) {
        this(minLength, maxLength, false, '_', null);
    }

    public StringNameValidator(int maxLength) {
        this(1, maxLength, false, '_', null);
    }

    public StringNameValidator() {
        this(1, 255, false, '_', null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public char getReplacementCharacter() {
        return this.replacementCharacter;
    }

    public String checkNameLength(String name) {
        CoreArgCheck.isNotNull((Object)name);
        int strLength = name.length();
        if (strLength < this.getMinimumLength()) {
            Object[] params = new Object[]{new Integer(this.getMinimumLength())};
            String msg = ModelerCore.Util.getString("StringNameValidator.MinLengthFailure", params);
            return msg;
        }
        if (strLength > this.getMaximumLength()) {
            Object[] params = new Object[]{new Integer(strLength), new Integer(this.getMaximumLength())};
            String msg = ModelerCore.Util.getString("StringNameValidator.The_name_length_({0})_is_longer_than_allowed_({1})", params);
            return msg;
        }
        return null;
    }

    public String checkNameCharacters(String name) {
        CoreArgCheck.isNotNull((Object)name);
        int length = name.length();
        if (length == 0) {
            return null;
        }
        char c = name.charAt(0);
        String msg = null;
        boolean isDoubleQuoted = false;
        if (!CoreStringUtil.isDoubleQuoted((String)name)) {
            msg = this.isValidInitialChar(c);
        } else if (length > 1) {
            isDoubleQuoted = true;
            msg = this.isValidInitialChar(name.charAt(1));
        }
        if (msg != null) {
            return msg;
        }
        int index = 1;
        while (index < length) {
            c = name.charAt(index);
            if (isDoubleQuoted) {
                if (index < length - 1) {
                    msg = this.isValidCharInDoubleQuotes(c, index);
                }
            } else {
                msg = this.isValidChar(c, index);
            }
            if (msg != null) {
                return msg;
            }
            ++index;
        }
        return null;
    }

    protected String isValidChar(char c, int index) {
        if (!(Character.isLetter(c) || Character.isDigit(c) || this.isValidNonLetterOrDigit(c))) {
            Object[] params = new Object[]{new Character(c), new Integer(index + 1), this.getValidNonLetterOrDigitMessageSuffix()};
            return ModelerCore.Util.getString("StringNameValidator.The_character___{0}___(at_position_{1})_is_not_allowed;_only_alphabetic,_digit_or_underscore", params);
        }
        return null;
    }

    protected String isValidCharInDoubleQuotes(char c, int index) {
        if (!(Character.isLetter(c) || c == '.' || Character.isDigit(c) || this.isValidNonLetterOrDigit(c))) {
            Object[] params = new Object[]{new Character(c), new Integer(index + 1), this.getValidNonLetterOrDigitMessageSuffix()};
            return ModelerCore.Util.getString("StringNameValidator.The_character___{0}___(at_position_{1})_is_not_allowed;_only_alphabetic,_digit_or_underscore", params);
        }
        return null;
    }

    protected String isValidInitialChar(char c) {
        if (!Character.isLetter(c)) {
            Object[] params = new Object[]{new Character(c)};
            String msg = ModelerCore.Util.getString("StringNameValidator.The_first_character_of_the_name_({0})_must_be_an_alphabetic_character", params);
            return msg;
        }
        return null;
    }

    public boolean isValidNonLetterOrDigit(char c) {
        return Arrays.binarySearch(this.validNonLetterOrDigitChars, c) >= 0;
    }

    public String getValidNonLetterOrDigitMessageSuffix() {
        return ModelerCore.Util.getString("StringNameValidator.or_other_valid_characters", new Object[0]);
    }

    public boolean isValidName(String name) {
        String reasonInvalid = this.checkValidName(name);
        return reasonInvalid == null;
    }

    public String checkValidName(String name) {
        if (name == null) {
            String msg = ModelerCore.Util.getString("StringNameValidator.The_name_may_not_be_null", new Object[0]);
            return msg;
        }
        String lengthMsg = this.checkNameLength(name);
        if (lengthMsg != null) {
            return lengthMsg;
        }
        String contentMsg = this.checkNameCharacters(name);
        if (contentMsg != null) {
            return contentMsg;
        }
        return null;
    }

    public String checkUniqueness(String name, EObject eObject, List siblings, int nameFeatureID) {
        CoreArgCheck.isNotNull((Object)name);
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isNotNull((Object)siblings);
        String eObjUri = eObject.eClass().getEPackage().getNsURI();
        Iterator iter = siblings.iterator();
        int matchCntr = 0;
        while (iter.hasNext()) {
            String siblingName;
            EStructuralFeature eFeature;
            EClass siblingClass;
            String siblingURI;
            EObject sibling = (EObject)iter.next();
            if (sibling == eObject || !eObjUri.equals(siblingURI = (siblingClass = sibling.eClass()).getEPackage().getNsURI()) || (eFeature = siblingClass.getEStructuralFeature(nameFeatureID)) == null || (siblingName = (String)sibling.eGet(eFeature)) == null || (!this.isCaseSensitive() || !siblingName.equals(name)) && (this.isCaseSensitive() || !siblingName.equalsIgnoreCase(name))) continue;
            ++matchCntr;
        }
        if (matchCntr != 0) {
            Object[] params = new Object[]{name, new Integer(matchCntr)};
            String msg = ModelerCore.Util.getString("StringNameValidator.The_name_{0}_is_the_same_as_{1}_other_objects_under_the_same_parent", (Object)params);
            return msg;
        }
        return null;
    }

    public Map getDuplicateNamesMap(List siblings, int nameFeatureID) {
        CoreArgCheck.isNotNull((Object)siblings);
        Map siblingNameMap = this.getSiblingsNameFeatureMap(siblings, nameFeatureID);
        HashMap<EObject, Integer> objectCountMap = new HashMap<EObject, Integer>();
        ArrayList siblingEObjects = new ArrayList(siblingNameMap.keySet());
        int siblingSize = siblingEObjects.size();
        int i = 0;
        while (i < siblingSize) {
            EObject siblingA = (EObject)siblingEObjects.get(i);
            String siblingNameA = (String)siblingNameMap.get(siblingA);
            int j = i + 1;
            while (j < siblingSize) {
                EObject siblingB = (EObject)siblingEObjects.get(j);
                String siblingNameB = (String)siblingNameMap.get(siblingB);
                if (this.isCaseSensitive() && siblingNameA.equals(siblingNameB) || !this.isCaseSensitive() && siblingNameA.equalsIgnoreCase(siblingNameB)) {
                    Integer matchCnt1 = (Integer)objectCountMap.get(siblingA);
                    Integer matchCnt2 = (Integer)objectCountMap.get(siblingB);
                    matchCnt1 = matchCnt1 == null ? INTEGER_ONE : new Integer(matchCnt1 + 1);
                    matchCnt2 = matchCnt2 == null ? INTEGER_ONE : new Integer(matchCnt2 + 1);
                    objectCountMap.put(siblingA, matchCnt1);
                    objectCountMap.put(siblingB, matchCnt2);
                }
                ++j;
            }
            ++i;
        }
        return objectCountMap;
    }

    private Map getSiblingsNameFeatureMap(List siblings, int nameFeatureID) {
        int siblingSize = siblings.size();
        HashMap<EObject, Object> siblingNameMap = new HashMap<EObject, Object>();
        int i = 0;
        while (i < siblingSize) {
            Object featureValue;
            EObject siblingEObject = (EObject)siblings.get(i);
            EClass siblingClass = siblingEObject.eClass();
            EStructuralFeature eFeature = siblingClass.getEStructuralFeature(nameFeatureID);
            if (eFeature != null && (featureValue = siblingEObject.eGet(eFeature)) != null && featureValue instanceof String) {
                siblingNameMap.put(siblingEObject, featureValue);
            }
            ++i;
        }
        return siblingNameMap;
    }

    public Map getDuplicateNamesMap(List features) {
        CoreArgCheck.isNotNull((Object)features);
        HashMap<EStructuralFeature, Integer> objectCountMap = new HashMap<EStructuralFeature, Integer>();
        int featuresSize = features.size();
        int i = 0;
        while (i < featuresSize) {
            EStructuralFeature eFeature1 = (EStructuralFeature)features.get(i);
            if (eFeature1 != null) {
                String featureName1 = eFeature1.getName();
                int j = i + 1;
                while (j < featuresSize) {
                    String featureName2;
                    EStructuralFeature eFeature2 = (EStructuralFeature)features.get(j);
                    if (eFeature2 != null && (featureName2 = eFeature2.getName()) != null && (this.isCaseSensitive() && featureName1.equals(featureName2) || !this.isCaseSensitive() && featureName1.equalsIgnoreCase(featureName2))) {
                        Integer matchCnt1 = (Integer)objectCountMap.get(eFeature1);
                        Integer matchCnt2 = (Integer)objectCountMap.get(eFeature2);
                        matchCnt1 = matchCnt1 == null ? INTEGER_ONE : new Integer(matchCnt1 + 1);
                        matchCnt2 = matchCnt2 == null ? INTEGER_ONE : new Integer(matchCnt2 + 1);
                        objectCountMap.put(eFeature1, matchCnt1);
                        objectCountMap.put(eFeature2, matchCnt2);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return objectCountMap;
    }

    public String createValidName(String name) {
        return this.createValidName(name, false);
    }

    public String createValidName(String name, boolean performValidityCheck) {
        CoreArgCheck.isNotNull((Object)name);
        StringBuffer newName = new StringBuffer(name.length());
        boolean changed = false;
        int initLength = name.length();
        int maxLength = Math.min(initLength, this.getMaximumLength());
        int actualLength = 0;
        if (initLength > 0) {
            boolean foundInitialChar = false;
            int index = 0;
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                String msg;
                char nextChar = cArray[n2];
                ++index;
                if (!foundInitialChar) {
                    msg = this.isValidInitialChar(nextChar);
                    if (msg == null) {
                        foundInitialChar = true;
                        changed = true;
                        ++actualLength;
                        newName.append(nextChar);
                    } else {
                        changed = true;
                    }
                } else {
                    if (actualLength >= maxLength) break;
                    msg = this.isValidChar(nextChar, index);
                    if (msg != null) {
                        changed = true;
                        ++actualLength;
                        newName.append(this.getReplacementCharacter());
                    } else {
                        ++actualLength;
                        newName.append(nextChar);
                    }
                }
                ++n2;
            }
        }
        while (newName.length() < this.getMinimumLength()) {
            changed = true;
            newName.append(this.getReplacementCharacter());
        }
        if (newName.length() > maxLength) {
            changed = true;
            newName.delete(maxLength, newName.length());
        }
        if (changed) {
            return newName.toString();
        }
        return null;
    }

    public String createValidUniqueName(String name) {
        String result = null;
        String validName = this.createValidName(name);
        if (validName == null) {
            validName = name;
        } else {
            result = validName;
        }
        String uniqueName = this.createUniqueName(validName);
        if (uniqueName != null) {
            result = uniqueName;
        }
        return result;
    }

    public String createUniqueName(String name) {
        CoreArgCheck.isNotNull((Object)name);
        int roomForCounterChars = Math.max(0, this.getMaximumLength() - name.length());
        int counterToStartRemoving = (int)Math.pow(10.0, roomForCounterChars) - 1;
        String theName = name;
        boolean changed = false;
        int counter = 0;
        while (!this.addExistingName(theName)) {
            int length = name.length();
            if (++counter > counterToStartRemoving) {
                int numCharsToRemove = 0;
                numCharsToRemove = counter - counterToStartRemoving < 10 ? 1 : (counter - counterToStartRemoving < 100 ? 2 : (counter - counterToStartRemoving < 1000 ? 3 : (counter - counterToStartRemoving < 10000 ? 4 : (counter - counterToStartRemoving < 100000 ? 5 : length + 1))));
                if (length > numCharsToRemove) {
                    theName = String.valueOf(name.substring(0, length - numCharsToRemove)) + counter;
                    changed = true;
                    continue;
                }
                Object[] params = new Object[]{name};
                String msg = ModelerCore.Util.getString("StringNameValidator.Unable_to_make_the_name_{0}_unique_within_the_limits_of_the_maximum_length", params);
                throw new ModelerCoreRuntimeException(msg);
            }
            changed = true;
            theName = String.valueOf(name) + counter;
        }
        return changed ? theName : null;
    }

    private class ExistingNames {
        private final boolean caseSensitive;
        private Node root;

        public ExistingNames(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.root = new Node(' ');
        }

        public boolean add(String name) {
            boolean added = false;
            if (!this.caseSensitive) {
                name = name.toUpperCase();
            }
            Node current = this.root;
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                Node child = current.subNode(c);
                if (child == null) {
                    Node newKid = new Node(c);
                    current.getChildren().put(Character.valueOf(c), newKid);
                    current = newKid;
                    added = true;
                } else {
                    current = child;
                }
                ++n2;
            }
            if (added || !current.marker) {
                current.marker = true;
                added = true;
            }
            return added;
        }

        private void buildNodeNameList(String name, Node node, StringBuilder txt) {
            if (node.marker) {
                txt.append(name).append(',');
            }
            for (Object obj : node.getChildren().values()) {
                Node kid = (Node)obj;
                this.buildNodeNameList(String.valueOf(name) + kid.content, kid, txt);
            }
        }

        public void clear() {
            this.root.clearChildren();
        }

        public String toString() {
            StringBuilder txt = new StringBuilder();
            this.buildNodeNameList("", this.root, txt);
            return txt.substring(0, txt.length() - 1).toString();
        }
    }

    class Node
    implements Comparable {
        final char content;
        boolean marker;
        private TreeMap<Character, Node> kids;

        Node(char c) {
            this.content = c;
        }

        public int compareTo(Object obj) {
            Node that = (Node)obj;
            if (this.content == that.content) {
                return 0;
            }
            return this.content - that.content;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.content == ((Node)obj).content;
        }

        void clearChildren() {
            if (this.kids != null) {
                this.kids.clear();
            }
        }

        TreeMap getChildren() {
            if (this.kids == null) {
                this.kids = new TreeMap();
            }
            return this.kids;
        }

        boolean hasChildren() {
            return this.kids != null && !this.kids.isEmpty();
        }

        public int hashCode() {
            return Character.valueOf(this.content).hashCode();
        }

        Node subNode(char c) {
            if (this.kids == null) {
                return null;
            }
            return this.kids.get(Character.valueOf(c));
        }
    }
}

