/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;

public class TargetTransformationRule
implements ResourceValidationRule {
    @Override
    public void validate(Resource resource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)context);
        URI uri = resource.getURI();
        if (uri != null && !uri.lastSegment().endsWith("xmi")) {
            return;
        }
        Map targetTransformMap = context.getTargetTransformMap();
        if (targetTransformMap == null || targetTransformMap.isEmpty()) {
            return;
        }
        for (EObject target : targetTransformMap.keySet()) {
            Resource targetResource = target.eResource();
            if (targetResource != resource || targetTransformMap.get(target) != null) continue;
            SqlAspect targetAspect = AspectManager.getSqlAspect(target);
            CoreArgCheck.isNotNull((Object)targetAspect);
            if (targetAspect instanceof SqlTableAspect) {
                boolean isXmlDoc;
                SqlTableAspect tableAspect = (SqlTableAspect)targetAspect;
                boolean bl = isXmlDoc = tableAspect.getTableType(target) == 2;
                if (!tableAspect.isVirtual(target) || isXmlDoc) continue;
                int status = this.getPreferenceStatus(context);
                if (status == 0) {
                    return;
                }
                ValidationResultImpl result = new ValidationResultImpl(target);
                String msg = ModelerCore.Util.getString("TargetTransformationRule.The_virtual_table_{0}_does_not_have_any_associated_transformation._1", (Object)tableAspect.getName(target));
                ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg);
                result.addProblem(problem);
                context.addResult(result);
                continue;
            }
            SqlProcedureAspect procAspect = (SqlProcedureAspect)targetAspect;
            if (!procAspect.isVirtual(target)) continue;
            int status = this.getPreferenceStatus(context);
            if (status == 0) {
                return;
            }
            ValidationResultImpl result = new ValidationResultImpl(target);
            String msg = ModelerCore.Util.getString("TargetTransformationRule.The_virtual_procedure_{0}_does_not_have_any_associated_transformation._1", (Object)procAspect.getName(target));
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg);
            result.addProblem(problem);
            context.addResult(result);
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.emptyTransformations", 4);
    }
}

