/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jdom.Document;
import org.jdom.Element;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.xml.JdomHelper;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class DotProjectUtils {
    public static final String DOT_PROJECT = ".project";

    private DotProjectUtils() {
    }

    public static IFile getDotProjectFile(IContainer container) {
        IProject project = container.getProject();
        if (project != null) {
            return container.getProject().getFile(DOT_PROJECT);
        }
        return null;
    }

    public static int getDotProjectCount(String fileName, boolean recurse, boolean onlyModelerProjects) throws Exception {
        File file = new File(fileName);
        return DotProjectUtils.getDotProjectCount(file, recurse, onlyModelerProjects);
    }

    public static int getDotProjectCount(File file, boolean recurse, boolean onlyModelerProjects) throws Exception {
        int dotProjectCount = 0;
        int depth = 0;
        ArrayList<File> resources = new ArrayList<File>();
        resources.add(file);
        while (resources.size() > 0) {
            File resource = (File)resources.get(0);
            if (resource.isFile()) {
                if (DotProjectUtils.isDotProject(resource, onlyModelerProjects)) {
                    ++dotProjectCount;
                }
                if (dotProjectCount > 1) {
                    return dotProjectCount;
                }
            } else if (recurse || depth == 0) {
                File[] members = resource.listFiles();
                int i = 0;
                while (i < members.length) {
                    resources.add(members[i]);
                    ++i;
                }
                ++depth;
            }
            resources.remove(0);
        }
        return dotProjectCount;
    }

    public static boolean isDotProject(String file, boolean onlyModelerProject) throws Exception {
        return DotProjectUtils.isDotProject(new File(file), onlyModelerProject);
    }

    public static boolean isDotProject(File file, boolean onlyModelerProject) throws Exception {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.getName().equals(DOT_PROJECT)) {
            if (onlyModelerProject) {
                Document doc = JdomHelper.buildDocument((File)file);
                Element elementFound = JdomHelper.findElement((Element)doc.getRootElement(), (String)"nature");
                if (elementFound == null) {
                    return false;
                }
                return elementFound.getText().equals("org.teiid.designer.core.modelNature");
            }
            return true;
        }
        return false;
    }

    public static int getDotProjectCount(IResource targetResource, boolean recurse, boolean onlyModelerProjects) throws Exception {
        int dotProjectCount = 0;
        int depth = 0;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add(targetResource);
        while (resources.size() > 0) {
            IResource resource = (IResource)resources.get(0);
            if (!(resource instanceof IContainer)) {
                if (DotProjectUtils.isDotProject(resource, onlyModelerProjects)) {
                    ++dotProjectCount;
                }
                if (dotProjectCount > 1) {
                    return dotProjectCount;
                }
            } else if (recurse || depth == 0) {
                IResource[] members = ((IContainer)resource).members();
                int i = 0;
                while (i < members.length) {
                    resources.add(members[i]);
                    ++i;
                }
                ++depth;
            }
            resources.remove(0);
        }
        return dotProjectCount;
    }

    public static boolean isDotProject(IResource resource, boolean onlyModelerProject) throws Exception {
        if (resource.getName().equals(DOT_PROJECT) && resource.getType() == 1 && resource.getLocation() != null) {
            if (onlyModelerProject) {
                if (resource.isAccessible()) {
                    if (resource.getProject().isOpen()) {
                        return resource.getProject().hasNature("org.teiid.designer.core.modelNature");
                    }
                    return DotProjectUtils.isModelNature(resource);
                }
                return DotProjectUtils.isDotProject(((IFile)resource).getLocation().toFile(), onlyModelerProject);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isModelNature(IResource resource) {
        boolean result = false;
        File theFile = ((IFile)resource).getLocation().toFile();
        FileReader fileReader = null;
        BufferedReader bufferReader = null;
        try {
            try {
                fileReader = new FileReader(theFile.getPath());
                bufferReader = new BufferedReader(fileReader);
                String str = null;
                while (true) {
                    str = bufferReader.readLine();
                    if (str == null) return result;
                    if (result) {
                        return result;
                    }
                    if (str.indexOf("org.teiid.designer.core.modelNature") <= -1) continue;
                    result = true;
                }
            }
            catch (Exception e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException e2) {
                    ModelerCore.Util.log(4, (Throwable)e2, e2.getMessage());
                }
                try {
                    if (bufferReader == null) return result;
                    bufferReader.close();
                    return result;
                }
                catch (IOException e3) {
                    ModelerCore.Util.log(4, (Throwable)e3, e3.getMessage());
                    return result;
                }
            }
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
            try {
                if (bufferReader != null) {
                    bufferReader.close();
                }
            }
            catch (IOException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    public static boolean isModelerProject(IProject iProject) {
        boolean result = false;
        IFile dotProjectFile = DotProjectUtils.getDotProjectFile((IContainer)iProject);
        if (dotProjectFile != null) {
            try {
                result = DotProjectUtils.isDotProject((IResource)dotProjectFile, true);
            }
            catch (Exception e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return result;
    }

    public static boolean hasNature(IProject project, String nature) {
        CoreArgCheck.isNotNull((Object)project);
        CoreArgCheck.isNotEmpty((String)nature);
        try {
            return project.hasNature(nature);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static Collection<IProject> getOpenModelProjects() {
        IProject[] allProjects = ModelerCore.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> openModelProjectList = new ArrayList<IProject>(allProjects.length);
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isOpen() && DotProjectUtils.isModelerProject(proj) && !DotProjectUtils.hasNature(proj, "org.teiid.designer.core.hiddenProjectNature")) {
                openModelProjectList.add(proj);
            }
            ++n2;
        }
        return openModelProjectList;
    }

    public static Collection<IFile> getAllProjectResources(IProject project) {
        return WorkspaceResourceFinderUtil.getProjectFileResources(project);
    }
}

