/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;

public class ModelMarkerManager
implements IResourceChangeListener {
    private HashMap resourceMap = new HashMap();

    public ModelMarkerManager() {
        if (ResourcesPlugin.getPlugin() != null) {
            ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean refreshNeeded = false;
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
        ArrayList changes = new ArrayList(markerDeltas.length);
        ModelMarkerManager.examineDelta(markerDeltas, changes);
        if (markerDeltas.length != changes.size()) {
            refreshNeeded = true;
        }
        if (refreshNeeded) {
            ArrayList<IResource> visitedResources = new ArrayList<IResource>();
            ArrayList<IResource> changedResources = new ArrayList<IResource>();
            int i = 0;
            while (i < markerDeltas.length) {
                IResource eventResource = markerDeltas[i].getResource();
                if (!visitedResources.contains(eventResource)) {
                    if (ModelUtil.isModelFile(eventResource)) {
                        ModelResource mr = null;
                        try {
                            mr = ModelUtil.getModelResource((IFile)eventResource, false);
                        }
                        catch (ModelWorkspaceException e) {
                            ModelerCore.Util.log((Throwable)((Object)e));
                        }
                        if (mr != null && !changedResources.contains(eventResource)) {
                            changedResources.add(eventResource);
                        }
                    }
                    visitedResources.add(eventResource);
                }
                ++i;
            }
            this.refreshMarkers(changedResources);
        }
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    private static void examineDelta(IMarkerDelta[] deltas, List changes) {
        int idx = 0;
        while (idx < deltas.length) {
            IMarkerDelta delta = deltas[idx];
            int kind = delta.getKind();
            if (kind == 4) {
                changes.add(deltas[idx].getMarker());
            }
            ++idx;
        }
    }

    private void refreshMarkers(List changedResources) {
        this.clearStaleResources();
        for (IResource theIResource : changedResources) {
            if (theIResource.exists()) {
                Object obj = this.resourceMap.get(theIResource);
                HashMap theMarkerMap = null;
                if (obj != null && obj instanceof HashMap) {
                    theMarkerMap = (HashMap)obj;
                    theMarkerMap.clear();
                }
                if (theMarkerMap == null) {
                    theMarkerMap = new HashMap();
                    this.resourceMap.put(theIResource, theMarkerMap);
                }
                this.populateMarkerMap(theMarkerMap, theIResource);
                continue;
            }
            this.resourceMap.remove(theIResource);
        }
    }

    private void clearStaleResources() {
        ArrayList staleKeys = new ArrayList();
        for (Object nextKey : this.resourceMap.keySet()) {
            if (!(nextKey instanceof IResource) || ((IResource)nextKey).exists()) continue;
            staleKeys.add(nextKey);
        }
        Iterator<Object> iter = staleKeys.iterator();
        while (iter.hasNext()) {
            this.resourceMap.remove(iter.next());
        }
    }

    private void populateMarkerMap(HashMap markerMap, IResource theResource) {
        IMarker[] markers = null;
        boolean errorOccurred = false;
        try {
            markers = theResource.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException ex) {
            ModelerCore.Util.log((Throwable)ex);
            errorOccurred = true;
        }
        if (!errorOccurred) {
            int ndx = markers.length;
            while (--ndx >= 0) {
                IMarker marker = markers[ndx];
                EObject targetEObject = this.getMarkedEObject(marker);
                if (targetEObject == null) continue;
                markerMap.put(marker, targetEObject);
            }
        }
    }

    public EObject getMarkedEObject(IResource resrc, IMarker iMarker) {
        CoreArgCheck.isNotNull((Object)resrc);
        EObject theMarkedEObject = null;
        if (resrc.exists()) {
            Object value;
            Object obj = this.resourceMap.get(resrc);
            HashMap theMarkerMap = null;
            if (obj != null && obj instanceof HashMap && (value = (theMarkerMap = (HashMap)obj).get(iMarker)) != null && value instanceof EObject) {
                theMarkedEObject = (EObject)value;
            }
        }
        return theMarkedEObject;
    }

    private EObject getMarkedEObject(IMarker iMarker) {
        URI theURI;
        EObject target = null;
        String uri = (String)this.getMarkerAttribute(iMarker, "org.teiid.designer.core.markerURI");
        if (uri != null && (theURI = URI.createURI((String)uri)) != null) {
            try {
                target = ModelerCore.getModelContainer().getEObject(theURI, true);
            }
            catch (CoreException e1) {
                ModelerCore.Util.log((Throwable)e1);
            }
        }
        return target;
    }

    private Object getMarkerAttribute(IMarker iMarker, String attributeName) {
        Object attribute = null;
        if (iMarker != null) {
            try {
                attribute = iMarker.getAttribute(attributeName);
            }
            catch (CoreException coreException) {}
        }
        return attribute;
    }

    public void dispose() {
        ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.resourceMap.clear();
    }
}

