/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class ModelObjectAnnotationHelper {
    public static final String EXTENDED_PROPERTY_NAMESPACE = "ext-custom:";

    private static String getNamespace(String str) {
        CoreArgCheck.isNotNull((Object)str, (String)"str");
        int semiColonIndex = str.indexOf(58) + 1;
        if (semiColonIndex > 0) {
            return str.substring(0, semiColonIndex);
        }
        return null;
    }

    public Annotation getModelObjectAnnotation(EObject modelObject, boolean forceCreate) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        Annotation annotation = ModelerCore.getModelEditor().getAnnotation(modelObject, forceCreate);
        return annotation;
    }

    public Object getPropertyValue(EObject modelObject, String key) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        Annotation annotation = this.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            return annotation.getTags().get((Object)key);
        }
        return null;
    }

    public Object getPropertyValueAnyCase(EObject modelObject, String key) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        Annotation annotation = this.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            int beginIndex = key.indexOf(":");
            String upperCase = String.valueOf(key.substring(0, beginIndex)) + key.substring(beginIndex).toUpperCase();
            Object tag = annotation.getTags().get((Object)upperCase);
            if (tag == null) {
                String lowerCase = String.valueOf(key.substring(0, beginIndex)) + key.substring(beginIndex).toLowerCase();
                tag = annotation.getTags().get((Object)lowerCase);
            }
            return tag;
        }
        return null;
    }

    public Properties getProperties(EObject modelObject, String namespacePrefix) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)namespacePrefix, (String)"namespacePrefix");
        Properties props = new Properties();
        Annotation annotation = modelObject instanceof Annotation ? (Annotation)modelObject : this.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            Set keys = tags.keySet();
            for (Object nextKey : keys) {
                String namespace = ModelObjectAnnotationHelper.getNamespace((String)nextKey);
                if (namespace == null || !namespace.equals(namespacePrefix)) continue;
                props.put(nextKey, tags.get(nextKey));
            }
        }
        return props;
    }

    public Properties getAllProperties(EObject modelObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        Properties props = new Properties();
        Annotation annotation = this.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            Set keys = tags.keySet();
            for (Object nextKey : keys) {
                props.put(nextKey, tags.get(nextKey));
            }
        }
        return props;
    }

    public void removeProperties(EObject modelObject, String namespacePrefix) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)namespacePrefix, (String)"namespacePrefix");
        Annotation annotation = this.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            HashSet keys = new HashSet(tags.keySet());
            for (Object nextKey : keys) {
                String namespace = ModelObjectAnnotationHelper.getNamespace((String)nextKey);
                if (namespace == null || !namespace.equals(namespacePrefix)) continue;
                tags.remove(nextKey);
            }
        }
    }

    public void removeProperty(EObject modelObject, String key) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        Annotation annotation = this.getModelObjectAnnotation(modelObject, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            HashSet keys = new HashSet(tags.keySet());
            for (String nextKey : keys) {
                if (!nextKey.equals(key)) continue;
                tags.remove((Object)nextKey);
                break;
            }
        }
    }

    public void addProperty(EObject modelObject, String key, Object value) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        CoreArgCheck.isNotNull((Object)value, (String)"value");
        Annotation annotation = this.getModelObjectAnnotation(modelObject, true);
        annotation.getTags().put((Object)key, value);
    }

    public boolean hasExtensionProperties(Object object) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)object, (String)"object");
        boolean hasExtendedProperties = false;
        Annotation annotation = null;
        if (object instanceof IFile) {
            ModelAnnotation modelAnnotation;
            ModelResource modelResource = ModelUtil.getModelResource((IFile)object, false);
            if (modelResource != null && (annotation = this.getModelObjectAnnotation((EObject)(modelAnnotation = modelResource.getModelAnnotation()), false)) != null) {
                hasExtendedProperties = this.checkForExtendedProperties(annotation);
            }
        } else if (object instanceof EObject && (annotation = this.getModelObjectAnnotation((EObject)object, false)) != null) {
            hasExtendedProperties = this.checkForExtendedProperties(annotation);
        }
        return hasExtendedProperties;
    }

    private boolean checkForExtendedProperties(Annotation annotation) {
        for (Object object : annotation.getTags().keySet()) {
            String key = (String)object;
            if (!key.startsWith(EXTENDED_PROPERTY_NAMESPACE)) continue;
            return true;
        }
        return false;
    }

    public Properties getExtendedProperties(EObject eObject) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject, (String)"eObject");
        Properties properties = this.getProperties(eObject, EXTENDED_PROPERTY_NAMESPACE);
        return properties;
    }

    public void addProperties(EObject modelObject, Properties props) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)modelObject, (String)"modelObject");
        CoreArgCheck.isNotNull((Object)props, (String)"props");
        Annotation annotation = this.getModelObjectAnnotation(modelObject, true);
        Set<Object> keys = props.keySet();
        for (Object nextKey : keys) {
            annotation.getTags().put(nextKey, props.get(nextKey));
        }
    }
}

