/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.Checksum;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.ChecksumUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xmi.ModelImportInfo;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.common.xmi.XMIHeaderReader;
import org.teiid.designer.common.xsd.XsdHeader;
import org.teiid.designer.common.xsd.XsdHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelBuffer;
import org.teiid.designer.core.workspace.ModelBufferImpl;
import org.teiid.designer.core.workspace.ModelBufferManager;
import org.teiid.designer.core.workspace.ModelDiagrams;
import org.teiid.designer.core.workspace.ModelDiagramsImpl;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelMappingClassSets;
import org.teiid.designer.core.workspace.ModelMappingClassSetsImpl;
import org.teiid.designer.core.workspace.ModelObjectAnnotations;
import org.teiid.designer.core.workspace.ModelObjectAnnotationsImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceInfo;
import org.teiid.designer.core.workspace.ModelTransformations;
import org.teiid.designer.core.workspace.ModelTransformationsImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceNotification;
import org.teiid.designer.core.workspace.OpenableImpl;
import org.teiid.designer.core.workspace.OpenableModelWorkspaceItemInfo;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;

public class ModelResourceImpl
extends OpenableImpl
implements ModelResource {
    private int indexType;
    private XMIHeader xmiHeader;
    private XsdHeader xsdHeader;
    private ModelType mdlType = null;
    private IStatus errors = null;
    private long checkSumForIndexType = 0L;
    private long fileSizeForIndexType = 0L;

    ModelResourceImpl() {
        super(5, null, null);
        this.xmiHeader = null;
        this.xsdHeader = null;
        this.setIndexType(0);
        ModelWorkspaceManager.getModelWorkspaceManager().setIndexType(0);
    }

    public ModelResourceImpl(ModelWorkspaceItem parent, String name) {
        this(parent, name, true);
    }

    ModelResourceImpl(ModelWorkspaceItem parent, String name, boolean createEmfResource) {
        super(5, parent, name);
        if (createEmfResource) {
            try {
                IResource iResource = this.getResource();
                IPath path = iResource.getLocation();
                URI uri = URI.createFileURI((String)path.toOSString());
                ResourceSet resourceSet = super.getBufferManager().getResourceSetFinder().getResourceSet(iResource);
                if (resourceSet.getResource(uri, false) == null) {
                    resourceSet.createResource(uri);
                }
            }
            catch (DuplicateResourceException dre) {
                ModelerCore.Util.log((Throwable)((Object)dre));
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log((Throwable)((Object)mwe));
            }
        }
    }

    @Override
    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelResourceInfo();
    }

    @Override
    public boolean isLoaded() {
        return this.getBufferManager().getOpenBuffer(this) != null;
    }

    @Override
    public boolean hasErrors() {
        block3: {
            if (this.errors == null) {
                try {
                    this.getBuffer();
                }
                catch (ModelWorkspaceException err) {
                    Throwable nested = err.getException();
                    if (nested instanceof DuplicateResourceException) break block3;
                    ModelerCore.Util.log((Throwable)((Object)err));
                }
            }
        }
        return this.errors != null && !this.errors.isOK();
    }

    @Override
    public IStatus getErrors() {
        try {
            ModelBuffer buffer = this.getBuffer();
            if (buffer != null) {
                return buffer.getErrors();
            }
        }
        catch (ModelWorkspaceException err) {
            Throwable nested = err.getException();
            if (nested instanceof DuplicateResourceException) {
                return this.errors;
            }
            ModelerCore.Util.log((Throwable)((Object)err));
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    @Override
    public boolean isXsd() {
        return ModelUtil.isXsdFile(this.getResource());
    }

    @Override
    public String getTargetNamespace() throws ModelWorkspaceException {
        String targetNamespace = null;
        if (!this.isResourceOpenAndLoaded()) {
            XsdHeader header = this.getXsdHeader();
            if (header != null) {
                targetNamespace = header.getTargetNamespaceURI();
            }
        } else {
            XSDSchema xsdSchema;
            Resource resource = this.getEmfResource();
            if (resource instanceof XSDResourceImpl && (xsdSchema = ((XSDResourceImpl)resource).getSchema()) != null) {
                targetNamespace = xsdSchema.getTargetNamespace();
            }
        }
        return targetNamespace;
    }

    @Override
    public void unload() {
        ModelBuffer modelBuffer = this.getBufferManager().getOpenBuffer(this);
        if (modelBuffer != null) {
            this.closeBuffer(null);
            ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            this.xmiHeader = null;
            this.xsdHeader = null;
            this.mdlType = null;
        }
    }

    @Override
    public int getIndexType() {
        return this.indexType;
    }

    @Override
    public void refreshIndexType() {
        block19: {
            try {
                boolean checksumDifference;
                boolean fileSizeDifference;
                block21: {
                    long fileSize;
                    File rawFile;
                    IResource iResource;
                    ModelBuffer buf = this.getBuffer();
                    if (buf == null || !((iResource = this.getResource()) instanceof IFile)) break block19;
                    if (this.indexType == 0) {
                        return;
                    }
                    fileSizeDifference = false;
                    IPath rawLocation = ModelUtil.getLocation(iResource);
                    if (rawLocation != null && (rawFile = new File(rawLocation.toString())).exists() && (fileSize = rawFile.length()) != this.fileSizeForIndexType) {
                        this.fileSizeForIndexType = fileSize;
                        fileSizeDifference = true;
                    }
                    checksumDifference = false;
                    InputStream stream = null;
                    try {
                        try {
                            stream = ((IFile)iResource).getContents();
                            Checksum checksum = ChecksumUtil.computeChecksum((InputStream)stream);
                            long checksumValue = checksum.getValue();
                            if (checksumValue != this.checkSumForIndexType) {
                                this.checkSumForIndexType = checksumValue;
                                checksumDifference = true;
                            }
                        }
                        catch (Exception exception) {
                            this.indexType = 0;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (fileSizeDifference || checksumDifference) {
                    this.indexType = 0;
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setIndexType(int indexType) {
        this.indexType = indexType;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isLoaded() && this.hasErrors()) {
            return true;
        }
        if (this.isLoaded() && ModelUtil.isLockedSourceObject(this)) {
            return true;
        }
        return ModelUtil.isIResourceReadOnly(this.getResource());
    }

    @Override
    protected boolean isSourceElement() {
        return true;
    }

    @Override
    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, IResource underlyingResource) throws ModelWorkspaceException {
        boolean validInfo = false;
        try {
            ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
            validInfo = this.updateModelContents();
        }
        finally {
            if (!validInfo) {
                ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
            }
        }
        return validInfo;
    }

    @Override
    public List getEObjects() throws ModelWorkspaceException {
        ModelBufferImpl buffer = (ModelBufferImpl)super.getBuffer();
        return buffer.getModelContents() != null ? buffer.getModelContents().getEObjects() : Collections.EMPTY_LIST;
    }

    @Override
    public List getAllRootEObjects() throws ModelWorkspaceException {
        ModelBufferImpl buffer = (ModelBufferImpl)super.getBuffer();
        return buffer.getModelContents() != null ? buffer.getModelContents().getAllRootEObjects() : Collections.EMPTY_LIST;
    }

    @Override
    public synchronized Resource getEmfResource() throws ModelWorkspaceException {
        Resource resource = super.getBuffer().getEmfResource();
        CoreArgCheck.isNotNull((Object)resource);
        return resource;
    }

    @Override
    public IResource getResource() {
        ModelWorkspaceItem parent = this.getParent();
        if (parent == null) {
            return null;
        }
        IContainer parentResource = (IContainer)parent.getResource();
        Path path = new Path(this.getItemName());
        return parentResource.getFile((IPath)path);
    }

    @Override
    public IPath getPath() {
        ModelWorkspaceItem parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getPath().append(this.getItemName());
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    protected ModelBuffer openBuffer(IProgressMonitor pm) throws ModelWorkspaceException {
        this.opening = true;
        ModelBuffer buffer = null;
        try {
            ModelBufferManager bufManager = this.getBufferManager();
            buffer = bufManager.createBuffer(this);
            if (buffer == null) {
                return null;
            }
            if (buffer instanceof ModelBufferImpl) {
                ModelBufferImpl theBuffer = (ModelBufferImpl)buffer;
                try {
                    try {
                        theBuffer.open(pm);
                    }
                    catch (DuplicateResourceException err) {
                        throw new ModelWorkspaceException((Throwable)((Object)err), err.getMessage());
                    }
                }
                finally {
                    this.errors = theBuffer.getErrors();
                }
            }
            bufManager.addBuffer(buffer);
        }
        finally {
            this.opening = false;
        }
        return buffer;
    }

    @Override
    public IResource getCorrespondingResource() {
        return this.getUnderlyingResource();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getResource();
    }

    @Override
    public ModelDiagrams getModelDiagrams() throws ModelWorkspaceException {
        return (ModelDiagrams)this.getFirstChildrenOfType(8);
    }

    @Override
    public ModelTransformations getModelTransformations() throws ModelWorkspaceException {
        return (ModelTransformations)this.getFirstChildrenOfType(9);
    }

    @Override
    public ModelObjectAnnotations getAnnotations() throws ModelWorkspaceException {
        return (ModelObjectAnnotations)this.getFirstChildrenOfType(10);
    }

    @Override
    public ModelMappingClassSets getModelMappingClassSets() throws ModelWorkspaceException {
        return (ModelMappingClassSets)this.getFirstChildrenOfType(11);
    }

    @Override
    public ModelType getModelType() throws ModelWorkspaceException {
        if (this.mdlType != null) {
            return this.mdlType;
        }
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null && header.getModelType() != null) {
                this.mdlType = ModelType.get((String)header.getModelType());
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            ModelType modelType = this.mdlType = annotation != null ? annotation.getModelType() : null;
            if (this.mdlType == ModelType.UNKNOWN_LITERAL) {
                this.mdlType = null;
            }
        }
        if (this.mdlType == null && this.isXsd()) {
            this.mdlType = ModelType.TYPE_LITERAL;
        }
        return this.mdlType != null ? this.mdlType : ModelType.PHYSICAL_LITERAL;
    }

    public void setModelType(ModelType type) {
        this.mdlType = type;
    }

    @Override
    public String getDescription() throws ModelWorkspaceException {
        String description = null;
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            description = annotation != null ? annotation.getDescription() : null;
        }
        return description;
    }

    @Override
    public String getUuid() throws ModelWorkspaceException {
        String uuidString = null;
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                uuidString = header.getUUID();
            }
        } else {
            String uuid;
            ModelAnnotation annotation = this.getModelAnnotation();
            if (annotation != null && (uuid = ModelerCore.getObjectIdString((EObject)annotation)) != null) {
                return uuid;
            }
        }
        return uuidString;
    }

    @Override
    public String getPrimaryMetamodelUri() throws ModelWorkspaceException {
        String uriString = null;
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                uriString = header.getPrimaryMetamodelURI();
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            if (annotation != null) {
                uriString = annotation.getPrimaryMetamodelUri();
            }
        }
        return uriString;
    }

    @Override
    public synchronized ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        ModelBufferImpl buffer = (ModelBufferImpl)this.getBufferHack();
        ModelContents contents = buffer.getModelContents();
        return contents != null ? contents.getModelAnnotation() : null;
    }

    protected ModelResourceInfo getModelResourceInfo() throws ModelWorkspaceException {
        return (ModelResourceInfo)this.getItemInfo();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateModelContents() throws ModelWorkspaceException {
        if (!this.isOpen()) return false;
        boolean failed = false;
        try {
            ModelResourceInfo info = this.getModelResourceInfo();
            info.setChildren(this.computeModelContents());
            if (!failed) return true;
        }
        catch (ModelWorkspaceException e) {
            try {
                failed = true;
                throw e;
                catch (RuntimeException e2) {
                    failed = true;
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                try {
                    this.close();
                    throw throwable;
                }
                catch (ModelWorkspaceException modelWorkspaceException) {}
                throw throwable;
            }
        }
        try {
            this.close();
            return true;
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        return true;
    }

    public ModelWorkspaceItem[] computeModelContents() {
        if (ModelUtil.isXsdFile(this.getCorrespondingResource())) {
            return new ModelWorkspaceItem[0];
        }
        ModelDiagramsImpl diagramContainer = new ModelDiagramsImpl(this);
        ModelTransformationsImpl transformationContainer = new ModelTransformationsImpl(this);
        ModelObjectAnnotationsImpl annotationContainer = new ModelObjectAnnotationsImpl(this);
        ModelMappingClassSetsImpl mcSets = new ModelMappingClassSetsImpl(this);
        return new ModelWorkspaceItem[]{diagramContainer, transformationContainer, annotationContainer, mcSets};
    }

    @Override
    public MetamodelDescriptor getPrimaryMetamodelDescriptor() throws ModelWorkspaceException {
        String primaryMetamodelUri = null;
        if (ModelUtil.isXsdFile(this.getResource())) {
            primaryMetamodelUri = "http://www.eclipse.org/xsd/2002/XSD";
        } else if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                primaryMetamodelUri = header.getPrimaryMetamodelURI();
            }
        } else {
            ModelAnnotation annotation = this.getModelAnnotation();
            String string = primaryMetamodelUri = annotation != null ? annotation.getPrimaryMetamodelUri() : null;
        }
        if (primaryMetamodelUri == null) {
            return null;
        }
        MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(primaryMetamodelUri);
        if (descriptor == null) {
            StringBuffer sb = new StringBuffer();
            MetamodelDescriptor[] descriptors = ModelerCore.getMetamodelRegistry().getMetamodelDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                MetamodelDescriptor mmd = descriptors[i];
                if (mmd.isPrimary() && !CoreStringUtil.isEmpty((String)mmd.getNamespaceURI())) {
                    sb.append(mmd.getNamespaceURI());
                    sb.append(CoreStringUtil.Constants.SPACE);
                }
                ++i;
            }
            Object[] params = new Object[]{primaryMetamodelUri, sb.toString()};
            String msg = ModelerCore.Util.getString("ModelResourceImpl.no_metamodel_found_for_primary_metamodel_URI", params);
            ModelerCore.Util.log(4, msg);
        }
        return descriptor;
    }

    @Override
    public List getAllMetamodelDescriptors() throws ModelWorkspaceException {
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                String primaryMetamodelUri = header.getPrimaryMetamodelURI();
                String[] namespaceURIs = header.getNamespaceURIs();
                ArrayList<MetamodelDescriptor> result = new ArrayList<MetamodelDescriptor>(namespaceURIs.length);
                int i = 0;
                while (i < namespaceURIs.length) {
                    String nsUri = namespaceURIs[i];
                    MetamodelDescriptor desc = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(nsUri);
                    if (desc != null) {
                        if (nsUri.equals(primaryMetamodelUri)) {
                            result.add(0, desc);
                        } else {
                            result.add(desc);
                        }
                    }
                    ++i;
                }
                return result;
            }
        } else {
            Resource resource = this.getEmfResource();
            if (resource instanceof EmfResource) {
                ModelAnnotation annotation = this.getModelAnnotation();
                String primaryMetamodelUri = annotation != null ? annotation.getPrimaryMetamodelUri() : null;
                ArrayList<MetamodelDescriptor> result = new ArrayList<MetamodelDescriptor>(9);
                List nsPrefixToUri = ((EmfResource)resource).getNamespacePrefixToUris();
                for (String nsUri : nsPrefixToUri) {
                    MetamodelDescriptor desc = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(nsUri);
                    if (desc == null) continue;
                    if (nsUri.equals(primaryMetamodelUri)) {
                        result.add(0, desc);
                        continue;
                    }
                    result.add(desc);
                }
                return result;
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getModelImports() throws ModelWorkspaceException {
        if (!this.isResourceOpenAndLoaded()) {
            XMIHeader header = this.getXmiHeader();
            if (header != null) {
                ModelImportInfo[] infos = header.getModelImportInfos();
                ArrayList<ModelImport> result = new ArrayList<ModelImport>(infos.length);
                int i = 0;
                while (i < infos.length) {
                    ModelImport modelImport = CoreFactory.eINSTANCE.createModelImport();
                    modelImport.setModelType(ModelType.get((String)infos[i].getModelType()));
                    modelImport.setName(infos[i].getName());
                    modelImport.setPrimaryMetamodelUri(infos[i].getPrimaryMetamodelURI());
                    modelImport.setUuid(infos[i].getUUID());
                    String location = infos[i].getLocation();
                    String path = infos[i].getPath();
                    if (!CoreStringUtil.isEmpty((String)location)) {
                        modelImport.setModelLocation(location);
                    } else if (!CoreStringUtil.isEmpty((String)path)) {
                        if (WorkspaceResourceFinderUtil.isGlobalResource(path)) {
                            modelImport.setModelLocation(location);
                        } else {
                            IFile iResource = WorkspaceResourceFinderUtil.findIResource(path);
                            if (iResource != null) {
                                URI importURI = URI.createFileURI((String)iResource.getLocation().toFile().getAbsolutePath());
                                URI modelURI = URI.createFileURI((String)this.getUnderlyingResource().getLocation().toFile().getAbsolutePath());
                                if (importURI.isFile()) {
                                    URI deresolvedURI;
                                    boolean deresolve;
                                    boolean bl = deresolve = modelURI != null && !modelURI.isRelative() && modelURI.isHierarchical();
                                    if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(modelURI, true, true, false)).hasRelativePath()) {
                                        importURI = deresolvedURI;
                                    }
                                    modelImport.setModelLocation(URI.decode((String)importURI.toString()));
                                }
                            }
                        }
                    }
                    result.add(modelImport);
                    ++i;
                }
                return result;
            }
        } else {
            Resource resource = this.getEmfResource();
            if (resource instanceof EmfResource) {
                ModelAnnotation annotation = this.getModelAnnotation();
                return annotation.getModelImports();
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    private XMIHeader getXmiHeader() throws ModelWorkspaceException {
        if (this.xmiHeader == null) {
            try {
                IPath modelPath = this.getUnderlyingResource().getLocation();
                File modelFile = new File(modelPath.toOSString());
                if (modelFile.exists()) {
                    this.xmiHeader = XMIHeaderReader.readHeader((File)modelFile);
                }
            }
            catch (TeiidDesignerException teiidDesignerException) {
            }
            catch (Throwable e) {
                throw new ModelWorkspaceException(e, ModelerCore.Util.getString("ModelResourceImpl.Error_reading_XMI_header_from_resource_1", (Object)this.getUnderlyingResource()));
            }
        }
        return this.xmiHeader;
    }

    private XsdHeader getXsdHeader() throws ModelWorkspaceException {
        if (this.xsdHeader == null) {
            try {
                IPath modelPath = this.getUnderlyingResource().getLocation();
                File modelFile = new File(modelPath.toOSString());
                if (modelFile.exists() && ModelFileUtil.isXsdFile((File)modelFile)) {
                    this.xsdHeader = XsdHeaderReader.readHeader((File)modelFile);
                }
            }
            catch (TeiidDesignerException teiidDesignerException) {
            }
            catch (Throwable e) {
                throw new ModelWorkspaceException(e, ModelerCore.Util.getString("ModelResourceImpl.Error_reading_Xsd_header_from_resource_1", (Object)this.getUnderlyingResource()));
            }
        }
        return this.xsdHeader;
    }

    private boolean isResourceOpenAndLoaded() {
        return !this.isOpening() && this.isOpen() && this.isLoaded();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean processContentsChange(ModelWorkspaceNotification notification) {
        block24: {
            reloaded = false;
            try {
                block25: {
                    buf = this.getBuffer();
                    if (buf == null || buf.isClosed() || !((resource = (delta = notification.getDelta()).getResource()) instanceof IFile)) break block24;
                    newModStamp = resource.getModificationStamp();
                    lastModStamp = buf.getLastModificationStamp();
                    bufferIsInProcessOfSaving = buf.isInProcessOfSaving();
                    if (newModStamp == -1L || newModStamp == lastModStamp || bufferIsInProcessOfSaving) break block24;
                    rawLocation = ModelUtil.getLocation(resource);
                    fileSize = 0L;
                    if (rawLocation != null && (rawFile = new File(rawLocation.toString())).exists()) {
                        fileSize = rawFile.length();
                    }
                    askToReload = true;
                    if (fileSize == buf.getLastFileSize()) {
                        stream = null;
                        try {
                            stream = ((IFile)resource).getContents();
                            checksum = ChecksumUtil.computeChecksum((InputStream)stream);
                            checksumValue = checksum.getValue();
                            if (checksumValue == buf.getLastChecksum()) {
                                askToReload = false;
                            }
                        }
                        catch (CoreException v0) {
                            askToReload = true;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException v1) {}
                            }
                            break block25;
                        }
                        catch (IOException v2) {
                            try {
                                askToReload = true;
                                ** if (stream == null) goto lbl-1000
                            }
                            catch (Throwable var19_17) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException v4) {}
                                }
                                throw var19_17;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    stream.close();
                                }
                                catch (IOException v3) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block25;
                            }
                        }
                        if (stream == null) break block25;
                        try {
                            stream.close();
                        }
                        catch (IOException v5) {}
                    }
                }
                if (askToReload) {
                    this.setIndexType(0);
                    reload = ModelWorkspaceManager.getModelWorkspaceManager().canReload(this);
                    if (reload) {
                        this.unload();
                        this.getBufferHack();
                        reloaded = true;
                    }
                }
            }
            catch (Exception v6) {}
        }
        return reloaded;
    }

    @Override
    public void save(IProgressMonitor pm, boolean force) throws ModelWorkspaceException {
        super.save(pm, force);
        this.refreshIndexType();
    }

    @Override
    public synchronized void close() throws ModelWorkspaceException {
        super.close();
        if (this.getModelProject().isClosing()) {
            this.removeEmfResource();
        }
    }

    public synchronized void removeEmfResource() {
        IPath path;
        IResource iResource = this.getResource();
        if (iResource != null && (path = iResource.getLocation()) != null) {
            URI uri = URI.createFileURI((String)path.toString());
            try {
                Container resourceSet = ModelerCore.getModelContainer();
                Resource resource = resourceSet.getResource(uri, false);
                if (resource != null) {
                    if (resource.isLoaded()) {
                        resource.unload();
                    }
                    resourceSet.getResources().remove((Object)resource);
                }
            }
            catch (CoreException err) {
                ModelerCore.Util.log((Throwable)err);
            }
        }
    }
}

