/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileSeparatorUtil;
import org.teiid.core.designer.util.FileUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.common.xsd.XsdHeader;
import org.teiid.designer.common.xsd.XsdHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.reader.ZipReader;
import org.teiid.designer.core.reader.ZipReaderCallback;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.MMXmiResource;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelStatusImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ResourceAnnotationHelper;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.core.xmi.XMIHeader;
import org.teiid.designer.core.xmi.XMIHeaderReader;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.CoreMetamodelPlugin;
import org.teiid.designer.metamodels.core.ModelType;

public class ModelUtil
implements StringConstants {
    public static final String META_INF_VDB_XML = "META-INF/vdb.xml";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelUtil.class);
    public static final String MODEL_CLASS_RELATIONAL = "Relational";
    public static final String MODEL_CLASS_XML = "xml";
    public static final String MODEL_CLASS_XML_SCHEMA = "XML Schema (XSD)";
    public static final String MODEL_CLASS_WEB_SERVICE = "Web Service";
    public static final String MODEL_CLASS_FUNCTION = "Function (Deprecated)";
    public static final String MODEL_CLASS_MODEL_EXTENSION = "Model Extension (Deprecated)";
    public static final String MODEL_CLASS_UNKNOWN = "Unknown";
    public static final String URI_XML_VIEW_MODEL = "http://www.metamatrix.com/metamodels/XmlDocument";
    public static final String URI_WEB_SERVICES_VIEW_MODEL = "http://www.metamatrix.com/metamodels/WebService";
    public static final String URI_FUNCTION_MODEL = "http://www.metamatrix.com/metamodels/MetaMatrixFunction";
    public static final String URI_EXTENSION_MODEL = "http://www.metamatrix.com/metamodels/Extension";
    public static final String URI_RELATIONAL_MODEL = "http://www.metamatrix.com/metamodels/Relational";
    public static final String URI_XML_SCHEMA_MODEL = "http://www.eclipse.org/xsd/2002/XSD";
    private static String VDB_NAME_KEY = "core:vdb-name";
    private static String LOCKED_NAME_KEY = "core:locked";
    private static final String[] EXTENSIONS = new String[]{"xml", "xmi"};
    private static XmiHeaderCache cache;

    public static void collectModelIFiles(IContainer iContainer, Collection<IResource> result) {
        if (iContainer != null) {
            try {
                IResource[] iResources = iContainer.members();
                int i = 0;
                while (i != iResources.length) {
                    IResource r = iResources[i];
                    if (r.exists()) {
                        if (r.getType() == 1) {
                            if (ModelUtil.isModelFile(r) || ModelUtil.isXsdFile(r)) {
                                result.add(r);
                            }
                        } else if (r.getType() == 2) {
                            ModelUtil.collectModelIFiles((IContainer)r, result);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                CoreMetamodelPlugin.Util.log((Throwable)e);
            }
        }
    }

    public static void collectModelResources(IContainer iContainer, Collection<ModelResource> result) {
        if (iContainer != null) {
            try {
                IResource[] iResources = iContainer.members();
                int i = 0;
                while (i != iResources.length) {
                    IResource r = iResources[i];
                    if (r.exists()) {
                        if (r.getType() == 1) {
                            ModelResource mr;
                            if ((ModelUtil.isModelFile(r) || ModelUtil.isXsdFile(r)) && (mr = ModelUtil.getModelResource((IFile)r, true)) != null) {
                                result.add(mr);
                            }
                        } else if (r.getType() == 2) {
                            ModelUtil.collectModelResources((IContainer)r, result);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                CoreMetamodelPlugin.Util.log((Throwable)e);
            }
        }
    }

    public static void collectResources(IContainer iContainer, Collection<Resource> result) {
        if (iContainer != null) {
            try {
                IResource[] iResources = iContainer.members();
                int i = 0;
                while (i != iResources.length) {
                    IResource r = iResources[i];
                    if (r.exists()) {
                        if (r.getType() == 1) {
                            ModelResource mr;
                            if ((ModelUtil.isModelFile(r) || ModelUtil.isXsdFile(r)) && (mr = ModelUtil.getModelResource((IFile)r, true)) != null) {
                                result.add(mr.getEmfResource());
                            }
                        } else if (r.getType() == 2) {
                            ModelUtil.collectResources((IContainer)r, result);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                CoreMetamodelPlugin.Util.log((Throwable)e);
            }
        }
    }

    public static IContainer getContainer(Object object) {
        ModelResource resource;
        CoreArgCheck.isNotNull((Object)object);
        Object obj = object;
        if (obj instanceof EObject && (resource = ModelerCore.getModelEditor().findModelResource((EObject)obj)) != null) {
            obj = resource.getResource();
        }
        if (obj instanceof IResource && !(obj instanceof IContainer)) {
            obj = ((IResource)obj).getParent();
        }
        if (obj instanceof IContainer) {
            IContainer ctnr = (IContainer)obj;
            return ctnr.isAccessible() ? ctnr : null;
        }
        return null;
    }

    public static String getFileExtension(File resource) {
        return FileUtil.getExtension((File)resource);
    }

    public static ModelResource getModel(Object object) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)object);
        if (object instanceof ModelResource) {
            return (ModelResource)object;
        }
        if (object instanceof EObject) {
            return ModelerCore.getModelEditor().findModelResource((EObject)object);
        }
        if (object instanceof IFile) {
            return ModelerCore.getModelEditor().findModelResource((IResource)((IFile)object));
        }
        if (object instanceof Resource) {
            return ModelerCore.getModelEditor().findModelResource((Resource)object);
        }
        return null;
    }

    public static String getModelClass(Object object) throws ModelWorkspaceException {
        String mmURI;
        CoreArgCheck.isNotNull((Object)object);
        ModelResource mr = ModelUtil.getModel(object);
        if (mr != null && (mmURI = mr.getPrimaryMetamodelUri()) != null) {
            if (mmURI.equals(URI_RELATIONAL_MODEL)) {
                return MODEL_CLASS_RELATIONAL;
            }
            if (mmURI.equals(URI_FUNCTION_MODEL)) {
                return MODEL_CLASS_FUNCTION;
            }
            if (mmURI.equals(URI_EXTENSION_MODEL)) {
                return MODEL_CLASS_MODEL_EXTENSION;
            }
            if (mmURI.equals(URI_XML_VIEW_MODEL)) {
                return MODEL_CLASS_XML;
            }
            if (mmURI.equals(URI_WEB_SERVICES_VIEW_MODEL)) {
                return MODEL_CLASS_WEB_SERVICE;
            }
            if (mmURI.equals(URI_XML_SCHEMA_MODEL)) {
                return MODEL_CLASS_XML_SCHEMA;
            }
        }
        return MODEL_CLASS_UNKNOWN;
    }

    public static ModelResource getModelResource(IFile modelFile, boolean forceOpen) throws ModelWorkspaceException {
        if (modelFile == null) {
            return null;
        }
        return ModelerCore.getModelEditor().findModelResource((IResource)modelFile);
    }

    private static void getDependentModelResources(ModelResource modelResource, Collection<ModelResource> resources, Collection<ModelResource> modelsProcessed, boolean includeVirtualModels) throws ModelWorkspaceException {
        if (!modelsProcessed.contains(modelResource)) {
            modelsProcessed.add(modelResource);
            Collection dependents = ModelUtil.getDependentResources(modelResource);
            for (ModelResource model : dependents) {
                if (model.getModelType().getValue() == ModelType.PHYSICAL) {
                    if (resources.contains(model)) continue;
                    resources.add(model);
                    continue;
                }
                if (model.getModelType().getValue() != ModelType.VIRTUAL) continue;
                if (includeVirtualModels && !resources.contains(model)) {
                    resources.add(model);
                }
                ModelUtil.getDependentModelResources(model, resources, modelsProcessed, includeVirtualModels);
            }
        }
    }

    public static void getDependentModelResources(ModelResource modelResource, Collection<ModelResource> resources, boolean includeVirtualModels) throws ModelWorkspaceException {
        ModelUtil.getDependentModelResources(modelResource, resources, new ArrayList<ModelResource>(), includeVirtualModels);
    }

    public static Collection getDependentResources(ModelResource resource) throws ModelWorkspaceException {
        ArrayList<ModelResource> result = Collections.EMPTY_LIST;
        IResource theResource = resource.getResource();
        List<IFile> dependents = WorkspaceResourceFinderUtil.getDependentResources(theResource);
        ModelResource mo = null;
        for (IFile dependentResource : dependents) {
            mo = ModelUtil.getModelResource(dependentResource, true);
            if (mo == null) continue;
            if (result.isEmpty()) {
                result = new ArrayList<ModelResource>();
            }
            result.add(mo);
        }
        return result;
    }

    public static String getModelAnnotationPropertyValue(IFile iFile, String key) throws ModelWorkspaceException {
        ModelResource mr = ModelUtil.getModelResource(iFile, true);
        if (mr != null) {
            ResourceAnnotationHelper helper = new ResourceAnnotationHelper();
            return (String)helper.getPropertyValue(mr, key);
        }
        return null;
    }

    public static String getModelAnnotationPropertyValue(ModelResource modelResource, String propertyKey) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotEmpty((String)propertyKey, (String)"propertyKey");
        ResourceAnnotationHelper helper = new ResourceAnnotationHelper();
        return (String)helper.getPropertyValue(modelResource, propertyKey);
    }

    public static void setModelAnnotationPropertyValue(ModelResource modelResource, String propertyKey, String propertyValue) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotEmpty((String)propertyKey, (String)"propertyKey");
        ResourceAnnotationHelper helper = new ResourceAnnotationHelper();
        helper.setProperty(modelResource, propertyKey, propertyValue);
    }

    public static Collection getModels(List objects) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)objects);
        HashSet modelResourceSet = new HashSet();
        for (Object nextObj : objects) {
            ModelResource mr;
            if (nextObj instanceof ModelResource) {
                modelResourceSet.add(nextObj);
            }
            if (nextObj instanceof EObject && (mr = ModelerCore.getModelEditor().findModelResource((EObject)nextObj)) != null) {
                modelResourceSet.add(mr);
            }
            if (nextObj instanceof IFile && (mr = ModelerCore.getModelEditor().findModelResource((IResource)((IFile)nextObj))) != null) {
                modelResourceSet.add(mr);
            }
            if (!(nextObj instanceof Resource) || (mr = ModelerCore.getModelEditor().findModelResource((Resource)nextObj)) == null) continue;
            modelResourceSet.add(mr);
        }
        return modelResourceSet;
    }

    public static ModelResource getModifiableModel(Object object) throws ModelWorkspaceException {
        ModelResource model = ModelUtil.getModel(object);
        if (model != null && !model.isReadOnly()) {
            return model;
        }
        return null;
    }

    public static EStructuralFeature getNameFeature(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        EClass eClass = eObject.eClass();
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!"name".equalsIgnoreCase(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    public static String getName(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = ModelUtil.getNameFeature(eObject);
        if (nameFeature == null) {
            return null;
        }
        Object value = eObject.eGet(nameFeature);
        return value != null ? value.toString() : null;
    }

    public static String getName(ModelResource modelResource) {
        String name = modelResource.getItemName();
        try {
            name = modelResource.getCorrespondingResource().getFullPath().removeFileExtension().lastSegment();
        }
        catch (ModelWorkspaceException e) {
            ModelerCore.Util.log((Throwable)((Object)e));
        }
        return name;
    }

    public static IPath getLocation(IResource resource) throws CoreException {
        if (resource == null) {
            String message = ModelUtil.getString("location.nullResource");
            Status errStatus = new Status(4, "org.teiid.designer.core", message);
            throw new CoreException((IStatus)errStatus);
        }
        IPath location = resource.getRawLocation();
        if (location == null) {
            location = resource.getLocation();
        }
        if (location == null) {
            String message = ModelUtil.getString("location.indeterminateResource", resource.getName());
            Status errStatus = new Status(4, "org.teiid.designer.core", message);
            throw new CoreException((IStatus)errStatus);
        }
        return location;
    }

    public static URI getRelativeLocation(URI baseResourceURI, URI importedResourceURI) {
        URI uri = importedResourceURI;
        if (importedResourceURI.isFile()) {
            URI deresolvedURI;
            boolean deresolve;
            boolean bl = deresolve = baseResourceURI != null && !baseResourceURI.isRelative() && baseResourceURI.isHierarchical();
            if (deresolve && !importedResourceURI.isRelative() && (deresolvedURI = importedResourceURI.deresolve(baseResourceURI, true, true, false)).hasRelativePath()) {
                uri = deresolvedURI;
            }
        }
        return uri;
    }

    public static String getRelativePath(IPath source, IPath base) {
        StringBuffer upPath = new StringBuffer();
        int baseSegments = base.segmentCount();
        int matchingSegments = source.matchingFirstSegments(base);
        int upSegments = baseSegments - matchingSegments;
        String fileSep = FileSeparatorUtil.getFileSeparator((String)source.toString());
        if (base.getFileExtension() != null) {
            --upSegments;
        }
        if (upSegments > 0) {
            int i = 0;
            while (i < upSegments) {
                upPath.append(".." + fileSep);
                ++i;
            }
        }
        IPath sourceRelativePath = source.removeFirstSegments(matchingSegments).makeRelative();
        return upPath + sourceRelativePath.toString();
    }

    static String getString(String id) {
        return ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String arg) {
        return ModelerCore.Util.getString(String.valueOf(I18N_PREFIX) + id, (Object)arg);
    }

    public static void readVdbHeader(File resource, ZipReaderCallback callback) throws Exception {
        if (resource == null || !resource.isFile() || !resource.exists()) {
            return;
        }
        if (!ModelFileUtil.isVdbArchiveFile((File)resource)) {
            return;
        }
        ZipReader reader = new ZipReader(resource);
        reader.readEntry(META_INF_VDB_XML, callback);
    }

    public static IPath getVdbProjectPathURI(MMXmiResource baseResource) {
        if (baseResource.getURI().isFile() && baseResource.getURI().hasAbsolutePath()) {
            String[] pathSegments = baseResource.getURI().segments();
            String baseURI = baseResource.getURI().toString();
            String fileSep = FileSeparatorUtil.getFileSeparator((String)baseURI);
            String deviceLocation = "";
            int vdbFolderIndex = -1;
            Path projectPath = null;
            int i = 0;
            while (i < pathSegments.length) {
                if (projectPath == null) {
                    projectPath = new Path(pathSegments[i]);
                    int index = baseURI.indexOf(pathSegments[i]);
                    if (Platform.getOS().equals("win32")) {
                        deviceLocation = baseURI.substring(0, index - 1);
                        if (deviceLocation.startsWith("file:")) {
                            deviceLocation = String.valueOf(deviceLocation.substring(6)) + fileSep;
                        }
                    } else {
                        deviceLocation = File.separator;
                    }
                } else {
                    projectPath = projectPath.append(FileUtils.normalizeFileName((String)pathSegments[i]));
                }
                if (pathSegments[i].equalsIgnoreCase("vdbWorkingFolder")) {
                    vdbFolderIndex = i;
                    break;
                }
                ++i;
            }
            if (vdbFolderIndex > -1) {
                projectPath = projectPath.append(pathSegments[vdbFolderIndex + 1]);
            }
            IPath finalPath = new Path(deviceLocation).append(projectPath);
            return finalPath;
        }
        return null;
    }

    public static String getVdbName(ModelResource modelResource) throws Exception {
        ModelExtensionRegistry registry;
        EmfModelObjectExtensionAssistant assistant;
        if (modelResource != null && (assistant = (EmfModelObjectExtensionAssistant)(registry = ExtensionPlugin.getInstance().getRegistry()).getModelExtensionAssistant("core")) != null) {
            return assistant.getPropertyValue(modelResource.getModelAnnotation(), "core:vdb-name");
        }
        return null;
    }

    public static XMIHeader getXmiHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && resource.canRead()) {
            XMIHeader header;
            if (cache != null && (header = cache.getCachedXmiHeader(resource)) != null) {
                return header;
            }
            try {
                header = XMIHeaderReader.readHeader(resource);
                if (cache != null) {
                    cache.setXmiHeaderToCache(resource, header);
                }
                return header;
            }
            catch (TeiidDesignerException e) {
                CoreModelerPlugin.Util.log((Throwable)e);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static XMIHeader getXmiHeader(IResource resource) {
        IPath path;
        if (resource != null && resource.getType() == 1 && (path = ((IFile)resource).getLocation()) != null) {
            return ModelUtil.getXmiHeader(path.toFile());
        }
        return null;
    }

    public static XsdHeader getXsdHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && ModelFileUtil.isXsdFile((File)resource)) {
            try {
                return XsdHeaderReader.readHeader((File)resource);
            }
            catch (TeiidDesignerException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return null;
    }

    public static XsdHeader getXsdHeader(IResource resource) {
        IPath path;
        if (resource != null && resource.getType() == 1 && (path = ((IFile)resource).getLocation()) != null) {
            return ModelUtil.getXsdHeader(path.toFile());
        }
        return null;
    }

    private static boolean isIndexFileLastModifiedAfterResourceFile(ModelResource targetModelResource) {
        File rsrcIndexFile = new File(IndexUtil.INDEX_PATH, IndexUtil.getRuntimeIndexFileName(targetModelResource));
        if (!rsrcIndexFile.exists()) {
            return false;
        }
        IPath path = ((IFile)targetModelResource.getResource()).getLocation();
        long resourceLastModified = path.toFile().lastModified();
        long indexLastModified = rsrcIndexFile.lastModified();
        return indexLastModified < resourceLastModified;
    }

    public static boolean isIResourceReadOnly(IResource iResource) {
        if (ModelUtil.isLockedSourceObject(iResource)) {
            return true;
        }
        ResourceAttributes attributes = iResource.getResourceAttributes();
        return attributes == null ? false : attributes.isReadOnly();
    }

    public static boolean isModelFile(IPath path) {
        String extension = path.getFileExtension();
        return ModelFileUtil.isModelFileExtension((String)extension, (boolean)true);
    }

    public static boolean isModelFile(IResource resource) {
        return ModelUtil.isModelFile(resource, true);
    }

    public static boolean isModelFile(IResource resource, boolean projectCheck) {
        IPath path;
        if (projectCheck && !ModelUtil.isModelProjectResource(resource)) {
            return false;
        }
        if (resource.getType() == 1 && (path = ((IFile)resource).getLocation()) != null) {
            return ModelFileUtil.isModelFile((File)path.toFile());
        }
        return false;
    }

    public static boolean isModelFile(Resource resource) {
        if (resource == null) {
            return false;
        }
        String extension = resource.getURI().fileExtension();
        return ModelFileUtil.isModelFileExtension((String)extension, (boolean)true);
    }

    private static boolean isModelProjectResource(IResource resource) {
        IProject proj;
        return resource != null && (proj = resource.getProject()) != null && ModelerCore.hasModelNature(proj);
    }

    public static boolean isPhysical(Object obj) {
        if (obj != null && obj instanceof EObject) {
            File newFile;
            XMIHeader header;
            URI theUri;
            EObject eObject = (EObject)obj;
            Resource resource = eObject.eResource();
            if (resource instanceof EmfResource) {
                return ModelType.PHYSICAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
            }
            if (resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelUtil.getXmiHeader(newFile = new File(theUri.toFileString()))) != null && ModelType.PHYSICAL_LITERAL.equals(ModelType.get((String)header.getModelType()))) {
                return true;
            }
        } else if (obj != null && obj instanceof EmfResource) {
            if (((EmfResource)obj).getModelAnnotation() == null) {
                return false;
            }
            return ModelType.PHYSICAL_LITERAL.equals(((EmfResource)obj).getModelAnnotation().getModelType());
        }
        return false;
    }

    public static boolean isValidFolderNameForPackage(String name) {
        return ModelUtil.validateFolderName(name).getSeverity() != 4;
    }

    public static boolean isValidModelFileName(String name) {
        return ModelUtil.validateModelFileName(name).getSeverity() != 4;
    }

    public static boolean isVdbArchiveFile(IPath path) {
        return path != null && path.getFileExtension() != null && "vdb".equals(path.getFileExtension());
    }

    public static boolean isVdbArchiveFile(IResource resource) {
        return "vdb".equals(resource.getFileExtension());
    }

    public static boolean isVdbArchiveFile(Resource resource) {
        String fileName;
        URI uri;
        return resource != null && (uri = resource.getURI()) != null && (fileName = uri.lastSegment()).endsWith("vdb");
    }

    public static boolean isVdbSourceObject(Object obj) {
        ModelResource mr = null;
        if (obj instanceof EObject) {
            mr = ModelerCore.getModelEditor().findModelResource((EObject)obj);
        } else if (obj instanceof ModelResource) {
            mr = (ModelResource)obj;
        } else if (obj instanceof IFile) {
            try {
                mr = ModelUtil.getModelResource((IFile)obj, true);
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        }
        if (mr != null) {
            try {
                String vdbSourceModelName;
                if (!mr.isLoaded()) {
                    mr.open((IProgressMonitor)new NullProgressMonitor());
                }
                return (vdbSourceModelName = ModelUtil.getModelAnnotationPropertyValue((IFile)mr.getUnderlyingResource(), VDB_NAME_KEY)) != null;
            }
            catch (ModelWorkspaceException ex) {
                CoreMetamodelPlugin.Util.log(4, (Throwable)((Object)ex), ex.getMessage());
            }
        }
        return false;
    }

    public static boolean isLockedSourceObject(Object obj) {
        ModelResource mr = null;
        if (obj instanceof EObject) {
            mr = ModelerCore.getModelEditor().findModelResource((EObject)obj);
        } else if (obj instanceof ModelResource) {
            mr = (ModelResource)obj;
        } else if (obj instanceof IFile) {
            try {
                mr = ModelUtil.getModelResource((IFile)obj, true);
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        }
        if (mr != null && mr.isLoaded()) {
            try {
                String lockedValue = ModelUtil.getModelAnnotationPropertyValue((IFile)mr.getUnderlyingResource(), LOCKED_NAME_KEY);
                return lockedValue != null;
            }
            catch (ModelWorkspaceException ex) {
                CoreMetamodelPlugin.Util.log(4, (Throwable)((Object)ex), ex.getMessage());
            }
        }
        return false;
    }

    public static boolean isVirtual(Object obj) {
        if (obj != null) {
            if (obj instanceof EObject) {
                File newFile;
                XMIHeader header;
                URI theUri;
                EObject eObject = (EObject)obj;
                Resource resource = eObject.eResource();
                if (resource instanceof EmfResource) {
                    return ModelType.VIRTUAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
                }
                if (resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelUtil.getXmiHeader(newFile = new File(theUri.toFileString()))) != null && ModelType.VIRTUAL_LITERAL.equals(ModelType.get((String)header.getModelType()))) {
                    return true;
                }
            } else if (obj instanceof EmfResource) {
                return ModelType.VIRTUAL_LITERAL.equals(((EmfResource)obj).getModelAnnotation().getModelType());
            }
        }
        return false;
    }

    public static boolean isXmiFile(File resource) {
        if ("xmi".equals(ModelUtil.getFileExtension(resource))) {
            if (resource != null && !resource.exists()) {
                return true;
            }
            XMIHeader header = ModelUtil.getXmiHeader(resource);
            if (header != null) {
                if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                    return false;
                }
                if (header.getUUID() != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isXmiFile(IResource resource) {
        XMIHeader header;
        if ("xmi".equals(resource.getFileExtension()) && (header = ModelUtil.getXmiHeader(resource)) != null) {
            if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                return false;
            }
            if (header.getUUID() != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isXmiFile(Resource resource) {
        return resource != null && resource instanceof EmfResource;
    }

    public static boolean isXsdFile(IPath path) {
        return "xsd".equals(path.getFileExtension());
    }

    public static boolean isXsdFile(IResource resource) {
        return "xsd".equals(resource.getFileExtension());
    }

    public static boolean isXsdFile(Resource resource) {
        if (resource != null) {
            String fileName;
            if (resource instanceof XSDResourceImpl) {
                return true;
            }
            URI uri = resource.getURI();
            if (uri != null && (fileName = uri.lastSegment()).endsWith("xsd")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isXsdFile(File file) {
        String fileName;
        return file != null && (fileName = file.getName()) != null && fileName.endsWith("xsd");
    }

    public static String getUuidString(Object obj) {
        ModelResource mr = null;
        String uuid = null;
        try {
            if (obj instanceof ModelResource) {
                mr = (ModelResource)obj;
            } else if (obj instanceof IFile) {
                mr = ModelUtil.getModelResource((IFile)obj, false);
            } else if (obj instanceof Resource) {
                mr = ModelerCore.getModelEditor().findModelResource((Resource)obj);
            }
            if (mr != null) {
                uuid = mr.getUuid();
            }
        }
        catch (ModelWorkspaceException ex) {
            ModelerCore.Util.log(4, (Throwable)((Object)ex), ex.getMessage());
        }
        return uuid;
    }

    private static IStatus newErrorStatus(String msg) {
        return new Status(4, "org.teiid.designer.core", -1, msg, null);
    }

    public static boolean requiresValidation(IFile file) {
        ModelResource mr = null;
        try {
            mr = ModelUtil.getModelResource(file, false);
        }
        catch (ModelWorkspaceException err) {
            String message = ModelUtil.getString("modelResourceNotFoundMessageKey", file.toString());
            ModelerCore.Util.log(4, (Throwable)((Object)err), message);
        }
        if (mr != null) {
            return ModelUtil.requiresValidation(mr);
        }
        return false;
    }

    public static boolean requiresValidation(ModelResource targetModelResource) {
        if (targetModelResource == null) {
            return false;
        }
        if (ModelUtil.isXsdFile(targetModelResource.getResource())) {
            return false;
        }
        boolean isIndexModified = ModelUtil.isIndexFileLastModifiedAfterResourceFile(targetModelResource);
        return targetModelResource.getIndexType() == 0 || isIndexModified;
    }

    public static boolean setIResourceReadOnly(IResource iResource, boolean isReadOnly) {
        ResourceAttributes attributes = iResource.getResourceAttributes();
        if (attributes == null) {
            return false;
        }
        attributes.setReadOnly(isReadOnly);
        return true;
    }

    public static void setModelWorkspaceManagerInitialized() {
        cache = ModelWorkspaceManager.getModelWorkspaceManager();
    }

    public static IStatus validateFolderName(String name) {
        if (name == null) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.folder_must_have_a_non-null_name", new Object[0]));
        }
        if (name.trim().length() == 0) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.folder_must_have_a_non-empty_name", new Object[0]));
        }
        return ModelUtil.validateName(name, 2);
    }

    public static IStatus validateModelFileName(String name) {
        if (name == null) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.model_file_name_may_not_be_null", new Object[0]));
        }
        if (name.trim().length() == 0) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.model_file_name_may_not_be_zero_length", new Object[0]));
        }
        boolean validExtension = false;
        String[] stringArray = EXTENSIONS;
        int n = EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (name.endsWith(element)) {
                validExtension = true;
                break;
            }
            ++n2;
        }
        if (!validExtension) {
            return ModelUtil.newErrorStatus(ModelerCore.Util.getString("ModelUtil.model_file_name_does_not_have_a_valid_extension", new Object[0]));
        }
        return ModelUtil.validateName(name, 1);
    }

    private static IStatus validateName(String segment, int type) {
        if (Character.isWhitespace(segment.charAt(0)) || Character.isWhitespace(segment.charAt(segment.length() - 1))) {
            String message = ModelerCore.Util.getString("ModelUtil.resources.invalidWhitespace", (Object)segment);
            return ModelUtil.newErrorStatus(message);
        }
        if (segment.endsWith(".")) {
            String message = ModelerCore.Util.getString("ModelUtil.resources.invalidDot", (Object)segment);
            return ModelUtil.newErrorStatus(message);
        }
        return ModelStatusImpl.VERIFIED_OK;
    }

    private ModelUtil() {
    }

    public static interface Constants {
        public static final String MODEL_NOT_PHYSICAL_MESSAGE = ModelUtil.getString("modelNotPhysicalMessage");
        public static final String MODEL_RESOURCE_NOT_FOUND_MSG_KEY = "modelResourceNotFoundMessageKey";
    }

    public static interface XmiHeaderCache {
        public XMIHeader getCachedXmiHeader(File var1);

        public void setXmiHeaderToCache(File var1, XMIHeader var2);
    }
}

