/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.ArrayList;
import org.eclipse.core.resources.IResourceDelta;
import org.teiid.designer.core.workspace.ModelWorkspaceDelta;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;

public class ModelWorkspaceDeltaImpl
implements ModelWorkspaceDelta {
    protected ModelWorkspaceItem fChangedElement;
    private int fKind = 0;
    private int fChangeFlags = 0;
    protected ModelWorkspaceDelta[] fAffectedChildren = fgEmptyDelta;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected ModelWorkspaceItem fMovedFromHandle = null;
    protected ModelWorkspaceItem fMovedToHandle = null;
    protected static ModelWorkspaceDelta[] fgEmptyDelta = new ModelWorkspaceDelta[0];

    public ModelWorkspaceDeltaImpl(ModelWorkspaceItem changedItem) {
        this.fChangedElement = changedItem;
    }

    @Override
    public ModelWorkspaceDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    @Override
    public ModelWorkspaceDelta[] getAffectedChildren() {
        return this.fAffectedChildren;
    }

    @Override
    public ModelWorkspaceDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    @Override
    public ModelWorkspaceItem getElement() {
        return this.fChangedElement;
    }

    @Override
    public int getFlags() {
        return this.fChangeFlags;
    }

    @Override
    public int getKind() {
        return this.fKind;
    }

    @Override
    public ModelWorkspaceItem getMovedFromElement() {
        return this.fMovedFromHandle;
    }

    @Override
    public ModelWorkspaceItem getMovedToElement() {
        return this.fMovedToHandle;
    }

    @Override
    public ModelWorkspaceDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    @Override
    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected ModelWorkspaceDelta[] getChildrenOfType(int type) {
        int length = this.fAffectedChildren.length;
        if (length == 0) {
            return new ModelWorkspaceDelta[0];
        }
        ArrayList<ModelWorkspaceDelta> children = new ArrayList<ModelWorkspaceDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.fAffectedChildren[i].getKind() == type) {
                children.add(this.fAffectedChildren[i]);
            }
            ++i;
        }
        ModelWorkspaceDelta[] childrenOfType = new ModelWorkspaceDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 1;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    protected void insertDeltaTree(ModelWorkspaceItem element, ModelWorkspaceDeltaImpl delta) {
        ModelWorkspaceDeltaImpl childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    protected ModelWorkspaceDeltaImpl createDeltaTree(ModelWorkspaceItem element, ModelWorkspaceDeltaImpl delta) {
        ModelWorkspaceDeltaImpl childDelta = delta;
        ArrayList ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.fKind = delta.fKind;
                this.fChangeFlags = delta.fChangeFlags;
                this.fMovedToHandle = delta.fMovedToHandle;
                this.fMovedFromHandle = delta.fMovedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                ModelWorkspaceItem ancestor = (ModelWorkspaceItem)ancestors.get(i);
                ModelWorkspaceDeltaImpl ancestorDelta = new ModelWorkspaceDeltaImpl(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    public void movedFrom(ModelWorkspaceItem movedFromElement, ModelWorkspaceItem movedToElement) {
        ModelWorkspaceDeltaImpl removedDelta = new ModelWorkspaceDeltaImpl(movedFromElement);
        removedDelta.fKind = 2;
        removedDelta.fChangeFlags |= 0x20;
        removedDelta.fMovedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(ModelWorkspaceItem movedToElement, ModelWorkspaceItem movedFromElement) {
        ModelWorkspaceDeltaImpl addedDelta = new ModelWorkspaceDeltaImpl(movedToElement);
        addedDelta.fKind = 1;
        addedDelta.fChangeFlags |= 0x10;
        addedDelta.fMovedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    private ArrayList getAncestors(ModelWorkspaceItem element) {
        ModelWorkspaceItem parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<ModelWorkspaceItem> parents = new ArrayList<ModelWorkspaceItem>();
        while (!parent.equals(this.fChangedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    public void fineGrained() {
        if (this.fKind == 0) {
            this.fKind = 4;
        }
    }

    protected ModelWorkspaceDelta[] removeAndShrinkArray(ModelWorkspaceDelta[] old, int index) {
        int rest;
        ModelWorkspaceDelta[] array = new ModelWorkspaceDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    protected ModelWorkspaceDelta[] growAndAddToArray(ModelWorkspaceDelta[] array, ModelWorkspaceDelta addition) {
        ModelWorkspaceDelta[] old = array;
        array = new ModelWorkspaceDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected void addAffectedChild(ModelWorkspaceDeltaImpl child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 8;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 8;
            }
        }
        if (this.fChangedElement.getItemType() >= 5) {
            this.fineGrained();
        }
        if (this.fAffectedChildren.length == 0) {
            this.fAffectedChildren = new ModelWorkspaceDelta[]{child};
            return;
        }
        ModelWorkspaceDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.fAffectedChildren != null) {
            int i = 0;
            while (i < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                    existingChild = this.fAffectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.fAffectedChildren = this.growAndAddToArray(this.fAffectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.fKind = 4;
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            ModelWorkspaceDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                ModelWorkspaceDeltaImpl childsChild = (ModelWorkspaceDeltaImpl)children[i];
                                ((ModelWorkspaceDeltaImpl)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            IResourceDelta[] resDeltas = child.getResourceDeltas();
                            if (resDeltas != null) {
                                ((ModelWorkspaceDeltaImpl)existingChild).resourceDeltas = resDeltas;
                                ((ModelWorkspaceDeltaImpl)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.fAffectedChildren[existingChildIndex] = child;
                    child.fChangeFlags |= flags;
                }
            }
        }
    }

    public void added(ModelWorkspaceItem element) {
        ModelWorkspaceDeltaImpl addedDelta = new ModelWorkspaceDeltaImpl(element);
        addedDelta.fKind = 1;
        this.insertDeltaTree(element, addedDelta);
    }

    public void changed(ModelWorkspaceItem element, int changeFlag) {
        ModelWorkspaceDeltaImpl changedDelta = new ModelWorkspaceDeltaImpl(element);
        changedDelta.fKind = 4;
        changedDelta.fChangeFlags |= changeFlag;
        this.insertDeltaTree(element, changedDelta);
    }

    protected boolean equalsAndSameParent(ModelWorkspaceItem e1, ModelWorkspaceItem e2) {
        ModelWorkspaceItem parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    protected ModelWorkspaceDeltaImpl find(ModelWorkspaceItem e) {
        if (this.equalsAndSameParent(this.fChangedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.fAffectedChildren.length) {
            ModelWorkspaceDeltaImpl delta = ((ModelWorkspaceDeltaImpl)this.fAffectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }
}

