/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.Index;

public class ModelWorkspaceIndexManager {
    private HashMap currentIndexes = new HashMap();
    private boolean doCache = true;

    public Index addIndex(String indexFileName, String fullPathIndexName, String resourceFileName, boolean reuseExistingFile) {
        Index newIndex = null;
        try {
            try {
                newIndex = resourceFileName != null ? new Index(fullPathIndexName, resourceFileName, reuseExistingFile) : new Index(fullPathIndexName, reuseExistingFile);
                if (this.doCache) {
                    newIndex.setDoCache(true);
                }
            }
            catch (IOException theException) {
                ModelerCore.Util.log(4, (Throwable)theException, "ModelWorkspaceIndexManager.addIndex() error creating Index() for file: " + fullPathIndexName);
                if (newIndex != null && this.doCache) {
                    this.currentIndexes.put(indexFileName, newIndex);
                }
            }
        }
        finally {
            if (newIndex != null && this.doCache) {
                this.currentIndexes.put(indexFileName, newIndex);
            }
        }
        return newIndex;
    }

    public Index getIndex(String indexFileName, String fullPathIndexName, String resourceFileName) {
        if (this.doCache) {
            Index cachedIndex = (Index)this.currentIndexes.get(indexFileName);
            if (cachedIndex != null) {
                return cachedIndex;
            }
            return this.addIndex(indexFileName, fullPathIndexName, resourceFileName, true);
        }
        Index newIndex = null;
        try {
            newIndex = new Index(fullPathIndexName, resourceFileName, true);
        }
        catch (IOException theException) {
            ModelerCore.Util.log(4, (Throwable)theException, "ModelWorkspaceIndexManager.addIndex() error creating Index() for file: " + fullPathIndexName);
        }
        return newIndex;
    }

    public Index getIndex(String indexFileName, String fullPathIndexName) {
        if (this.doCache) {
            Index cachedIndex = (Index)this.currentIndexes.get(indexFileName);
            if (cachedIndex != null) {
                return cachedIndex;
            }
            return this.addIndex(indexFileName, fullPathIndexName, null, false);
        }
        Index newIndex = null;
        try {
            newIndex = new Index(fullPathIndexName, true);
        }
        catch (IOException theException) {
            ModelerCore.Util.log(4, (Throwable)theException, "ModelWorkspaceIndexManager.addIndex() error creating Index() for file: " + fullPathIndexName);
        }
        return newIndex;
    }

    public Index getExistingIndex(String indexFileName) {
        Index cachedIndex = (Index)this.currentIndexes.get(indexFileName);
        return cachedIndex;
    }

    public Index[] getExistingIndexes(File[] indexFiles) {
        ArrayList<Index> tmp = new ArrayList<Index>();
        int i = 0;
        while (i < indexFiles.length) {
            String fileName = indexFiles[i].getName();
            Index nextIndex = this.getExistingIndex(fileName);
            if (nextIndex != null) {
                tmp.add(nextIndex);
            }
            ++i;
        }
        Index[] indexes = new Index[tmp.size()];
        tmp.toArray(indexes);
        return indexes;
    }

    public Index getNewIndex(String indexFileName, String fullPathIndexName, String resourceFileName) {
        if (this.doCache) {
            Index cachedIndex = (Index)this.currentIndexes.get(indexFileName);
            if (cachedIndex != null) {
                this.disposeIndex(cachedIndex);
            }
            return this.addIndex(indexFileName, fullPathIndexName, null, false);
        }
        Index newIndex = null;
        try {
            newIndex = new Index(fullPathIndexName, resourceFileName, true);
        }
        catch (IOException theException) {
            ModelerCore.Util.log(4, (Throwable)theException, "ModelWorkspaceIndexManager.addIndex() error creating Index() for file: " + fullPathIndexName);
        }
        return newIndex;
    }

    public Index getNewIndex(String indexFileName, String fullPathIndexName) {
        if (this.doCache) {
            Index cachedIndex = (Index)this.currentIndexes.get(indexFileName);
            if (cachedIndex != null) {
                this.disposeIndex(cachedIndex);
            }
            return this.addIndex(indexFileName, fullPathIndexName, null, false);
        }
        Index newIndex = null;
        try {
            newIndex = new Index(fullPathIndexName, true);
        }
        catch (IOException theException) {
            ModelerCore.Util.log(4, (Throwable)theException, "ModelWorkspaceIndexManager.addIndex() error creating Index() for file: " + fullPathIndexName);
        }
        return newIndex;
    }

    public void disposeIndex(String indexFileName) {
        Index existingIndex = (Index)this.currentIndexes.get(indexFileName);
        if (existingIndex != null) {
            this.currentIndexes.remove(indexFileName);
            existingIndex.dispose();
        }
    }

    public void disposeIndex(Index index) {
        this.disposeIndex(index.getIndexFile().getName());
    }

    public void clear() {
        for (Index nextIndex : this.currentIndexes.values()) {
            if (nextIndex == null) continue;
            nextIndex.close();
        }
        this.currentIndexes.clear();
    }

    public void disposeAll() {
        ArrayList copyOfIndexes = new ArrayList(this.currentIndexes.values());
        for (Index nextIndex : copyOfIndexes) {
            if (nextIndex == null) continue;
            this.disposeIndex(nextIndex);
        }
        this.currentIndexes.clear();
    }

    public void closeIndex(Index index) {
        index.close();
        this.currentIndexes.remove(index.getIndexFile().getName());
    }

    public void closeAll() {
        ArrayList copyOfIndexes = new ArrayList(this.currentIndexes.values());
        for (Index nextIndex : copyOfIndexes) {
            if (nextIndex == null) continue;
            nextIndex.close();
            this.currentIndexes.remove(nextIndex.getIndexFile().getName());
        }
    }
}

