/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.InternalOpenable;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelStatusImpl;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceItemInfo;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceVisitor;
import org.teiid.designer.core.workspace.Openable;

public abstract class ModelWorkspaceItemImpl
extends PlatformObject
implements ModelWorkspaceItem {
    protected static final int MINIMUM_VALID_TYPE = 1;
    protected static final int MAXIMUM_VALID_TYPE = 11;
    protected int occurrenceCount = 1;
    protected boolean opening = false;
    protected boolean closing = false;
    protected final int fType;
    protected final ModelWorkspaceItem fParent;
    protected final String fName;
    protected static final Object NO_INFO = new Object();

    protected ModelWorkspaceItemImpl(int type, ModelWorkspaceItem parent, String name) throws IllegalArgumentException {
        if (type < 1 || type > 11) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("element.invalidType", new Object[0]));
        }
        this.fType = type;
        this.fParent = parent;
        this.fName = name;
        if (this.fParent != null) {
            try {
                ModelWorkspaceItemInfo info = this.fParent.getItemInfo();
                info.addChild(this);
            }
            catch (ModelWorkspaceException e) {
                ModelerCore.Util.log(4, (Throwable)((Object)e), ModelerCore.Util.getString("ModelWorkspaceItemImpl.Error_trying_to_create_a_modelWorksapceItem_{0}_under_the_parent_{1}_1", new Object[]{name, this.fParent.getItemName()}));
            }
        }
    }

    @Override
    public String getItemName() {
        return this.fName;
    }

    @Override
    public int getItemType() {
        return this.fType;
    }

    @Override
    public ModelWorkspace getModelWorkspace() {
        ModelWorkspaceItem current = this;
        do {
            if (!(current instanceof ModelWorkspace)) continue;
            return (ModelWorkspace)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public ModelProject getModelProject() {
        ModelWorkspaceItem current = this;
        do {
            if (!(current instanceof ModelProject)) continue;
            return (ModelProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public IResource getCorrespondingResource() throws ModelWorkspaceException {
        return null;
    }

    @Override
    public Openable getOpenable() {
        return this.getOpenableParent();
    }

    public Openable getOpenableParent() {
        return (Openable)((Object)this.fParent);
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return HashCodeUtil.hashCode((int)this.fParent.hashCode(), (int)this.fName.hashCode());
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected boolean isAncestorOf(ModelWorkspaceItem item) {
        if (item == null) {
            return false;
        }
        ModelWorkspaceItem parent = item.getParent();
        while (parent != null && !parent.equals(this)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    @Override
    public ModelWorkspaceItem getParent() {
        return this.fParent;
    }

    @Override
    public ModelWorkspaceItem[] getChildren() throws ModelWorkspaceException {
        return this.getItemInfo().getChildren();
    }

    public ArrayList getChildrenOfType(int type) throws ModelWorkspaceException {
        ModelWorkspaceItem[] children = this.getChildren();
        int size = children.length;
        ArrayList<ModelWorkspaceItem> list = new ArrayList<ModelWorkspaceItem>(size);
        int i = 0;
        while (i < size) {
            ModelWorkspaceItem elt = children[i];
            if (elt.getItemType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public ModelWorkspaceItem getFirstChildrenOfType(int type) throws ModelWorkspaceException {
        ModelWorkspaceItem[] children = this.getChildren();
        int size = children.length;
        int i = 0;
        while (i < size) {
            ModelWorkspaceItem elt = children[i];
            if (elt.getItemType() == type) {
                return elt;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isStructureKnown() throws ModelWorkspaceException {
        return this.getItemInfo().isStructureKnown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelWorkspaceItemInfo getItemInfo() throws ModelWorkspaceException {
        ModelWorkspaceManager manager;
        ModelWorkspaceManager modelWorkspaceManager = manager = ModelWorkspaceManager.getModelWorkspaceManager();
        synchronized (manager) {
            ModelWorkspaceItemInfo info = manager.getInfo(this);
            if (info == null) {
                this.openHierarchy();
                info = manager.getInfo(this);
                if (info == null) {
                    throw this.newNotPresentException();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return info;
        }
    }

    protected void openHierarchy() throws ModelWorkspaceException {
        if (this instanceof InternalOpenable) {
            ((InternalOpenable)((Object)this)).openWhenClosed(null);
        } else {
            Openable openableParent = this.getOpenableParent();
            if (openableParent != null) {
                ModelWorkspaceItemInfo openableParentInfo = ModelWorkspaceManager.getModelWorkspaceManager().getInfo((ModelWorkspaceItem)((Object)openableParent));
                if (openableParentInfo == null) {
                    if (openableParent instanceof InternalOpenable) {
                        ((InternalOpenable)((Object)openableParent)).openWhenClosed(null);
                    }
                } else {
                    throw this.newNotPresentException();
                }
            }
        }
    }

    protected void opening(Object info) {
    }

    public void close() throws ModelWorkspaceException {
        this.closing = true;
        boolean wasVerbose = ModelWorkspaceManager.VERBOSE;
        try {
            try {
                Object info = ModelWorkspaceManager.getModelWorkspaceManager().peekAtInfo(this);
                if (info != null) {
                    if (ModelWorkspaceManager.VERBOSE) {
                        System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
                        wasVerbose = true;
                        ModelWorkspaceManager.VERBOSE = false;
                    }
                    ModelWorkspaceItem[] children = ((ModelWorkspaceItemInfo)info).getChildren();
                    int i = 0;
                    int size = children.length;
                    while (i < size) {
                        ModelWorkspaceItemImpl child = (ModelWorkspaceItemImpl)children[i];
                        child.close();
                        ++i;
                    }
                    this.closing(info);
                    ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
                    if (wasVerbose) {
                        System.out.println("-> Package cache size = " + ModelWorkspaceManager.getModelWorkspaceManager().cache.pkgSize());
                    }
                }
            }
            catch (ModelWorkspaceException e) {
                throw e;
            }
            catch (Throwable t) {
                ModelerCore.Util.log(t);
                ModelWorkspaceManager.VERBOSE = wasVerbose;
                this.closing = false;
            }
        }
        finally {
            ModelWorkspaceManager.VERBOSE = wasVerbose;
            this.closing = false;
        }
    }

    protected void closing(Object info) {
    }

    protected void removeInfo() {
        Object info = ModelWorkspaceManager.getModelWorkspaceManager().peekAtInfo(this);
        if (info != null) {
            ModelWorkspaceItem[] children = ((ModelWorkspaceItemInfo)info).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                ModelWorkspaceItemImpl child = (ModelWorkspaceItemImpl)children[i];
                child.removeInfo();
                ++i;
            }
            ModelWorkspaceManager.getModelWorkspaceManager().removeInfo(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.fParent == null) {
            return super.equals(o);
        }
        if (o instanceof ModelWorkspaceItemImpl) {
            ModelWorkspaceItemImpl other = (ModelWorkspaceItemImpl)o;
            if (this.fType != other.fType) {
                return false;
            }
            return this.fName.equals(other.fName) && this.fParent.equals(other.fParent) && this.occurrenceCount == other.occurrenceCount;
        }
        return false;
    }

    @Override
    public boolean exists() {
        try {
            this.getItemInfo();
            return true;
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            return false;
        }
    }

    protected ModelWorkspaceException newNotPresentException() {
        return new ModelWorkspaceException(new ModelStatusImpl(969, this));
    }

    protected void setOccurrenceCount(int count) {
        this.occurrenceCount = count;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        ModelWorkspaceItemImpl parent = (ModelWorkspaceItemImpl)this.getParent();
        if (parent != null && parent.getParent() != null) {
            buffer.append(" [in ");
            parent.toStringInfo(0, buffer, NO_INFO);
            parent.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof ModelWorkspaceItemInfo)) {
            return;
        }
        ModelWorkspaceItem[] children = ((ModelWorkspaceItemInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((ModelWorkspaceItemImpl)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = ModelWorkspaceManager.getModelWorkspaceManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append(this.getItemName());
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    public void accept(ModelWorkspaceVisitor visitor, int depth) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)visitor);
        if (depth != 2 && depth != 1 && depth != 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ModelWorkspaceItemImpl.Invalid_visitor_depth", new Object[0]));
        }
        if (!visitor.visit(this) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        ModelWorkspaceItem[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].accept(visitor, nextDepth);
            ++i;
        }
    }

    @Override
    public ModelWorkspaceItem getChild(IResource resource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)resource);
        String resourceName = resource.getName();
        return this.getChild(resourceName);
    }

    @Override
    public ModelWorkspaceItem getChild(String childName) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)childName);
        ModelWorkspaceItem[] children = this.getChildren();
        int j = 0;
        while (j < children.length) {
            ModelWorkspaceItem child = children[j];
            if (child.getItemName().equals(childName)) {
                return child;
            }
            ++j;
        }
        return null;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public boolean isOpening() {
        return this.opening;
    }
}

