/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.teiid.core.designer.selection.TreeSelection;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceSelectionFilter;
import org.teiid.designer.core.workspace.ModelWorkspaceView;

public class ModelWorkspaceSelections
implements TreeSelection {
    public static final ModelWorkspaceSelectionFilter ALL_SELECTABLE_FILTER = new ModelWorkspaceSelectionFilter(){

        @Override
        public boolean isSelectable(Object element) {
            return true;
        }
    };
    public static final int UNSELECTED = 0;
    public static final int SELECTED = 1;
    public static final int PARTIALLY_SELECTED = 2;
    public static final int UNKNOWN_SELECTION = -1;
    private final Set selecteds = new HashSet();
    private final Set unselecteds = new HashSet();
    private final Set partiallySelected = new HashSet();
    private final List selectableFilters = new LinkedList();
    private ModelWorkspaceView modelWorkspaceView;

    public ModelWorkspaceView getModelWorkspaceView() {
        return this.modelWorkspaceView;
    }

    public void setModelWorkspaceView(ModelWorkspaceView view) {
        this.modelWorkspaceView = view;
    }

    public List getModelWorkspaceSelectionFilters() {
        return this.selectableFilters;
    }

    protected boolean isSelectable(Object object) {
        for (ModelWorkspaceSelectionFilter filter : this.selectableFilters) {
            if (!filter.isSelectable(object)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectionModes() {
        return this.selecteds.size() != 0 || this.partiallySelected.size() != 0 || this.unselecteds.size() != 0;
    }

    public int getSelectionMode(IPath path) {
        CoreArgCheck.isNotNull((Object)path);
        if (this.selecteds.contains(path)) {
            return 1;
        }
        if (this.unselecteds.contains(path)) {
            return 0;
        }
        if (this.partiallySelected.contains(path)) {
            return 2;
        }
        if (path.segmentCount() == 0) {
            this.unselecteds.add(path);
            return 0;
        }
        if (path.segmentCount() == 1) {
            this.unselecteds.add(path);
            return 0;
        }
        IPath parentPath = path.removeLastSegments(1);
        int parentMode = this.getSelectionMode(parentPath);
        if (parentMode == 1) {
            this.selecteds.add(path);
            return 1;
        }
        return 0;
    }

    public int getSelectionMode(Object modelObject) {
        CoreArgCheck.isNotNull((Object)modelObject);
        this.assertNonNullView();
        IPath path = this.modelWorkspaceView.getPath(modelObject);
        if (path != null) {
            return this.getSelectionMode(path);
        }
        return 0;
    }

    protected void assertNonNullView() {
        if (this.modelWorkspaceView == null) {
            String msg = ModelerCore.Util.getString("ModelWorkspaceSelections.NoViewReference", new Object[0]);
            throw new IllegalStateException(msg);
        }
    }

    public void setSelected(Object modelObject, boolean selected) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelObject);
        int mode = selected ? 1 : 0;
        this.setSelected(modelObject, mode);
    }

    protected void setSelected(Object modelObject, int selectionMode) throws ModelWorkspaceException {
        if (this.isSelectable(modelObject)) {
            this.assertNonNullView();
            IPath path = this.modelWorkspaceView.getPath(modelObject);
            if (path != null) {
                this.setSelected(path, selectionMode);
                this.updateParentSelection(modelObject, path, selectionMode);
            }
        }
    }

    protected void setSelected(IPath path, int selectionMode) {
        CoreArgCheck.isNotNull((Object)path);
        if (selectionMode == 1) {
            this.selecteds.add(path);
            this.unselecteds.remove(path);
            this.partiallySelected.remove(path);
            this.removeSubpaths(this.unselecteds, path);
            this.removeSubpaths(this.partiallySelected, path);
        } else if (selectionMode == 0) {
            this.selecteds.remove(path);
            this.unselecteds.add(path);
            this.partiallySelected.remove(path);
            this.removeSubpaths(this.selecteds, path);
            this.removeSubpaths(this.partiallySelected, path);
        } else if (selectionMode == 2) {
            this.selecteds.remove(path);
            this.unselecteds.remove(path);
            this.partiallySelected.add(path);
        }
    }

    protected void removeSubpaths(Set paths, IPath path) {
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            IPath existingPath = (IPath)iter.next();
            if (!path.isPrefixOf(existingPath)) continue;
            iter.remove();
        }
    }

    protected void updateParentSelection(Object child, IPath childPath, int childSelectionMode) throws ModelWorkspaceException {
        IPath parentPath = childPath.removeLastSegments(1);
        if (parentPath.segmentCount() == 0) {
            return;
        }
        int currentParentMode = this.getSelectionMode(parentPath);
        if (currentParentMode == childSelectionMode) {
            return;
        }
        if (this.modelWorkspaceView != null) {
            Object parent = this.modelWorkspaceView.getParent(child);
            if (parent != null) {
                Object[] children = this.modelWorkspaceView.getChildren(parent);
                boolean foundFullySelected = false;
                boolean foundUnselected = false;
                int i = 0;
                while (i < children.length) {
                    Object childObj = children[i];
                    if (this.isSelectable(childObj)) {
                        IPath childObjPath = this.modelWorkspaceView.getPath(childObj);
                        int mode = this.getSelectionMode(childObjPath);
                        if (mode == 1) {
                            foundFullySelected = true;
                        } else if (mode == 0) {
                            foundUnselected = true;
                        }
                        if (mode == 2 || foundFullySelected && foundUnselected) {
                            this.setSelected(parent, 2);
                            return;
                        }
                    }
                    ++i;
                }
                if (foundFullySelected) {
                    this.setSelected(parent, 1);
                } else {
                    this.setSelected(parent, 0);
                }
                return;
            }
        } else if (currentParentMode == 1 && childSelectionMode == 0 || childSelectionMode == 2) {
            this.setSelected(parentPath, 2);
        }
    }

    public List getSelectedPaths() {
        return this.createSortedPaths(this.selecteds);
    }

    public List getPartiallySelectedPaths() {
        return this.createSortedPaths(this.partiallySelected);
    }

    public List getUnselectedPaths() {
        return this.createSortedPaths(this.unselecteds);
    }

    public List getSelectedOrPartiallySelectedModelResources() throws ModelWorkspaceException {
        this.assertNonNullView();
        LinkedList<ModelResource> result = new LinkedList<ModelResource>();
        int i = 0;
        while (i < 2) {
            List paths = i == 0 ? this.getSelectedPaths() : this.getPartiallySelectedPaths();
            for (IPath path : paths) {
                ModelResource modelResource = this.modelWorkspaceView.findModelResourceForObject(path);
                if (modelResource != null) {
                    if (result.contains(modelResource)) continue;
                    result.add(modelResource);
                    continue;
                }
                Object obj = this.modelWorkspaceView.findObject(path);
                if (!(obj instanceof ModelWorkspaceItem)) continue;
                this.addAllModelResources((ModelWorkspaceItem)obj, result);
            }
            ++i;
        }
        return result;
    }

    private void addAllModelResources(ModelWorkspaceItem item, List result) throws ModelWorkspaceException {
        int mode = this.getSelectionMode(item);
        if (mode != 1 && mode != 2) {
            return;
        }
        if (item instanceof ModelResource) {
            if (!result.contains(item)) {
                result.add(item);
            }
            return;
        }
        ModelWorkspaceItem[] children = item.getChildren();
        int i = 0;
        while (i < children.length) {
            ModelWorkspaceItem child = children[i];
            if (this.modelWorkspaceView.isVisible(item, child)) {
                this.addAllModelResources(child, result);
            }
            ++i;
        }
    }

    public List getSelectedOrPartiallySelectedNonModelResources() throws ModelWorkspaceException {
        this.assertNonNullView();
        LinkedList<IResource> result = new LinkedList<IResource>();
        int i = 0;
        while (i < 2) {
            List paths = i == 0 ? this.getSelectedPaths() : this.getPartiallySelectedPaths();
            for (IPath path : paths) {
                IResource resource = ModelerCore.getWorkspace().getRoot().findMember(path);
                if (resource != null) {
                    if (result.contains(resource)) continue;
                    result.add(resource);
                    continue;
                }
                Object obj = this.modelWorkspaceView.findObject(path);
                if (!(obj instanceof ModelWorkspaceItem)) continue;
                this.addAllNonModelResources((ModelWorkspaceItem)obj, result);
            }
            ++i;
        }
        return result;
    }

    private void addAllNonModelResources(ModelWorkspaceItem item, List result) throws ModelWorkspaceException {
        int mode = this.getSelectionMode(item);
        if (mode != 1 && mode != 2) {
            return;
        }
        IResource iresource = item.getCorrespondingResource();
        if (item instanceof ModelResource) {
            if (!result.contains(iresource)) {
                result.add(iresource);
            }
            return;
        }
        ModelWorkspaceItem[] children = item.getChildren();
        int i = 0;
        while (i < children.length) {
            ModelWorkspaceItem child = children[i];
            this.addAllNonModelResources(child, result);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString("  Selected Paths", this.selecteds, sb);
        this.toString("\n  Partially-Selected Paths", this.partiallySelected, sb);
        this.toString("\n  Unselected Paths", this.unselecteds, sb);
        return sb.toString();
    }

    protected void toString(String desc, Set paths, StringBuffer sb) {
        sb.append(String.valueOf(desc) + " (" + paths.size() + "):");
        List sortedPaths = this.createSortedPaths(paths);
        for (Object path : sortedPaths) {
            sb.append("\n     " + path);
        }
    }

    protected List createSortedPaths(Set paths) {
        LinkedList sortedPaths = new LinkedList();
        sortedPaths.addAll(paths);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IPath)o1).toString().compareTo(((IPath)o2).toString());
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        };
        Collections.sort(sortedPaths, comparator);
        return sortedPaths;
    }
}

