/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceFilter;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;

public class ModelWorkspaceView {
    public static final boolean DEFAULT_RESTRICT_TO_MODEL_RESOURCES_ONLY = true;
    public static final ModelWorkspaceFilter SHOW_ALL_FILTER = new ModelWorkspaceFilter(){

        @Override
        public boolean select(Object parentElement, Object element) {
            return true;
        }
    };
    private static final Object[] EMPTY_CHILDREN = new Object[0];
    final List filters = new LinkedList();
    final ModelWorkspace workspace = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
    private boolean restrictedToModelResourcesOnly;

    public ModelWorkspaceView() {
        CoreArgCheck.isNotNull((Object)this.workspace);
        this.restrictedToModelResourcesOnly = true;
    }

    public boolean isRestrictedToModelWorkspaceItemsOnly() {
        return this.restrictedToModelResourcesOnly;
    }

    public void setRestrictedToModelWorkspaceItemsOnly(boolean b) {
        this.restrictedToModelResourcesOnly = b;
    }

    public List getModelWorkspaceFilters() {
        return this.filters;
    }

    protected boolean isVisible(Object parent, Object object) {
        for (ModelWorkspaceFilter filter : this.filters) {
            if (!filter.select(parent, object)) continue;
            return true;
        }
        return false;
    }

    public IPath getPath(Object object) {
        if (object instanceof ModelWorkspaceItem) {
            return ((ModelWorkspaceItem)object).getPath();
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = editor.findModelResource(eObject);
            IPath modelPath = resource.getPath();
            IPath pathInModel = editor.getModelRelativePath(eObject);
            return modelPath.append(pathInModel);
        }
        return null;
    }

    public Object findObject(IPath path) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)path);
        String[] segments = path.segments();
        ModelWorkspaceItem object = this.workspace;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            if (object instanceof ModelResource) {
                ModelResource modelResource = (ModelResource)object;
                IPath pathInModel = path.removeFirstSegments(i);
                ModelEditor editor = ModelerCore.getModelEditor();
                return editor.findObjectByPath(modelResource, pathInModel);
            }
            if (object instanceof ModelWorkspaceItem) {
                ModelWorkspaceItem item = object;
                object = item.getChild(segment);
            }
            ++i;
        }
        return object;
    }

    public ModelResource findModelResourceForObject(IPath path) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)path);
        String[] segments = path.segments();
        ModelWorkspaceItem object = this.workspace;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            if (object instanceof ModelResource) {
                return (ModelResource)object;
            }
            if (object instanceof ModelWorkspaceItem) {
                ModelWorkspaceItem item = object;
                object = item.getChild(segment);
            }
            ++i;
        }
        return null;
    }

    public Object[] getChildren(Object parent) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)parent);
        Object children = this.doGetChildren(parent);
        if (children == null) {
            return EMPTY_CHILDREN;
        }
        LinkedList<Object> results = new LinkedList<Object>();
        if (children instanceof Object[]) {
            Object[] childObjects = (Object[])children;
            boolean allChildren = true;
            int i = 0;
            while (i < childObjects.length) {
                Object child = childObjects[i];
                if (this.isVisible(parent, child)) {
                    results.add(child);
                } else {
                    allChildren = false;
                }
                ++i;
            }
            if (allChildren) {
                return childObjects;
            }
        } else if (children instanceof Collection) {
            Collection childrenList = (Collection)children;
            for (Object child : childrenList) {
                if (!this.isVisible(parent, child)) continue;
                results.add(child);
            }
        }
        return results.toArray();
    }

    protected Object doGetChildren(Object parent) throws ModelWorkspaceException {
        if (parent instanceof EObject) {
            return ((EObject)parent).eContents();
        }
        if (parent instanceof ModelResource) {
            return ((ModelResource)parent).getEObjects();
        }
        if (parent instanceof ModelWorkspaceItem) {
            ModelWorkspaceItem mwsItem = (ModelWorkspaceItem)parent;
            ModelWorkspaceItem[] children = mwsItem.getChildren();
            if (this.restrictedToModelResourcesOnly) {
                return children;
            }
            HashSet<IResource> modelResources = new HashSet<IResource>();
            ArrayList<ModelWorkspaceItem> results = new ArrayList<ModelWorkspaceItem>();
            int i = 0;
            while (i < children.length) {
                ModelWorkspaceItem item = children[i];
                results.add(item);
                IResource iresource = item.getCorrespondingResource();
                if (iresource != null) {
                    modelResources.add(iresource);
                }
                ++i;
            }
            try {
                IResource iresource = mwsItem.getCorrespondingResource();
                if (iresource != null && iresource instanceof IContainer) {
                    IContainer container = (IContainer)iresource;
                    IResource[] resourceChildren = container.members();
                    int i2 = 0;
                    while (i2 < resourceChildren.length) {
                        IResource resource = resourceChildren[i2];
                        if (!modelResources.contains(resource)) {
                            results.add((ModelWorkspaceItem)resource);
                        }
                        ++i2;
                    }
                }
            }
            catch (ModelWorkspaceException e) {
                ModelerCore.Util.log((Throwable)((Object)e));
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            return results;
        }
        return null;
    }

    public boolean hasChildren(Object element) throws ModelWorkspaceException {
        Object children = this.doGetChildren(element);
        if (children == EMPTY_CHILDREN) {
            return false;
        }
        if (children instanceof Object[]) {
            Object[] childObjects = (Object[])children;
            int i = 0;
            while (i < childObjects.length) {
                Object child = childObjects[i];
                if (this.isVisible(element, child)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (children instanceof Collection) {
            Collection childrenList = (Collection)children;
            for (Object child : childrenList) {
                if (!this.isVisible(element, child)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getParent(Object element) {
        CoreArgCheck.isNotNull((Object)element);
        if (element instanceof EObject) {
            EObject obj = (EObject)element;
            EObject parentObject = obj.eContainer();
            if (parentObject != null) {
                return parentObject;
            }
            return this.workspace.findModelResource(obj);
        }
        if (element instanceof ModelWorkspaceItem) {
            return ((ModelWorkspaceItem)element).getParent();
        }
        return null;
    }
}

