/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;

public class ResourceAnnotationHelper {
    private static String getNamespace(String str) {
        CoreArgCheck.isNotNull((Object)str, (String)"str");
        int semiColonIndex = str.indexOf(58) + 1;
        if (semiColonIndex > 0) {
            return str.substring(0, semiColonIndex);
        }
        return null;
    }

    public Annotation getResourceAnnotation(ModelResource modelResource, boolean forceCreate) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Annotation annotation = null;
        if (modelResource.getAnnotations() != null && modelResource.getModelAnnotation() != null && (annotation = modelResource.getAnnotations().getAnnotation((EObject)modelResource.getModelAnnotation())) == null && forceCreate) {
            annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)modelResource.getModelAnnotation(), modelResource.getEmfResource());
            ModelContents contents = ModelerCore.getModelEditor().getModelContents(modelResource);
            AnnotationContainer ac = contents.getAnnotationContainer(true);
            if (ac != null) {
                annotation.setAnnotationContainer(ac);
            }
        }
        return annotation;
    }

    public Object getPropertyValue(ModelResource modelResource, String key) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        Annotation annotation = this.getResourceAnnotation(modelResource, false);
        if (annotation != null) {
            return annotation.getTags().get((Object)key);
        }
        return null;
    }

    public Properties getProperties(ModelResource modelResource, String namespacePrefix) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotNull((Object)namespacePrefix, (String)"namespacePrefix");
        Properties props = new Properties();
        Annotation annotation = this.getResourceAnnotation(modelResource, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            Set keys = tags.keySet();
            for (Object nextKey : keys) {
                String namespace = ResourceAnnotationHelper.getNamespace((String)nextKey);
                if (namespace == null || !namespace.equals(namespacePrefix)) continue;
                props.put(nextKey, tags.get(nextKey));
            }
        }
        return props;
    }

    public Properties getAllProperties(ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Properties props = new Properties();
        Annotation annotation = this.getResourceAnnotation(modelResource, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            Set keys = tags.keySet();
            for (Object nextKey : keys) {
                props.put(nextKey, tags.get(nextKey));
            }
        }
        return props;
    }

    public void removeProperties(ModelResource modelResource, String namespacePrefix) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotNull((Object)namespacePrefix, (String)"namespacePrefix");
        Annotation annotation = this.getResourceAnnotation(modelResource, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            HashSet keys = new HashSet(tags.keySet());
            for (Object nextKey : keys) {
                String namespace = ResourceAnnotationHelper.getNamespace((String)nextKey);
                if (namespace == null || !namespace.equals(namespacePrefix)) continue;
                tags.remove(nextKey);
            }
        }
    }

    public void setProperty(ModelResource modelResource, String key, Object value) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        CoreArgCheck.isNotNull((Object)value, (String)"value");
        Annotation annotation = this.getResourceAnnotation(modelResource, true);
        annotation.getTags().put((Object)key, value);
    }

    public void setProperties(ModelResource modelResource, Properties props) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotNull((Object)props, (String)"props");
        Annotation annotation = this.getResourceAnnotation(modelResource, true);
        Set<Object> keys = props.keySet();
        for (Object nextKey : keys) {
            annotation.getTags().put(nextKey, props.get(nextKey));
        }
    }
}

