/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui;

import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.esb.project.ui.ESBProjectPlugin;
import org.osgi.framework.Bundle;

public class ESBSharedImages {
    public static String WIZARD_NEW_PROJECT = "WIZARD_NEW_PROJECT";
    private static ESBSharedImages instance;
    private Hashtable<String, Object> images;
    private Hashtable<String, Object> descriptors;

    private static ESBSharedImages instance() {
        if (instance == null) {
            return new ESBSharedImages();
        }
        return instance;
    }

    public static Image getImage(String key) {
        return ESBSharedImages.instance().image(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ESBSharedImages.instance().descriptor(key);
    }

    private ESBSharedImages() {
        instance = this;
        this.images = new Hashtable();
        this.descriptors = new Hashtable();
        Bundle pluginBundle = ESBProjectPlugin.getDefault().getBundle();
        this.descriptors.put(WIZARD_NEW_PROJECT, this.createImageDescriptor(pluginBundle, "/icons/obj16/EclipseCreateNewProject.png"));
        for (String key : this.descriptors.keySet()) {
            ImageDescriptor descriptor = this.descriptor(key);
            this.images.put(key, descriptor.createImage());
        }
    }

    public ImageDescriptor descriptor(String key) {
        return (ImageDescriptor)this.descriptors.get(key);
    }

    private ImageDescriptor createImageDescriptor(Bundle pluginBundle, String relativePath) {
        return ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(relativePath));
    }

    public Image image(String key) {
        return (Image)this.images.get(key);
    }

    protected void finalize() throws Throwable {
        Iterator<String> iter = this.images.keySet().iterator();
        while (iter.hasNext()) {
            Image image = (Image)this.images.get(iter.next());
            image.dispose();
        }
        super.finalize();
    }
}

