/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.project.ui.visualizer;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.esb.project.ui.ESBProjectPlugin;
import org.jboss.tools.esb.project.ui.messages.JBossESBUIMessages;
import org.jboss.tools.esb.project.ui.visualizer.ESBNode;
import org.jboss.tools.esb.project.ui.visualizer.ESBNodeWithChildren;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ESBDomParser {
    Document dom;
    ESBNodeWithChildren root;

    public boolean isFileESBConfig(String filepath) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(filepath);
            this.dom.getDocumentElement().normalize();
            if (this.dom.getDocumentElement().getTagName().equalsIgnoreCase("jbossesb")) {
                return true;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    public void parseXmlFile(String filepath) {
        this.root = new ESBNodeWithChildren("Invisible Root");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db;
            block7: {
                db = dbf.newDocumentBuilder();
                try {
                    Path path;
                    if (filepath != null) break block7;
                    Bundle bundle = ESBProjectPlugin.getDefault().getBundle();
                    URL setupUrl = FileLocator.find((Bundle)bundle, (IPath)(path = new Path("META-INF/jboss-esb.xml")), (Map)Collections.EMPTY_MAP);
                    File setupFile = new File(FileLocator.toFileURL((URL)setupUrl).toURI());
                    if (setupFile.exists() && setupFile.canRead()) {
                        filepath = setupFile.getAbsolutePath();
                        break block7;
                    }
                    return;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            this.dom = db.parse(filepath);
            this.dom.getDocumentElement().normalize();
            File tempFile = new File(filepath);
            String filename = tempFile.getName();
            this.root.setName(filename);
            this.root.setEsbObjectType(ESBNode.ESBType.ESB);
            File setupFile = new File(filepath);
            this.root.setData(setupFile);
            this.parseDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseDocument() {
        NodeList nl2;
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("providers");
        if (nl != null && nl.getLength() > 0) {
            Element providersElement = null;
            int j = 0;
            while (j < nl.getLength()) {
                if (nl.item(j) instanceof Element) {
                    providersElement = (Element)nl.item(j);
                    break;
                }
                ++j;
            }
            if (providersElement != null) {
                ESBNodeWithChildren providersRoot = new ESBNodeWithChildren(JBossESBUIMessages.ESBDomParser_Providers_Label);
                providersRoot.setEsbObjectType(ESBNode.ESBType.PROVIDER);
                this.processChildren(providersRoot, providersElement);
                this.root.addChild(providersRoot);
            }
        }
        if ((nl2 = docEle.getElementsByTagName("services")) != null && nl2.getLength() > 0) {
            Element servicesElement = null;
            int j = 0;
            while (j < nl2.getLength()) {
                if (nl2.item(j) instanceof Element) {
                    servicesElement = (Element)nl2.item(j);
                    break;
                }
                ++j;
            }
            if (servicesElement != null) {
                ESBNodeWithChildren servicesRoot = new ESBNodeWithChildren(JBossESBUIMessages.ESBDomParser_Services_Label);
                servicesRoot.setEsbObjectType(ESBNode.ESBType.SERVICE);
                this.processChildren(servicesRoot, servicesElement);
                this.root.addChild(servicesRoot);
            }
        }
    }

    private void processChildren(ESBNodeWithChildren parent, Element el) {
        el.normalize();
        parent.setData(el);
        if (parent.getEsbObjectType() == null) {
            String tag = el.getTagName();
            if (tag.endsWith("-bus") && el.getAttribute("busid") != null) {
                parent.setEsbObjectType(ESBNode.ESBType.BUS);
            } else if (tag.endsWith("-listener") && el.getAttribute("busidref") != null) {
                parent.setEsbObjectType(ESBNode.ESBType.LISTENER);
            } else if (tag.endsWith("-provider")) {
                parent.setEsbObjectType(ESBNode.ESBType.PROVIDER);
            } else if (tag.equalsIgnoreCase("service")) {
                parent.setEsbObjectType(ESBNode.ESBType.SERVICE);
            } else if (tag.equalsIgnoreCase("listeners")) {
                parent.setEsbObjectType(ESBNode.ESBType.LISTENER);
            } else if (tag.equalsIgnoreCase("Actions")) {
                parent.setEsbObjectType(ESBNode.ESBType.ACTION);
            } else if (tag.equalsIgnoreCase("action")) {
                parent.setEsbObjectType(ESBNode.ESBType.ACTION);
            } else if (tag.equalsIgnoreCase("property")) {
                parent.setEsbObjectType(ESBNode.ESBType.PROPERTY);
                return;
            }
        }
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                Element child = (Element)children.item(i);
                String name = child.getAttribute("name");
                if (name == null || name.trim().length() == 0) {
                    name = child.getAttribute("busid");
                }
                if (name == null || name.trim().length() == 0) {
                    name = child.getAttribute("dest-name");
                }
                if (name == null || name.trim().length() == 0) {
                    name = child.getTagName();
                }
                if (name.equalsIgnoreCase("actions")) {
                    name = JBossESBUIMessages.ESBDomParser_Actions_Node_Label;
                } else if (name.equalsIgnoreCase("listeners")) {
                    name = JBossESBUIMessages.ESBDomParser_Listeners_Node_Label;
                }
                ESBNodeWithChildren childNode = new ESBNodeWithChildren(name);
                String ref = child.getAttribute("busidref");
                if (ref != null && ref.trim().length() > 0) {
                    childNode.setRef(ref);
                }
                this.processChildren(childNode, child);
                if (childNode.getEsbObjectType() != null && !childNode.getEsbObjectType().equals((Object)ESBNode.ESBType.PROPERTY)) {
                    parent.addChild(childNode);
                    childNode.setEsbObjectType(parent.getEsbObjectType());
                }
            }
            ++i;
        }
    }

    public ESBNodeWithChildren getRoot() {
        return this.root;
    }
}

