/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.core.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.teiid.designer.metamodels.core.CoreMetamodelPlugin;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;

public class ModelImportImpl
extends EObjectImpl
implements ModelImport {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String PATH_EDEFAULT = null;
    protected static final String MODEL_LOCATION_EDEFAULT = null;
    protected String modelLocation = MODEL_LOCATION_EDEFAULT;
    protected static final String UUID_EDEFAULT = null;
    protected String uuid = UUID_EDEFAULT;
    protected static final ModelType MODEL_TYPE_EDEFAULT = ModelType.UNKNOWN_LITERAL;
    protected ModelType modelType = MODEL_TYPE_EDEFAULT;
    protected static final String PRIMARY_METAMODEL_URI_EDEFAULT = null;
    protected String primaryMetamodelUri = PRIMARY_METAMODEL_URI_EDEFAULT;
    protected static IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();

    protected ModelImportImpl() {
    }

    protected EClass eStaticClass() {
        return CorePackage.eINSTANCE.getModelImport();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getPath() {
        if (this.modelLocation != null) {
            if (this.modelLocation.startsWith("http") || this.modelLocation.startsWith("mtkplugin:") || this.modelLocation.startsWith("pathmap://UML2_METAMODELS/")) {
                return this.modelLocation;
            }
            if (workspaceRoot != null && this.eResource() != null) {
                IFile iFile;
                URI modelLocationURI;
                URI baseLocationURI = this.eResource().getURI();
                URI uRI = modelLocationURI = baseLocationURI.isFile() ? URI.createURI((String)this.modelLocation, (boolean)false) : URI.createURI((String)this.modelLocation);
                if (baseLocationURI.isHierarchical() && !baseLocationURI.isRelative() && modelLocationURI.isRelative()) {
                    modelLocationURI = modelLocationURI.resolve(baseLocationURI);
                }
                if ((iFile = this.matchUriToIFile(modelLocationURI)) != null) {
                    return iFile.getFullPath().toString();
                }
            }
        }
        return null;
    }

    protected IFile matchUriToIFile(URI uri) {
        File f;
        if (uri != null && uri.isFile() && (f = new File(URI.decode((String)uri.toFileString()))).exists()) {
            String modelPath = new Path(f.getAbsolutePath()).toPortableString();
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i != projects.length) {
                IProject iProj = projects[i];
                if (iProj.isOpen() && modelPath.startsWith(iProj.getLocation().toPortableString())) {
                    ArrayList iFiles = new ArrayList();
                    this.collectIFiles((IContainer)iProj, iFiles);
                    for (IFile iFile : iFiles) {
                        if (!modelPath.equals(iFile.getLocation().toPortableString())) continue;
                        return iFile;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected void collectIFiles(IContainer iContainer, List result) {
        if (iContainer != null) {
            try {
                IResource[] iResources = iContainer.members();
                int i = 0;
                while (i != iResources.length) {
                    IResource r = iResources[i];
                    if (r.exists()) {
                        if (r.getType() == 1) {
                            result.add(r);
                        } else if (r.getType() == 2) {
                            this.collectIFiles((IContainer)r, result);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                CoreMetamodelPlugin.Util.log((Throwable)e);
            }
        }
    }

    @Override
    public String getModelLocation() {
        return this.modelLocation;
    }

    @Override
    public void setModelLocation(String newModelLocation) {
        String oldModelLocation = this.modelLocation;
        this.modelLocation = newModelLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldModelLocation, (Object)this.modelLocation));
        }
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(String newUuid) {
        String oldUuid = this.uuid;
        this.uuid = newUuid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldUuid, (Object)this.uuid));
        }
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public void setModelType(ModelType newModelType) {
        ModelType oldModelType = this.modelType;
        ModelType modelType = this.modelType = newModelType == null ? MODEL_TYPE_EDEFAULT : newModelType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldModelType, (Object)this.modelType));
        }
    }

    @Override
    public String getPrimaryMetamodelUri() {
        return this.primaryMetamodelUri;
    }

    @Override
    public void setPrimaryMetamodelUri(String newPrimaryMetamodelUri) {
        String oldPrimaryMetamodelUri = this.primaryMetamodelUri;
        this.primaryMetamodelUri = newPrimaryMetamodelUri;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPrimaryMetamodelUri, (Object)this.primaryMetamodelUri));
        }
    }

    @Override
    public ModelAnnotation getModel() {
        if (this.eContainerFeatureID != 6) {
            return null;
        }
        return (ModelAnnotation)this.eContainer;
    }

    @Override
    public void setModel(ModelAnnotation newModel) {
        if (newModel != this.eContainer || this.eContainerFeatureID != 6 && newModel != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newModel)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newModel != null) {
                msgs = ((InternalEObject)newModel).eInverseAdd((InternalEObject)this, 15, ModelAnnotation.class, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)newModel, 6, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newModel, (Object)newModel));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove((InternalEObject)this, 15, ModelAnnotation.class, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getPath();
            }
            case 2: {
                return this.getModelLocation();
            }
            case 3: {
                return this.getUuid();
            }
            case 4: {
                return this.getModelType();
            }
            case 5: {
                return this.getPrimaryMetamodelUri();
            }
            case 6: {
                return this.getModel();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setModelLocation((String)newValue);
                return;
            }
            case 3: {
                this.setUuid((String)newValue);
                return;
            }
            case 4: {
                this.setModelType((ModelType)((Object)newValue));
                return;
            }
            case 5: {
                this.setPrimaryMetamodelUri((String)newValue);
                return;
            }
            case 6: {
                this.setModel((ModelAnnotation)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setModelLocation(MODEL_LOCATION_EDEFAULT);
                return;
            }
            case 3: {
                this.setUuid(UUID_EDEFAULT);
                return;
            }
            case 4: {
                this.setModelType(MODEL_TYPE_EDEFAULT);
                return;
            }
            case 5: {
                this.setPrimaryMetamodelUri(PRIMARY_METAMODEL_URI_EDEFAULT);
                return;
            }
            case 6: {
                this.setModel(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return PATH_EDEFAULT == null ? this.getPath() != null : !PATH_EDEFAULT.equals(this.getPath());
            }
            case 2: {
                return MODEL_LOCATION_EDEFAULT == null ? this.modelLocation != null : !MODEL_LOCATION_EDEFAULT.equals(this.modelLocation);
            }
            case 3: {
                return UUID_EDEFAULT == null ? this.uuid != null : !UUID_EDEFAULT.equals(this.uuid);
            }
            case 4: {
                return this.modelType != MODEL_TYPE_EDEFAULT;
            }
            case 5: {
                return PRIMARY_METAMODEL_URI_EDEFAULT == null ? this.primaryMetamodelUri != null : !PRIMARY_METAMODEL_URI_EDEFAULT.equals(this.primaryMetamodelUri);
            }
            case 6: {
                return this.getModel() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", modelLocation: ");
        result.append(this.modelLocation);
        result.append(", uuid: ");
        result.append(this.uuid);
        result.append(", modelType: ");
        result.append((Object)this.modelType);
        result.append(", primaryMetamodelUri: ");
        result.append(this.primaryMetamodelUri);
        result.append(')');
        return result.toString();
    }
}

