/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.sql;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.MappingClassSetContainer;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.ChoiceOption;
import org.teiid.designer.metamodels.xml.ValueType;
import org.teiid.designer.metamodels.xml.XmlAll;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlChoice;
import org.teiid.designer.metamodels.xml.XmlComment;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlDocumentFactory;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlNamespace;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.metamodels.xml.XmlSequence;
import org.teiid.designer.metamodels.xml.XmlValueHolder;
import org.teiid.designer.metamodels.xml.namespace.NamespaceContext;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.metamodels.xml.util.XmlNamespaceComparator;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.xml.IMappingAttribute;
import org.teiid.designer.xml.IMappingBaseNode;
import org.teiid.designer.xml.IMappingChoiceNode;
import org.teiid.designer.xml.IMappingCriteriaNode;
import org.teiid.designer.xml.IMappingDocument;
import org.teiid.designer.xml.IMappingDocumentFactory;
import org.teiid.designer.xml.IMappingElement;
import org.teiid.designer.xml.IMappingNode;
import org.teiid.designer.xml.IMappingRecursiveElement;
import org.teiid.designer.xml.IMappingSequenceNode;
import org.teiid.designer.xml.PluginConstants;
import org.teiid.designer.xml.aspects.sql.MappingContext;
import org.teiid.designer.xml.aspects.sql.XmlDocumentMappingHelper;

public class MappingDocumentFormatter {
    static final String XSI_TYPE_ATTRIBUTE_NAME = "type";
    private boolean includeSoapDefaultEncoding = false;
    private final XmlDocument xmlDoc;
    private final MappingContext mappingContext;
    private final List treeMappingRoots;
    private final XmlDocumentMappingHelper helper;
    private boolean indent;
    private boolean newlines;

    public static MappingDocumentFormatter create(XmlDocument xmlDoc, MappingContext mappingContext) {
        MappingClassSet mappingClassSet;
        List treeMappingRoots = MappingDocumentFormatter.findTreeMappingRoot(xmlDoc);
        if (treeMappingRoots != null && treeMappingRoots.size() != 0 && (mappingClassSet = MappingDocumentFormatter.findMappingClassSet(xmlDoc)) != null) {
            MappingDocumentFormatter formatter = new MappingDocumentFormatter(xmlDoc, treeMappingRoots, mappingClassSet, mappingContext);
            return formatter;
        }
        return null;
    }

    private static MappingClassSet findMappingClassSet(XmlDocument xmlDoc) {
        Resource resource = xmlDoc.eResource();
        if (resource == null) {
            return null;
        }
        for (Object rootObj : resource.getContents()) {
            if (!(rootObj instanceof MappingClassSetContainer)) continue;
            MappingClassSetContainer container = (MappingClassSetContainer)rootObj;
            for (MappingClassSet mcSet : container.getMappingClassSets()) {
                EObject target = mcSet.getTarget();
                if (target != xmlDoc) continue;
                return mcSet;
            }
        }
        return null;
    }

    private static List findTreeMappingRoot(XmlDocument xmlDoc) {
        Resource resource = xmlDoc.eResource();
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<TransformationMappingRoot> treeMappingRoots = new LinkedList<TransformationMappingRoot>();
        for (Object rootObj : resource.getContents()) {
            if (!(rootObj instanceof TransformationContainer)) continue;
            TransformationContainer container = (TransformationContainer)rootObj;
            for (TransformationMappingRoot tmroot : container.getTransformationMappings()) {
                EObject target;
                if (!(tmroot instanceof TreeMappingRoot) || (target = tmroot.getTarget()) != xmlDoc) continue;
                treeMappingRoots.add(tmroot);
            }
        }
        return treeMappingRoots;
    }

    private String getNamespacePrefix(XmlDocumentNode elementOrAttribute, NamespaceContext context, MappingContext mappingContext) {
        if (elementOrAttribute == null) {
            return null;
        }
        XSDComponent xsdComponent = elementOrAttribute.getXsdComponent();
        XSDSchema startingSchema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        String defaultTargetNamespace = MappingDocumentFormatter.getTargetNamespace(startingSchema, elementOrAttribute, context, mappingContext);
        String prefix = this.getNamespacePrefix(xsdComponent, context, mappingContext, defaultTargetNamespace, true, true);
        return prefix;
    }

    private String getNamespacePrefix(XmlNamespace ns) {
        String prefix = ns.getPrefix();
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = XmlDocumentUtil.createXmlPrefixFromUri((String)ns.getUri());
        }
        return prefix;
    }

    private String getNamespacePrefix(XSDComponent xsdComponent, NamespaceContext context, MappingContext mappingContext, String defaultTargetNamespace, boolean checkWhetherPrefixIsRequired, boolean addIfMissing) {
        String prefix;
        if (xsdComponent == null) {
            return null;
        }
        XSDSchema schema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        if (schema == null) {
            return null;
        }
        String uri = schema.getTargetNamespace() == null ? defaultTargetNamespace : schema.getTargetNamespace();
        XmlNamespace namespace = context.getBestNamespace(uri);
        if (namespace == null) {
            if (XsdUtil.isBuiltInDatatype((XSDComponent)xsdComponent)) {
                String prefix2 = this.getSchemaNamespacePrefix(context);
                if (!checkWhetherPrefixIsRequired || MappingDocumentFormatter.isPrefixRequired(xsdComponent, schema, uri)) {
                    return prefix2;
                }
                return null;
            }
            if (uri != null && addIfMissing) {
                XmlNamespace newNs = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
                prefix = XmlDocumentUtil.createXmlPrefixFromUri((String)uri);
                if (prefix == null) {
                    prefix = "nspace";
                }
                newNs.setPrefix(prefix);
                newNs.setUri(uri);
                int counter = 0;
                while (!context.addXmlNamespace(newNs)) {
                    newNs.setPrefix(String.valueOf(prefix) + ++counter);
                }
                namespace = newNs;
            }
        }
        if (namespace != null) {
            String actualPrefix = namespace.getPrefix();
            if (actualPrefix == null || actualPrefix.trim().length() == 0) {
                return null;
            }
            prefix = this.getNamespacePrefix(namespace);
            if (!checkWhetherPrefixIsRequired || MappingDocumentFormatter.isPrefixRequired(xsdComponent, schema, uri)) {
                return prefix;
            }
            return null;
        }
        return null;
    }

    private String getSchemaInstanceNamespacePrefix(NamespaceContext context) {
        for (XmlNamespace nsDecl : context.getAllXmlNamespaces()) {
            String uri = nsDecl.getUri();
            if (uri == null || !uri.startsWith("http://www.w3.org/") || !uri.endsWith("/XMLSchema-instance")) continue;
            return this.getNamespacePrefix(nsDecl);
        }
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("xsi");
        newNsDecl.setUri("http://www.w3.org/2001/XMLSchema-instance");
        context.addXmlNamespace(newNsDecl);
        return "xsi";
    }

    private String getSchemaNamespacePrefix(NamespaceContext context) {
        for (XmlNamespace nsDecl : context.getAllXmlNamespaces()) {
            String uri = nsDecl.getUri();
            if (uri == null || !uri.startsWith("http://www.w3.org/") || !uri.endsWith("/XMLSchema")) continue;
            return this.getNamespacePrefix(nsDecl);
        }
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("xsd");
        newNsDecl.setUri("http://www.w3.org/2001/XMLSchema");
        context.addXmlNamespace(newNsDecl);
        return "xsd";
    }

    private String getSoapArrayType(XmlElement element, NamespaceContext context, MappingContext mappingContext) {
        XSDComponent xsdComponent = element.getXsdComponent();
        while (xsdComponent != null) {
            if (xsdComponent instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition complexTypeDefn = (XSDComplexTypeDefinition)xsdComponent;
                if (XSDConstants.isAnyType((XSDTypeDefinition)complexTypeDefn)) {
                    return null;
                }
                String name = complexTypeDefn.getName();
                if ("Array".equals(name)) {
                    XSDSchema schema = complexTypeDefn.getSchema();
                    String targetNS = schema.getTargetNamespace();
                    if ("http://schemas.xmlsoap.org/soap/encoding/".equals(targetNS)) {
                        XSDTypeDefinition schemaCompOfChildren = XsdUtil.getCommonBaseTypeForContained((XSDComponent)element.getXsdComponent());
                        if (schemaCompOfChildren == null) {
                            String namespacePrefix = this.getSchemaNamespacePrefix(context);
                            return String.valueOf(namespacePrefix) + ":anyType[]";
                        }
                        String namespacePrefix = this.getNamespacePrefix((XSDComponent)schemaCompOfChildren, context, mappingContext, null, false, true);
                        if (namespacePrefix == null && XsdUtil.isBuiltInDatatype((XSDComponent)schemaCompOfChildren)) {
                            namespacePrefix = this.getSchemaNamespacePrefix(context);
                        }
                        String result = null;
                        result = namespacePrefix != null && namespacePrefix.trim().length() != 0 ? String.valueOf(namespacePrefix) + ":" + schemaCompOfChildren.getName() + "[]" : String.valueOf(schemaCompOfChildren.getName()) + "[]";
                        return result;
                    }
                } else {
                    xsdComponent = complexTypeDefn.getBaseTypeDefinition();
                }
            }
            if (xsdComponent instanceof XSDSimpleTypeDefinition) {
                return null;
            }
            if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration elmDeclaration = (XSDElementDeclaration)xsdComponent;
                xsdComponent = elmDeclaration.getTypeDefinition();
            }
            if (xsdComponent instanceof XSDComplexTypeDefinition || xsdComponent instanceof XSDSimpleTypeDefinition || xsdComponent instanceof XSDElementDeclaration) continue;
            return null;
        }
        return null;
    }

    private String getSoapEncodingNamespacePrefix(NamespaceContext context) {
        XmlNamespace namespace = context.getBestNamespace("http://schemas.xmlsoap.org/soap/encoding/");
        if (namespace != null) {
            String prefix = this.getNamespacePrefix(namespace);
            return prefix;
        }
        XmlNamespace newNsDecl = XmlDocumentFactory.eINSTANCE.createXmlNamespace();
        newNsDecl.setPrefix("soap-enc");
        newNsDecl.setUri("http://schemas.xmlsoap.org/soap/encoding/");
        context.addXmlNamespace(newNsDecl);
        return "soap-enc";
    }

    private static String getTargetNamespace(XSDSchema startingSchema, XmlDocumentNode element, NamespaceContext context, MappingContext mappingContext) {
        String targetNS;
        String resolvedTNS;
        XSDFeature resolvedComponent;
        if (element == null) {
            return null;
        }
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent instanceof XSDFeature && (resolvedComponent = XsdUtil.getResolved((XSDFeature)((XSDFeature)xsdComponent))) != null && resolvedComponent != xsdComponent && !CoreStringUtil.isEmpty((String)(resolvedTNS = resolvedComponent.getTargetNamespace()))) {
            return resolvedTNS;
        }
        XSDSchema schema = MappingDocumentFormatter.getTargetNamespaceSchema(xsdComponent, context, mappingContext);
        String string = targetNS = schema == null ? null : schema.getTargetNamespace();
        if (!CoreStringUtil.isEmpty((String)targetNS)) {
            if (startingSchema != null && startingSchema.getTargetNamespace() == null) {
                if (MappingDocumentFormatter.hasMatchingIncludeDirective(schema, startingSchema)) {
                    return targetNS;
                }
                return null;
            }
            return targetNS;
        }
        XmlElement owner = MappingDocumentFormatter.getXmlElementContainer(element);
        return MappingDocumentFormatter.getTargetNamespace(startingSchema, (XmlDocumentNode)owner, context, mappingContext);
    }

    private static XSDSchema getTargetNamespaceSchema(XSDComponent xsdComponent, NamespaceContext context, MappingContext mappingContext) {
        XSDFeature resolvedComponent;
        if (xsdComponent == null) {
            return null;
        }
        XSDSchema schema = xsdComponent.getSchema();
        if (schema == null && xsdComponent.eIsProxy() && (schema = (xsdComponent = (XSDComponent)EcoreUtil.resolve((EObject)xsdComponent, (ResourceSet)mappingContext.getResourceSet())).getSchema()) == null) {
            URI componentURi = ModelerCore.getModelEditor().getUri((EObject)xsdComponent);
            String msg = PluginConstants.Util.getString("MappingDocumentFormatter.Unable_to_determine_schema_in_the_workspace_for_XsdComponent_{0}_when_deriving_Namespace_Prefix_1", (Object)componentURi);
            PluginConstants.Util.log(4, msg);
            return null;
        }
        if (xsdComponent instanceof XSDFeature && (resolvedComponent = XsdUtil.getResolved((XSDFeature)((XSDFeature)xsdComponent))) != null && resolvedComponent != xsdComponent) {
            XSDSchema resolvedSchema = resolvedComponent.getSchema();
            String resolvedTNS = resolvedComponent.getTargetNamespace();
            if (CoreStringUtil.isEmpty((String)resolvedTNS)) {
                resolvedTNS = resolvedSchema.getTargetNamespace();
            }
            if (resolvedTNS != null && resolvedTNS.trim().length() != 0) {
                if (resolvedSchema != null && resolvedSchema.eIsProxy()) {
                    XSDResourceImpl resource;
                    URI proxyURI = ((InternalEObject)resolvedSchema).eProxyURI();
                    if (proxyURI != null && (resource = (XSDResourceImpl)mappingContext.getResourceSet().getResource(proxyURI.trimFragment(), true)) != null) {
                        schema = resource.getSchema();
                    }
                } else {
                    schema = resolvedSchema;
                }
            }
        }
        return schema;
    }

    private static XmlElement getXmlElementContainer(XmlDocumentNode element) {
        if (element == null) {
            return null;
        }
        EObject owner = element.eContainer();
        while (owner != null && !(owner instanceof XmlElement)) {
            owner = owner.eContainer();
        }
        return owner instanceof XmlElement ? (XmlElement)owner : null;
    }

    private static boolean hasMatchingIncludeDirective(XSDSchema schemaWithDirectives, XSDSchema schemaToCheck) {
        if (schemaWithDirectives != null && schemaToCheck != null) {
            for (Object content : schemaWithDirectives.eContents()) {
                XSDInclude includeDeclaration;
                XSDSchema resolvedSchema;
                String includeSchemaLocation;
                if (!(content instanceof XSDInclude) || (includeSchemaLocation = (resolvedSchema = (includeDeclaration = (XSDInclude)content).getResolvedSchema()).getSchemaLocation()) == null || !includeSchemaLocation.equals(schemaToCheck.getSchemaLocation())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPrefixRequired(XSDComponent component, XSDSchema schema, String schemaNamespaceUri) {
        boolean global = XsdUtil.isGlobal((XSDComponent)component);
        if (global) {
            return schemaNamespaceUri != null && schemaNamespaceUri.trim().length() != 0;
        }
        if (component instanceof XSDFeature) {
            XSDFeature feature = (XSDFeature)component;
            XSDFeature resolvedFeature = XsdUtil.getResolved((XSDFeature)feature);
            if (resolvedFeature != null && resolvedFeature != feature) {
                XSDSchema schemaForResolved = resolvedFeature.getSchema();
                String uri = schemaForResolved.getTargetNamespace();
                return MappingDocumentFormatter.isPrefixRequired((XSDComponent)resolvedFeature, resolvedFeature.getSchema(), uri);
            }
            XSDForm form = null;
            if (feature.isSetForm()) {
                form = feature.getForm();
            } else if (component instanceof XSDElementDeclaration) {
                form = schema.isSetElementFormDefault() ? schema.getElementFormDefault() : XSDForm.UNQUALIFIED_LITERAL;
            } else if (component instanceof XSDAttributeDeclaration) {
                form = schema.isSetAttributeFormDefault() ? schema.getAttributeFormDefault() : XSDForm.UNQUALIFIED_LITERAL;
            }
            if (form != null) {
                switch (form.getValue()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public MappingDocumentFormatter(XmlDocument xmlDoc, List treeMappingRoots, MappingClassSet mappingClassSet, MappingContext mappingContext) {
        CoreArgCheck.isNotNull((Object)xmlDoc);
        CoreArgCheck.isNotNull((Object)treeMappingRoots);
        CoreArgCheck.isNotNull((Object)mappingClassSet);
        this.includeSoapDefaultEncoding = false;
        this.xmlDoc = xmlDoc;
        this.treeMappingRoots = treeMappingRoots;
        this.mappingContext = mappingContext;
        this.helper = new XmlDocumentMappingHelper(this.treeMappingRoots);
    }

    private IMappingDocumentFactory getFactory() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        return queryService.getMappingDocumentFactory();
    }

    private void createAttributeNode(IMappingElement parent, XmlAttribute element, ElementInfo elementInfo, MappingContext mappingContext) {
        String name = element.getName();
        String nsPrefix = this.getNamespacePrefix((XmlDocumentNode)element, elementInfo.getNamespaceContext(), mappingContext);
        IMappingAttribute attribute = null;
        if (nsPrefix != null && nsPrefix.equalsIgnoreCase("xmlns")) {
            this.getFactory().addNamespace(parent, "", this.getFixedValue((XmlValueHolder)element));
        } else if (name != null && nsPrefix != null && nsPrefix.equalsIgnoreCase("xmlns")) {
            this.getFactory().addNamespace(parent, name, this.getFixedValue((XmlValueHolder)element));
        } else {
            attribute = this.getFactory().createMappingAttribute(name, nsPrefix);
            attribute.setNameInSource(this.getNameInSource((XmlDocumentEntity)element));
            attribute.setDefaultValue(this.getDefaultValue((XmlValueHolder)element));
            attribute.setValue(this.getFixedValue((XmlValueHolder)element));
            attribute.setExclude(element.isExcludeFromDocument());
            attribute.setNormalizeText(this.getXsiTypeTextNormalization((XmlDocumentNode)element, mappingContext));
            if (parent != null) {
                parent.addAttribute(attribute);
            }
        }
    }

    private IMappingBaseNode createChoiceNode(IMappingBaseNode parent, XmlChoice choice, ElementInfo elementInfo) {
        IMappingCriteriaNode criteria = this.createCriteriaNode((ChoiceOption)choice);
        if (parent != null && parent instanceof IMappingChoiceNode && criteria != null) {
            parent.addChildNode((IMappingNode)criteria);
        }
        IMappingChoiceNode choiceNode = this.getFactory().createMappingChoiceNode(choice.getDefaultErrorMode().getValue() == 0);
        choiceNode.setExclude(choice.isExcludeFromDocument());
        choiceNode.setSource(this.getSource((XmlContainerNode)choice));
        if (parent != null) {
            parent.addChildNode((IMappingNode)choiceNode);
        }
        choiceNode.addStagingTable(this.getStagingTable((XmlDocumentEntity)choice));
        return choiceNode;
    }

    private IMappingNode createCommentNode(IMappingElement parent, XmlComment comment, ElementInfo elementInfo) {
        String text = comment.getText();
        if (text != null && text.trim().length() > 0 && parent != null) {
            parent.addCommentNode(text);
        }
        return null;
    }

    private IMappingCriteriaNode createCriteriaNode(ChoiceOption element) {
        boolean isDefault;
        String criteria = this.getCriteria(element);
        boolean bl = isDefault = element.getDefaultFor() != null;
        if (criteria == null && !isDefault) {
            criteria = "TRUE = FALSE";
        }
        return this.getFactory().createMappingCriteriaNode(criteria, isDefault);
    }

    private IMappingDocument createDocumentNode(XmlRoot xmlRoot, NamespaceContext nsContext, ElementInfo rootElementInfo, MappingContext mappingContext) {
        this.includeSoapDefaultEncoding = this.xmlDoc.getSoapEncoding().getValue() == 1;
        IMappingDocument doc = this.getFactory().createMappingDocument(this.xmlDoc.getEncoding(), this.xmlDoc.isFormatted());
        IMappingElement node = this.processElementNode((XmlElement)xmlRoot, rootElementInfo, mappingContext);
        doc.addChildNode((IMappingNode)node);
        IMappingBaseNode rootNode = doc.getRootNode();
        this.processNamespaces((List)xmlRoot.getDeclaredNamespaces(), rootNode, nsContext, rootElementInfo);
        this.processChildren((List)xmlRoot.getAttributes(), rootNode, nsContext, rootElementInfo);
        this.processChildren((List)xmlRoot.getComments(), rootNode, nsContext, rootElementInfo);
        this.processChildren((List)xmlRoot.getEntities(), rootNode, nsContext, rootElementInfo);
        this.processChildren((List)xmlRoot.getProcessingInstructions(), rootNode, nsContext, rootElementInfo);
        return doc;
    }

    private IMappingBaseNode createElementNode(IMappingBaseNode parent, XmlElement element, ElementInfo elementInfo, MappingContext mappingContext) {
        IMappingCriteriaNode criteria = this.createCriteriaNode((ChoiceOption)element);
        if (parent != null && parent instanceof IMappingChoiceNode && criteria != null) {
            parent.addChildNode((IMappingNode)criteria);
        }
        IMappingElement node = this.processElementNode(element, elementInfo, mappingContext);
        if (parent != null) {
            parent.addChildNode((IMappingNode)node);
        }
        return node;
    }

    public IMappingDocument createMapping() {
        this.helper.initialize();
        XmlRoot xmlRootElement = this.xmlDoc.getRoot();
        NamespaceContext nsContext = new NamespaceContext((XmlElement)xmlRootElement, null);
        ElementInfo elementInfo = new ElementInfo(nsContext, null);
        IMappingDocument document = this.createDocumentNode(xmlRootElement, nsContext, elementInfo, this.mappingContext);
        return document;
    }

    private void createMapping(XmlDocumentEntity entity, IMappingBaseNode parent, NamespaceContext namespaceContext, MappingContext mappingContext, ElementInfo parentInfo) {
        int classifierId = entity.eClass().getClassifierID();
        IMappingBaseNode entityMappingNode = null;
        ElementInfo entityInfo = parentInfo;
        NamespaceContext entityNamespaceContext = namespaceContext;
        switch (classifierId) {
            case 3: {
                XmlElement element = (XmlElement)entity;
                entityNamespaceContext = new NamespaceContext(element, namespaceContext);
                entityInfo = new ElementInfo(entityNamespaceContext, parentInfo);
                entityMappingNode = this.createElementNode(parent, element, entityInfo, mappingContext);
                this.processNamespaces((List)element.getDeclaredNamespaces(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getAttributes(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getComments(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getEntities(), entityMappingNode, entityNamespaceContext, entityInfo);
                this.processChildren((List)element.getProcessingInstructions(), entityMappingNode, entityNamespaceContext, entityInfo);
                break;
            }
            case 4: {
                this.createAttributeNode((IMappingElement)parent, (XmlAttribute)entity, entityInfo, mappingContext);
                break;
            }
            case 8: {
                this.createNamespaceAttribute((IMappingElement)parent, (XmlNamespace)entity, entityInfo);
                break;
            }
            case 10: 
            case 11: {
                XmlContainerNode container = (XmlContainerNode)entity;
                entityMappingNode = this.createSequenceNode(parent, container, entityInfo);
                EList kids = container.eContents();
                this.processChildren((List)kids, entityMappingNode, namespaceContext, parentInfo);
                break;
            }
            case 12: {
                XmlChoice choiceNode = (XmlChoice)entity;
                entityMappingNode = this.createChoiceNode(parent, choiceNode, entityInfo);
                List optionsInOrder = choiceNode.getOrderedChoiceOptions();
                this.processChildren(optionsInOrder, entityMappingNode, namespaceContext, parentInfo);
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                this.createCommentNode((IMappingElement)parent, (XmlComment)entity, entityInfo);
                break;
            }
        }
    }

    public String createMappingString() throws Exception {
        IMappingDocument mapping = this.createMapping();
        return mapping.getMappingString();
    }

    private void createNamespaceAttribute(IMappingElement parent, XmlNamespace ns, ElementInfo elementInfo) {
        this.getFactory().addNamespace(parent, ns.getPrefix(), ns.getUri());
    }

    private IMappingBaseNode createSequenceNode(IMappingBaseNode parent, XmlContainerNode compositor, ElementInfo elementInfo) {
        IMappingCriteriaNode criteria = this.createCriteriaNode((ChoiceOption)compositor);
        if (parent != null && parent instanceof IMappingChoiceNode && criteria != null) {
            parent.addChildNode((IMappingNode)criteria);
        }
        IMappingSequenceNode seqNode = null;
        if (compositor instanceof XmlSequence) {
            seqNode = this.getFactory().createMappingSequenceNode();
        } else if (compositor instanceof XmlAll) {
            seqNode = this.getFactory().createMappingAllNode();
        }
        if (seqNode != null) {
            parent.addChildNode((IMappingNode)seqNode);
            seqNode.setExclude(compositor.isExcludeFromDocument());
            seqNode.setSource(this.getSource(compositor));
            seqNode.addStagingTable(this.getStagingTable((XmlDocumentEntity)compositor));
        }
        return seqNode;
    }

    private void createSoapArrayTypeAttribute(IMappingElement parent, ElementInfo elementInfo) {
        String value = elementInfo.getSoapArrayType();
        if (value == null) {
            return;
        }
        NamespaceContext context = elementInfo.getNamespaceContext();
        String prefix = this.getSoapEncodingNamespacePrefix(context);
        IMappingAttribute attribute = this.getFactory().createMappingAttribute("arrayType", prefix);
        attribute.setValue(value);
        attribute.setOptional(true);
        attribute.setAlwaysInclude(true);
        parent.addAttribute(attribute);
    }

    private void createXsiTypeAttribute(IMappingElement parent, ElementInfo elementInfo) {
        String value = elementInfo.getXsiType();
        if (value == null) {
            return;
        }
        NamespaceContext context = elementInfo.getNamespaceContext();
        String prefix = this.getSchemaInstanceNamespacePrefix(context);
        IMappingAttribute attribute = this.getFactory().createMappingAttribute(XSI_TYPE_ATTRIBUTE_NAME, prefix);
        attribute.setValue(value);
        attribute.setOptional(true);
        attribute.setAlwaysInclude(true);
        parent.addAttribute(attribute);
    }

    String getBuitInType(XmlElement element) {
        MappingClassColumn mappingClassColumn = this.helper.getMappingClassColumn((XmlDocumentEntity)element);
        if (mappingClassColumn != null) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)mappingClassColumn);
            EObject dataType = columnAspect.getDatatype((EObject)mappingClassColumn);
            DatatypeManager dtm = ModelerCore.getBuiltInTypesManager();
            CoreArgCheck.isNotNull((Object)dtm);
            try {
                dataType = dtm.getDatatypeForXsdType(dataType);
            }
            catch (ModelerCoreException err) {
                PluginConstants.Util.log((Throwable)err);
            }
            if (dataType != null && dtm.isBuiltInDatatype(dataType)) {
                return dtm.getName(dataType);
            }
        }
        return "";
    }

    String getCriteria(ChoiceOption element) {
        String choiceCriteria = element.getChoiceCriteria();
        return choiceCriteria;
    }

    String getDefaultValue(XmlValueHolder valueHolder) {
        ValueType valueType;
        String value = valueHolder.getValue();
        if (value != null && (valueType = valueHolder.getValueType()).getValue() == 1) {
            return value;
        }
        return null;
    }

    String getFixedValue(XmlValueHolder valueHolder) {
        ValueType valueType;
        String value = valueHolder.getValue();
        if (value != null && (valueType = valueHolder.getValueType()).getValue() == 2) {
            return value;
        }
        return null;
    }

    private String getFullName(EObject object) {
        SqlAspect sqlAspect = (SqlAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect(object, SqlAspect.class);
        if (sqlAspect != null) {
            return sqlAspect.getFullName(object);
        }
        return null;
    }

    int getMaxOccurrences(XmlElement element) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null) {
            return XsdUtil.getMaxOccurs((XSDComponent)xsdComponent);
        }
        return IMappingNode.DEFAULT_CARDINALITY_MAXIMUM_BOUND;
    }

    int getMinOccurrences(XmlElement element) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null) {
            return XsdUtil.getMinOccurs((XSDComponent)xsdComponent);
        }
        return IMappingNode.DEFAULT_CARDINALITY_MINIMUM_BOUND;
    }

    String getNameInSource(XmlDocumentEntity element) {
        MappingClassColumn mappingClassColumn = this.helper.getMappingClassColumn(element);
        if (mappingClassColumn != null) {
            return this.getFullName((EObject)mappingClassColumn);
        }
        return null;
    }

    String getRecursionCriteria(XmlElement element) {
        String criteria = null;
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive() && !CoreStringUtil.isEmpty((String)(criteria = mappingClass.getRecursionCriteria()))) {
            criteria = CoreStringUtil.replaceAll((String)criteria, (String)this.getFullName((EObject)mappingClass), (String)this.getRecursionMappingClass(element));
        }
        return criteria;
    }

    int getRecursionLimit(XmlElement element) {
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            return mappingClass.getRecursionLimit();
        }
        return IMappingNode.DEFAULT_RECURSION_LIMIT;
    }

    String getRecursionMappingClass(XmlElement element) {
        MappingClass rootMappingClass = this.helper.getRecusionRootMappingClass(element);
        if (rootMappingClass != null) {
            return this.getFullName((EObject)rootMappingClass);
        }
        return null;
    }

    private String getSource(XmlContainerNode compositor) {
        String fullName;
        String source = null;
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)compositor);
        if (mappingClass != null && (fullName = this.getFullName((EObject)mappingClass)) != null) {
            source = fullName;
        }
        return source;
    }

    String getSource(XmlDocumentEntity element) {
        MappingClass mappingClass = this.helper.getMappingClass(element);
        if (mappingClass != null) {
            return this.getFullName((EObject)mappingClass);
        }
        return null;
    }

    private String getStagingTable(XmlDocumentEntity compositor) {
        String stagingTable = null;
        StagingTable[] tempGroups = this.helper.getStagingTables(compositor);
        if (tempGroups != null && tempGroups.length != 0) {
            StagingTable[] stagingTableArray = tempGroups;
            int n = tempGroups.length;
            int n2 = 0;
            while (n2 < n) {
                StagingTable st = stagingTableArray[n2];
                String fullName = this.getFullName((EObject)st);
                if (fullName != null) {
                    stagingTable = fullName;
                }
                ++n2;
            }
        }
        return stagingTable;
    }

    private String getXsiType(XmlElement element, NamespaceContext context, MappingContext mappingContext) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent == null) {
            return null;
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        String typeName = typeDefn.getName();
        String nsPrefix = this.getNamespacePrefix((XSDComponent)typeDefn, context, mappingContext, null, false, true);
        return nsPrefix == null ? typeName : String.valueOf(nsPrefix) + ":" + typeName;
    }

    private String getXsiTypeTextNormalization(XmlDocumentNode node, MappingContext mappingContext) {
        XSDWhiteSpace whiteSpaceEnum;
        XSDSimpleTypeDefinition simpleTypeDefn;
        XSDWhiteSpaceFacet facet;
        XSDComponent xsdComponent = node.getXsdComponent();
        if (xsdComponent == null) {
            return "preserve";
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        if (typeDefn instanceof XSDSimpleTypeDefinition && (facet = (simpleTypeDefn = (XSDSimpleTypeDefinition)typeDefn).getEffectiveWhiteSpaceFacet()) != null && (whiteSpaceEnum = facet.getValue()) != null) {
            switch (whiteSpaceEnum.getValue()) {
                case 0: {
                    return "preserve";
                }
                case 1: {
                    return "replace";
                }
                case 2: {
                    return "collapse";
                }
            }
        }
        return "preserve";
    }

    public boolean isIndent() {
        return this.indent;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    boolean isNillable(XmlElement element) {
        XSDComponent xsdComponent = element.getXsdComponent();
        if (xsdComponent != null && xsdComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
            return xsdElement.isNillable();
        }
        return IMappingNode.DEFAULT_IS_NILLABLE;
    }

    boolean isRecursive(XmlElement element) {
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            return mappingClass.isRecursive();
        }
        return false;
    }

    private void processChildren(List children, IMappingBaseNode parentMappingNode, NamespaceContext namespaceContext, ElementInfo parentInfo) {
        for (Object child : children) {
            if (!(child instanceof XmlDocumentEntity)) continue;
            this.createMapping((XmlDocumentEntity)child, parentMappingNode, namespaceContext, this.mappingContext, parentInfo);
        }
    }

    private IMappingElement processElementNode(XmlElement element, ElementInfo elementInfo, MappingContext mappingContext) {
        IMappingElement node = null;
        String name = element.getName();
        String nsPrefix = this.getNamespacePrefix((XmlDocumentNode)element, elementInfo.getNamespaceContext(), mappingContext);
        if (this.isRecursive(element)) {
            IMappingRecursiveElement elem = this.getFactory().createMappingRecursiveElement(name, nsPrefix, this.getRecursionMappingClass(element));
            elem.setCriteria(this.getRecursionCriteria(element));
            elem.setRecursionLimit(this.getRecursionLimit(element), this.throwExceptionOnRecursionLimit(element));
            node = elem;
        } else {
            node = this.getFactory().createMappingElement(name, nsPrefix);
        }
        node.setMinOccurrs(this.getMinOccurrences(element));
        node.setMaxOccurrs(this.getMaxOccurrences(element));
        node.setNameInSource(this.getNameInSource((XmlDocumentEntity)element));
        node.setSource(this.getSource((XmlDocumentEntity)element));
        node.setDefaultValue(this.getDefaultValue((XmlValueHolder)element));
        node.setValue(this.getFixedValue((XmlValueHolder)element));
        node.setNillable(this.isNillable(element));
        node.setExclude(element.isExcludeFromDocument());
        node.setType(this.getBuitInType(element));
        node.setNormalizeText(this.getXsiTypeTextNormalization((XmlDocumentNode)element, mappingContext));
        node.addStagingTable(this.getStagingTable((XmlDocumentEntity)element));
        if (this.includeSoapDefaultEncoding) {
            String soapArrayType = this.getSoapArrayType(element, elementInfo.getNamespaceContext(), mappingContext);
            if (soapArrayType != null) {
                elementInfo.setSoapArrayType(soapArrayType);
                this.createSoapArrayTypeAttribute(node, elementInfo);
            }
            if (elementInfo.isXsiTypeRequired()) {
                String xsiTypeValue = this.getXsiType(element, elementInfo.getNamespaceContext(), mappingContext);
                elementInfo.setXsiType(xsiTypeValue);
                this.createXsiTypeAttribute(node, elementInfo);
            }
        }
        return node;
    }

    private void processNamespaces(List children, IMappingBaseNode parentMappingNode, NamespaceContext namespaceContext, ElementInfo parentInfo) {
        LinkedList orderedNamespaces = new LinkedList(children);
        XmlNamespaceComparator comparator = new XmlNamespaceComparator();
        Collections.sort(orderedNamespaces, comparator);
        this.processChildren(orderedNamespaces, parentMappingNode, namespaceContext, parentInfo);
    }

    public void setIndent(boolean b) {
        this.indent = b;
    }

    public void setNewlines(boolean b) {
        this.newlines = b;
    }

    boolean throwExceptionOnRecursionLimit(XmlElement element) {
        MappingClass mappingClass = this.helper.getMappingClass((XmlDocumentEntity)element);
        if (mappingClass != null && mappingClass.isRecursionAllowed() && mappingClass.isRecursive()) {
            return mappingClass.getRecursionLimitErrorMode().getValue() == 0;
        }
        return IMappingNode.DEFAULT_EXCEPTION_ON_RECURSION_LIMIT;
    }

    private class ElementInfo {
        private String soapArrayType;
        private String xsiType;
        private final ElementInfo parentInfo;
        private final NamespaceContext namespaceContext;

        private ElementInfo(NamespaceContext namespaceContext, ElementInfo parentInfo) {
            this.parentInfo = parentInfo;
            this.namespaceContext = namespaceContext;
        }

        public NamespaceContext getNamespaceContext() {
            return this.namespaceContext;
        }

        public String getSoapArrayType() {
            return this.soapArrayType;
        }

        public XmlElement getXmlElement() {
            return this.namespaceContext.getXmlElement();
        }

        public String getXsiType() {
            return this.xsiType;
        }

        public boolean isXsiTypeRequired() {
            if (this.soapArrayType != null) {
                return true;
            }
            return this.parentInfo != null && this.parentInfo.getSoapArrayType() != null;
        }

        public void setSoapArrayType(String soapArrayType) {
            this.soapArrayType = soapArrayType;
        }

        public void setXsiType(String xsiType) {
            this.xsiType = xsiType;
        }
    }

    static final class Soap {
        public static final String ARRAY_TYPE_XML_ATTRIBUTE_NAME = "arrayType";
        public static final String ARRAY_TYPE_NAME = "Array";
        public static final String TARGET_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/encoding/";
        public static final String DEFAULT_NAMESPACE_PREFIX = "soap-enc";

        Soap() {
        }
    }
}

