/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mapping.Mapping;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IndexingContext;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTransformationInfo;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.sql.MappingDocumentFormatter;
import org.teiid.designer.transformation.aspects.sql.TransformationMappingRootSqlAspect;
import org.teiid.designer.xml.aspects.sql.MappingContext;

public class TreeMappingRootSqlAspect
extends TransformationMappingRootSqlAspect {
    private static final String[] TRANSFORMATION_TYPES = new String[]{"Mapping"};
    private static final String SCHEMA_EXTENTION = ".XSD";

    protected TreeMappingRootSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public Object getTransformedObject(EObject eObject) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TreeMappingRoot root = (TreeMappingRoot)eObject;
        EObject targetEObj = root.getTarget();
        if (targetEObj == null) {
            TransformationPlugin.Util.log(2, TransformationPlugin.Util.getString("TreeMappingRootSqlAspect.0", (Object)ModelerCore.getObjectIdString((EObject)root)));
        }
        return targetEObj;
    }

    public List getInputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        return root.getInputs();
    }

    public List getNestedInputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        for (Mapping mapping : root.getNested()) {
            if (mapping == null) continue;
            result.addAll(mapping.getInputs());
        }
        return result;
    }

    public List getNestedOutputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        for (Mapping mapping : root.getNested()) {
            if (mapping == null) continue;
            result.addAll(mapping.getOutputs());
        }
        return result;
    }

    public List getNestedInputsForOutput(EObject eObject, EObject output) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() != null) {
            for (Mapping mapping : root.getNested()) {
                if (mapping == null || !mapping.getOutputs().contains((Object)output)) continue;
                return mapping.getInputs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List getNestedOutputsForInput(EObject eObject, EObject input) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        if (root.getNested() != null) {
            for (Mapping mapping : root.getNested()) {
                if (mapping == null || !mapping.getInputs().contains((Object)input)) continue;
                return mapping.getOutputs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public List getOutputObjects(EObject eObject) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        TransformationMappingRoot root = (TransformationMappingRoot)eObject;
        return root.getOutputs();
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'U';
    }

    public boolean isQueryable(EObject eObject) {
        return true;
    }

    public String getName(EObject eObject) {
        EObject transformedObject = (EObject)this.getTransformedObject(eObject);
        if (transformedObject == null) {
            return null;
        }
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
        if (sqlAspect != null) {
            return sqlAspect.getName(transformedObject);
        }
        return null;
    }

    @Override
    public String getFullName(EObject eObject) {
        EObject transformedObject = (EObject)this.getTransformedObject(eObject);
        if (transformedObject == null) {
            return null;
        }
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
        if (sqlAspect != null) {
            return sqlAspect.getFullName(transformedObject);
        }
        return null;
    }

    public String getNameInSource(EObject eObject) {
        EObject transformedObject = (EObject)this.getTransformedObject(eObject);
        if (transformedObject == null) {
            return null;
        }
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)transformedObject);
        if (sqlAspect != null) {
            return sqlAspect.getNameInSource(transformedObject);
        }
        return null;
    }

    public String[] getTransformationTypes(EObject eObject) {
        CoreArgCheck.isInstanceOf(TreeMappingRoot.class, (Object)eObject);
        return TRANSFORMATION_TYPES;
    }

    public boolean isDeleteAllowed(EObject eObject) {
        return false;
    }

    public boolean isInsertAllowed(EObject eObject) {
        return false;
    }

    public boolean isUpdateAllowed(EObject eObject) {
        return false;
    }

    public String getTransformation(EObject eObject, String type) {
        MappingContext mappingContext;
        XmlDocument xmlDoc = (XmlDocument)this.getTransformedObject(eObject);
        MappingDocumentFormatter formatter = MappingDocumentFormatter.create(xmlDoc, mappingContext = new MappingContext(this.getResourceSet(eObject)));
        if (formatter != null) {
            try {
                String result = formatter.createMappingString();
                return result;
            }
            catch (Exception e) {
                TransformationPlugin.Util.log((Throwable)e);
            }
        }
        return null;
    }

    private ResourceSet getResourceSet(EObject eObject) {
        Resource eResource = eObject.eResource();
        if (eResource != null) {
            return eResource.getResourceSet();
        }
        try {
            return ModelerCore.getModelContainer();
        }
        catch (CoreException e) {
            TransformationPlugin.Util.log((Throwable)e);
            return null;
        }
    }

    public SqlTransformationInfo getTransformationInfo(EObject eObject, IndexingContext context, String type) {
        XmlDocument xmlDoc = (XmlDocument)this.getTransformedObject(eObject);
        ArrayList<String> schemaPaths = new ArrayList<String>();
        Resource eResource = xmlDoc.eResource();
        if (eResource != null && eResource instanceof EmfResource) {
            EList modelImports = ((EmfResource)eResource).getModelAnnotation().getModelImports();
            for (ModelImport mdlImport : modelImports) {
                String modelPath;
                if (mdlImport == null || !(modelPath = mdlImport.getModelLocation().toUpperCase()).endsWith(SCHEMA_EXTENTION)) continue;
                schemaPaths.add(mdlImport.getModelLocation());
            }
            String result = this.getTransformation(eObject, type);
            SqlTransformationInfo info = new SqlTransformationInfo(result);
            info.setSchemaPaths(schemaPaths);
            return info;
        }
        Object[] params = new Object[]{xmlDoc};
        String msg = TransformationPlugin.Util.getString("TreeMappingRootSqlAspect.could_not_get_resource_for_xmldoc", params);
        TransformationPlugin.Util.log(4, msg);
        return null;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }
}

