/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation.rules;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.IGroupsUsedByElementsVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.transformation.TransformationPlugin;

public class MappingClassTransformationValidationHelper {
    public void validate(ICommand command, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        EObject targetObj = transRoot.getTarget();
        if (!(targetObj instanceof MappingClass)) {
            return;
        }
        MappingClass mappingClass = (MappingClass)targetObj;
        if (mappingClass.isRecursionAllowed() && mappingClass.isRecursive() && mappingClass.eResource() instanceof EmfResource) {
            this.validateRecursiveMappingClass(mappingClass, validationResult);
        } else if (command instanceof IQuery) {
            this.validate((IQuery)command, mappingClass, validationResult);
        } else if (command instanceof ISetQuery) {
            this.validate((ISetQuery)command, mappingClass, validationResult);
        } else {
            ValidationProblemImpl errorProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("MappingClassTransformationRule.Non-Query_NonUnion_transformation"));
            validationResult.addProblem((ValidationProblem)errorProblem);
        }
    }

    public void validate(IQuery query, MappingClass mappingClass, ValidationResult validationResult) {
        ValidationProblem problem2 = this.checkInputParamInCriteria(query, mappingClass);
        if (problem2 != null) {
            validationResult.addProblem(problem2);
            return;
        }
    }

    public void validate(ISetQuery setQuery, MappingClass mappingClass, ValidationResult validationResult) {
        boolean hasInputParamInCriteria = false;
        ValidationProblem inputCriteriaProblem = null;
        for (Object query : setQuery.getQueryCommands()) {
            if (query instanceof ISetQuery) {
                this.validate((ISetQuery)query, mappingClass, validationResult);
                return;
            }
            ValidationProblem problem2 = this.checkInputParamInCriteria((IQuery)query, mappingClass);
            if (problem2 != null && !hasInputParamInCriteria) {
                inputCriteriaProblem = problem2;
                continue;
            }
            hasInputParamInCriteria = true;
        }
        if (!hasInputParamInCriteria) {
            validationResult.addProblem(inputCriteriaProblem);
        }
    }

    ValidationProblem checkInputParamInCriteria(IQuery query, MappingClass mappingClass) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        IGroupsUsedByElementsVisitor groupsUsedByElementsVisitor = queryService.getGroupsUsedByElementsVisitor();
        if (mappingClass.isRecursive()) {
            Set groups;
            boolean foundInParam = false;
            ICriteria criteriaClause = query.getCriteria();
            if (criteriaClause != null && ((groups = groupsUsedByElementsVisitor.findGroups((ILanguageObject)criteriaClause)).contains(factory.createGroupSymbol("INPUT")) || groups.contains(factory.createGroupSymbol("INPUTS")))) {
                foundInParam = true;
            }
            if (!foundInParam) {
                return new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("MappingClassTransformationRule.No_INPUT_Parameters_In_Criteria", (Object)mappingClass.getName()));
            }
        }
        return null;
    }

    void validateRecursiveMappingClass(MappingClass mc, ValidationResult validationResult) {
        EmfResource eResource = (EmfResource)mc.eResource();
        ModelContents contents = eResource.getModelContents();
        if (contents != null) {
            TreeMappingRoot tmr;
            MappingClassSet mcset = (MappingClassSet)mc.eContainer();
            List treeMappingRoots = contents.getTransformations(mcset.getTarget());
            HashMap xmlDocNodeToMappingClass = new HashMap();
            for (Object obj : treeMappingRoots) {
                if (!(obj instanceof TreeMappingRoot)) continue;
                tmr = (TreeMappingRoot)obj;
                CoreArgCheck.isEqual((int)1, (int)tmr.getInputs().size());
                Iterator outIter = tmr.getOutputs().iterator();
                while (outIter.hasNext()) {
                    xmlDocNodeToMappingClass.put(outIter.next(), tmr.getInputs().get(0));
                }
            }
            block2: for (Object obj : treeMappingRoots) {
                ValidationProblemImpl errorProblem;
                String msg;
                if (!(obj instanceof TreeMappingRoot) || (tmr = (TreeMappingRoot)obj).getInputs().get(0) != mc) continue;
                XmlElement element = (XmlElement)tmr.getOutputs().get(0);
                MappingClass rootMappingClass = this.getRecusionRootMappingClass(element, xmlDocNodeToMappingClass);
                if (rootMappingClass == null) {
                    msg = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mapping_Class_Is_Null_For_{0}_0", (Object)mc.getName());
                    errorProblem = new ValidationProblemImpl(0, 4, msg);
                    validationResult.addProblem((ValidationProblem)errorProblem);
                }
                if (rootMappingClass == null) continue;
                if (mc.getColumns().size() != rootMappingClass.getColumns().size()) {
                    msg = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mismatch_Number_Of_Column_{0}_AND_{1}_1", new Object[]{rootMappingClass.getName(), mc.getName()});
                    errorProblem = new ValidationProblemImpl(0, 4, msg);
                    validationResult.addProblem((ValidationProblem)errorProblem);
                    continue;
                }
                EList childColumns = mc.getColumns();
                EList rootColumns = rootMappingClass.getColumns();
                int i = 0;
                int n = rootColumns.size();
                while (i < n) {
                    ValidationProblemImpl errorProblem2;
                    String msg2;
                    String childColName;
                    String rootColName;
                    MappingClassColumn rootCol = (MappingClassColumn)rootColumns.get(i);
                    MappingClassColumn childCol = (MappingClassColumn)childColumns.get(i);
                    if (!rootCol.getName().equalsIgnoreCase(childCol.getName())) {
                        rootColName = String.valueOf(rootMappingClass.getName()) + "." + rootCol.getName();
                        childColName = String.valueOf(mc.getName()) + "." + childCol.getName();
                        msg2 = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mismatch_Number_Column_Name_{0}_AND_{1}_2", new Object[]{rootColName, childColName});
                        errorProblem2 = new ValidationProblemImpl(0, 4, msg2);
                        validationResult.addProblem((ValidationProblem)errorProblem2);
                        continue block2;
                    }
                    if (rootCol.getType() != childCol.getType()) {
                        rootColName = String.valueOf(rootMappingClass.getName()) + "." + rootCol.getName();
                        childColName = String.valueOf(mc.getName()) + "." + childCol.getName();
                        msg2 = TransformationPlugin.Util.getString("MappingClassTransformationRule.Mismatch_Column_Type_{0}_AND_{1}_3", new Object[]{rootColName, childColName});
                        errorProblem2 = new ValidationProblemImpl(0, 4, msg2);
                        validationResult.addProblem((ValidationProblem)errorProblem2);
                        continue block2;
                    }
                    ++i;
                }
            }
        }
    }

    private MappingClass getRecusionRootMappingClass(XmlElement xmlElement, Map xmlDocNodeToMappingClass) {
        MappingClass mc = (MappingClass)xmlDocNodeToMappingClass.get(xmlElement);
        if (mc != null && mc.isRecursionAllowed() && mc.isRecursive()) {
            XSDComponent xsdComponent = xmlElement.getXsdComponent();
            XSDTypeDefinition type = XmlDocumentUtil.findXSDType((XSDComponent)xsdComponent);
            if (xsdComponent == null) {
                return null;
            }
            EObject owner = xmlElement.eContainer();
            while (owner != null) {
                if (owner instanceof XmlElement) {
                    XSDComponent ownerXsdComponent = ((XmlElement)owner).getXsdComponent();
                    XSDTypeDefinition ownerType = XmlDocumentUtil.findXSDType((XSDComponent)ownerXsdComponent);
                    if (type != null && type == ownerType) {
                        mc = (MappingClass)xmlDocNodeToMappingClass.get(owner);
                        if (mc != null) {
                            return mc;
                        }
                        if (owner.eContainer() instanceof XmlContainerNode && (mc = (MappingClass)xmlDocNodeToMappingClass.get(owner.eContainer())) != null) {
                            return mc;
                        }
                    }
                }
                owner = owner.eContainer();
            }
        }
        return null;
    }
}

