/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.metadata.runtime.ColumnRecord;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.util.AttributeMappingHelper;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.type.IDataTypeManagerService;

public class ProjectSymbolsValidationHelper {
    public void validateProjectedSymbols(ICommand command, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        List projSymbols = CommandHelper.getProjectedSymbols((ICommand)command);
        this.applyMappingValidationRules(projSymbols, transRoot, validationResult);
    }

    public void applyMappingValidationRules(List projSymbols, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        ArrayList attributes = new ArrayList(TransformationValidator.getOutputColumns(transRoot));
        ArrayList mappings = new ArrayList(transRoot.getNested());
        this.checkMappingsForProjectSymbols(transRoot, mappings, projSymbols, validationResult);
        this.checkTargetAttributesForProjectSymbols(transRoot, attributes, projSymbols, validationResult);
        this.compareProjectSymbolsAndTargetColumns(transRoot, projSymbols, attributes, validationResult);
    }

    public void checkMappingsForProjectSymbols(SqlTransformationMappingRoot transRoot, Collection mappings, Collection projSymbols, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        String problemMsg = null;
        if (projSymbols.size() > mappings.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_less_than_the_number_defined_in_the_sql_transformation._1", (Object)TransformationHelper.getSqlEObjectName(target));
        } else if (projSymbols.size() < mappings.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_greater_than_the_number_defined_in_the_sql_transformation._2", (Object)TransformationHelper.getSqlEObjectName(target));
        }
        if (problemMsg != null) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }

    public void checkTargetAttributesForProjectSymbols(SqlTransformationMappingRoot transRoot, Collection attributes, Collection projSymbols, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        String problemMsg = null;
        if (projSymbols.size() > attributes.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_less_than_the_number_defined_in_the_sql_transformation._1", (Object)TransformationHelper.getSqlEObjectName(target));
        } else if (projSymbols.size() < attributes.size()) {
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_number_of_columns/elements_in_{0}_are_greater_than_the_number_defined_in_the_sql_transformation._2", (Object)TransformationHelper.getSqlEObjectName(target));
        }
        if (problemMsg != null) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }

    public void compareProjectSymbolsAndTargetColumns(SqlTransformationMappingRoot transRoot, List projSymbols, List targetColumns, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        Iterator colIter = targetColumns.iterator();
        Iterator projIter = projSymbols.iterator();
        while (projIter.hasNext() && colIter.hasNext()) {
            int columnNullType;
            ColumnRecord colRecord;
            int symbolNullType;
            IElementSymbol eSymbol;
            Object metadataID;
            IExpression singleElementSymbol;
            String symbolName;
            boolean foundMatch = false;
            EObject outputColumn = (EObject)colIter.next();
            String outputColumnName = TransformationHelper.getSqlColumnName(outputColumn);
            if (outputColumnName.equalsIgnoreCase(symbolName = AttributeMappingHelper.getSymbolShortName(singleElementSymbol = (IExpression)projIter.next()))) {
                foundMatch = true;
            } else if (symbolName != null && symbolName.toLowerCase().startsWith("mmuuid")) {
                Object obj;
                String uuid = symbolName.toLowerCase();
                Container cntr = ModelerCore.getContainer((EObject)outputColumn);
                if (cntr != null && (obj = cntr.getEObjectFinder().find((Object)uuid)) instanceof EObject && outputColumnName.equalsIgnoreCase(symbolName = TransformationHelper.getSqlColumnName((EObject)obj))) {
                    foundMatch = true;
                }
            }
            if (!foundMatch) {
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_target_attribute_matches_no_symbol_in_the_query_{0}._1", (Object)outputColumnName));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
            Class sourceType = singleElementSymbol.getType();
            String problemMsg = null;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)outputColumn);
            if (sourceType != null && sourceType != service.getDefaultDataClass(IDataTypeManagerService.DataTypeName.NULL)) {
                SqlDatatypeAspect typeAspect;
                EObject datatype = columnAspect.getDatatype(outputColumn);
                SqlDatatypeAspect sqlDatatypeAspect = typeAspect = datatype != null ? (SqlDatatypeAspect)AspectManager.getSqlAspect((EObject)datatype) : null;
                if (typeAspect != null) {
                    Class targetType = service.getDataTypeClass(typeAspect.getRuntimeTypeName(datatype));
                    if (!sourceType.equals(targetType)) {
                        problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_datatype_type_of_the_column_{0}_does_not_match_the_source_column_type._1", new Object[]{outputColumnName, service.getDataTypeName(targetType), service.getDataTypeName(sourceType)});
                        ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
                        validationResult.addProblem((ValidationProblem)typeProblem);
                        continue;
                    }
                } else {
                    problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_datatype_type_of_the_column_{0}_is_not_set_or_cannot_be_resolved_in_the_workspace._1", (Object)outputColumnName);
                    ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, problemMsg);
                    validationResult.addProblem((ValidationProblem)typeProblem);
                    continue;
                }
            }
            if (target instanceof MappingClass || !(singleElementSymbol instanceof IElementSymbol) || outputColumn == null || (metadataID = (eSymbol = (IElementSymbol)singleElementSymbol).getMetadataID()) == null || !(metadataID instanceof ColumnRecord) || (symbolNullType = (colRecord = (ColumnRecord)metadataID).getNullType()) == (columnNullType = (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)outputColumn)).getNullType(outputColumn))) continue;
            problemMsg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_Nullable_value_of_virtual_group_attribute_{0}_doesn____t_match_that_of_the_attribute_it_mapps_to_in_query_transform._1", (Object)outputColumnName);
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 2, problemMsg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }
}

