/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.aspects.validation.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.TableRecord;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.transformation.impl.MappingClassImpl;
import org.teiid.designer.metamodels.transformation.impl.MappingClassSetImpl;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.impl.XmlDocumentImpl;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ICommandCollectorVisitor;
import org.teiid.designer.query.sql.IElementCollectorVisitor;
import org.teiid.designer.query.sql.IFunctionCollectorVisitor;
import org.teiid.designer.query.sql.IGroupCollectorVisitor;
import org.teiid.designer.query.sql.IPredicateCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICompareCriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IOption;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.validation.rules.MappingClassTransformationValidationHelper;
import org.teiid.designer.transformation.aspects.validation.rules.ProjectSymbolsValidationHelper;
import org.teiid.designer.transformation.util.AttributeMappingHelper;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;

public class SqlTransformationMappingRootValidationRule
implements ObjectValidationRule {
    private IQueryService getQueryService() {
        return ModelerCore.getTeiidQueryService();
    }

    private IQueryFactory getQueryFactory() {
        return this.getQueryService().createQueryFactory();
    }

    private IGroupCollectorVisitor getGroupCollectorVisitor() {
        return this.getQueryService().getGroupCollectorVisitor(true);
    }

    public void validate(EObject eObject, ValidationContext validationContext) {
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)eObject);
        SqlTransformationMappingRoot transRoot = (SqlTransformationMappingRoot)eObject;
        EObject target = transRoot.getTarget();
        if (target instanceof BaseTable && RelationalUtil.isGlobalTempTable((EObject)target)) {
            return;
        }
        ValidationResultImpl validationResult = new ValidationResultImpl((Object)transRoot, (Object)transRoot.getTarget());
        this.validateMapping(transRoot, (ValidationResult)validationResult);
        this.validateSourcesAndTargets(transRoot, (ValidationResult)validationResult);
        this.validMappingInputDependencies(transRoot, (ValidationResult)validationResult);
        this.validateUpdatability(transRoot, (ValidationResult)validationResult);
        TransformationValidator validator = new TransformationValidator(transRoot, validationContext, true, true);
        this.validateSqlTransformation(transRoot, (ValidationResult)validationResult, validator, validationContext);
        this.validateInputDocumentForWebService(transRoot, (ValidationResult)validationResult);
        validationContext.addResult((ValidationResult)validationResult);
    }

    /*
     * Unable to fully structure code
     */
    private void validateInputDocumentForWebService(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        target = transRoot.getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        sources = transRoot.getInputs();
        for (EObject source : sources) {
            if (!(source instanceof XmlDocument)) continue;
            xmlDoc = (XmlDocument)source;
            rootElement = xmlDoc.getRoot();
            mdlContents = ((EmfResource)source.eResource()).getModelContents();
            contentIter = mdlContents.getTransformations(source).iterator();
            if (contentIter.hasNext()) ** GOTO lbl23
            return;
lbl-1000:
            // 1 sources

            {
                mappingRoot = (MappingRoot)contentIter.next();
                if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
                outputRootElementsIter = mappingRoot.getOutputs().iterator();
                while (outputRootElementsIter.hasNext()) {
                    if (!rootElement.equals(outputRootElementsIter.next())) continue;
                    problem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.xml_doc_mapped_at_root_for_web_service"));
                    validationResult.addProblem((ValidationProblem)problem);
                    return;
                }
lbl23:
                // 3 sources

                ** while (contentIter.hasNext())
            }
lbl24:
            // 1 sources

        }
    }

    public void validateSourcesAndTargets(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        EObject target = transRoot.getTarget();
        CoreArgCheck.isNotNull((Object)target);
        Container container = ModelerCore.getContainer((EObject)transRoot);
        if (container == null) {
            return;
        }
        if (target.eIsProxy() && (target = EcoreUtil.resolve((EObject)target, (ResourceSet)container)).eIsProxy()) {
            return;
        }
        SqlAspect targetSqlAspect = SqlAspectHelper.getSqlAspect((EObject)target);
        if (targetSqlAspect == null || !(targetSqlAspect instanceof SqlTableAspect) && !(targetSqlAspect instanceof SqlProcedureAspect)) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.no_valid_target"));
            validationResult.addProblem((ValidationProblem)typeProblem);
            return;
        }
        EList sources = transRoot.getInputs();
        for (EObject source : sources) {
            if (source.eIsProxy() && (source = EcoreUtil.resolve((EObject)source, (ResourceSet)container)).eIsProxy()) {
                return;
            }
            SqlAspect sourceSqlAspect = SqlAspectHelper.getSqlAspect((EObject)source);
            boolean isFunction = source instanceof ScalarFunction;
            if (!(isFunction || sourceSqlAspect != null && (sourceSqlAspect instanceof SqlTableAspect || sourceSqlAspect instanceof SqlProcedureAspect))) {
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.no_valid_source"));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            if (isFunction) continue;
            boolean isValidSource = true;
            if (targetSqlAspect instanceof SqlTableAspect) {
                isValidSource = ((SqlTableAspect)targetSqlAspect).canAcceptTransformationSource(target, source);
            } else if (targetSqlAspect instanceof SqlProcedureAspect) {
                isValidSource = ((SqlProcedureAspect)targetSqlAspect).canAcceptTransformationSource(target, source);
            }
            if (!isValidSource) {
                String targetName = targetSqlAspect.getName(target);
                String sourceName = sourceSqlAspect.getName(source);
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.invalid_source_for_target", new Object[]{sourceName, targetName}));
                validationResult.addProblem((ValidationProblem)typeProblem);
                return;
            }
            boolean isValidTarget = true;
            if (sourceSqlAspect instanceof SqlTableAspect) {
                isValidTarget = ((SqlTableAspect)sourceSqlAspect).canBeTransformationSource(source, target);
            } else if (sourceSqlAspect instanceof SqlProcedureAspect) {
                isValidTarget = ((SqlProcedureAspect)sourceSqlAspect).canBeTransformationSource(source, target);
            }
            if (isValidTarget) continue;
            String targetName = targetSqlAspect.getName(target);
            String sourceName = sourceSqlAspect.getName(source);
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.invalid_target_for_source", new Object[]{targetName, sourceName}));
            validationResult.addProblem((ValidationProblem)typeProblem);
            return;
        }
    }

    private void validMappingInputDependencies(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        Collection inputs = this.getMappingInputs(transRoot, true);
        EObject target = transRoot.getTarget();
        for (EObject source : inputs) {
            if (source == null || source != target) continue;
            Object[] params = new Object[]{ModelerCore.getModelEditor().getModelRelativePathIncludingModel(source)};
            String msg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.A_circular_dependency_exists_between_this_tranformation_and_the_source_group_0_1", params);
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, msg);
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
    }

    private void validateMapping(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EList outputs = transRoot.getOutputs();
        if (outputs.size() < 1) {
            String modelName = ModelerCore.getModelEditor().getModelName((EObject)transRoot).toString();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Sql_transformation_in_the_model_{0},_has_no_target_tables/groups._1", (Object)modelName));
            validationResult.addProblem((ValidationProblem)problem);
        } else if (outputs.size() > 1) {
            String modelName = ModelerCore.getModelEditor().getModelName((EObject)transRoot).toString();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Sql_transformation_in_the_model_{0},_cannot_not_have_multiple_target_tables/groups._2", (Object)modelName));
            validationResult.addProblem((ValidationProblem)problem);
        } else {
            EObject output = (EObject)outputs.iterator().next();
            Iterator inputIter = transRoot.getInputs().iterator();
            while (inputIter.hasNext()) {
                if (output != inputIter.next()) continue;
                String msg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_virtual_group_{0}_cannot_be_involved_as_an_input_to_the_transformation_defining_it._1", (Object)TransformationHelper.getSqlEObjectName(output));
                ValidationProblemImpl failureProblem = new ValidationProblemImpl(0, 4, msg);
                validationResult.addProblem((ValidationProblem)failureProblem);
            }
        }
    }

    private void validateUpdateProcedures(TransformationValidationResult transformResult, SqlTransformationMappingRoot transRoot, ValidationResult validationResult, ValidationContext validationContext) {
        ICommand deleteCommand;
        ICommand updateCommand;
        ICommand insertCommand;
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EObject target = transRoot.getTarget();
        if (!(target instanceof Table) || !((Table)target).isSupportsUpdate()) {
            return;
        }
        SqlTransformation transform = (SqlTransformation)transRoot.getHelper();
        if (!transform.isInsertSqlDefault() && transformResult.hasInsertResult() && (insertCommand = transformResult.getInsertResult().getCommand()) != null) {
            this.validateSubCommands(insertCommand, 2, transRoot, validationResult, validationContext);
        }
        if (!transform.isUpdateSqlDefault() && transformResult.hasUpdateResult() && (updateCommand = transformResult.getUpdateResult().getCommand()) != null) {
            this.validateSubCommands(updateCommand, 3, transRoot, validationResult, validationContext);
        }
        if (!transform.isDeleteSqlDefault() && transformResult.hasDeleteResult() && (deleteCommand = transformResult.getDeleteResult().getCommand()) != null) {
            this.validateSubCommands(deleteCommand, 4, transRoot, validationResult, validationContext);
        }
    }

    private void validateSubCommands(ICommand command, int subCmdType, SqlTransformationMappingRoot transRoot, ValidationResult validationResult, ValidationContext validationContext) {
        ValidationProblemImpl typeProblem = null;
        boolean foundDesiredSubCmd = false;
        ICommandCollectorVisitor commandCollectorVisitor = this.getQueryService().getCommandCollectorVisitor();
        List commands = commandCollectorVisitor.findCommands(command);
        EObject target = transRoot.getTarget();
        for (ICommand subCommand : commands) {
            int currentCmdType = subCommand.getType();
            if (currentCmdType == subCmdType) {
                foundDesiredSubCmd = true;
            }
            switch (currentCmdType) {
                case 1: {
                    if (!(subCommand instanceof IQuery)) break;
                    this.validateQuery((IQuery)subCommand, transRoot, validationResult, validationContext);
                    break;
                }
                case 2: {
                    if (!this.containsTarget(subCommand, target)) break;
                    typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_insert_procedure_for_the_virtualGroup_{0},_is_trying_to_execute_an_insert_against_itself._1", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 3: {
                    if (!this.containsTarget(subCommand, target)) break;
                    typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_update_procedure_for_the_virtualGroup_{0},_is_trying_to_execute_an_update_against_itself._2", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 4: {
                    if (!this.containsTarget(subCommand, target)) break;
                    typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_delete_procedure_for_the_virtualGroup_{0},_is_trying_to_execute_an_delete_against_itself._3", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
            }
            validationResult.addProblem(typeProblem);
            if (typeProblem != null && typeProblem.getSeverity() == 4) {
                return;
            }
            this.validateSubCommands(subCommand, 0, transRoot, validationResult, validationContext);
        }
        if (subCmdType != 0 && !foundDesiredSubCmd) {
            switch (subCmdType) {
                case 2: {
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_insert_procedure_for_the_virtualGroup_{0}_does____not_execute_an_insert._1", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 3: {
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_update_procedure_for_the_virtualGroup_{0}_does____not_execute_an_update._2", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
                case 4: {
                    typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_delete_procedure_for_the_virtualGroup_{0}_does____not_execute_an_delete._3", (Object)TransformationHelper.getSqlEObjectName(target)));
                    break;
                }
            }
            validationResult.addProblem(typeProblem);
        }
    }

    private boolean containsTarget(ICommand command, EObject target) {
        String targetName = TransformationHelper.getSqlEObjectFullName(target);
        String targetUUID = TransformationHelper.getSqlEObjectUUID(target);
        for (IGroupSymbol group : this.getGroupCollectorVisitor().findGroups((ILanguageObject)command)) {
            if (!group.getName().equalsIgnoreCase(targetUUID) && !group.getName().equalsIgnoreCase(targetName)) continue;
            return true;
        }
        return false;
    }

    private void validateVirtualProcedures(ICommand command, SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EObject target = transRoot.getTarget();
        if (!(target instanceof Procedure)) {
            return;
        }
        Procedure procTrgt = (Procedure)target;
        int cmdType = command.getType();
        ProcedureResult procResult = procTrgt.getResult();
        if (procResult == null && cmdType != 7) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Virtual_stored_procedures_should_always_return_a_resultSet._1"));
            validationResult.addProblem((ValidationProblem)typeProblem);
            return;
        }
        Collection elements = this.getElementsIncludeParameters((ILanguageObject)command);
        HashSet<String> upperSymbolNames = new HashSet<String>(elements.size());
        for (IElementSymbol symbol : elements) {
            String symbolUpperName = AttributeMappingHelper.getSymbolFullName((IExpression)symbol).toUpperCase();
            upperSymbolNames.add(symbolUpperName);
        }
        EList parameters = procTrgt.getParameters();
        boolean paramUsed = parameters.isEmpty();
        for (ProcedureParameter param : parameters) {
            String paramUpperName;
            String paramName;
            SqlAspect sqlAspect;
            if (paramUsed || (sqlAspect = AspectManager.getSqlAspect((EObject)param)) == null || (paramName = sqlAspect.getFullName((EObject)param)) == null || !upperSymbolNames.contains(paramUpperName = paramName.toUpperCase())) continue;
            paramUsed = true;
        }
        if (!paramUsed) {
            ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Sql_Transform_defining_the_virtual_procedure_{0}_does_not_use_any_of_the_parameters_defined_on_the_procedure._1", (Object)procTrgt.getName()));
            validationResult.addProblem((ValidationProblem)typeProblem);
        }
        if (cmdType == 2 || cmdType == 3 || cmdType == 4) {
            EList columns = procResult.getColumns();
            String typeName = null;
            if (columns.size() == 1) {
                Column column = (Column)columns.iterator().next();
                EObject columnType = column.getType();
                if (columnType == null) {
                    return;
                }
                DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)column, (boolean)true);
                typeName = dtMgr.getName(columnType);
            }
            if (typeName == null || !typeName.equals("int")) {
                ValidationProblemImpl typeProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Virtual_stored_procedures_defined_by_an_Insert,_Update_or_Delete_statement_must_define_return_a_resultSet_with_one_column_of_type_int._4"));
                validationResult.addProblem((ValidationProblem)typeProblem);
            }
        }
    }

    private Collection getElementsIncludeParameters(ILanguageObject obj) {
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        IElementCollectorVisitor elementCollectorVisitor = this.getQueryService().getElementCollectorVisitor(true);
        return elementCollectorVisitor.findElements(obj, true);
    }

    private void validateUpdatability(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EList inputs = transRoot.getInputs();
        EList outputs = transRoot.getOutputs();
        if (outputs.isEmpty() || inputs.isEmpty()) {
            return;
        }
        EObject targetObj = (EObject)outputs.iterator().next();
        if (SqlAspectHelper.isUpdatableGroup((EObject)targetObj)) {
            boolean updatable = false;
            for (EObject sourceObj : inputs) {
                if (!SqlAspectHelper.isUpdatableGroup((EObject)sourceObj) && !SqlAspectHelper.isProcedure((EObject)sourceObj)) continue;
                updatable = true;
                break;
            }
            if (!updatable) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.The_transformation_defining_an_updatable_virtual_group_should_be_include_atleast_one_updatable_source_group._1", (Object)TransformationHelper.getSqlEObjectName(targetObj)));
                validationResult.addProblem((ValidationProblem)problem);
            }
        }
    }

    private void validateSqlTransformation(SqlTransformationMappingRoot transRoot, ValidationResult validationResult, TransformationValidator validator, ValidationContext validationContext) {
        SqlTransformationResult selectResult;
        int pref;
        if (validationResult.isFatalObject((Object)transRoot)) {
            return;
        }
        EObject target = transRoot.getTarget();
        if (!validator.shouldValidate()) {
            return;
        }
        String targetName = ModelerCore.getModelEditor().getName(target);
        String selectSQL = SqlMappingRootCache.getSelectSql((EObject)transRoot);
        if (selectSQL == null && (pref = validationContext.getPreferenceStatus("relationalPreferences.emptyTransformations", 4)) != 0) {
            String msg = TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.No_sql_defined_for_{0}", (Object)targetName);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, pref, msg);
            validationResult.addProblem((ValidationProblem)problem);
            return;
        }
        TransformationValidationResult transformResult = validator.validateTransformation();
        if (!transformResult.isValid()) {
            List transformStatuses;
            Collection<IStatus> deleteStatuses;
            SqlTransformationResult deleteResult;
            Collection<IStatus> updateStatuses;
            SqlTransformationResult updateResult;
            Collection<IStatus> insertStatuses;
            SqlTransformationResult insertResult;
            List selectStatuses;
            if (target instanceof Procedure && ((Procedure)target).isFunction()) {
                return;
            }
            Collection<Object> statuses = null;
            SqlTransformationResult selectResult2 = transformResult.getSelectResult();
            if (selectResult2 != null && !selectResult2.isValidatable() && (selectStatuses = selectResult2.getStatusList()) != null) {
                statuses = selectStatuses;
            }
            if ((insertResult = transformResult.getInsertResult()) != null && !insertResult.isValidatable() && (insertStatuses = insertResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = insertStatuses;
                } else {
                    statuses.addAll(insertStatuses);
                }
            }
            if ((updateResult = transformResult.getUpdateResult()) != null && !updateResult.isValidatable() && (updateStatuses = updateResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = updateStatuses;
                } else {
                    statuses.addAll(updateStatuses);
                }
            }
            if ((deleteResult = transformResult.getDeleteResult()) != null && !deleteResult.isValidatable() && (deleteStatuses = deleteResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = deleteStatuses;
                } else {
                    statuses.addAll(deleteStatuses);
                }
            }
            if ((transformStatuses = transformResult.getStatusList()) != null) {
                if (statuses == null) {
                    statuses = transformStatuses;
                } else {
                    statuses.addAll(transformStatuses);
                }
            }
            if (statuses != null) {
                Iterator statusIter = statuses.iterator();
                while (statusIter.hasNext()) {
                    ValidationProblemImpl failureProblem = new ValidationProblemImpl((IStatus)statusIter.next());
                    validationResult.addProblem((ValidationProblem)failureProblem);
                }
            }
            return;
        }
        if (SqlAspectHelper.isUpdatableGroup((EObject)target)) {
            this.validateUpdateProcedures(transformResult, transRoot, validationResult, validationContext);
        }
        if ((selectResult = transformResult.getSelectResult()) != null) {
            int pref2;
            ICommand command = selectResult.getCommand();
            if (command != null) {
                if (command instanceof IQuery) {
                    this.validateQuery((IQuery)command, transRoot, validationResult, validationContext);
                }
                this.validateSubCommands(command, 0, transRoot, validationResult, validationContext);
            }
            if (!validationResult.isFatalObject((Object)transRoot)) {
                ProjectSymbolsValidationHelper projRule = new ProjectSymbolsValidationHelper();
                projRule.validateProjectedSymbols(command, transRoot, validationResult);
                this.validateVirtualProcedures(command, transRoot, validationResult);
                MappingClassTransformationValidationHelper rule = new MappingClassTransformationValidationHelper();
                rule.validate(command, transRoot, validationResult);
            }
            if ((pref2 = validationContext.getPreferenceStatus("corePreferences.stringFunctionsAreOneBased", 2)) != 0) {
                IFunctionCollectorVisitor functionCollectorVisitor = this.getQueryService().getFunctionCollectorVisitor(true);
                Collection functions = functionCollectorVisitor.findFunctions((ILanguageObject)command, true);
                for (IFunction function : functions) {
                    String functionName = function.getName().toUpperCase();
                    if (!"SUBSTRING".equals(functionName) && !"LOCATE".equals(functionName) && !"INSERT".equals(functionName)) continue;
                    ValidationProblemImpl stringFunctionWarning = new ValidationProblemImpl(0, pref2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.STRING_BASED_FUNCTION_ONE_BASED"));
                    stringFunctionWarning.setHasPreference(validationContext.hasPreferences());
                    validationResult.addProblem((ValidationProblem)stringFunctionWarning);
                    break;
                }
            }
        }
    }

    private void validateQuery(IQuery query, SqlTransformationMappingRoot transRoot, ValidationResult validationResult, ValidationContext validationContext) {
        IElementCollectorVisitor elementCollectorVisitor = this.getQueryService().getElementCollectorVisitor(true);
        IPredicateCollectorVisitor predicateCollectorVisitor = this.getQueryService().getPredicateCollectorVisitor();
        Collection predicates = predicateCollectorVisitor.findPredicates((ILanguageObject)query);
        Collection groups = this.getGroupCollectorVisitor().findGroups((ILanguageObject)query);
        if (predicates.isEmpty() && groups.size() > 1) {
            int pref = validationContext.getPreferenceStatus("relationalPreferences.possibleCrossJoin", 2);
            if (pref != 0) {
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, pref, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.6", (Object)this.getNamesForGroupSymbols(groups)));
                validationResult.addProblem((ValidationProblem)warningProblem);
                this.appendDocumentLocation(transRoot, validationResult);
            }
        } else if (groups.size() > 1) {
            ArrayList allJoins = new ArrayList();
            IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
            for (Object predicate : predicates) {
                Class rightDataType;
                Class leftDataType;
                String descriptorName;
                if (!(predicate instanceof ICompareCriteria)) continue;
                ICompareCriteria compare = (ICompareCriteria)predicate;
                HashSet<IGroupSymbol> groupsInJoin = new HashSet<IGroupSymbol>();
                for (IElementSymbol element : elementCollectorVisitor.findElements((ILanguageObject)compare)) {
                    IGroupSymbol group = element.getGroupSymbol();
                    if (group == null && element.isExternalReference()) {
                        String elementFullName = element.getName();
                        int grpIndex = elementFullName.indexOf(element.getShortName());
                        String groupName = elementFullName.substring(0, grpIndex - 1);
                        group = this.getQueryFactory().createGroupSymbol(groupName);
                    }
                    if (group == null) continue;
                    groupsInJoin.add(group);
                }
                if (groupsInJoin.size() > 1) {
                    allJoins.add(groupsInJoin);
                }
                if (compare.getOperator() != 1) continue;
                IExpression leftExpression = compare.getLeftExpression();
                IExpression rightExpression = compare.getRightExpression();
                if (leftExpression != null && leftExpression instanceof IFunction) {
                    IFunction leftFunction = (IFunction)leftExpression;
                    descriptorName = leftFunction.getFunctionDescriptor().getName();
                    if (leftFunction.isImplicit() && descriptorName != null && (descriptorName.equals(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CONVERT)) || descriptorName.equals(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CAST)))) {
                        leftExpression = leftFunction.getArg(0);
                    }
                }
                if (rightExpression != null && rightExpression instanceof IFunction) {
                    IFunction rightFunction = (IFunction)rightExpression;
                    descriptorName = rightFunction.getFunctionDescriptor().getName();
                    if (rightFunction.isImplicit() && descriptorName != null && (descriptorName.equals(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CONVERT)) || descriptorName.equals(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CAST)))) {
                        rightExpression = rightFunction.getArg(0);
                    }
                }
                IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
                if (!(leftExpression instanceof IElementSymbol) || !(rightExpression instanceof IElementSymbol) || (leftDataType = leftExpression.getType()).equals(rightDataType = rightExpression.getType())) continue;
                Object[] params = new Object[]{compare, service.getDataTypeName(leftDataType), service.getDataTypeName(rightDataType)};
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.Join_type_mismatch_in_crit", params));
                validationResult.addProblem((ValidationProblem)warningProblem);
                this.appendDocumentLocation(transRoot, validationResult);
            }
            HashSet groupsJoined = new HashSet();
            if (allJoins.size() == 1) {
                groupsJoined.addAll((Collection)allJoins.get(0));
            } else {
                int i = 0;
                while (i < allJoins.size()) {
                    Collection join1 = (Collection)allJoins.get(i);
                    int j = i + 1;
                    while (j < allJoins.size()) {
                        Collection join2 = (Collection)allJoins.get(j);
                        for (IGroupSymbol joinGrp : join2) {
                            if (!join1.contains(joinGrp)) continue;
                            groupsJoined.addAll(join1);
                            groupsJoined.addAll(join2);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (!groupsJoined.containsAll(groups)) {
                groups.removeAll(groupsJoined);
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.6", (Object)this.getNamesForGroupSymbols(groups)));
                validationResult.addProblem((ValidationProblem)warningProblem);
                this.appendDocumentLocation(transRoot, validationResult);
            }
        }
        this.validateOption((ICommand)query, transRoot, validationResult);
    }

    private void appendDocumentLocation(SqlTransformationMappingRoot transRoot, ValidationResult validationResult) {
        String docName = this.getDocumentName(transRoot);
        if (docName != null) {
            validationResult.setLocationPath(String.valueOf(docName) + "/" + validationResult.getLocationPath());
        }
    }

    private String getDocumentName(SqlTransformationMappingRoot transRoot) {
        String docName = null;
        try {
            EObject xmlDocumentImpl;
            EObject mappingClassSetImpl;
            EObject mappingClassImpl = transRoot.getTarget();
            if (mappingClassImpl instanceof MappingClassImpl && (mappingClassSetImpl = ((MappingClassImpl)mappingClassImpl).eContainer()) instanceof MappingClassSetImpl && (xmlDocumentImpl = ((MappingClassSetImpl)mappingClassSetImpl).getTarget()) instanceof XmlDocumentImpl) {
                docName = ((XmlDocumentImpl)xmlDocumentImpl).getName();
            }
        }
        catch (Exception ex) {
            TransformationPlugin.Util.log(2, (Throwable)ex, ex.getMessage());
        }
        return docName;
    }

    private Collection getNamesForGroupSymbols(Collection groups) {
        HashSet<String> groupNames = new HashSet<String>(groups.size());
        for (IGroupSymbol grpSyb : groups) {
            Object metadataID = grpSyb.getMetadataID();
            if (metadataID != null && metadataID instanceof MetadataRecord) {
                groupNames.add(((MetadataRecord)metadataID).getFullName());
                continue;
            }
            groupNames.add(grpSyb.getName());
        }
        return groupNames;
    }

    private void validateOption(ICommand command, SqlTransformationMappingRoot root, ValidationResult result) {
        IOption option = command.getOption();
        if (option == null) {
            return;
        }
        this.validateDepOptionGroups(option.getDependentGroups(), root, result);
        this.validateDepOptionGroups(option.getNotDependentGroups(), root, result);
        this.validateOptionNoCacheGrps(command, root, result);
    }

    private void validateDepOptionGroups(Collection<String> groupNames, SqlTransformationMappingRoot root, ValidationResult result) {
        if (groupNames == null || groupNames.isEmpty()) {
            return;
        }
        for (String groupName : groupNames) {
            if (groupName.indexOf(46) >= 0) continue;
            ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.0", (Object)groupName));
            result.addProblem((ValidationProblem)warningProblem);
        }
    }

    private void validateOptionNoCacheGrps(ICommand command, SqlTransformationMappingRoot root, ValidationResult result) {
        IOption option = command.getOption();
        if (option == null || !option.isNoCache()) {
            return;
        }
        Collection groups = this.getGroupCollectorVisitor().findGroups((ILanguageObject)command);
        Collection noCacheGroups = option.getNoCacheGroups();
        boolean hasMaterializedGroups = false;
        if (noCacheGroups != null) {
            for (String groupName : noCacheGroups) {
                boolean foundMaterializedMatch = false;
                LinkedList<String> shortNamesMatched = new LinkedList<String>();
                LinkedList<String> partialNamesMatched = new LinkedList<String>();
                LinkedList<String> aliasNamesMatched = new LinkedList<String>();
                for (IGroupSymbol grpSymbol : groups) {
                    Object metadataID = grpSymbol.getMetadataID();
                    if (metadataID == null || !(metadataID instanceof TableRecord)) continue;
                    TableRecord record = (TableRecord)metadataID;
                    String tableFullName = record.getFullName();
                    String tableShortName = record.getName();
                    String aliasName = grpSymbol.getDefinition() != null ? grpSymbol.getName() : null;
                    boolean isMaterialized = record.isMaterialized();
                    if (isMaterialized) {
                        hasMaterializedGroups = true;
                    }
                    if (isMaterialized && groupName.equalsIgnoreCase(tableFullName)) {
                        foundMaterializedMatch = true;
                        break;
                    }
                    if (groupName.equalsIgnoreCase(tableShortName)) {
                        if (!shortNamesMatched.contains(groupName.toUpperCase())) {
                            shortNamesMatched.add(groupName.toUpperCase());
                            if (!isMaterialized) continue;
                            foundMaterializedMatch = true;
                            continue;
                        }
                        ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.7", (Object)groupName));
                        result.addProblem((ValidationProblem)warningProblem);
                        return;
                    }
                    if (aliasName != null && groupName.equalsIgnoreCase(aliasName)) {
                        if (!aliasNamesMatched.contains(groupName.toUpperCase())) {
                            aliasNamesMatched.add(groupName.toUpperCase());
                            if (!isMaterialized) continue;
                            foundMaterializedMatch = true;
                            continue;
                        }
                        ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.8", (Object)groupName));
                        result.addProblem((ValidationProblem)warningProblem);
                        return;
                    }
                    if (!CoreStringUtil.endsWithIgnoreCase((String)tableFullName, (String)groupName)) continue;
                    if (!partialNamesMatched.contains(tableFullName.toUpperCase())) {
                        partialNamesMatched.add(tableFullName.toUpperCase());
                        if (!isMaterialized) continue;
                        foundMaterializedMatch = true;
                        continue;
                    }
                    ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.11", (Object)groupName));
                    result.addProblem((ValidationProblem)warningProblem);
                    return;
                }
                if (foundMaterializedMatch) continue;
                ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 4, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.9", (Object)groupName));
                result.addProblem((ValidationProblem)warningProblem);
                return;
            }
        }
        if (!hasMaterializedGroups && (noCacheGroups == null || noCacheGroups.isEmpty())) {
            ValidationProblemImpl warningProblem = new ValidationProblemImpl(0, 2, TransformationPlugin.Util.getString("SqlTransformationMappingRootValidationRule.10"));
            result.addProblem((ValidationProblem)warningProblem);
            return;
        }
    }

    private Collection getMappingInputs(SqlTransformationMappingRoot root, boolean recursive) {
        if (root != null) {
            HashSet result = new HashSet();
            HashSet visitedMappings = new HashSet();
            this.addInputsToCollection((Mapping)root, result, visitedMappings, recursive);
            return result;
        }
        return Collections.EMPTY_SET;
    }

    private void addInputsToCollection(Mapping mapping, Collection result, Collection visitedMappings, boolean recursive) {
        if (mapping != null) {
            if (visitedMappings.contains(mapping)) {
                return;
            }
            visitedMappings.add(mapping);
            result.addAll(mapping.getInputs());
            if (!recursive) {
                return;
            }
            for (EObject input : mapping.getInputs()) {
                EmfResource emfResource;
                ModelAnnotation model;
                Container container = ModelerCore.getContainer((EObject)mapping);
                Resource resource = ModelerCore.getModelEditor().findResource(container, input);
                if (!(resource instanceof EmfResource) || (model = (emfResource = (EmfResource)resource).getModelAnnotation()) == null || model.getModelType() != ModelType.VIRTUAL_LITERAL) continue;
                ModelContents contents = emfResource.getModelContents();
                List xforms = contents.getTransformations(input);
                for (TransformationMappingRoot mappingRoot : xforms) {
                    this.addInputsToCollection((Mapping)mappingRoot, result, visitedMappings, recursive);
                }
            }
        }
    }
}

