/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ddl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.ModelType;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.transformation.ddl.TeiidDDLConstants;
import org.teiid.designer.transformation.ddl.TeiidReservedConstants;
import org.teiid.designer.transformation.ddl.TeiidSQLConstants;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.type.IDataTypeManagerService;

public class TeiidModelToDdlGenerator
implements TeiidDDLConstants,
TeiidReservedConstants,
RelationalConstants {
    private StringBuilder ddlBuffer = new StringBuilder();
    private boolean includeTables = true;
    private boolean includeProcedures = true;
    private boolean includeFKs = true;
    private boolean isVirtual = false;
    private RelationalModelExtensionAssistant assistant;
    private List<IStatus> issues = new ArrayList<IStatus>();
    private Set<String> namespaces = new HashSet<String>();
    private ModelExtensionAssistantAggregator medAggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
    private boolean ignoreTeiidProcedures = false;

    public TeiidModelToDdlGenerator() {
    }

    public TeiidModelToDdlGenerator(boolean ignoreTeiidProcedures) {
        this.ignoreTeiidProcedures = ignoreTeiidProcedures;
    }

    public String generate(ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isNotNull((Object)modelResource);
        ModelContents contents = ModelContents.getModelContents((ModelResource)modelResource);
        this.isVirtual = modelResource.getModelType().getValue() == ModelType.VIRTUAL;
        this.append("\n");
        for (Object obj : contents.getAllRootEObjects()) {
            String statement = this.getStatement((EObject)obj);
            if (StringUtilities.isEmpty((String)statement)) continue;
            this.append(statement);
            this.append("\n");
        }
        if (!this.namespaces.isEmpty()) {
            for (String namespace : this.namespaces) {
                this.ddlBuffer.insert(0, String.valueOf(namespace) + "\n");
            }
            this.ddlBuffer.insert(0, "\n");
        }
        return this.ddlBuffer.toString();
    }

    public String getStatement(EObject eObj) {
        if (eObj instanceof Table) {
            if (this.isVirtual) {
                return this.view((Table)eObj);
            }
            return this.table((Table)eObj);
        }
        if (eObj instanceof Procedure) {
            return this.procedure((Procedure)eObj);
        }
        return null;
    }

    private String getColumnDdl(Column col) {
        String options;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName((EObject)col));
        sb.append(" ");
        String teiidDdlDataType = this.resolveExportedDataType(col.getType());
        if (teiidDdlDataType == null) {
            this.addIssue(4, "Error finding " + this.getName(col.getType()) + ".  Type set to 'string'");
            teiidDdlDataType = IDataTypeManagerService.DataTypeName.STRING.name();
        }
        sb.append(this.getColumnDatatypeDdl(teiidDdlDataType, col.getLength(), col.getPrecision(), col.getScale()));
        String properties = this.getColumnProperties(col);
        if (!StringUtilities.isEmpty((String)properties)) {
            sb.append(" ").append(properties);
        }
        if (!StringUtilities.isEmpty((String)(options = this.getColumnOptions(col)))) {
            sb.append(" ").append(options);
        }
        return sb.toString();
    }

    private String resolveExportedDataType(EObject dataTypeEObject) {
        String dataTypeName = ModelerCore.getBuiltInTypesManager().getName(dataTypeEObject);
        if (dataTypeName == null) {
            this.addIssue(4, "Error finding " + this.getName(dataTypeEObject) + ".  Type set to 'string'");
            return IDataTypeManagerService.DataTypeName.STRING.name();
        }
        if (dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.VARBINARY.name())) {
            return dataTypeName;
        }
        String runtimeTypeName = ModelerCore.getBuiltInTypesManager().getRuntimeTypeName(dataTypeEObject);
        if (runtimeTypeName == null) {
            runtimeTypeName = ModelerCore.getDatatypeManager().getRuntimeTypeName(dataTypeEObject);
        }
        if (runtimeTypeName != null && runtimeTypeName.equalsIgnoreCase("XMLLITERAL")) {
            return IDataTypeManagerService.DataTypeName.XML.name();
        }
        return runtimeTypeName;
    }

    private String getColumnDatatypeDdl(String name, int length, int precision, int scale) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        boolean isLengthType = ModelerCore.getTeiidDataTypeManagerService().isLengthDataType(name);
        boolean isPrecisionType = ModelerCore.getTeiidDataTypeManagerService().isPrecisionDataType(name);
        boolean isScaleType = ModelerCore.getTeiidDataTypeManagerService().isScaleDataType(name);
        if (isLengthType) {
            if (length > 0) {
                sb.append("(").append(length).append(")");
            }
        } else if (isPrecisionType && precision > 0) {
            sb.append("(").append(precision);
            if (isScaleType && scale > 0) {
                sb.append(",").append(" ").append(scale).append(")");
            } else {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String getParameterDatatypeDdl(String name, int length, int precision, int scale) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        boolean isLengthType = ModelerCore.getTeiidDataTypeManagerService().isLengthDataType(name);
        boolean isPrecisionType = ModelerCore.getTeiidDataTypeManagerService().isPrecisionDataType(name);
        boolean isScaleType = ModelerCore.getTeiidDataTypeManagerService().isScaleDataType(name);
        if (isLengthType) {
            if (length > 0) {
                sb.append("(").append(length).append(")");
            }
        } else if (isPrecisionType && precision > 0) {
            sb.append("(").append(precision);
            if (isScaleType && scale > 0) {
                sb.append(",").append(" ").append(scale).append(")");
            } else {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String getParameterDdl(ProcedureParameter param) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName((EObject)param));
        sb.append(" ");
        String teiidDdlDataType = this.resolveExportedDataType(param.getType());
        sb.append(this.getParameterDatatypeDdl(teiidDdlDataType, param.getLength(), param.getPrecision(), param.getScale()));
        return sb.toString();
    }

    private String getName(EObject eObj) {
        return ModelerCore.getModelEditor().getName(eObj);
    }

    private String getDescription(EObject eObj) {
        try {
            return ModelerCore.getModelEditor().getDescription(eObj);
        }
        catch (ModelerCoreException e) {
            this.addIssue(4, "Error finding description for " + this.getName(eObj), e);
            return null;
        }
    }

    private void append(Object o) {
        this.ddlBuffer.append(o);
    }

    private String table(Table table) {
        String constraints;
        if (!this.includeTables) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE FOREIGN TABLE").append(" ");
        sb.append(this.getName((EObject)table));
        sb.append(" (");
        EList columns = table.getColumns();
        int nColumns = columns.size();
        int count = 0;
        for (Column col : columns) {
            if (count == 0) {
                sb.append("\n");
            }
            String columnStr = this.getColumnDdl(col);
            sb.append("\t").append(columnStr);
            if (++count >= nColumns) continue;
            sb.append(",\n");
        }
        if (table instanceof BaseTable && (constraints = this.getContraints((BaseTable)table)) != null) {
            sb.append(constraints);
        }
        sb.append("\n)");
        String options = this.getTableOptions(table);
        if (!StringUtilities.isEmpty((String)options)) {
            sb.append(" ").append(options);
        }
        sb.append("\n");
        return sb.toString();
    }

    private String view(Table table) {
        TransformationMappingRoot tRoot;
        String sqlString;
        String constraints;
        if (!this.includeTables) {
            return null;
        }
        boolean isGlobalTempTable = false;
        StringBuilder sb = new StringBuilder();
        try {
            String value;
            if (this.hasOption((EObject)table, "relational:global-temp-table") && (value = this.getOption((EObject)table, "relational:global-temp-table")).toLowerCase().equals(Boolean.TRUE.toString())) {
                isGlobalTempTable = true;
            }
        }
        catch (Exception e) {
            this.addIssue(4, "Error finding options for " + this.getName((EObject)table), e);
        }
        if (isGlobalTempTable) {
            sb.append("CREATE GLOBAL TEMPORARY TABLE").append(" ");
        } else {
            sb.append("CREATE VIEW").append(" ");
        }
        sb.append(this.getName((EObject)table));
        sb.append(" (");
        EList columns = table.getColumns();
        int nColumns = columns.size();
        int count = 0;
        for (Column col : columns) {
            if (count == 0) {
                sb.append("\n");
            }
            String columnStr = this.getColumnDdl(col);
            sb.append("\t").append(columnStr);
            if (++count >= nColumns) continue;
            sb.append(",\n");
        }
        if (table instanceof BaseTable && (constraints = this.getContraints((BaseTable)table)) != null) {
            sb.append(constraints);
        }
        sb.append("\n)");
        String options = this.getTableOptions(table);
        if (!StringUtilities.isEmpty((String)options)) {
            sb.append(" ").append(options);
        }
        if (!isGlobalTempTable && (sqlString = TransformationHelper.getSelectSqlString(tRoot = (TransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)table))) != null) {
            sb.append(" ").append("\nAS").append("\n\t").append(sqlString);
            sb.append(";\n");
        }
        return sb.toString();
    }

    private String procedure(Procedure procedure) {
        String options;
        if (!this.includeProcedures) {
            return null;
        }
        if (this.ignoreTeiidProcedures && this.isTeiidProcedure(procedure.getName())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFunction = procedure.isFunction();
        if (isFunction) {
            if (this.isVirtual) {
                sb.append("CREATE VIRTUAL FUNCTION").append(" ");
            } else {
                sb.append("CREATE FOREIGN FUNCTION").append(" ");
            }
        } else if (this.isVirtual) {
            sb.append("CREATE VIRTUAL PROCEDURE").append(" ");
        } else {
            sb.append("CREATE FOREIGN PROCEDURE").append(" ");
        }
        sb.append(this.getName((EObject)procedure));
        sb.append(" (");
        EList params = procedure.getParameters();
        int nParams = params.size();
        int count = 0;
        String returnType = null;
        ProcedureParameter returnParam = null;
        int returnTypeLength = 0;
        int returnTypeScale = 0;
        int returnTypePrecision = 0;
        for (ProcedureParameter param : params) {
            if (param.getDirection() != DirectionKind.RETURN_LITERAL) continue;
            returnType = this.resolveExportedDataType(param.getType());
            returnTypeLength = param.getLength();
            returnTypeScale = param.getScale();
            returnTypePrecision = param.getPrecision();
            returnParam = param;
            break;
        }
        if (returnType != null) {
            --nParams;
        }
        for (ProcedureParameter param : params) {
            if (param.getDirection() == DirectionKind.RETURN_LITERAL) continue;
            String paramStr = this.getParameterDdl(param);
            ++count;
            sb.append(paramStr);
            String options2 = this.getOptions((EObject)param);
            if (!StringUtilities.isEmpty((String)options2)) {
                sb.append(" ").append(options2);
            }
            if (count >= nParams) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (procedure.getResult() != null) {
            sb.append(" RETURNS");
            options = this.getOptions((EObject)procedure.getResult());
            if (!StringUtilities.isEmpty((String)options)) {
                sb.append(" ").append(options);
            }
            sb.append(" TABLE ");
            sb.append("(");
            count = 0;
            int nCols = procedure.getResult().getColumns().size();
            for (Object col : procedure.getResult().getColumns()) {
                Column nextCol = (Column)col;
                String columnStr = this.getColumnDdl(nextCol);
                sb.append(columnStr);
                if (++count < nCols) {
                    sb.append(", ");
                }
                if (StringUtilities.isEmpty((String)(options = this.getColumnOptions(nextCol)))) continue;
                sb.append(" ").append(options);
            }
            sb.append(")");
        } else if (returnType != null) {
            sb.append(" RETURNS");
            options = this.getOptions((EObject)returnParam);
            if (!StringUtilities.isEmpty((String)options)) {
                sb.append(" ").append(options);
            }
            sb.append(" ").append(this.getParameterDatatypeDdl(returnType, returnTypeLength, returnTypePrecision, returnTypeScale));
        }
        options = this.getProcedureOptions(procedure);
        if (!StringUtilities.isEmpty((String)options)) {
            sb.append("\n");
            sb.append(" ").append(options);
        }
        if (this.isVirtual && !isFunction) {
            TransformationMappingRoot tRoot = (TransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)procedure);
            String sqlString = TransformationHelper.getSelectSqlString(tRoot).replace("CREATE VIRTUAL PROCEDURE", "");
            if (sqlString != null) {
                if (sqlString.indexOf(10) == 0) {
                    sqlString = sqlString.replace("\n", "");
                }
                sb.append("\n\t").append("AS").append("\n").append(sqlString);
                if (!sqlString.endsWith(";")) {
                    sb.append(";");
                }
                sb.append("\n");
            }
        } else {
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getColumnProperties(Column col) {
        boolean autoIncremented;
        String defaultValue;
        StringBuffer sb = new StringBuffer();
        NullableType nullableType = col.getNullable();
        if (nullableType.equals(NullableType.NO_NULLS_LITERAL)) {
            sb.append("NOT NULL").append(" ");
        }
        if (!StringUtilities.isEmpty((String)(defaultValue = col.getDefaultValue()))) {
            if (!StringUtilities.isSingleQuoted((String)defaultValue)) {
                defaultValue = StringUtilities.getQuotedValue((String)defaultValue, (String)"'");
            }
            sb.append("DEFAULT").append(" ").append(defaultValue).append(" ");
        }
        if (autoIncremented = col.isAutoIncremented()) {
            sb.append("AUTO_INCREMENT").append(" ");
        }
        if (col.getOwner() instanceof BaseTable && !col.getIndexes().isEmpty()) {
            sb.append("INDEX").append(" ");
        }
        return sb.toString().trim();
    }

    private String getColumnOptions(Column col) {
        OptionsStatement options = new OptionsStatement();
        options.add("NAMEINSOURCE", col.getNameInSource(), null);
        options.add("NATIVE_TYPE", col.getNativeType(), null);
        options.add("CASE_SENSITIVE", Boolean.toString(col.isCaseSensitive()), Boolean.TRUE.toString());
        options.add("SELECTABLE", Boolean.toString(col.isSelectable()), Boolean.TRUE.toString());
        options.add("UPDATABLE", Boolean.toString(col.isUpdateable()), Boolean.TRUE.toString());
        options.add("SIGNED", Boolean.toString(col.isSigned()), Boolean.TRUE.toString());
        options.add("CURRENCY", Boolean.toString(col.isCurrency()), Boolean.FALSE.toString());
        options.add("FIXED_LENGTH", Boolean.toString(col.isFixedLength()), Boolean.FALSE.toString());
        int distinctValueCt = col.getDistinctValueCount();
        if (distinctValueCt > -1) {
            options.add("DISTINCT_VALUES", Integer.toString(distinctValueCt), Integer.toString(0));
        } else if (distinctValueCt < -1) {
            Integer obj = new Integer(distinctValueCt);
            float floatValue = Float.intBitsToFloat(obj & Integer.MAX_VALUE);
            DecimalFormat myFormatter = new DecimalFormat("###");
            String output = myFormatter.format(floatValue);
            options.add("DISTINCT_VALUES", output, Integer.toString(0));
        }
        int nullValueCt = col.getNullValueCount();
        if (nullValueCt > -1) {
            options.add("NULL_VALUE_COUNT", Integer.toString(nullValueCt), Integer.toString(0));
        } else if (distinctValueCt < -1) {
            Integer obj = new Integer(nullValueCt);
            float floatValue = Float.intBitsToFloat(obj & Integer.MAX_VALUE);
            DecimalFormat myFormatter = new DecimalFormat("###");
            String output = myFormatter.format(floatValue);
            options.add("NULL_VALUE_COUNT", output, Integer.toString(0));
        }
        String desc = this.getDescription((EObject)col);
        if (!StringUtilities.isEmpty((String)desc)) {
            options.add("ANNOTATION", desc, "");
        }
        if (!col.getSearchability().equals(0)) {
            options.add("SEARCHABLE", col.getSearchability().getLiteral(), SearchabilityType.SEARCHABLE_LITERAL.toString());
        }
        try {
            Map<String, String> props = this.getOptionsForObject((EObject)col);
            for (String key : props.keySet()) {
                String value = props.get(key);
                options.add(key, value, null);
            }
        }
        catch (Exception e) {
            this.addIssue(4, "Error finding options for " + this.getName((EObject)col), e);
        }
        return options.toString();
    }

    private String getOptions(EObject eobject) {
        OptionsStatement options = new OptionsStatement();
        String desc = this.getDescription(eobject);
        if (!StringUtilities.isEmpty((String)desc)) {
            options.add("ANNOTATION", desc, "");
        }
        try {
            Map<String, String> props = this.getOptionsForObject(eobject);
            for (String key : props.keySet()) {
                String value = props.get(key);
                options.add(key, value, null);
            }
        }
        catch (Exception e) {
            this.addIssue(4, "Error finding options for " + this.getName(eobject), e);
        }
        return options.toString();
    }

    private String getContraints(BaseTable table) {
        StringBuilder theSB;
        boolean hasUCs;
        StringBuffer sb = new StringBuffer();
        boolean hasPK = table.getPrimaryKey() != null;
        boolean hasFKs = table.getForeignKeys().size() > 0;
        int nColumns = 0;
        int count = 0;
        Collection<UniqueConstraint> uniqueConstraints = this.getUniqueUniqueContraints(table);
        boolean bl = hasUCs = uniqueConstraints.size() > 0;
        if (hasPK) {
            PrimaryKey pk = table.getPrimaryKey();
            String pkName = this.getName((EObject)pk);
            sb.append(",");
            StringBuilder stringBuilder = new StringBuilder("\n\tCONSTRAINT " + pkName + " " + "PRIMARY KEY");
            nColumns = pk.getColumns().size();
            count = 0;
            for (Object col : pk.getColumns()) {
                if (++count == 1) {
                    stringBuilder.append("(");
                }
                stringBuilder.append(this.getName((EObject)col));
                if (count < nColumns) {
                    stringBuilder.append(", ");
                    continue;
                }
                stringBuilder.append(")");
            }
            sb.append(stringBuilder.toString());
            if (hasFKs && this.includeFKs || hasUCs) {
                sb.append(",");
            }
        }
        if (hasFKs && this.includeFKs) {
            int nFKs = table.getForeignKeys().size();
            int countFK = 0;
            for (Object e : table.getForeignKeys()) {
                ++countFK;
                ForeignKey fk = (ForeignKey)e;
                String fkName = this.getName((EObject)fk);
                theSB = new StringBuilder("\n\tCONSTRAINT " + fkName + " " + "FOREIGN KEY");
                nColumns = fk.getColumns().size();
                count = 0;
                for (Object col : fk.getColumns()) {
                    if (++count == 1) {
                        theSB.append("(");
                    }
                    theSB.append(this.getName((EObject)col));
                    if (count < nColumns) {
                        theSB.append(", ");
                        continue;
                    }
                    theSB.append(")");
                }
                if (fk.getTable() != null) {
                    UniqueKey uk = fk.getUniqueKey();
                    BaseTable fkTableRef = uk.getTable();
                    String fkTableRefName = this.getName((EObject)fkTableRef);
                    theSB.append(" ").append("REFERENCES").append(" ").append(fkTableRefName);
                    if (uk instanceof UniqueConstraint) {
                        UniqueConstraint ucRef = (UniqueConstraint)fkTableRef.getUniqueConstraints().get(0);
                        nColumns = ucRef.getColumns().size();
                        count = 0;
                        for (Object col : ucRef.getColumns()) {
                            if (++count == 1) {
                                theSB.append("(");
                            }
                            theSB.append(this.getName((EObject)col));
                            if (count < nColumns) {
                                theSB.append(", ");
                                continue;
                            }
                            theSB.append(")");
                        }
                    } else {
                        PrimaryKey pkRef = fkTableRef.getPrimaryKey();
                        nColumns = pkRef.getColumns().size();
                        count = 0;
                        for (Object col : pkRef.getColumns()) {
                            if (++count == 1) {
                                theSB.append("(");
                            }
                            theSB.append(this.getName((EObject)col));
                            if (count < nColumns) {
                                theSB.append(", ");
                                continue;
                            }
                            theSB.append(")");
                        }
                    }
                }
                sb.append(theSB.toString());
                if (countFK >= nFKs) continue;
                sb.append(",");
            }
            if (hasUCs) {
                sb.append(",");
            }
        }
        if (hasUCs) {
            int nUCs = uniqueConstraints.size();
            int ucCount = 0;
            for (Object e : uniqueConstraints) {
                ++ucCount;
                UniqueConstraint uc = (UniqueConstraint)e;
                String name = this.getName((EObject)uc);
                theSB = new StringBuilder("\n\tCONSTRAINT " + name + " " + "UNIQUE");
                nColumns = uc.getColumns().size();
                count = 0;
                for (Object col : uc.getColumns()) {
                    if (++count == 1) {
                        theSB.append("(");
                    }
                    theSB.append(this.getName((EObject)col));
                    if (count < nColumns) {
                        theSB.append(", ");
                        continue;
                    }
                    theSB.append(")");
                }
                if (ucCount < nUCs) {
                    sb.append(",");
                }
                sb.append(theSB.toString());
            }
        }
        return sb.toString();
    }

    private String getTableOptions(Table table) {
        OptionsStatement options = new OptionsStatement();
        options.add("NAMEINSOURCE", table.getNameInSource(), null);
        options.add("MATERIALIZED", Boolean.toString(table.isMaterialized()), Boolean.FALSE.toString());
        options.add("UPDATABLE", Boolean.toString(table.isSupportsUpdate()), Boolean.TRUE.toString());
        if (table.getCardinality() != 0) {
            int cardValue = table.getCardinality();
            if (cardValue > -1) {
                options.add("CARDINALITY", Integer.toString(table.getCardinality()), Integer.toString(0));
            } else if (cardValue < -1) {
                Integer obj = new Integer(cardValue);
                float floatValue = Float.intBitsToFloat(obj & Integer.MAX_VALUE);
                DecimalFormat myFormatter = new DecimalFormat("###");
                String output = myFormatter.format(floatValue);
                options.add("CARDINALITY", output, Integer.toString(0));
            }
        }
        if (table.getMaterializedTable() != null) {
            options.add("MATERIALIZED_TABLE", table.getMaterializedTable().getName(), null);
        }
        try {
            Map<String, String> props = this.getOptionsForObject((EObject)table);
            for (String key : props.keySet()) {
                if (key.equals("relational:global-temp-table")) continue;
                String value = props.get(key);
                options.add(key, value, null);
            }
        }
        catch (Exception e) {
            this.addIssue(4, "Error finding options for " + this.getName((EObject)table), e);
        }
        String desc = this.getDescription((EObject)table);
        if (!StringUtilities.isEmpty((String)desc)) {
            options.add("ANNOTATION", desc, null);
        }
        return options.toString();
    }

    private Map<String, String> getOptionsForObject(EObject modelObject) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        Collection extensionNamespaces = this.medAggregator.getSupportedNamespacePrefixes((Object)modelObject);
        for (String ns : extensionNamespaces) {
            String value;
            String propId;
            ModelObjectExtensionAssistant assistant = this.medAggregator.getModelObjectExtensionAssistant(ns);
            if (assistant == null) continue;
            Collection defns = assistant.getPropertyDefinitions((Object)modelObject);
            if (ns.equals("relational")) {
                this.addRelationalOption(options, "relational:native-query", modelObject, assistant);
                this.addRelationalOption(options, "relational:ALLOW_MATVIEW_MANAGEMENT", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_STATUS_TABLE", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_BEFORE_LOAD_SCRIPT", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_LOAD_SCRIPT", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_AFTER_LOAD_SCRIPT", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_SHARE_SCOPE", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATERIALIZED_STAGE_TABLE", modelObject, assistant);
                this.addRelationalOption(options, "relational:ON_VDB_START_SCRIPT", modelObject, assistant);
                this.addRelationalOption(options, "relational:ON_VDB_DROP_SCRIPT", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_ONERROR_ACTION", modelObject, assistant);
                this.addRelationalOption(options, "relational:MATVIEW_TTL", modelObject, assistant);
                continue;
            }
            if (ns.equals("salesforce")) {
                for (ModelExtensionPropertyDefinition ext : defns) {
                    propId = ext.getId();
                    value = assistant.getOverriddenValue((Object)modelObject, propId);
                    if (value == null) continue;
                    propId = propId.replace("salesforce", "teiid_sf");
                    options.put(propId, value);
                }
                continue;
            }
            if (ns.equals("mongodb")) {
                for (ModelExtensionPropertyDefinition ext : defns) {
                    propId = ext.getId();
                    value = assistant.getOverriddenValue((Object)modelObject, propId);
                    if (value == null) continue;
                    propId = propId.replace("mongodb", "teiid_mongo");
                    options.put(propId, value);
                }
                continue;
            }
            if (!ns.equals("excel")) continue;
            for (ModelExtensionPropertyDefinition ext : defns) {
                propId = ext.getId();
                value = assistant.getOverriddenValue((Object)modelObject, propId);
                if (value == null) continue;
                propId = propId.replace("excel", "teiid_excel");
                options.put(propId, value);
            }
        }
        return options;
    }

    private void addRelationalOption(Map<String, String> options, String propId, EObject modelObject, ModelObjectExtensionAssistant assistant) throws Exception {
        String value = assistant.getOverriddenValue((Object)modelObject, propId);
        if (!CoreStringUtil.isEmpty((String)value)) {
            propId = propId.replace("relational", "teiid_rel");
            options.put(propId, value);
        }
    }

    private boolean hasOption(EObject modelObject, String propId) throws Exception {
        Collection extensionNamespaces = this.medAggregator.getSupportedNamespacePrefixes((Object)modelObject);
        for (String ns : extensionNamespaces) {
            ModelObjectExtensionAssistant assistant = this.medAggregator.getModelObjectExtensionAssistant(ns);
            if (assistant == null) continue;
            assistant.getPropertyDefinitions((Object)modelObject);
            String property = assistant.getOverriddenValue((Object)modelObject, propId);
            if (CoreStringUtil.isEmpty((String)property)) continue;
            return true;
        }
        return false;
    }

    private String getOption(EObject modelObject, String propId) throws Exception {
        Collection extensionNamespaces = this.medAggregator.getSupportedNamespacePrefixes((Object)modelObject);
        for (String ns : extensionNamespaces) {
            ModelObjectExtensionAssistant assistant = this.medAggregator.getModelObjectExtensionAssistant(ns);
            if (assistant == null) continue;
            assistant.getPropertyDefinitions((Object)modelObject);
            String property = assistant.getOverriddenValue((Object)modelObject, propId);
            if (CoreStringUtil.isEmpty((String)property)) continue;
            return property;
        }
        return null;
    }

    private void addOptionsForEObject(EObject eObj, StringBuilder sb) {
        try {
            OptionsStatement options = new OptionsStatement();
            Map<String, String> props = this.getOptionsForObject(eObj);
            for (String key : props.keySet()) {
                String value = props.get(key);
                options.add(key, value, null);
            }
            if (!StringUtilities.isEmpty((String)options.toString())) {
                sb.append(" ").append(options);
            }
        }
        catch (Exception e) {
            this.addIssue(4, "Error finding options for " + this.getName(eObj), e);
        }
    }

    private String getProcedureOptions(Procedure procedure) {
        String value;
        boolean isFunction;
        OptionsStatement options = new OptionsStatement();
        String desc = this.getDescription((EObject)procedure);
        if (!StringUtilities.isEmpty((String)desc)) {
            options.add("ANNOTATION", desc, "");
        }
        options.add("NAMEINSOURCE", procedure.getNameInSource(), null);
        String nativeQuery = this.getPropertyValue((EObject)procedure, "relational:native-query");
        if (!CoreStringUtil.isEmpty((String)nativeQuery)) {
            options.add("NATIVE-QUERY", nativeQuery, null);
        }
        if (!this.isVirtual) {
            String nonPreparedValue = this.getPropertyValue((EObject)procedure, "relational:non-prepared");
            this.setBooleanProperty("NON-PREPARED", nonPreparedValue, false, options);
        }
        if (isFunction = procedure.isFunction()) {
            boolean booleanValue;
            value = this.getPropertyValue((EObject)procedure, "relational:function-category");
            options.add("FUNCTION-CATEGORY", value, null);
            value = this.getPropertyValue((EObject)procedure, "relational:java-class");
            options.add("JAVA_CLASS", value, null);
            value = this.getPropertyValue((EObject)procedure, "relational:java-method");
            options.add("JAVA_METHOD", value, null);
            value = this.getPropertyValue((EObject)procedure, "relational:varargs");
            this.setBooleanProperty("VARARGS", value, false, options);
            value = this.getPropertyValue((EObject)procedure, "relational:null-on-null");
            this.setBooleanProperty("NULL-ON-NULL", value, false, options);
            value = this.getPropertyValue((EObject)procedure, "relational:deterministic");
            this.setBooleanProperty("DETERMINISM", value, false, options);
            value = this.getPropertyValue((EObject)procedure, "relational:aggregate");
            if (value != null && (booleanValue = Boolean.getBoolean(value))) {
                this.setBooleanProperty("AGGREGATE", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:analytic");
                this.setBooleanProperty("ANALYTIC", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:allows-orderby");
                this.setBooleanProperty("ALLOWS-ORDERBY", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:uses-distinct-rows");
                this.setBooleanProperty("USES-DISTINCT-ROWS", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:allows-distinct");
                this.setBooleanProperty("ALLOWS-DISTINCT", value, false, options);
                value = this.getPropertyValue((EObject)procedure, "relational:decomposable");
                this.setBooleanProperty("DECOMPOSABLE", value, false, options);
            }
        } else {
            value = this.getRestPropertyValue((EObject)procedure, RestModelExtensionConstants.PropertyIds.URI);
            if (value != null) {
                this.namespaces.add("SET NAMESPACE 'http://teiid.org/rest' AS REST;");
            }
            options.add("REST:URI", value, null);
            value = this.getRestPropertyValue((EObject)procedure, RestModelExtensionConstants.PropertyIds.REST_METHOD);
            if (value != null) {
                this.namespaces.add("SET NAMESPACE 'http://teiid.org/rest' AS REST;");
            }
            options.add("REST:METHOD", value, null);
        }
        try {
            Map<String, String> props = this.getOptionsForObject((EObject)procedure);
            for (String key : props.keySet()) {
                String value2 = props.get(key);
                options.add(key, value2, null);
            }
        }
        catch (Exception e) {
            this.addIssue(4, "Error finding options for " + this.getName((EObject)procedure), e);
        }
        return options.toString();
    }

    private RelationalModelExtensionAssistant getRelationalModelExtensionAssistant() {
        if (this.assistant == null) {
            this.assistant = RelationalUtil.getRelationalExtensionAssistant();
        }
        return this.assistant;
    }

    private String getPropertyValue(EObject eObj, String propertyID) {
        try {
            return this.getRelationalModelExtensionAssistant().getPropertyValue((Object)eObj, propertyID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setIsVirtual(boolean isVirtualModel) {
        this.isVirtual = isVirtualModel;
    }

    private String getRestPropertyValue(EObject eObj, String propertyID) {
        try {
            return RestModelExtensionAssistant.getRestProperty((EObject)eObj, (String)propertyID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setBooleanProperty(String propID, String stringValue, boolean defaultValue, OptionsStatement options) {
        if (stringValue != null) {
            boolean booleanValue = Boolean.parseBoolean(stringValue);
            options.add(propID, String.valueOf(booleanValue), String.valueOf(defaultValue));
        }
    }

    private String escapeStringValue(String str, String tick) {
        return StringUtilities.replaceAll((String)str, (String)tick, (String)(String.valueOf(tick) + tick));
    }

    private String escapeSinglePart(String token) {
        if (TeiidSQLConstants.isReservedWord(token)) {
            return "\"" + token + "\"";
        }
        boolean escape = true;
        char start = token.charAt(0);
        if ("#".equals(Character.toString(start)) || "@".equals(Character.toString(start)) || StringUtilities.isLetter((char)start)) {
            escape = false;
            int i = 1;
            while (!escape && i < token.length()) {
                char c = token.charAt(i);
                escape = !StringUtilities.isLetterOrDigit((char)c) && c != '_';
                ++i;
            }
        }
        if (escape) {
            return "\"" + this.escapeStringValue(token, "\"") + "\"";
        }
        return token;
    }

    private Collection<UniqueConstraint> getUniqueUniqueContraints(BaseTable table) {
        EList ucs = table.getUniqueConstraints();
        ArrayList<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>();
        PrimaryKey pk = table.getPrimaryKey();
        for (Object obj : ucs) {
            UniqueConstraint uc = (UniqueConstraint)obj;
            if (pk != null) {
                EList pkColumns = pk.getColumns();
                EList ucColumns = uc.getColumns();
                if (pkColumns.size() == ucColumns.size()) {
                    boolean matchesAll = true;
                    for (Object col : ucColumns) {
                        if (pkColumns.contains(col)) continue;
                        matchesAll = false;
                    }
                    if (matchesAll) continue;
                    uniqueConstraints.add(uc);
                    continue;
                }
                uniqueConstraints.add(uc);
                continue;
            }
            uniqueConstraints.add(uc);
        }
        return uniqueConstraints;
    }

    public boolean isTeiidProcedure(String name) {
        return name.equalsIgnoreCase("invoke") || name.equalsIgnoreCase("invokeHttp") || name.equalsIgnoreCase("getFiles") || name.equalsIgnoreCase("getTextFiles") || name.equalsIgnoreCase("saveFile");
    }

    private void addIssue(int severity, String message) {
        this.issues.add((IStatus)new Status(severity, "org.teiid.designer.transformation", message));
    }

    private void addIssue(int severity, String message, Throwable e) {
        this.issues.add((IStatus)new Status(severity, "org.teiid.designer.transformation", message, e));
    }

    public void setIncludeTables(boolean includeTables) {
        this.includeTables = includeTables;
    }

    public void setIncludeProcedures(boolean includeProcedures) {
        this.includeProcedures = includeProcedures;
    }

    public void setIncludeFKs(boolean includeFKs) {
        this.includeFKs = includeFKs;
    }

    class OptionsStatement {
        boolean hasOptions;
        StringBuilder sb = new StringBuilder();

        public OptionsStatement() {
            this.sb.append("OPTIONS").append("(");
        }

        public void add(String key, String value, String defaultValue) {
            if (StringUtilities.isEmpty((String)value)) {
                return;
            }
            if (!StringUtilities.areDifferent((String)value, (String)defaultValue)) {
                return;
            }
            if (this.hasOptions) {
                this.sb.append(", ");
            }
            this.hasOptions = true;
            this.sb.append(TeiidModelToDdlGenerator.this.escapeSinglePart(key)).append(" ");
            if ("FALSE".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value)) {
                this.sb.append("'" + value.toUpperCase() + "'");
                return;
            }
            this.sb.append("'" + value + "'");
        }

        public String toString() {
            this.sb.append(")");
            if (!this.hasOptions) {
                return null;
            }
            return this.sb.toString();
        }
    }

    class ProcedureHandler {
        Procedure proc;

        public ProcedureHandler(Procedure procedure) {
            this.proc = procedure;
        }
    }
}

