/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.ScriptEngine;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.LRUCache;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metadata.runtime.ColumnRecord;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.TableRecord;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IQueryNode;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.transformation.metadata.TransformationMetadata;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.xml.IMappingNode;

public class TransformationMetadataFacade
implements IQueryMetadataInterface {
    public static final int DEFAULT_SPACELIMIT = 4000;
    public static final int DEFAULT_SPACELIMIT_PARTIAL_NAME_CACHE = 100;
    private final TransformationMetadata metadata;
    private final Map<String, Object> nameToIdCache;
    private final Map<Object, MetadataRecord> idToRecordCache;
    private final Map<String, String> partialNameToFullNameCache;

    public TransformationMetadataFacade(TransformationMetadata delegate) {
        this(delegate, 4000);
    }

    public TransformationMetadataFacade(TransformationMetadata delegate, int cacheSize) {
        CoreArgCheck.isNotNull((Object)delegate);
        this.metadata = delegate;
        this.nameToIdCache = Collections.synchronizedMap(new LRUCache(cacheSize));
        this.idToRecordCache = Collections.synchronizedMap(new LRUCache(cacheSize));
        this.partialNameToFullNameCache = Collections.synchronizedMap(new LRUCache(100));
    }

    public ITeiidServerVersion getTeiidVersion() {
        return ModelerCore.getTeiidServerVersion();
    }

    public Object getElementID(String elementName) throws Exception {
        MetadataRecord record = this.getRecordByName(elementName, 'G');
        if (record == null && (record = (MetadataRecord)this.metadata.getElementID(elementName)) != null) {
            this.updateNameToIdCache(elementName, 'G', record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        return record;
    }

    public Object getGroupID(String groupName) throws Exception {
        MetadataRecord record = this.getRecordByName(groupName, 'B');
        if (record == null && (record = (MetadataRecord)this.metadata.getGroupID(groupName)) != null) {
            this.updateNameToIdCache(groupName, 'B', record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getGroupsForPartialName(String partialGroupName) throws Exception {
        String fullName = this.getFullNameByPartialName(partialGroupName, 'B');
        if (fullName == null) {
            Map<String, String> map = this.partialNameToFullNameCache;
            synchronized (map) {
                fullName = this.getFullNameByPartialName(partialGroupName, 'B');
                if (fullName == null) {
                    Collection partialNameRecords = this.metadata.getGroupsForPartialName(partialGroupName);
                    if (partialNameRecords != null && partialNameRecords.size() == 1) {
                        this.updatePartialNameToFullName(partialGroupName, (String)partialNameRecords.iterator().next(), 'B');
                    }
                    return partialNameRecords;
                }
            }
        }
        ArrayList<String> partialNameRecords = new ArrayList<String>(1);
        partialNameRecords.add(fullName);
        return partialNameRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getModelID(Object groupOrElementID) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)groupOrElementID);
        MetadataRecord record = (MetadataRecord)groupOrElementID;
        Object modelRecord = record.getPropertyValue("modelForRecord");
        if (modelRecord == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                modelRecord = record.getPropertyValue("modelForRecord");
                if (modelRecord == null) {
                    modelRecord = this.metadata.getModelID(groupOrElementID);
                    record.setPropertyValue("modelForRecord", modelRecord);
                }
            }
        }
        return modelRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInGroupID(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        List elementIDs = (List)record.getPropertyValue("elementsInGroup");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInGroup");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInGroupID(groupID)) != null) {
                    record.setPropertyValue("elementsInGroup", (Object)elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    public Object getGroupIDForElementID(Object elementID) throws Exception {
        CoreArgCheck.isInstanceOf(ColumnRecord.class, (Object)elementID);
        ColumnRecord columnRecord = (ColumnRecord)elementID;
        String tableUUID = columnRecord.getParentUUID();
        MetadataRecord record = this.getRecordByID(tableUUID);
        if (record == null && (record = (MetadataRecord)this.metadata.getGroupID(tableUUID)) != null) {
            this.updateNameToIdCache(record.getFullName(), record.getRecordType(), record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        return record;
    }

    public IStoredProcedureInfo getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws Exception {
        IStoredProcedureInfo procInfo = null;
        MetadataRecord record = this.getRecordByName(fullyQualifiedProcedureName, 'E');
        if (record == null && (procInfo = this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName)) != null) {
            record = (MetadataRecord)procInfo.getProcedureID();
            record.setPropertyValue("storedProcInfoForRecord", (Object)procInfo);
            this.updateNameToIdCache(fullyQualifiedProcedureName, 'E', record.getUUID());
            this.updateIdToRecordCache(record.getUUID(), record);
        }
        if (procInfo == null && record != null && (procInfo = (IStoredProcedureInfo)record.getPropertyValue("storedProcInfoForRecord")) == null) {
            procInfo = this.metadata.getStoredProcedureInfoForProcedure(fullyQualifiedProcedureName);
            record.setPropertyValue("storedProcInfoForRecord", (Object)procInfo);
        }
        return procInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQueryNode getVirtualPlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        IQueryNode queryPlan = (IQueryNode)tableRecord.getPropertyValue("queryPlan");
        if (queryPlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                queryPlan = (IQueryNode)tableRecord.getPropertyValue("queryPlan");
                if (queryPlan == null) {
                    queryPlan = this.metadata.getVirtualPlan(groupID);
                    tableRecord.setPropertyValue("queryPlan", (Object)queryPlan);
                }
            }
        }
        return queryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInsertPlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String insertPlan = (String)tableRecord.getPropertyValue("insertPlan");
        if (insertPlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                insertPlan = (String)tableRecord.getPropertyValue("insertPlan");
                if (insertPlan == null) {
                    insertPlan = this.metadata.getInsertPlan(groupID);
                    tableRecord.setPropertyValue("insertPlan", (Object)insertPlan);
                }
            }
        }
        return insertPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUpdatePlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String updatePlan = (String)tableRecord.getPropertyValue("updatePlan");
        if (updatePlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                updatePlan = (String)tableRecord.getPropertyValue("updatePlan");
                if (updatePlan == null) {
                    updatePlan = this.metadata.getUpdatePlan(groupID);
                    tableRecord.setPropertyValue("updatePlan", (Object)updatePlan);
                }
            }
        }
        return updatePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeletePlan(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        TableRecord tableRecord = (TableRecord)groupID;
        String deletePlan = (String)tableRecord.getPropertyValue("deletePlan");
        if (deletePlan == null) {
            TableRecord tableRecord2 = tableRecord;
            synchronized (tableRecord2) {
                deletePlan = (String)tableRecord.getPropertyValue("deletePlan");
                if (deletePlan == null) {
                    deletePlan = this.metadata.getDeletePlan(groupID);
                    tableRecord.setPropertyValue("deletePlan", (Object)deletePlan);
                }
            }
        }
        return deletePlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getIndexesInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection indexes = (Collection)record.getPropertyValue("indexesInGroup");
        if (indexes == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                indexes = (Collection)record.getPropertyValue("indexesInGroup");
                if (indexes == null) {
                    indexes = this.metadata.getIndexesInGroup(groupID);
                    record.setPropertyValue("indexesInGroup", (Object)indexes);
                }
            }
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getUniqueKeysInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection uks = (Collection)record.getPropertyValue("uksInGroup");
        if (uks == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                uks = (Collection)record.getPropertyValue("uksInGroup");
                if (uks == null) {
                    uks = this.metadata.getUniqueKeysInGroup(groupID);
                    record.setPropertyValue("uksInGroup", (Object)uks);
                }
            }
        }
        return uks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getForeignKeysInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection fks = (Collection)record.getPropertyValue("fksInGroup");
        if (fks == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                fks = (Collection)record.getPropertyValue("fksInGroup");
                if (fks == null) {
                    fks = this.metadata.getForeignKeysInGroup(groupID);
                    record.setPropertyValue("fksInGroup", (Object)fks);
                }
            }
        }
        return fks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)foreignKeyID);
        MetadataRecord keyRecord = (MetadataRecord)foreignKeyID;
        Object primaryKey = keyRecord.getPropertyValue("primaryKeyForForeignKey");
        if (primaryKey == null) {
            MetadataRecord metadataRecord = keyRecord;
            synchronized (metadataRecord) {
                primaryKey = keyRecord.getPropertyValue("primaryKeyForForeignKey");
                if (primaryKey == null) {
                    primaryKey = this.metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
                    keyRecord.setPropertyValue("primaryKeyForForeignKey", primaryKey);
                }
            }
        }
        return primaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAccessPatternsInGroup(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection accPatterns = (Collection)record.getPropertyValue("accPttrnsInGroup");
        if (accPatterns == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                accPatterns = (Collection)record.getPropertyValue("accPttrnsInGroup");
                if (accPatterns == null) {
                    accPatterns = this.metadata.getAccessPatternsInGroup(groupID);
                    record.setPropertyValue("accPttrnsInGroup", (Object)accPatterns);
                }
            }
        }
        return accPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInIndex(Object index) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)index);
        MetadataRecord record = (MetadataRecord)index;
        List elementIDs = (List)record.getPropertyValue("elementsInIndex");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInIndex");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInIndex(index)) != null) {
                    record.setPropertyValue("elementsInIndex", (Object)elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInKey(Object key) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)key);
        MetadataRecord record = (MetadataRecord)key;
        List elementIDs = (List)record.getPropertyValue("elementsInKey");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInKey");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInKey(key)) != null) {
                    record.setPropertyValue("elementsInKey", (Object)elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElementIDsInAccessPattern(Object accessPattern) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)accessPattern);
        MetadataRecord record = (MetadataRecord)accessPattern;
        List elementIDs = (List)record.getPropertyValue("elementsInAccPttrn");
        if (elementIDs == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                elementIDs = (List)record.getPropertyValue("elementsInAccPttrn");
                if (elementIDs == null && (elementIDs = this.metadata.getElementIDsInAccessPattern(accessPattern)) != null) {
                    record.setPropertyValue("elementsInAccPttrn", (Object)elementIDs);
                    for (MetadataRecord columnRecord : elementIDs) {
                        if (columnRecord == null) continue;
                        this.updateNameToIdCache(columnRecord.getFullName(), columnRecord.getRecordType(), columnRecord.getUUID());
                        this.updateIdToRecordCache(columnRecord.getUUID(), columnRecord);
                    }
                }
            }
        }
        return elementIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMappingNode getMappingNode(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        IMappingNode mappingNode = (IMappingNode)record.getPropertyValue("mappingNodeForRecord");
        if (mappingNode == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                mappingNode = (IMappingNode)record.getPropertyValue("mappingNodeForRecord");
                if (mappingNode == null) {
                    mappingNode = this.metadata.getMappingNode(groupID);
                    record.setPropertyValue("mappingNodeForRecord", (Object)mappingNode);
                }
            }
        }
        return mappingNode.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getXMLTempGroups(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        Collection<Object> tempGroups = (Collection<Object>)record.getPropertyValue("tempGroupsForDocument");
        if (tempGroups == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                tempGroups = (Collection)record.getPropertyValue("tempGroupsForDocument");
                if (tempGroups == null) {
                    tempGroups = this.metadata.getXMLTempGroups(groupID);
                    record.setPropertyValue("tempGroupsForDocument", tempGroups);
                }
            }
        }
        return tempGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getXMLSchemas(Object groupID) throws Exception {
        CoreArgCheck.isInstanceOf(TableRecord.class, (Object)groupID);
        MetadataRecord record = (MetadataRecord)groupID;
        List schemas = (List)record.getPropertyValue("schemasForDocument");
        if (schemas == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                schemas = (List)record.getPropertyValue("schemasForDocument");
                if (schemas == null) {
                    schemas = this.metadata.getXMLSchemas(groupID);
                    record.setPropertyValue("schemasForDocument", (Object)schemas);
                }
            }
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getExtensionProperties(Object metadataID) throws Exception {
        CoreArgCheck.isInstanceOf(MetadataRecord.class, (Object)metadataID);
        MetadataRecord record = (MetadataRecord)metadataID;
        Properties extentions = (Properties)record.getPropertyValue("extentionsForRecord");
        if (extentions == null) {
            MetadataRecord metadataRecord = record;
            synchronized (metadataRecord) {
                extentions = (Properties)record.getPropertyValue("extentionsForRecord");
                if (extentions == null) {
                    extentions = this.metadata.getExtensionProperties(metadataID);
                    record.setPropertyValue("extentionsForRecord", (Object)extentions);
                }
            }
        }
        return extentions;
    }

    public TransformationMetadata getDelegate() {
        return this.metadata;
    }

    private MetadataRecord getRecordByName(String fullname, char recordType) {
        CoreArgCheck.isNotZeroLength((String)fullname);
        Object id = this.nameToIdCache.get(this.getLookupKey(fullname, recordType));
        if (id != null) {
            return this.getRecordByID(id);
        }
        return null;
    }

    private String getFullNameByPartialName(String partialName, char recordType) {
        CoreArgCheck.isNotZeroLength((String)partialName);
        return this.partialNameToFullNameCache.get(this.getLookupKey(partialName, recordType));
    }

    private MetadataRecord getRecordByID(Object id) {
        CoreArgCheck.isNotNull((Object)id);
        return this.idToRecordCache.get(id);
    }

    private void updateNameToIdCache(String fullName, char recordType, Object id) {
        if (!CoreStringUtil.isEmpty((String)fullName) && id != null) {
            this.nameToIdCache.put(this.getLookupKey(fullName, recordType), id);
        }
    }

    private void updateIdToRecordCache(Object id, MetadataRecord record) {
        if (id != null && record != null) {
            this.idToRecordCache.put(id, record);
        }
    }

    private void updatePartialNameToFullName(String partialName, String fullName, char recordType) {
        if (!CoreStringUtil.isEmpty((String)partialName) && !CoreStringUtil.isEmpty((String)fullName)) {
            this.partialNameToFullNameCache.put(this.getLookupKey(partialName, recordType), fullName);
        }
    }

    private String getLookupKey(String name, char recordType) {
        return String.valueOf(name.toUpperCase()) + recordType;
    }

    public String getFullName(Object metadataID) throws Exception {
        return null;
    }

    public String getName(Object metadataID) throws Exception {
        return null;
    }

    public String getElementType(Object elementID) throws Exception {
        return null;
    }

    public String getDefaultValue(Object elementID) throws Exception {
        return null;
    }

    public Object getMinimumValue(Object elementID) throws Exception {
        return null;
    }

    public Object getMaximumValue(Object elementID) throws Exception {
        return null;
    }

    public int getPosition(Object elementID) throws Exception {
        return 0;
    }

    public int getPrecision(Object elementID) throws Exception {
        return 0;
    }

    public int getScale(Object elementID) throws Exception {
        return 0;
    }

    public int getRadix(Object elementID) throws Exception {
        return 0;
    }

    public String getFormat(Object elementID) throws Exception {
        return null;
    }

    public float getDistinctValues(Object elementID) throws Exception {
        return 0.0f;
    }

    public float getNullValues(Object elementID) throws Exception {
        return 0.0f;
    }

    public boolean isVirtualGroup(Object groupID) throws Exception {
        return false;
    }

    public boolean isVirtualModel(Object modelID) throws Exception {
        return false;
    }

    public boolean modelSupports(Object modelID, int modelConstant) throws Exception {
        return false;
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws Exception {
        return false;
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws Exception {
        return false;
    }

    public int getMaxSetSize(Object modelID) throws Exception {
        return 0;
    }

    public boolean isXMLGroup(Object groupID) throws Exception {
        return false;
    }

    public String getVirtualDatabaseName() throws Exception {
        return null;
    }

    public float getCardinality(Object groupID) throws Exception {
        return 0.0f;
    }

    public String getNameInSource(Object metadataID) throws Exception {
        return null;
    }

    public int getElementLength(Object elementID) throws Exception {
        return 0;
    }

    public boolean hasMaterialization(Object groupID) throws Exception {
        return false;
    }

    public Object getMaterialization(Object groupID) throws Exception {
        return null;
    }

    public Object getMaterializationStage(Object groupID) throws Exception {
        return null;
    }

    public String getNativeType(Object elementID) throws Exception {
        return null;
    }

    public boolean isProcedure(Object groupID) throws Exception {
        return false;
    }

    public boolean hasProcedure(String procedureName) {
        return false;
    }

    public String[] getVDBResourcePaths() throws Exception {
        return null;
    }

    public String getModeledType(Object elementID) throws Exception {
        return null;
    }

    public String getModeledBaseType(Object elementID) throws Exception {
        return null;
    }

    public String getModeledPrimitiveType(Object elementID) throws Exception {
        return null;
    }

    public String getCharacterVDBResource(String resourcePath) throws Exception {
        return null;
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws Exception {
        return null;
    }

    public Object getPrimaryKey(Object metadataID) {
        return null;
    }

    public IFunctionLibrary getFunctionLibrary() {
        return null;
    }

    public boolean isTemporaryTable(Object groupID) throws Exception {
        return false;
    }

    public Object addToMetadataCache(Object metadataID, String key, Object value) throws Exception {
        return null;
    }

    public Object getFromMetadataCache(Object metadataID, String key) throws Exception {
        return null;
    }

    public boolean isScalarGroup(Object groupID) throws Exception {
        return false;
    }

    public boolean isMultiSource(Object modelId) throws Exception {
        return false;
    }

    public boolean isMultiSourceElement(Object elementId) throws Exception {
        return false;
    }

    public IQueryMetadataInterface getDesignTimeMetadata() {
        return null;
    }

    public IQueryMetadataInterface getSessionMetadata() {
        return null;
    }

    public Set getImportedModels() {
        return null;
    }

    public ScriptEngine getScriptEngine(String langauge) throws Exception {
        return null;
    }

    public boolean isVariadic(Object metadataID) {
        return false;
    }

    public Map getFunctionBasedExpressions(Object metadataID) {
        return null;
    }

    public boolean isPseudo(Object elementId) {
        return false;
    }

    public Object getModelID(String modelName) throws Exception {
        return null;
    }

    public String getExtensionProperty(Object metadataID, String key, boolean checkUnqualified) {
        return null;
    }

    public boolean findShortName() {
        return false;
    }

    public boolean useOutputName() {
        return false;
    }

    public boolean widenComparisonToString() {
        return false;
    }
}

