/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.ModelerMetadata;
import org.teiid.designer.transformation.metadata.QueryMetadataContext;

public class VdbMetadata
extends ModelerMetadata {
    public VdbMetadata(QueryMetadataContext context, Container container) {
        super(context, container);
    }

    @Override
    protected Collection findMetadataRecords(char recordType, String entityName, boolean isPartialName) throws Exception {
        Collection sysObjects;
        EObject eObj;
        LinkedList<EObject> eObjects = new LinkedList<EObject>();
        String uuid = null;
        if (CoreStringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
            uuid = entityName.toLowerCase();
        } else {
            String shortName = super.getShortElementName(entityName);
            if (CoreStringUtil.startsWithIgnoreCase((String)shortName, (String)"mmuuid")) {
                uuid = shortName.toLowerCase();
            }
        }
        if (uuid != null && (eObj = this.lookupEObject(uuid)) != null && (eObj.eContainer() != null || eObj.eResource() != null)) {
            eObjects.add(eObj);
        }
        if (eObjects.isEmpty() && !(sysObjects = this.findSystemMetadataRecords(recordType, entityName, isPartialName)).isEmpty()) {
            return sysObjects;
        }
        if (eObjects.isEmpty()) {
            IEntryResult[] results = this.queryIndex(recordType, entityName, isPartialName);
            Collection records = this.findMetadataRecords(results);
            if (CoreStringUtil.startsWithIgnoreCase((String)entityName, (String)"mmuuid")) {
                this.filterMetadataRecordForUUID(entityName, records);
            }
            return records;
        }
        if (!eObjects.isEmpty()) {
            ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(eObjects.size());
            Iterator eObjIter = eObjects.iterator();
            while (eObjIter.hasNext()) {
                MetadataRecord record = this.createMetadataRecord(recordType, (EObject)eObjIter.next());
                if (record == null) continue;
                records.add(record);
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected EObject lookupEObject(String uuid) {
        CoreArgCheck.isNotEmpty((String)uuid);
        return (EObject)this.getContainer().getEObjectFinder().find((Object)uuid);
    }

    @Override
    protected Index[] getIndexes(char recordType, IndexSelector selector) throws Exception {
        try {
            String indexName = IndexUtil.getIndexFileNameForRecordType((char)recordType);
            return IndexUtil.getIndexes((String)indexName, (IndexSelector)selector);
        }
        catch (Exception e) {
            throw new TeiidDesignerException((Throwable)e, TransformationPlugin.Util.getString("TransformationMetadata.Error_trying_to_obtain_index_file_using_IndexSelector_1", (Object)selector));
        }
    }
}

