/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionAssistant;
import org.teiid.designer.relational.RelationalPlugin;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.relational.model.RelationalViewTable;
import org.teiid.designer.transformation.Messages;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.util.TransformationHelper;

public class RelationalViewModelFactory
extends RelationalModelFactory {
    public ModelResource createRelationalViewModel(IPath location, String modelName) throws ModelWorkspaceException {
        ModelResource resrc = ModelerCore.createModelResource((IPath)location, (String)modelName);
        resrc.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
        ModelerCore.getModelEditor().getAllContainers(resrc.getEmfResource());
        return resrc;
    }

    public ModelResource createRelationalViewModel(IContainer container, String modelName) throws ModelWorkspaceException {
        IProject project = container.getProject();
        String actualModelName = modelName;
        if (!modelName.toLowerCase().endsWith(".xmi")) {
            actualModelName = String.valueOf(modelName) + ".xmi";
        }
        IPath relativeModelPath = container.getFullPath().removeFirstSegments(1).append(actualModelName);
        IFile modelFile = project.getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        resrc.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
        ModelerCore.getModelEditor().getAllContainers(resrc.getEmfResource());
        return resrc;
    }

    public void build(ModelResource modelResource, RelationalModel model, IProgressMonitor progressMonitor) {
        try {
            this.buildFullModel(model, modelResource, progressMonitor);
            modelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (ModelerCoreException e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public EObject buildObject(RelationalReference obj, ModelResource modelResource, IProgressMonitor progressMonitor) throws ModelWorkspaceException {
        EObject newEObject = null;
        String msg = TransformationPlugin.Util.getString("RelationalViewModelFactory.relationalModelFactory_creatingModelChild", (Object)obj.getName());
        progressMonitor.setTaskName(msg);
        switch (obj.getType()) {
            case 0: {
                break;
            }
            case 1: {
                throw new UnsupportedOperationException(Messages.virtualSchemaUnsupportedMessage);
            }
            case 2: {
                throw new UnsupportedOperationException(Messages.virtualCatalogUnsupportedMessage);
            }
            case 3: {
                EObject baseTable = this.createBaseTable(obj, modelResource);
                modelResource.getEmfResource().getContents().add((Object)baseTable);
                this.applyTableExtensionProperties((RelationalTable)obj, (BaseTable)baseTable, true);
                RelationalViewTable viewTable = (RelationalViewTable)obj;
                TransformationHelper.createTransformation(baseTable, viewTable.getTransformationSQL());
                break;
            }
            case 4: {
                throw new UnsupportedOperationException(Messages.virtualViewUnsupportedMessage);
            }
            case 5: {
                EObject procedure = this.createProcedure(obj, modelResource);
                modelResource.getEmfResource().getContents().add((Object)procedure);
                RelationalViewProcedure viewProc = (RelationalViewProcedure)obj;
                TransformationHelper.createTransformation(procedure, viewProc.getTransformationSQL());
                this.applyProcedureExtensionProperties((RelationalProcedure)obj, (Procedure)procedure);
                break;
            }
            case 13: {
                super.buildObject(obj, modelResource, progressMonitor);
                break;
            }
            default: {
                RelationalPlugin.Util.log(2, NLS.bind((String)org.teiid.designer.relational.Messages.relationalModelFactory_unknown_object_type_0_cannot_be_processed, (Object)obj.getName()));
            }
        }
        return newEObject;
    }

    protected void applyTableExtensionProperties(RelationalTable tableRef, BaseTable baseTable, boolean isVirtual) {
        RelationalModelExtensionAssistant assistant = this.getExtensionAssistant();
        if (assistant != null) {
            try {
                if (((RelationalViewTable)tableRef).isGlobalTempTable()) {
                    assistant.setPropertyValue((Object)baseTable, "relational:global-temp-table", Boolean.toString(true));
                }
            }
            catch (Exception ex) {
                RelationalPlugin.Util.log(4, (Throwable)ex, NLS.bind((String)org.teiid.designer.relational.Messages.relationalModelFactory_error_setting_extension_props_on_0, (Object)tableRef.getName()));
            }
        }
    }

    protected void applyProcedureExtensionProperties(RelationalProcedure procedureRef, Procedure procedure) {
        RelationalViewProcedure viewProcedure = (RelationalViewProcedure)procedureRef;
        if (!viewProcedure.isFunction()) {
            RestModelExtensionAssistant.setRestProperties((EObject)procedure, (String)viewProcedure.getRestMethod(), (String)viewProcedure.getRestUri(), (String)viewProcedure.getRestCharSet(), (String)viewProcedure.getRestHeaders(), (String)viewProcedure.getRestDescription());
        }
        super.applyProcedureExtensionProperties(procedureRef, procedure);
    }

    public void addTransformation(BaseTable baseTable, RelationalViewTable viewTable) {
        TransformationHelper.createTransformation((EObject)baseTable, viewTable.getTransformationSQL());
    }
}

