/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.metamodels.transformation.TransformationMapping;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IMetadataID;
import org.teiid.designer.query.sql.IElementCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;

public class AttributeMappingHelper {
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;

    public static boolean updateAttributeMappings(Object transMappingRoot, Object txnSource) {
        boolean changed = false;
        if (!TransformationHelper.isTransformationMappingRoot(transMappingRoot)) {
            return changed;
        }
        List targetAttrs = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
        if (targetAttrs == null || targetAttrs.isEmpty()) {
            return changed;
        }
        AttributeMappingHelper.attributesFullyMapped(transMappingRoot, targetAttrs);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update attr mappings", (Object)txnSource);
        boolean succeeded = false;
        try {
            AttributeMappingHelper.cleanAttributeMappings(transMappingRoot, txnSource);
            changed = AttributeMappingHelper.reconcileAttributeMappings(transMappingRoot, targetAttrs, txnSource);
            boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
            if (!isValid) {
                boolean bl = changed;
                return bl;
            }
            ICommand command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
            List projectedSymbols = CommandHelper.getProjectedSymbols((ICommand)command);
            List attrs = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            for (EObject attr : attrs) {
                IExpression seSymbol;
                if (!TransformationHelper.isSqlColumn(attr)) continue;
                String colName = TransformationHelper.getSqlEObjectName(attr);
                if (!AttributeMappingHelper.hasAttributeMapping(transMappingRoot, attr)) {
                    AttributeMappingHelper.createAttributeMapping(transMappingRoot, attr, txnSource);
                    changed = true;
                }
                if ((seSymbol = AttributeMappingHelper.getSymbolWithName(projectedSymbols, colName)) == null) continue;
                IElementCollectorVisitor elementCollectorVisitor = queryService.getElementCollectorVisitor(true);
                Collection elemSymbols = elementCollectorVisitor.findElements((ILanguageObject)seSymbol);
                List<EObject> elemEObjs = TransformationSqlHelper.getElementSymbolEObjects(elemSymbols, command);
                boolean bl = changed = AttributeMappingHelper.setAttributeMapping(transMappingRoot, attr, elemEObjs, txnSource) || changed;
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return changed;
    }

    private static boolean reconcileAttributeMappings(Object transMappingRoot, List targetAttrs, Object txnSource) {
        boolean changed = false;
        if (TransformationHelper.isTransformationMappingRoot(transMappingRoot) && targetAttrs != null) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile attr mappings", (Object)txnSource);
            boolean succeeded = false;
            try {
                List currentMappedAttributes = AttributeMappingHelper.getMappedAttributes(transMappingRoot);
                for (EObject targetAttr : targetAttrs) {
                    if (currentMappedAttributes.contains(targetAttr)) continue;
                    TransformationFactory mappingFactory = TransformationFactory.eINSTANCE;
                    TransformationMapping attrMapping = mappingFactory.createTransformationMapping();
                    attrMapping.setNestedIn((Mapping)((MappingRoot)transMappingRoot));
                    EList outputs = attrMapping.getOutputs();
                    outputs.add(targetAttr);
                    changed = true;
                }
                int i = currentMappedAttributes.size() - 1;
                while (i >= 0) {
                    EObject mappingAttr = (EObject)currentMappedAttributes.get(i);
                    if (!targetAttrs.contains(mappingAttr)) {
                        AttributeMappingHelper.removeAttributeMapping(transMappingRoot, mappingAttr, txnSource);
                        changed = true;
                    }
                    --i;
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return changed;
    }

    public static void createAttributeMapping(Object transMappingRoot, EObject targetAttr, Object txnSource) {
        List currentMappedAttributes;
        if (TransformationHelper.isTransformationMappingRoot(transMappingRoot) && targetAttr != null && TransformationHelper.isSqlColumn(targetAttr) && !(currentMappedAttributes = AttributeMappingHelper.getMappedAttributes(transMappingRoot)).contains(targetAttr)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create attr mapping", (Object)txnSource);
            boolean succeeded = false;
            try {
                TransformationFactory mappingFactory = TransformationFactory.eINSTANCE;
                TransformationMapping attrMapping = mappingFactory.createTransformationMapping();
                attrMapping.setNestedIn((Mapping)((MappingRoot)transMappingRoot));
                EList outputs = attrMapping.getOutputs();
                outputs.add(targetAttr);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static Mapping getAttributeMapping(Object transMappingRoot, EObject targetAttr) {
        Mapping attrMapping = null;
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        for (EObject eObj : attrMappings) {
            EObject target;
            EList targets;
            if (!(eObj instanceof Mapping) || (targets = ((Mapping)eObj).getOutputs()).isEmpty() || (target = (EObject)targets.get(0)) == null || !target.equals(targetAttr)) continue;
            attrMapping = (Mapping)eObj;
            break;
        }
        return attrMapping;
    }

    public static boolean hasAttributeMapping(Object transMappingRoot, EObject targetAttr) {
        boolean hasMapping = false;
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        for (EObject eObj : attrMappings) {
            EObject target;
            EList targets;
            if (!(eObj instanceof Mapping) || (targets = ((Mapping)eObj).getOutputs()).isEmpty() || (target = (EObject)targets.get(0)) == null || !target.equals(targetAttr)) continue;
            hasMapping = true;
            break;
        }
        return hasMapping;
    }

    public static void removeAttributeMapping(Object transMappingRoot, EObject targetAttr, Object txnSource) {
        block10: {
            Mapping mapping = AttributeMappingHelper.getAttributeMapping(transMappingRoot, targetAttr);
            if (mapping != null) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Remove attr mapping", (Object)txnSource);
                boolean succeeded = false;
                try {
                    try {
                        ModelerCore.getModelEditor().delete((EObject)mapping);
                        succeeded = true;
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("AttributeMappingHelper.removeAttrMappingError", (Object)transMappingRoot.toString());
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                        if (!requiredStart) break block10;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block10;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static boolean setAttributeMapping(Object transMappingRoot, EObject targetAttr, Collection sourceAttrs, Object txnSource) {
        boolean changed = false;
        Mapping attrMapping = AttributeMappingHelper.getAttributeMapping(transMappingRoot, targetAttr);
        if (attrMapping != null) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Set attr mapping", (Object)txnSource);
            boolean succeeded = false;
            try {
                EList inputs = attrMapping.getInputs();
                Iterator iter = inputs.iterator();
                while (iter.hasNext()) {
                    Object currInput = iter.next();
                    if (sourceAttrs.contains(currInput)) {
                        sourceAttrs.remove(currInput);
                        continue;
                    }
                    iter.remove();
                    changed = true;
                }
                for (Object attr : sourceAttrs) {
                    if (attr == null) continue;
                    inputs.add(attr);
                    changed = true;
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return changed;
    }

    public static void clearAttributeMappingInputs(Object transMappingRoot, Object txnSource) {
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        if (!attrMappings.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Clear attr mappings", (Object)txnSource);
            boolean succeeded = false;
            try {
                for (Mapping mapping : attrMappings) {
                    EList mappingInputs = mapping.getInputs();
                    Iterator mIter = mappingInputs.iterator();
                    while (mIter.hasNext()) {
                        mIter.next();
                        mIter.remove();
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void cleanAttributeMappings(Object transMappingRoot, Object txnSource) {
        block11: {
            ArrayList attrMappings = new ArrayList(AttributeMappingHelper.getAttributeMappings(transMappingRoot));
            Iterator iter = attrMappings.iterator();
            ArrayList<Mapping> staleMappings = new ArrayList<Mapping>();
            while (iter.hasNext()) {
                Mapping mapping = (Mapping)iter.next();
                EList outputs = mapping.getOutputs();
                if (outputs != null && outputs.size() != 0) continue;
                staleMappings.add(mapping);
            }
            if (!staleMappings.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"check attr mappings", (Object)txnSource);
                boolean succeeded = false;
                try {
                    try {
                        ModelerCore.getModelEditor().delete(staleMappings);
                        succeeded = true;
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("AttributeMappingHelper.cleanAttrMappingError", (Object)transMappingRoot.toString());
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                        if (!requiredStart) break block11;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block11;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static void clearAttributeMappings(Object transMappingRoot, Object txnSource) {
        block10: {
            ArrayList attrMappings = new ArrayList(AttributeMappingHelper.getAttributeMappings(transMappingRoot));
            if (!attrMappings.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Clear attr mappings", (Object)txnSource);
                boolean succeeded = false;
                try {
                    try {
                        ModelerCore.getModelEditor().delete(attrMappings);
                        succeeded = true;
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("AttributeMappingHelper.removeAttrMappingError", (Object)transMappingRoot.toString());
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                        if (!requiredStart) break block10;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block10;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private static List getMappedAttributes(Object transMappingRoot) {
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        ArrayList mappedAttrs = new ArrayList(attrMappings.size());
        for (EObject eObj : attrMappings) {
            EList targets;
            if (!(eObj instanceof Mapping) || (targets = ((Mapping)eObj).getOutputs()).isEmpty()) continue;
            mappedAttrs.add(targets.get(0));
        }
        return mappedAttrs;
    }

    private static boolean attributesFullyMapped(Object transMappingRoot, List targetAttributes) {
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        if (attrMappings.size() != targetAttributes.size()) {
            return false;
        }
        ArrayList localAttrList = new ArrayList(targetAttributes);
        for (EObject eObj : attrMappings) {
            if (!(eObj instanceof Mapping)) continue;
            Mapping mapping = (Mapping)eObj;
            if (mapping.getOutputs() == null || mapping.getOutputs().isEmpty()) {
                return false;
            }
            if (mapping.getInputs() == null || mapping.getInputs().isEmpty()) {
                return false;
            }
            localAttrList.remove(mapping.getOutputs().get(0));
        }
        return localAttrList.isEmpty();
    }

    public static List getAttributeMappings(Object transMappingRoot) {
        List result = Collections.EMPTY_LIST;
        if (transMappingRoot != null && TransformationHelper.isTransformationMappingRoot(transMappingRoot)) {
            result = ((MappingRoot)transMappingRoot).getNested();
        }
        return result;
    }

    private static IExpression getSymbolWithName(List seSymbols, String name) {
        IExpression result = null;
        for (IExpression seSymbol : seSymbols) {
            String symbolName = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
            if (symbolName == null || !symbolName.equalsIgnoreCase(name)) continue;
            result = seSymbol;
            break;
        }
        return result;
    }

    public static String getSymbolShortName(IExpression symbol) {
        String fullName = AttributeMappingHelper.getSymbolFullName(symbol);
        int index = fullName.lastIndexOf(".");
        return fullName.substring(index + 1);
    }

    public static String getSymbolFullName(IExpression symbol) {
        CoreArgCheck.isNotNull((Object)symbol);
        if (symbol instanceof IElementSymbol) {
            Object metadataID = ((IElementSymbol)symbol).getMetadataID();
            if (metadataID instanceof MetadataRecord) {
                MetadataRecord record = (MetadataRecord)metadataID;
                return record.getFullName();
            }
            if (metadataID instanceof IMetadataID) {
                IMetadataID tempID = (IMetadataID)metadataID;
                return tempID.getID();
            }
        }
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        return queryService.getSymbolName(symbol);
    }
}

