/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.NullType;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.type.IDataTypeManagerService;

public class RuntimeTypeConverter {
    private boolean[] compatible;
    private boolean explicitMatch;
    private ArrayList primaryCandidates;
    private String primaryName = "Primary";
    private Object primaryObj;
    private List primaryResults;
    private int primarySize;
    private ArrayList secondaryCandidates;
    private String secondaryName = "Secondary";
    private Object secondaryObj;
    private List secondaryResults;
    private int secondarySize;
    private int size;

    private RuntimeTypeConverter(List thePrimaryCandidates, List theSecondaryCandidates) {
        this(thePrimaryCandidates, false, theSecondaryCandidates, false);
    }

    private RuntimeTypeConverter(List thePrimaryCandidates, boolean thePrimaryCandidatesLockedFlag, List theSecondaryCandidates, boolean theSecondaryCandidatesLockedFlag) {
        if (thePrimaryCandidates == null || theSecondaryCandidates == null) {
            throw new IllegalArgumentException("RuntimeTypeConverter.init:Primary or secondary candidate list is null.");
        }
        this.primarySize = thePrimaryCandidates.size();
        this.secondarySize = theSecondaryCandidates.size();
        this.size = Math.max(this.primarySize, this.secondarySize);
        this.primaryCandidates = new ArrayList(this.primarySize);
        this.primaryCandidates.addAll(thePrimaryCandidates);
        this.primaryResults = (List)this.primaryCandidates.clone();
        this.secondaryCandidates = new ArrayList(this.secondarySize);
        this.secondaryCandidates.addAll(theSecondaryCandidates);
        this.secondaryResults = (List)this.secondaryCandidates.clone();
        this.compatible = new boolean[this.size];
        this.explicitMatch = false;
        this.setCompatibility();
        this.setExplicitMatch();
    }

    private Object getCandidateResultAt(int theIndex, boolean thePrimaryFlag) {
        this.validateIndex(theIndex, thePrimaryFlag ? this.primarySize : this.secondarySize, "getCandidateResultAt(int, boolean");
        List candidates = thePrimaryFlag ? this.primaryResults : this.secondaryResults;
        return candidates.get(theIndex);
    }

    private String getName(boolean thePrimaryFlag) {
        Object obj;
        String result = thePrimaryFlag ? this.primaryName : this.secondaryName;
        Object object = obj = thePrimaryFlag ? this.primaryObj : this.secondaryObj;
        if (obj != null && obj instanceof EObject && TransformationHelper.isSqlColumn(obj)) {
            EObject eObj = (EObject)obj;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObj);
            result = columnAspect.getFullName(eObj);
        }
        return result;
    }

    private String getPrimaryName() {
        return this.getName(true);
    }

    private Object getPrimaryResultAt(int theIndex) {
        return this.getCandidateResultAt(theIndex, true);
    }

    public static String getRuntimeType(Object theObj) {
        String type = null;
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        if (theObj instanceof EObject) {
            EObject eObj = (EObject)theObj;
            DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObj, (boolean)true);
            if (TransformationHelper.isSqlColumn(theObj)) {
                SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObj);
                type = columnAspect.getRuntimeType(eObj);
            } else if (dtMgr.isSimpleDatatype((EObject)theObj)) {
                return dtMgr.getRuntimeTypeName(eObj);
            }
        } else if (theObj instanceof IExpression) {
            Class objClass = ((IExpression)theObj).getType();
            type = objClass == null ? service.getDataTypeName(NullType.class) : service.getDataTypeName(objClass);
        } else {
            throw new IllegalArgumentException("RuntimeTypeConverter.getRuntimeType:Object type cannot be determined for <" + theObj + ">.");
        }
        return type;
    }

    private String getSecondaryName() {
        return this.getName(false);
    }

    private Object getSecondaryResultAt(int theIndex) {
        return this.getCandidateResultAt(theIndex, false);
    }

    private boolean isCompatible(String theFirstType, String theSecondType) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        return theFirstType.equals(theSecondType) || service.isTransformable(theFirstType, theSecondType);
    }

    public static boolean isExplicitMatch(Object primaryObj, Object secondaryObj) {
        boolean isExplicitMatch = false;
        if (primaryObj != null && secondaryObj != null) {
            ArrayList<Object> primaryList = new ArrayList<Object>(1);
            ArrayList<Object> secondaryList = new ArrayList<Object>(1);
            primaryList.add(primaryObj);
            secondaryList.add(secondaryObj);
            RuntimeTypeConverter rtc = new RuntimeTypeConverter(primaryList, true, secondaryList, true);
            isExplicitMatch = rtc.isExplicitMatch();
        }
        return isExplicitMatch;
    }

    private boolean isExplicitMatch() {
        return this.explicitMatch;
    }

    private boolean isExplicitMatch(int theIndex) {
        this.validateIndex(theIndex, this.size, "isExplicitMatch(int)");
        boolean result = false;
        if (theIndex < this.primarySize && theIndex < this.secondarySize) {
            Object primaryCandidate = this.primaryCandidates.get(theIndex);
            String primaryType = RuntimeTypeConverter.getRuntimeType(primaryCandidate);
            Object secondaryCandidate = this.secondaryCandidates.get(theIndex);
            String secondaryType = RuntimeTypeConverter.getRuntimeType(secondaryCandidate);
            result = primaryType.equals(secondaryType);
        }
        return result;
    }

    private void setCompatibility() {
        int i = 0;
        while (i < this.size) {
            this.setCompatibility(i);
            ++i;
        }
    }

    private void setCompatibility(int theIndex) {
        this.validateIndex(theIndex, this.size, "setCompatibility(int)");
        boolean result = false;
        if (theIndex < this.primarySize && theIndex < this.secondarySize) {
            Object secondary;
            String secondaryType;
            Object primary = this.getPrimaryResultAt(theIndex);
            String primaryType = RuntimeTypeConverter.getRuntimeType(primary);
            result = this.isCompatible(primaryType, secondaryType = RuntimeTypeConverter.getRuntimeType(secondary = this.getSecondaryResultAt(theIndex))) || this.isCompatible(secondaryType, primaryType);
        }
        this.compatible[theIndex] = result;
    }

    private void setExplicitMatch() {
        boolean match = true;
        int i = 0;
        while (i < this.size) {
            if (!this.isExplicitMatch(i)) {
                match = false;
                break;
            }
            ++i;
        }
        this.explicitMatch = match;
    }

    public String toString() {
        return String.valueOf(this.getPrimaryName()) + "<->" + this.getSecondaryName();
    }

    private void validateIndex(int theIndex, int theSize, String theMethod) {
        if (theSize <= theIndex) {
            throw new IllegalArgumentException(new StringBuffer().append(this.getClass().getName()).append(".").append(theMethod).append(":Index <").append(theIndex).append("> is invalid for size of <").append(theSize).append(">.").toString());
        }
    }
}

