/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.validation.TransformationValidator;

public class SqlConverter {
    public static final char DELIMITER_CHAR = '.';

    public static String convertToString(String sqlString, EObject transMappingRoot, int cmdType) {
        return SqlConverter.convertToString(sqlString, transMappingRoot, cmdType, false, null);
    }

    public static String convertToString(String sqlString, EObject transMappingRoot, int cmdType, boolean restrictSearch) {
        return SqlConverter.convertSql(sqlString, transMappingRoot, cmdType, restrictSearch, null);
    }

    public static String convertToString(String sqlString, EObject transMappingRoot, int cmdType, boolean restrictSearch, ValidationContext context) {
        return SqlConverter.convertSql(sqlString, transMappingRoot, cmdType, restrictSearch, context);
    }

    private static synchronized String convertSql(String sqlString, EObject transMappingRoot, int cmdType, boolean restrictSearch, ValidationContext context) {
        if (CoreStringUtil.isEmpty((String)sqlString)) {
            return null;
        }
        CoreArgCheck.isInstanceOf(SqlTransformationMappingRoot.class, (Object)transMappingRoot);
        SqlTransformationMappingRoot sqlTransMappingRoot = (SqlTransformationMappingRoot)transMappingRoot;
        TransformationValidator validator = new TransformationValidator(sqlTransMappingRoot, context, false, restrictSearch);
        QueryValidationResult validationResult = validator.validateSql(sqlString, cmdType, false);
        if (!validationResult.isValidatable()) {
            return null;
        }
        return sqlString;
    }
}

