/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.ModelResourceCollectorVisitor;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerVersionListener;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.util.SqlTransformationStatusChangeEvent;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;

public class SqlMappingRootCache
implements ISQLConstants {
    private static HashMap selectSqlCache = new HashMap();
    private static HashMap insertSqlCache = new HashMap();
    private static HashMap updateSqlCache = new HashMap();
    private static HashMap deleteSqlCache = new HashMap();
    private static List eventListeners;
    private static final SqlMappingRootCache INSTANCE;
    private static ITeiidServerVersionListener teiidServerVersionListener;

    static {
        INSTANCE = new SqlMappingRootCache();
        teiidServerVersionListener = new ITeiidServerVersionListener(){

            public void serverChanged(ITeiidServer server) {
            }

            public void versionChanged(ITeiidServerVersion version) {
                SqlMappingRootCache.invalidateCache();
            }
        };
        ModelerCore.addTeiidServerVersionListener((ITeiidServerVersionListener)teiidServerVersionListener);
    }

    public static SqlMappingRootCache getInstance() {
        return INSTANCE;
    }

    public static void invalidateCache() {
        SqlMappingRootCache.getCache(0).clear();
        SqlMappingRootCache.getCache(1).clear();
        SqlMappingRootCache.getCache(2).clear();
        SqlMappingRootCache.getCache(3).clear();
    }

    public static void invalidateSelectStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, notifyListeners, source, false);
    }

    public static void invalidateSelectStatus(Object transMappingRoot, boolean notifyListeners, Object source, boolean overwriteDirty) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 0, notifyListeners, source, overwriteDirty);
    }

    public static void invalidateInsertStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 1, notifyListeners, source, false);
    }

    public static void invalidateUpdateStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 2, notifyListeners, source, false);
    }

    public static void invalidateDeleteStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 3, notifyListeners, source, false);
    }

    public static void invalidateStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 0, notifyListeners, source, false);
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 2, notifyListeners, source, false);
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 1, notifyListeners, source, false);
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 3, notifyListeners, source, false);
    }

    public static void invalidateRootsWithSourceGroups(Set sourceGroups) {
        HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
        for (EObject selectRoot : currentSelectSqlCache.keySet()) {
            boolean invalidateRoot = false;
            for (Object sourceGroup : sourceGroups) {
                SqlTransformationResult deleteStatus;
                SqlTransformationResult updateStatus;
                SqlTransformationResult insertStatus;
                if (TransformationHelper.isSqlProcedureResultSet(sourceGroup)) {
                    sourceGroup = TransformationHelper.getSqlProcedureForResultSet(sourceGroup);
                }
                if (!SqlMappingRootCache.containsStatus(selectRoot, 0)) continue;
                SqlTransformationResult selectStatus = SqlMappingRootCache.getStatus(selectRoot, 0, false);
                if (selectStatus != null && selectStatus.hasSourceGroup(sourceGroup)) {
                    invalidateRoot = true;
                    break;
                }
                if (SqlMappingRootCache.containsStatus(selectRoot, 1) && (insertStatus = SqlMappingRootCache.getStatus(selectRoot, 1, false)) != null && insertStatus.hasSourceGroup(sourceGroup)) {
                    invalidateRoot = true;
                    break;
                }
                if (SqlMappingRootCache.containsStatus(selectRoot, 2) && (updateStatus = SqlMappingRootCache.getStatus(selectRoot, 2, false)) != null && updateStatus.hasSourceGroup(sourceGroup)) {
                    invalidateRoot = true;
                    break;
                }
                if (!SqlMappingRootCache.containsStatus(selectRoot, 3) || (deleteStatus = SqlMappingRootCache.getStatus(selectRoot, 3, false)) == null || !deleteStatus.hasSourceGroup(sourceGroup)) continue;
                invalidateRoot = true;
                break;
            }
            if (!invalidateRoot) continue;
            SqlMappingRootCache.invalidateSelectStatus(selectRoot, true, null);
        }
    }

    public static void invalidateRootsWithTargetGroups(Set groups) {
        HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
        for (EObject mappingRoot : currentSelectSqlCache.keySet()) {
            if (!SqlMappingRootCache.containsStatus(mappingRoot, 0)) continue;
            EObject targetGrp = TransformationHelper.getTransformationLinkTarget(mappingRoot);
            if (groups == null || !groups.contains(targetGrp)) continue;
            SqlMappingRootCache.invalidateSelectStatus(mappingRoot, true, null);
        }
    }

    public static void invalidateCacheForProject(IProject proj) {
        if (proj != null && proj.isOpen()) {
            ArrayList modelResources = new ArrayList();
            ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
            try {
                proj.getProject().accept((IResourceVisitor)visitor);
                modelResources.addAll(visitor.getModelResources());
            }
            catch (CoreException coreException) {
                return;
            }
            HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
            for (EObject mappingRoot : currentSelectSqlCache.keySet()) {
                ModelResource mdlRsrc = ModelerCore.getModelEditor().findModelResource(mappingRoot);
                if (mdlRsrc == null || !mdlRsrc.exists() || !modelResources.contains(mdlRsrc)) continue;
                SqlMappingRootCache.invalidateSelectStatus(mappingRoot, true, null);
            }
        }
    }

    public static void invalidateRootsOnProjectOrModelRemove() {
        HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
        for (EObject selectRoot : currentSelectSqlCache.keySet()) {
            EObject realEObj = null;
            if (selectRoot != null && selectRoot.eResource() != null) {
                realEObj = selectRoot;
            }
            ModelResource mdlRsrc = null;
            boolean invalidateRoot = false;
            if (realEObj == null) {
                invalidateRoot = true;
            } else {
                mdlRsrc = ModelerCore.getModelEditor().findModelResource(selectRoot);
                if (mdlRsrc == null || !mdlRsrc.exists()) {
                    invalidateRoot = true;
                } else if (SqlMappingRootCache.containsStatus(selectRoot, 0)) {
                    SqlTransformationResult selectStatus = SqlMappingRootCache.getStatus(selectRoot, 0, false);
                    if (selectStatus != null && (SqlMappingRootCache.areAnySourceGroupsProxies(selectStatus) || !selectStatus.areSrcGroupMdlResourcesValid())) {
                        invalidateRoot = true;
                    } else {
                        SqlTransformationResult deleteStatus;
                        SqlTransformationResult updateStatus;
                        SqlTransformationResult insertStatus;
                        if (SqlMappingRootCache.containsStatus(selectRoot, 1) && (insertStatus = SqlMappingRootCache.getStatus(selectRoot, 1, false)) != null && !insertStatus.areSrcGroupMdlResourcesValid()) {
                            invalidateRoot = true;
                        }
                        if (!invalidateRoot && SqlMappingRootCache.containsStatus(selectRoot, 2) && (updateStatus = SqlMappingRootCache.getStatus(selectRoot, 2, false)) != null && !updateStatus.areSrcGroupMdlResourcesValid()) {
                            invalidateRoot = true;
                        }
                        if (!invalidateRoot && SqlMappingRootCache.containsStatus(selectRoot, 3) && (deleteStatus = SqlMappingRootCache.getStatus(selectRoot, 3, false)) != null && !deleteStatus.areSrcGroupMdlResourcesValid()) {
                            invalidateRoot = true;
                        }
                    }
                }
            }
            if (!invalidateRoot) continue;
            SqlMappingRootCache.invalidateSelectStatus(selectRoot, true, null);
        }
    }

    private static boolean areAnySourceGroupsProxies(SqlTransformationResult status) {
        Object[] srcGroups = null;
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"SqlMappingRootCache_ProxyCheck", (Object)status);
        boolean succeeded = false;
        try {
            srcGroups = status.getSourceGroups().toArray();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        int i = 0;
        while (i < srcGroups.length) {
            EObject eoj = (EObject)srcGroups[i];
            if (eoj.eIsProxy()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSelectParsable(Object transMappingRoot) {
        return SqlMappingRootCache.isParsable(transMappingRoot, 0);
    }

    public static boolean isSelectResolvable(Object transMappingRoot) {
        return SqlMappingRootCache.isResolvable(transMappingRoot, 0);
    }

    public static boolean isSelectValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 0);
    }

    public static boolean isInsertValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 1);
    }

    public static boolean isUpdateValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 2);
    }

    public static boolean isDeleteValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 3);
    }

    public static ICommand getSelectCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 0);
    }

    public static ICommand getInsertCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 1);
    }

    public static ICommand getUpdateCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 2);
    }

    public static ICommand getDeleteCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 3);
    }

    public static String getSelectSql(EObject transMappingRoot) {
        return SqlMappingRootCache.getSqlString(transMappingRoot, 0);
    }

    public static boolean isSqlDifferent(Object transMappingRoot, int cmdType, String userSql) {
        boolean isDifferent = true;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && SqlMappingRootCache.containsStatus((EObject)transMappingRoot, cmdType)) {
            HashMap cache = SqlMappingRootCache.getCache(cmdType);
            SqlTransformationResult status = (SqlTransformationResult)cache.get(transMappingRoot);
            String cachedSql = status.getSqlString();
            isDifferent = TransformationHelper.stringsDifferent(userSql, cachedSql);
        }
        return isDifferent;
    }

    private static synchronized void invalidateStatus(Object transMappingRoot, int cmdType, boolean notifyListeners, Object source, boolean overwriteDirty) {
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            if (SqlMappingRootCache.containsStatus((EObject)transMappingRoot, cmdType)) {
                SqlMappingRootCache.removeStatus((EObject)transMappingRoot, cmdType);
                if (cmdType == 0) {
                    SqlMappingRootCache.removeStatus((EObject)transMappingRoot, 1);
                    SqlMappingRootCache.removeStatus((EObject)transMappingRoot, 2);
                    SqlMappingRootCache.removeStatus((EObject)transMappingRoot, 3);
                }
                if (source == null) {
                    source = SqlMappingRootCache.getInstance();
                }
            }
            if (notifyListeners) {
                SqlMappingRootCache.notifyEventListeners(new SqlTransformationStatusChangeEvent((EObject)transMappingRoot, source, overwriteDirty));
            }
        }
    }

    public static boolean isParsable(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isParsable = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            isParsable = status.isParsable();
        }
        return isParsable;
    }

    public static boolean isResolvable(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isResolvable = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            isResolvable = status.isResolvable();
        }
        return isResolvable;
    }

    public static boolean isValid(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isValid = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            isValid = status.isValidatable();
        }
        return isValid;
    }

    public static boolean hasSourceGroup(Object transMappingRoot, Object sourceGroup, int cmdType) {
        Collection sourceGroups;
        SqlTransformationResult status;
        boolean hasSourceGroup = false;
        if (transMappingRoot != null && sourceGroup != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && TransformationHelper.isSqlTable(sourceGroup) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null && (sourceGroups = status.getSourceGroups()).contains(sourceGroup)) {
            hasSourceGroup = true;
        }
        return hasSourceGroup;
    }

    public static boolean isTargetValid(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isTargetValid = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            isTargetValid = status.isTargetValid();
        }
        return isTargetValid;
    }

    public static IStatus getTargetValidStatus(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        IStatus targetValidStatus = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            targetValidStatus = status.getTargetValidStatus();
        }
        return targetValidStatus;
    }

    public static SqlTransformationResult getSqlTransformationStatus(SqlTransformationMappingRoot transMappingRoot, int cmdType, boolean restrictSearch, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)transMappingRoot);
        return SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, restrictSearch, context);
    }

    public static ICommand getCommand(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        ICommand command = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            command = status.getCommand();
        }
        return command;
    }

    public static String getSqlString(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        String sqlString = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, false)) != null) {
            sqlString = status.getSqlString();
        }
        return sqlString;
    }

    public static boolean containsStatus(EObject transMappingRoot, int cmdType) {
        HashMap cache = SqlMappingRootCache.getCache(cmdType);
        return cache.containsKey(transMappingRoot);
    }

    private static void removeStatus(EObject transMappingRoot, int cmdType) {
        HashMap cache = SqlMappingRootCache.getCache(cmdType);
        cache.remove(transMappingRoot);
    }

    private static SqlTransformationResult createStatus(EObject transMappingRoot, int cmdType, boolean restrictSearch, ValidationContext context) {
        SqlTransformationResult status = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            String userSql = null;
            TransformationValidator validator = context != null ? new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, context, true, restrictSearch) : new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, true, restrictSearch);
            try {
                userSql = SqlMappingRootCache.getSqlUserString(transMappingRoot, cmdType);
                if (userSql != null) {
                    status = (SqlTransformationResult)validator.validateSql(userSql, cmdType, false);
                }
            }
            catch (Exception e) {
                String message = TransformationPlugin.Util.getString("SqlMappingRootCache.validationError");
                TransformationPlugin.Util.log(4, (Throwable)e, message);
                Status fatalErrorStatus = new Status(4, "org.teiid.designer.transformation", 0, message, (Throwable)e);
                status = new SqlTransformationResult(null, (IStatus)fatalErrorStatus);
                status.setParsable(false);
                status.setResolvable(false);
                status.setValidatable(false);
                status.setSqlString(SqlMappingRootCache.getSqlUserString(transMappingRoot, cmdType));
            }
        }
        return status;
    }

    public static void setStatus(EObject transMappingRoot, int cmdType, SqlTransformationResult status) {
        HashMap cache = SqlMappingRootCache.getCache(cmdType);
        if (status != null) {
            cache.put(transMappingRoot, status);
            SqlMappingRootCache.notifyEventListeners(new SqlTransformationStatusChangeEvent(transMappingRoot, new Object(), false));
        } else {
            SqlMappingRootCache.removeStatus(transMappingRoot, cmdType);
        }
    }

    private static synchronized SqlTransformationResult getStatus(EObject transMappingRoot, int cmdType, boolean restrictSearch) {
        return SqlMappingRootCache.getStatus(transMappingRoot, cmdType, restrictSearch, null);
    }

    private static synchronized SqlTransformationResult getStatus(EObject transMappingRoot, int cmdType, boolean restrictSearch, ValidationContext context) {
        HashMap cache;
        SqlTransformationResult status;
        SqlTransformationResult statusResult = null;
        if (SqlMappingRootCache.containsStatus(transMappingRoot, cmdType) && (status = (SqlTransformationResult)(cache = SqlMappingRootCache.getCache(cmdType)).get(transMappingRoot)) != null) {
            statusResult = status;
        }
        if (statusResult == null) {
            statusResult = SqlMappingRootCache.createStatus(transMappingRoot, cmdType, restrictSearch, context);
            if (context == null || context.cacheMappingRootResults()) {
                SqlMappingRootCache.setStatus(transMappingRoot, cmdType, statusResult);
            }
        }
        return statusResult;
    }

    private static HashMap getCache(int cmdType) {
        switch (cmdType) {
            case 0: {
                return selectSqlCache;
            }
            case 1: {
                return insertSqlCache;
            }
            case 2: {
                return updateSqlCache;
            }
            case 3: {
                return deleteSqlCache;
            }
        }
        return null;
    }

    private static String getSqlUserString(Object transMappingRoot, int cmdType) {
        switch (cmdType) {
            case 0: {
                return SqlMappingRootCache.getSelectSqlUserString(transMappingRoot);
            }
            case 1: {
                return SqlMappingRootCache.getInsertSqlUserString(transMappingRoot);
            }
            case 2: {
                return SqlMappingRootCache.getUpdateSqlUserString(transMappingRoot);
            }
            case 3: {
                return SqlMappingRootCache.getDeleteSqlUserString(transMappingRoot);
            }
        }
        return SqlMappingRootCache.getSelectSqlUserString(transMappingRoot);
    }

    private static String getSelectSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getSelectSql();
        }
        return result;
    }

    private static String getInsertSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getInsertSql();
        }
        return result;
    }

    private static String getUpdateSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getUpdateSql();
        }
        return result;
    }

    private static String getDeleteSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getDeleteSql();
        }
        return result;
    }

    public static void addEventListener(EventObjectListener listener) {
        if (eventListeners == null) {
            eventListeners = new ArrayList();
        }
        if (!eventListeners.contains(listener)) {
            eventListeners.add(listener);
        }
    }

    public static void removeEventListener(EventObjectListener listener) {
        if (eventListeners != null) {
            eventListeners.remove(listener);
        }
    }

    private static void notifyEventListeners(EventObject event) {
        if (eventListeners != null) {
            for (EventObjectListener listener : eventListeners) {
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }
}

