/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IMetadataID;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.IFunctionCollectorVisitor;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.metadata.TransformationMetadataFactory;
import org.teiid.designer.transformation.util.AttributeMappingHelper;
import org.teiid.designer.transformation.util.RuntimeTypeConverter;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.udf.IFunctionDescriptor;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;

public class TransformationMappingHelper
implements ISQLConstants {
    private static final TransformationMappingHelper INSTANCE = new TransformationMappingHelper();
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;
    public static final int TRANSFORMATION_CHANGED = 10;
    public static final int TRANSFORMATION_UNCHANGED = 20;
    private static final IStatus TRANSFORMATION_OK_CHANGED = new Status(0, "org.teiid.designer.transformation", 10, "internal: transformation parsed successfully, changes were applied", null);
    private static final IStatus TRANSFORMATION_OK_UNCHANGED = new Status(0, "org.teiid.designer.transformation", 20, "internal: transformation parsed successfully, no changes applied", null);
    private static final IStatus TRANSFORMATION_ISSUE = new Status(2, "org.teiid.designer.transformation", 20, "internal: transformation has warnings, no changes applied", null);
    private static boolean createTargetAttributes = true;

    public static TransformationMappingHelper getInstance() {
        return INSTANCE;
    }

    public static void reconcileMappingsOnSqlChange(EObject transMappingRoot, Object source) {
        if (TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            boolean isValid;
            if (source == null) {
                source = TransformationMappingHelper.getInstance();
            }
            if ((isValid = SqlMappingRootCache.isSelectValid(transMappingRoot)) || TransformationHelper.isEmptySelect(transMappingRoot)) {
                boolean isLocked = TransformationHelper.isTargetGroupLocked(transMappingRoot);
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update Atribute Mappings", (Object)source);
                boolean succeeded = false;
                try {
                    TransformationMappingHelper.reconcileSources(transMappingRoot, source);
                    if (!isLocked && TransformationMappingHelper.shouldCreateTargetAttributes()) {
                        TransformationMappingHelper.reconcileTargetAttributes(transMappingRoot, source);
                    }
                    AttributeMappingHelper.updateAttributeMappings(transMappingRoot, source);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                if (requiredStart) {
                    SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, true, source);
                }
            }
        }
    }

    public static boolean[] compareQueryTargetAndSQLOutput(EObject transMappingRoot, int type) {
        EObject targetGroup;
        boolean sizesMatch = false;
        boolean namesMatch = false;
        boolean typesMatch = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot)) != null) {
            List attributes = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
            ICommand command = TransformationHelper.getCommand(transMappingRoot, type);
            List<String> sqlNames = TransformationSqlHelper.getProjectedSymbolNames(command);
            if (sqlNames.size() == 0 && !(targetGroup instanceof Procedure) && type == 0) {
                sizesMatch = false;
            } else if (sqlNames.size() == attributes.size()) {
                sizesMatch = true;
            }
            if (sizesMatch) {
                List attributeNames = TransformationMappingHelper.getAttributeNames(attributes);
                namesMatch = TransformationMappingHelper.allStringsMatch(sqlNames, attributeNames);
                if (TransformationHelper.isValid(transMappingRoot, type)) {
                    List sqlSyms = CommandHelper.getProjectedSymbols((ICommand)command);
                    typesMatch = TransformationMappingHelper.allTypesMatch(sqlSyms, attributes);
                }
            }
        }
        boolean[] result = new boolean[]{sizesMatch, namesMatch, typesMatch};
        return result;
    }

    public static boolean targetAndCommandReconcile(EObject transMappingRoot, ICommand command, boolean nameMatchReqd) {
        EObject targetGroup;
        boolean sizesMatch = false;
        boolean namesMatch = false;
        boolean typesMatch = false;
        boolean areReconciled = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot)) != null) {
            List attributes = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
            List<String> sqlNames = TransformationSqlHelper.getProjectedSymbolNames(command);
            if (sqlNames.size() == attributes.size()) {
                sizesMatch = true;
            }
            if (sizesMatch) {
                List attributeNames = TransformationMappingHelper.getTargetAttributeNames(transMappingRoot);
                namesMatch = TransformationMappingHelper.allStringsMatch(sqlNames, attributeNames);
                if (TransformationMappingHelper.commandValid(transMappingRoot, command)) {
                    List sqlSyms = CommandHelper.getProjectedSymbols((ICommand)command);
                    typesMatch = TransformationMappingHelper.allTypesMatch(sqlSyms, attributes);
                }
            }
        }
        if (nameMatchReqd && sizesMatch && namesMatch && typesMatch) {
            areReconciled = true;
        } else if (!nameMatchReqd && sizesMatch && typesMatch) {
            areReconciled = true;
        }
        return areReconciled;
    }

    public static boolean typesMatch(IExpression seSymbol, EObject attribute) {
        boolean typesMatch = false;
        if (seSymbol != null && attribute != null) {
            Class symType = seSymbol.getType();
            IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
            if (symType != null && (symType == service.getDefaultDataClass(IDataTypeManagerService.DataTypeName.NULL) || RuntimeTypeConverter.isExplicitMatch(seSymbol, attribute))) {
                typesMatch = true;
            }
        }
        return typesMatch;
    }

    private static boolean allTypesMatch(List symbolList, List attributeList) {
        if (symbolList != null && attributeList != null && symbolList.size() == attributeList.size()) {
            int i = 0;
            while (i < symbolList.size()) {
                EObject attr;
                IExpression seSymbol = (IExpression)symbolList.get(i);
                if (!TransformationMappingHelper.typesMatch(seSymbol, attr = (EObject)attributeList.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean allStringsMatch(List list1, List list2) {
        if (list1 != null && list2 != null && list1.size() == list2.size()) {
            int i = 0;
            while (i < list1.size()) {
                String str2;
                String str1 = (String)list1.get(i);
                if (!str1.equalsIgnoreCase(str2 = (String)list2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean commandValid(EObject transMappingRoot, ICommand command) {
        boolean isCommandValid = false;
        if (!command.isResolved()) {
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot);
            QueryValidationResult result = validator.validateSql(command.toString(), 0, false);
            if (result.isValidatable()) {
                isCommandValid = true;
            }
        } else {
            isCommandValid = true;
        }
        return isCommandValid;
    }

    public static boolean reconcileSources(EObject transMappingRoot, Object source) {
        boolean isValid;
        boolean success = false;
        if (source == null) {
            source = TransformationMappingHelper.getInstance();
        }
        if ((isValid = SqlMappingRootCache.isSelectValid(transMappingRoot)) && !TransformationMappingHelper.isReadOnly(transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Sources", (Object)source);
            boolean succeeded = false;
            try {
                TransformationHelper.reconcileInputsAndAliases(transMappingRoot);
                ArrayList<ICommand> allCommands = new ArrayList<ICommand>();
                ICommand selectCommand = SqlMappingRootCache.getSelectCommand(transMappingRoot);
                allCommands.add(selectCommand);
                EObject target = TransformationHelper.getTransformationTarget(transMappingRoot);
                if (TransformationHelper.tableSupportsUpdate(target)) {
                    if (TransformationHelper.isInsertAllowed(transMappingRoot) && SqlMappingRootCache.isInsertValid(transMappingRoot)) {
                        allCommands.add(SqlMappingRootCache.getInsertCommand(transMappingRoot));
                    }
                    if (TransformationHelper.isUpdateAllowed(transMappingRoot) && SqlMappingRootCache.isUpdateValid(transMappingRoot)) {
                        allCommands.add(SqlMappingRootCache.getUpdateCommand(transMappingRoot));
                    }
                    if (TransformationHelper.isDeleteAllowed(transMappingRoot) && SqlMappingRootCache.isDeleteValid(transMappingRoot)) {
                        allCommands.add(SqlMappingRootCache.getDeleteCommand(transMappingRoot));
                    }
                }
                IQueryMetadataInterface metadata = TransformationMetadataFactory.getInstance().getModelerMetadata(transMappingRoot, false);
                ArrayList<EObjectAlias> symbolsToAdd = new ArrayList<EObjectAlias>();
                ArrayList<EObjectAlias> symbolsIncluded = new ArrayList<EObjectAlias>();
                for (ICommand command : allCommands) {
                    TransformationMappingHelper.getEObjectAliases(transMappingRoot, command, symbolsToAdd, symbolsIncluded, metadata);
                }
                LinkedList allAliases = new LinkedList(TransformationHelper.getAllSqlAliases(transMappingRoot));
                for (SqlAlias sqlAlias : allAliases) {
                    if (TransformationMappingHelper.sqlAliasInGroupSymbolList(sqlAlias, symbolsIncluded)) continue;
                    EObject sqlEObj = sqlAlias.getAliasedObject();
                    String sqlAliasName = sqlAlias.getAlias();
                    TransformationHelper.removeSourceAlias(transMappingRoot, sqlEObj, sqlAliasName, true, source);
                }
                for (EObjectAlias eObjectAlias : symbolsToAdd) {
                    TransformationHelper.addSqlAlias(transMappingRoot, eObjectAlias.object, eObjectAlias.name, true, source);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        if (TransformationHelper.isEmptySelect(transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Sources", (Object)source);
            boolean succeeded = false;
            try {
                TransformationHelper.removeAllSourcesAndAliases(transMappingRoot, true, source);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return success;
    }

    private static void getEObjectAliases(EObject transMappingRoot, ICommand command, List<EObjectAlias> toAdd, List<EObjectAlias> included, IQueryMetadataInterface metadata) {
        Collection<IGroupSymbol> sqlGroupSymbols = TransformationSqlHelper.getGroupSymbols(command);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        IFunctionCollectorVisitor functionCollectorVisitor = queryService.getFunctionCollectorVisitor(true);
        Collection functions = functionCollectorVisitor.findFunctions((ILanguageObject)command, true);
        List mappingAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
        ArrayList<EObjectAlias> allAliases = new ArrayList<EObjectAlias>();
        for (IFunction function : functions) {
            IExpression[] args;
            IFunctionDescriptor fd = function.getFunctionDescriptor();
            if (fd == null) continue;
            IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
            if (!fd.getName().equalsIgnoreCase(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.LOOKUP)) || !((args = function.getArgs())[0] instanceof IConstant)) continue;
            String groupName = (String)((IConstant)args[0]).getValue();
            try {
                Object metadataID = metadata.getGroupID(groupName);
                IGroupSymbol symbol = factory.createGroupSymbol(groupName);
                symbol.setMetadataID(metadataID);
                if (TransformationSqlHelper.containsGroupSymbol(sqlGroupSymbols, symbol)) continue;
                sqlGroupSymbols.add(symbol);
            }
            catch (Exception e) {
                String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)groupName);
                TransformationPlugin.Util.log(2, (Throwable)e, message);
            }
        }
        for (IGroupSymbol gSymbol : sqlGroupSymbols) {
            if (gSymbol.getMetadataID() instanceof IMetadataID && !gSymbol.isProcedure()) continue;
            EObject groupEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
            String groupName = TransformationSqlHelper.getGroupSymbolShortName(gSymbol);
            if (groupEObj == null || groupName == null) continue;
            allAliases.add(new EObjectAlias(groupEObj, groupName));
        }
        for (EObjectAlias eObjectAlias : allAliases) {
            if (!TransformationMappingHelper.inAliasList(eObjectAlias, mappingAliases)) {
                toAdd.add(eObjectAlias);
                continue;
            }
            included.add(eObjectAlias);
        }
    }

    private static boolean inAliasList(EObjectAlias alias, List sqlAliases) {
        boolean inSqlList = false;
        for (SqlAlias sqlAlias : sqlAliases) {
            EObject aEObj = sqlAlias.getAliasedObject();
            String aName = sqlAlias.getAlias();
            if (aEObj == null || aName == null || !aEObj.equals(alias.object) || !aName.equalsIgnoreCase(alias.name)) continue;
            inSqlList = true;
            break;
        }
        return inSqlList;
    }

    private static boolean sqlAliasInGroupSymbolList(SqlAlias sqlAlias, Collection<EObjectAlias> objects) {
        boolean inGroupSymbolList = false;
        EObject aliasEObj = sqlAlias.getAliasedObject();
        String aliasName = sqlAlias.getAlias();
        for (EObjectAlias eObjectAlias : objects) {
            if (!eObjectAlias.object.equals(aliasEObj) || !eObjectAlias.name.equalsIgnoreCase(aliasName)) continue;
            inGroupSymbolList = true;
            break;
        }
        return inGroupSymbolList;
    }

    public static IStatus reconcileTargetAttributes(EObject transMappingRoot, boolean reconcileMappingClassTarget, Object txnSource) {
        boolean success = false;
        boolean changed = false;
        if (!TransformationHelper.isTargetGroupLocked(transMappingRoot)) {
            EObject targetGroup;
            if (txnSource == null) {
                txnSource = TransformationMappingHelper.getInstance();
            }
            if ((targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot)) instanceof MappingClass && !(targetGroup instanceof StagingTable) && !reconcileMappingClassTarget) {
                return TRANSFORMATION_ISSUE;
            }
            boolean hasXMLDocSource = false;
            List sources = TransformationHelper.getTransformationSources(transMappingRoot);
            if (sources.size() == 1 && sources.get(0) instanceof XmlDocument) {
                hasXMLDocSource = true;
            }
            boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
            ICommand validCommand = null;
            if (isValid) {
                validCommand = SqlMappingRootCache.getSelectCommand(transMappingRoot);
            }
            if (targetGroup != null && validCommand != null) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Reconcile Target Attributes", (Object)txnSource);
                boolean succeeded = false;
                try {
                    Map symbolTypeMap;
                    List currentTargetAttrNames = TransformationMappingHelper.getTargetAttributeNames(transMappingRoot);
                    List<String> projectedSymbolNames = TransformationSqlHelper.getProjectedSymbolUniqueNames(validCommand);
                    int nCurrentTargetAttrs = currentTargetAttrNames.size();
                    int nProjectedSymbols = projectedSymbolNames.size();
                    if (nProjectedSymbols < nCurrentTargetAttrs) {
                        TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                        IStatus iStatus = TRANSFORMATION_ISSUE;
                        return iStatus;
                    }
                    boolean namesMatch = TransformationMappingHelper.compareLists(currentTargetAttrNames, projectedSymbolNames, true);
                    if (!namesMatch) {
                        List matchedNames = TransformationMappingHelper.getMatchedNames(currentTargetAttrNames, projectedSymbolNames);
                        List unmatchedVirtualNames = TransformationMappingHelper.removeNames(currentTargetAttrNames, matchedNames);
                        if (unmatchedVirtualNames.size() != 0) {
                            TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                            IStatus iStatus = TRANSFORMATION_ISSUE;
                            return iStatus;
                        }
                        List extraSymbolNames = TransformationMappingHelper.removeNames(projectedSymbolNames, matchedNames);
                        if (extraSymbolNames.size() != 0) {
                            SqlProcedureAspect procAspect;
                            EObject rs;
                            if (TransformationHelper.isSqlProcedure(targetGroup) && (rs = (EObject)(procAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)targetGroup)).getResult(targetGroup)) == null) {
                                targetGroup = TransformationHelper.createProcResultSet(targetGroup);
                            }
                            Map eObjectMap = TransformationSqlHelper.getProjectedSymbolAndProcInputEObjects(validCommand);
                            TransformationMappingHelper.addTargetAttributes(extraSymbolNames, eObjectMap, targetGroup, txnSource);
                            changed = true;
                        }
                    }
                    TransformationMappingHelper.resetSelectSqlOnNameConflict(validCommand, transMappingRoot, true, txnSource);
                    if (TransformationMappingHelper.attributesOutOfOrder(targetGroup, projectedSymbolNames)) {
                        changed = TransformationMappingHelper.orderGroupAttributes(targetGroup, projectedSymbolNames) || changed;
                    }
                    boolean bl = changed = TransformationMappingHelper.setGroupAttributeTypes(targetGroup, symbolTypeMap = TransformationSqlHelper.getProjectedSymbolAndProcInputUniqueTypes(validCommand)) || changed;
                    if (!(targetGroup instanceof MappingClass)) {
                        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolAndProcInputLengths(validCommand, hasXMLDocSource);
                        changed = TransformationMappingHelper.setGroupAttributeLengths(targetGroup, symbolLengthMap) || changed;
                    }
                    changed = AttributeMappingHelper.updateAttributeMappings(transMappingRoot, txnSource) || changed;
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                if (changed && requiredStart) {
                    SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, true, txnSource);
                }
                success = true;
            }
        }
        IStatus rv = success ? (changed ? TRANSFORMATION_OK_CHANGED : TRANSFORMATION_OK_UNCHANGED) : TRANSFORMATION_ISSUE;
        return rv;
    }

    public static IStatus reconcileTargetAttributes(EObject transMappingRoot, Object txnSource) {
        return TransformationMappingHelper.reconcileTargetAttributes(transMappingRoot, false, txnSource);
    }

    public static boolean hasProcedure(List objList) {
        boolean hasProcedure = false;
        for (Object source : objList) {
            if (!TransformationHelper.isSqlProcedure(source)) continue;
            hasProcedure = true;
            break;
        }
        return hasProcedure;
    }

    public static List getTargetAttributeNames(EObject transMappingRoot) {
        List attributes = TransformationHelper.getTransformationTargetAttributes(transMappingRoot);
        return TransformationMappingHelper.getAttributeNames(attributes);
    }

    public static List getAttributeNames(List attributes) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (EObject attr : attributes) {
            if (!SqlAspectHelper.isColumn((EObject)attr)) continue;
            if (SqlAspectHelper.isXmlDocument((EObject)attr)) {
                attributeNames.add("xml");
                continue;
            }
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)attr);
            attributeNames.add(columnAspect.getName(attr));
        }
        return attributeNames;
    }

    private static List getMatchedNames(List list1, List list2) {
        ArrayList<String> newList = new ArrayList<String>();
        block0: for (String list1Str : list1) {
            if (list1Str == null) continue;
            for (String list2Str : list2) {
                if (!list1Str.equalsIgnoreCase(list2Str)) continue;
                newList.add(list1Str);
                continue block0;
            }
        }
        return newList;
    }

    private static List removeNames(List list, List removeList) {
        ArrayList newList = new ArrayList(list);
        block0: for (String removeStr : removeList) {
            Iterator newListIter = newList.iterator();
            while (newListIter.hasNext()) {
                String listName = (String)newListIter.next();
                if (listName == null || !listName.equalsIgnoreCase(removeStr)) continue;
                newListIter.remove();
                continue block0;
            }
        }
        return newList;
    }

    public static void resetSelectSqlOnNameConflict(ICommand command, EObject transMappingRoot, boolean isSignificant, Object source) {
        IQuery newQuery;
        if (command != null && command instanceof IQuery && TransformationSqlHelper.hasProjectedSymbolNameConflict((ICommand<IExpression, ILanguageVisitor>)command) && (newQuery = TransformationSqlHelper.createQueryFixNameConflicts((IQuery)command, false)) != null) {
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), isSignificant, source);
        }
    }

    public static void addTargetAttributes(EObject targetEObject, List attributeNames, Object source) {
        if (targetEObject != null && attributeNames != null && !attributeNames.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Add Target Attributes", (Object)source);
            boolean succeeded = false;
            try {
                String attrName2 = null;
                for (String attrName2 : attributeNames) {
                    Command paramToCreate = TransformationMappingHelper.getSqlColumnDescriptor(targetEObject);
                    if (paramToCreate == null) continue;
                    try {
                        EObject newEObject = ModelerCore.getModelEditor().createNewChildFromCommand(targetEObject, paramToCreate);
                        ModelerCore.getModelEditor().rename(newEObject, attrName2);
                    }
                    catch (ModelerCoreException theException) {
                        String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorCreatingAttribute", (Object)attrName2);
                        TransformationPlugin.Util.log(4, (Throwable)theException, message);
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private static Command getSqlColumnDescriptor(EObject targetEObject) {
        Command colDescriptor2 = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(targetEObject);
        }
        catch (ModelerCoreException e) {
            String message = TransformationPlugin.Util.getString("TransformationMappingHelper.getChildDescriptorError", (Object)targetEObject.toString());
            TransformationPlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        for (Command colDescriptor2 : descriptors) {
            EObject eObj = (EObject)colDescriptor2.getResult().iterator().next();
            if (SqlAspectHelper.isColumn((EObject)eObj)) break;
        }
        return colDescriptor2;
    }

    public static void addTargetAttributes(List attributeNames, Map sourceEObjectMap, EObject targetEObject, Object txnSource) {
        if (targetEObject != null && attributeNames != null && !attributeNames.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Add Target Attributes", (Object)txnSource);
            boolean succeeded = false;
            try {
                String attrName2 = null;
                for (String attrName2 : attributeNames) {
                    Command paramToCreate = TransformationMappingHelper.getSqlColumnDescriptor(targetEObject);
                    EObject srcEObj = (EObject)sourceEObjectMap.get(attrName2);
                    try {
                        EObject newEObject = ModelerCore.getModelEditor().createNewChildFromCommand(targetEObject, paramToCreate);
                        ModelerCore.getModelEditor().rename(newEObject, attrName2);
                        TransformationHelper.transferSqlColumnProperties(newEObject, srcEObj, txnSource);
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("TransformationMappingHelper.createNewAttrError", (Object)targetEObject.toString());
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void removeTargetAttributes(Object mappingRoot, List attributes, boolean isSignificant, Object source) {
        boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)"Add Target Attributes", (Object)source);
        boolean succeeded = false;
        try {
            SqlTransformationMappingRoot transMappingRoot = null;
            if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
                transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
            }
            EObject virtualTarget = TransformationHelper.getTransformationTarget(transMappingRoot);
            SqlAspect theTargetAspect = AspectManager.getSqlAspect((EObject)virtualTarget);
            ArrayList<EObject> deleteList = new ArrayList<EObject>();
            if (theTargetAspect instanceof SqlTableAspect || theTargetAspect instanceof SqlColumnSetAspect) {
                List columns = null;
                if (theTargetAspect instanceof SqlTableAspect) {
                    columns = ((SqlTableAspect)theTargetAspect).getColumns(virtualTarget);
                } else if (theTargetAspect instanceof SqlColumnSetAspect) {
                    columns = ((SqlColumnSetAspect)theTargetAspect).getColumns(virtualTarget);
                }
                if (columns != null) {
                    for (EObject attr : columns) {
                        SqlAspect theChildAspect = AspectManager.getSqlAspect((EObject)attr);
                        if (!(theChildAspect instanceof SqlColumnAspect) || !TransformationMappingHelper.containsName(attributes, ((SqlColumnAspect)theChildAspect).getName(attr))) continue;
                        deleteList.add(attr);
                    }
                }
            }
            if (deleteList.size() > 0) {
                try {
                    ModelerCore.getModelEditor().delete(deleteList);
                }
                catch (ModelerCoreException e) {
                    String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorDeletingAttributes");
                    TransformationPlugin.Util.log(4, (Throwable)e, message);
                }
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static boolean containsName(List attributes, String name) {
        boolean contains = false;
        for (EObject eObj : attributes) {
            String objName;
            SqlAspect theAspect = AspectManager.getSqlAspect((EObject)eObj);
            if (theAspect == null || !(theAspect instanceof SqlColumnAspect) || !(objName = ((SqlColumnAspect)theAspect).getName(eObj)).equalsIgnoreCase(name)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static EObject getListAttrByName(List attributes, String name) {
        EObject result = null;
        for (EObject eObj : attributes) {
            String objName;
            SqlAspect theAspect = AspectManager.getSqlAspect((EObject)eObj);
            if (theAspect == null || !(theAspect instanceof SqlColumnAspect) || !(objName = ((SqlColumnAspect)theAspect).getName(eObj)).equalsIgnoreCase(name)) continue;
            result = eObj;
            break;
        }
        return result;
    }

    public static boolean orderGroupAttributes(EObject transMappingRoot, boolean requiresValidSelect, ICommand modifiedCommand) {
        if (!TransformationHelper.isTargetGroupLocked(transMappingRoot)) {
            boolean isValid = true;
            if (requiresValidSelect) {
                isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
            }
            ICommand validCommand = null;
            if (isValid) {
                validCommand = SqlMappingRootCache.getSelectCommand(transMappingRoot);
                EObject targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot);
                List<String> projectedSymbolNames = null;
                projectedSymbolNames = modifiedCommand != null && validCommand instanceof ISetQuery ? TransformationSqlHelper.getProjectedSymbolUniqueNames(modifiedCommand) : TransformationSqlHelper.getProjectedSymbolUniqueNames(validCommand);
                return TransformationMappingHelper.orderGroupAttributes(targetGroup, projectedSymbolNames);
            }
        }
        return false;
    }

    private static boolean orderGroupAttributes(EObject groupEObject, List attrNames) {
        List columnIndices = TransformationMappingHelper.getColumnIndices(groupEObject);
        boolean attributeMoved = false;
        if (columnIndices.size() == attrNames.size()) {
            int i = 0;
            while (i < attrNames.size()) {
                String name = (String)attrNames.get(i);
                boolean wasMoved = TransformationMappingHelper.moveAttribute(groupEObject, name, (Integer)columnIndices.get(i));
                if (wasMoved) {
                    attributeMoved = wasMoved;
                }
                ++i;
            }
        }
        return attributeMoved;
    }

    private static boolean attributesOutOfOrder(EObject groupEObject, List attrNames) {
        EList children = groupEObject.eContents();
        int iSqlColumn = 0;
        int i = 0;
        while (i < children.size()) {
            EObject nextChild = (EObject)children.get(i);
            if (TransformationHelper.isSqlColumn(nextChild)) {
                String targetChildName = ModelerCore.getModelEditor().getName(nextChild);
                String sourceAttrName = (String)attrNames.get(iSqlColumn++);
                if (targetChildName != null && !targetChildName.equalsIgnoreCase(sourceAttrName)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean setGroupAttributeTypes(EObject groupEObject, Map attrTypeMap) {
        boolean changed = false;
        EList children = groupEObject.eContents();
        for (EObject child : children) {
            Object theType;
            SqlAspect theAspect = AspectManager.getSqlAspect((EObject)child);
            if (theAspect == null || !(theAspect instanceof SqlColumnAspect)) continue;
            String colName = theAspect.getName(child);
            EObject dtype = ((SqlColumnAspect)theAspect).getDatatype(child);
            if (dtype != null || (theType = attrTypeMap.get(colName)) == null) continue;
            TransformationMappingHelper.setAttributeType(child, theType);
            changed = true;
        }
        return changed;
    }

    public static boolean setGroupAttributeLengths(EObject groupEObject, Map attrLengthMap) {
        boolean changed = false;
        if (attrLengthMap != null && !attrLengthMap.isEmpty()) {
            EList children = groupEObject.eContents();
            for (EObject child : children) {
                int length;
                SqlAspect theAspect = AspectManager.getSqlAspect((EObject)child);
                if (theAspect == null || !(theAspect instanceof SqlColumnAspect)) continue;
                String targetColName = theAspect.getName(child);
                int currentLength = ((SqlColumnAspect)theAspect).getLength(child);
                if (currentLength > 0 || attrLengthMap.get(targetColName) == null || (length = ((Integer)attrLengthMap.get(targetColName)).intValue()) == -1 || length == currentLength || !((SqlColumnAspect)theAspect).canSetLength()) continue;
                TransformationMappingHelper.setAttributeLength(child, length);
                changed = true;
            }
        }
        return changed;
    }

    private static List getColumnIndices(EObject groupEObject) {
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        EList children = groupEObject.eContents();
        int i = 0;
        while (i < children.size()) {
            if (TransformationHelper.isSqlColumn(children.get(i))) {
                columnIndices.add(new Integer(i));
            }
            ++i;
        }
        return columnIndices;
    }

    private static boolean moveAttribute(EObject groupEObject, String attrName, int newIndex) {
        EList children = groupEObject.eContents();
        boolean moved = false;
        Iterator iter = children.iterator();
        int index = 0;
        while (iter.hasNext()) {
            String currentAttrName;
            EObject eObj = (EObject)iter.next();
            if (TransformationHelper.isSqlColumn(eObj) && (currentAttrName = TransformationHelper.getSqlEObjectName(eObj)).equalsIgnoreCase(attrName) && newIndex != index) {
                try {
                    ModelerCore.getModelEditor().move((Object)groupEObject, eObj, newIndex);
                    moved = true;
                }
                catch (ModelerCoreException err) {
                    String message = TransformationPlugin.Util.getString("TransformationMappingHelper.moveTargetAttrError", (Object)groupEObject.toString());
                    TransformationPlugin.Util.log(4, (Throwable)err, message);
                }
                break;
            }
            ++index;
        }
        return moved;
    }

    private static void setAttributeType(EObject attrEObject, Object typeObj) {
        if (TransformationHelper.isSqlColumn(attrEObject)) {
            EObject newDatatype = TransformationMappingHelper.getDatatype(typeObj);
            EObject currentDatatype = TransformationHelper.getSqlColumnDatatype(attrEObject);
            if (newDatatype == null && currentDatatype != null || newDatatype != null && !newDatatype.equals(currentDatatype)) {
                TransformationHelper.setSqlColumnDatatype(attrEObject, newDatatype, TransformationMappingHelper.getInstance());
            }
        }
    }

    private static void setAttributeLength(EObject attrEObject, int newLength) {
        int currentLength;
        if (TransformationHelper.isSqlColumn(attrEObject) && newLength != (currentLength = TransformationHelper.getSqlColumnLength(attrEObject))) {
            TransformationHelper.setSqlColumnLength(attrEObject, newLength, TransformationMappingHelper.getInstance());
        }
    }

    private static EObject getDatatype(Object typeObj) {
        EObject datatype = null;
        if (typeObj != null) {
            if (typeObj instanceof EObject) {
                EObject eObject = (EObject)typeObj;
                DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
                if (dtMgr.isSimpleDatatype(eObject)) {
                    datatype = (EObject)typeObj;
                }
            } else if (typeObj instanceof Class) {
                IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
                if (((Class)typeObj).getSimpleName().equals(service.getDataTypeClass(null).getSimpleName())) {
                    typeObj = String.class;
                }
                String runtimeTypeName = service.getDataTypeName(typeObj);
                datatype = TransformationMappingHelper.getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
            }
        }
        return datatype;
    }

    public static EObject getDefaultDatatypeForRuntimeTypeName(String runtimeTypeName) {
        DatatypeManager dtMgr;
        EObject datatype = null;
        EObject typeEObj = null;
        try {
            typeEObj = ModelerCore.getWorkspaceDatatypeManager().getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
        }
        catch (ModelerCoreException e) {
            String message = TransformationPlugin.Util.getString("TransformationMappingHelper.errorFindingDefaultType", (Object)runtimeTypeName);
            TransformationPlugin.Util.log(4, (Throwable)e, message);
        }
        if (typeEObj != null && (dtMgr = ModelerCore.getDatatypeManager((EObject)typeEObj, (boolean)true)).isSimpleDatatype(typeEObj)) {
            return typeEObj;
        }
        return datatype;
    }

    private static boolean isReadOnly(EObject theEObject) {
        boolean result = true;
        if (theEObject != null) {
            ModelResource modelResource = ModelerCore.getModelEditor().findModelResource(theEObject);
            result = modelResource != null ? ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource()) : false;
        }
        return result;
    }

    public static boolean compareLists(List strings1, List strings2, boolean ignoreCase) {
        int size2;
        int size1 = strings1.size();
        if (size1 != (size2 = strings2.size())) {
            return false;
        }
        int i = 0;
        while (i < size1) {
            if (ignoreCase ? !((String)strings1.get(i)).equals(strings2.get(i)) : !((String)strings1.get(i)).equalsIgnoreCase((String)strings2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean shouldCreateTargetAttributes() {
        return createTargetAttributes;
    }

    public static void setCreateTargetAttributes(boolean theCreateTargetAttributes) {
        createTargetAttributes = theCreateTargetAttributes;
    }

    static class EObjectAlias {
        EObject object;
        String name;

        public EObjectAlias(EObject object, String name) {
            this.object = object;
            this.name = name;
        }
    }
}

