/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metadata.runtime.ColumnRecordImpl;
import org.teiid.designer.core.metadata.runtime.TableRecordImpl;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.query.SetQueryUtil;
import org.teiid.designer.metadata.runtime.ColumnRecord;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.ProcedureParameterRecord;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IMetadataID;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.IElementCollectorVisitor;
import org.teiid.designer.query.sql.IGroupCollectorVisitor;
import org.teiid.designer.query.sql.IGroupsUsedByElementsVisitor;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.IReferenceCollectorVisitor;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IFromClause;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.designer.query.sql.lang.IOrderByItem;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.IQueryCommand;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.IStoredProcedure;
import org.teiid.designer.query.sql.lang.ISubqueryFromClause;
import org.teiid.designer.query.sql.lang.IUnaryFromClause;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.proc.IBlock;
import org.teiid.designer.query.sql.proc.ICommandStatement;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.query.sql.proc.IStatement;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.query.sql.symbol.IMultipleElementSymbol;
import org.teiid.designer.transformation.TransformationPlugin;
import org.teiid.designer.transformation.aspects.sql.InputParameterSqlAspect;
import org.teiid.designer.transformation.metadata.TransformationMetadataFactory;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.udf.IFunctionDescriptor;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;

public class TransformationSqlHelper
implements ISQLConstants {
    private static final TransformationSqlHelper INSTANCE = new TransformationSqlHelper();
    private static final String NEW_CONVERSION_NAME = "conversion";

    public static TransformationSqlHelper getInstance() {
        return INSTANCE;
    }

    public static IQueryService getQueryService() {
        return ModelerCore.getTeiidQueryService();
    }

    public static IQueryFactory getQueryFactory() {
        return TransformationSqlHelper.getQueryService().createQueryFactory();
    }

    public static boolean canAddGroupToSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery(transMappingRoot) || TransformationHelper.isValidSetQuery(transMappingRoot) || TransformationHelper.isSelectFromString(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static boolean canRemoveGroupFromSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static void updateAllSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupAdded(transMappingRoot, sqlAliasGroup, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsAdded(transMappingRoot, sqlAliasGroups, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsRemoved(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        TransformationSqlHelper.updateSqlOnElementsRemoved(transMappingRoot, elementEObjs, source);
    }

    public static void updateSelectSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup) && (TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) && sqlAliasGroup != null) {
            ArrayList<EObject> groups = new ArrayList<EObject>(1);
            groups.add(sqlAliasGroup);
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, groups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        if (TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot) || TransformationHelper.isSelectFromString(transMappingRoot)) {
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, sqlAliasGroups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        if (TransformationHelper.isParsableQuery(transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source, validator);
        }
    }

    public static void updateSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        if (TransformationHelper.isParsableQuery(transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationSqlHelper.removeElementsFromStatement(transMappingRoot, elementEObjs, source);
        }
    }

    public static void updateUnionSelectOnGroupsAdded(EObject transMappingRoot, List sourceGroups, boolean useAll, Object txnSource) {
        if (TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isParsableSetQuery(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            ICommand command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
            if (command != null) {
                if (command instanceof IQueryCommand) {
                    ISetQuery newQuery = TransformationSqlHelper.createSetQueryAddUnionSources((IQueryCommand)command, sourceGroups, useAll);
                    TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
                }
            } else {
                ISetQuery newQuery = TransformationSqlHelper.createSetQueryAddUnionSources(null, sourceGroups, useAll);
                TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
            }
        }
    }

    public static void updateUnionSelectAddGroupsToSegment(EObject transMappingRoot, List sourceGroups, int nSegmentIndex, Object txnSource) {
        ICommand command;
        if (TransformationHelper.isParsableSetQuery(transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand(transMappingRoot)) != null && command instanceof ISetQuery) {
            ISetQuery newSetQuery = (ISetQuery)command.clone();
            List queries = ((ISetQuery)command).getQueryCommands();
            IQueryCommand queryCommand = (IQueryCommand)queries.get(nSegmentIndex);
            if (queryCommand instanceof IQuery) {
                IQuery query = (IQuery)queryCommand;
                IQuery newQuery = TransformationSqlHelper.createQueryAddGroupsToFrom(query, sourceGroups);
                SetQueryUtil.setQueryAtIndex((ISetQuery)newSetQuery, (int)nSegmentIndex, (IQueryCommand)newQuery);
                TransformationHelper.setSelectSqlString(transMappingRoot, newSetQuery.toString(), false, txnSource);
            }
        }
    }

    private static void addSqlAliasGroupsToSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
        ICommand command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
        boolean doAutoExpandSelect = TransformationPlugin.getDefault().getPreferences().getBoolean("org.teiid.designer.transformation.preferences.auto_expand_select", false);
        if (!doAutoExpandSelect && addElemsToSelect) {
            doAutoExpandSelect = addElemsToSelect;
        }
        if (isValid && command instanceof IQuery) {
            IQuery query = (IQuery)command;
            IQuery newQuery = TransformationSqlHelper.createQueryAddSqlAliasGroups(query, sqlAliasGroups, doAutoExpandSelect, 0, validator);
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
        } else if (TransformationHelper.isEmptySelect(transMappingRoot)) {
            EObject targetGrp = TransformationHelper.getTransformationLinkTarget(transMappingRoot);
            if (!TransformationHelper.isSqlProcedure(targetGrp)) {
                IQuery qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, doAutoExpandSelect, 0, validator);
                TransformationHelper.setSelectSqlString(transMappingRoot, qry.toString(), false, txnSource);
            } else if (sqlAliasGroups.size() == 1) {
                SqlAlias sqlAlias = (SqlAlias)sqlAliasGroups.get(0);
                EObject aliasedEObject = sqlAlias.getAliasedObject();
                if (TransformationHelper.isSqlProcedure(aliasedEObject)) {
                    IStoredProcedure proc = TransformationSqlHelper.createStoredProc((EObject)sqlAlias);
                    if (proc != null) {
                        ICreateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((ICommand)proc);
                        TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
                    }
                } else if (TransformationHelper.isSqlTable(aliasedEObject)) {
                    IQuery qry = TransformationSqlHelper.createDefaultQuery(null);
                    qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, doAutoExpandSelect, 0, validator);
                    ICreateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((ICommand)qry);
                    TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
                }
            } else {
                IQuery qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, doAutoExpandSelect, 0, validator);
                ICreateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((ICommand)qry);
                TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
            }
        } else if (TransformationHelper.isSelectFromString(transMappingRoot)) {
            StringBuffer sb = new StringBuffer(TransformationHelper.getSelectSqlString(transMappingRoot));
            sb.append(" ");
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            TransformationHelper.setSelectSqlString(transMappingRoot, sb.toString(), false, txnSource);
        }
    }

    public static ICreateProcedureCommand createVirtualProcCommmandForCommand(ICommand command) {
        IBlock block = TransformationSqlHelper.getQueryFactory().createBlock();
        ICommandStatement cmdStmt = TransformationSqlHelper.getQueryFactory().createCommandStatement(command);
        block.addStatement((IStatement)cmdStmt);
        ICreateProcedureCommand cCommand = TransformationSqlHelper.getQueryFactory().createCreateProcedureCommand(block);
        return cCommand;
    }

    private static IQuery createQueryAddSqlAliasGroupElemsToSelect(IQuery resolvedQuery, List addedSqlAliasGroups) {
        IQuery result = null;
        if (!TransformationSqlHelper.isSelectStar(resolvedQuery.getSelect())) {
            result = (IQuery)resolvedQuery.clone();
            ISelect select = resolvedQuery.getSelect();
            List currentSelectSymbols = select.getSymbols();
            List newElementSymbols = TransformationSqlHelper.createElemSymbols(addedSqlAliasGroups);
            ArrayList selectSymbols = new ArrayList();
            selectSymbols.addAll(currentSelectSymbols);
            selectSymbols.addAll(newElementSymbols);
            List newSelectSymbols = TransformationSqlHelper.renameConflictingSymbols(selectSymbols);
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(TransformationSqlHelper.getQueryFactory().createMultipleElementSymbol());
                select.setSymbols((Collection)newSelectSymbols);
            } else {
                select.setSymbols((Collection)newSelectSymbols);
            }
            result.setSelect(select);
        }
        return result;
    }

    private static IQuery createQueryAddSqlAliasGroupsToFrom(IQuery resolvedQuery, List sqlAliasGroups) {
        IQuery result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            result = (IQuery)resolvedQuery.clone();
            IFrom from = resolvedQuery.getFrom();
            IFrom newFrom = from != null ? (IFrom)from.clone() : TransformationSqlHelper.getQueryFactory().createFrom();
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            for (IFromClause nextFromClause : clausesToAdd) {
                if (newFrom.containsGroup(((IUnaryFromClause)nextFromClause).getGroup())) continue;
                newFrom.addClause(nextFromClause);
            }
            result.setFrom(newFrom);
        }
        return result;
    }

    private static IQuery createQueryAddGroupsToFrom(IQuery query, List grpEObjs) {
        IQuery result = null;
        if (query != null && grpEObjs != null) {
            result = (IQuery)query.clone();
            IFrom from = query.getFrom();
            IFrom newFrom = from != null ? (IFrom)from.clone() : TransformationSqlHelper.getQueryFactory().createFrom();
            int i = 0;
            while (i < grpEObjs.size()) {
                EObject grpEObj = (EObject)grpEObjs.get(i);
                IFromClause fClause = TransformationSqlHelper.createFromClause(grpEObj);
                newFrom.addClause(fClause);
                ++i;
            }
            result.setFrom(newFrom);
        }
        return result;
    }

    private static IQuery createQueryAddSqlAliasGroups(IQuery resolvedQuery, List sqlAliasGroups, boolean addGroupElemsToSelect, int cmdType, TransformationValidator validator) {
        IQuery result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            SqlTransformationResult resolverResult;
            result = TransformationSqlHelper.createQueryAddSqlAliasGroupsToFrom(resolvedQuery, sqlAliasGroups);
            SqlTransformationResult parserResult = TransformationValidator.parseSQL(result.toString());
            IQuery resultQuery = (IQuery)parserResult.getCommand();
            boolean isResolvable = false;
            boolean isValid = false;
            if (resultQuery != null && (isResolvable = (resolverResult = validator.resolveCommand((ICommand)resultQuery, cmdType)).isResolvable())) {
                SqlTransformationResult validationResult = validator.validateCommand((ICommand)resultQuery, cmdType);
                isValid = validationResult.isValidatable();
            }
            if (isValid) {
                ISelect select = resultQuery.getSelect();
                result = TransformationSqlHelper.isSelectStar(select) ? TransformationSqlHelper.createQueryFixNameConflicts(resultQuery, addGroupElemsToSelect) : (addGroupElemsToSelect ? TransformationSqlHelper.createQueryAddSqlAliasGroupElemsToSelect(resultQuery, sqlAliasGroups) : resultQuery);
            }
        }
        return result;
    }

    private static ISetQuery createSetQueryAddUnionSources(IQueryCommand queryCommand, List unionSourceGrps, boolean useAll) {
        IQuery qry;
        EObject sourceGroup;
        ISetQuery result = null;
        result = TransformationSqlHelper.getQueryFactory().createSetQuery(ISetQuery.Operation.UNION);
        result.setAll(useAll);
        Iterator iter = null;
        if (queryCommand != null) {
            result.setLeftQuery((IQueryCommand)queryCommand.clone());
            iter = unionSourceGrps.iterator();
        } else {
            iter = unionSourceGrps.iterator();
            if (iter.hasNext()) {
                sourceGroup = (EObject)iter.next();
                qry = TransformationSqlHelper.createDefaultQuery(sourceGroup);
                result.setLeftQuery((IQueryCommand)qry);
                if (iter.hasNext()) {
                    sourceGroup = (EObject)iter.next();
                    IQuery right = TransformationSqlHelper.createDefaultQuery(sourceGroup);
                    result.setRightQuery((IQueryCommand)right);
                }
            }
            if (iter.hasNext()) {
                ISetQuery unionResult = TransformationSqlHelper.getQueryFactory().createSetQuery(ISetQuery.Operation.UNION);
                unionResult.setAll(useAll);
                unionResult.setLeftQuery((IQueryCommand)result);
                result = unionResult;
            }
        }
        while (iter.hasNext()) {
            sourceGroup = (EObject)iter.next();
            qry = TransformationSqlHelper.createDefaultQuery(sourceGroup);
            result.setRightQuery((IQueryCommand)qry);
            if (!iter.hasNext()) continue;
            ISetQuery left = result;
            result = TransformationSqlHelper.getQueryFactory().createSetQuery(ISetQuery.Operation.UNION);
            result.setAll(useAll);
            result.setLeftQuery((IQueryCommand)left);
        }
        return result;
    }

    private static void removeSqlAliasGroupsFromSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
        ICommand command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
        if (isValid && command instanceof IQuery) {
            IQuery query = (IQuery)command;
            IQuery newQuery = TransformationSqlHelper.createQueryRemoveSqlAliasGroups(query, sqlAliasGroups, removeElemsFromSelect, 0, validator);
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
        }
    }

    private static void removeElementsFromStatement(EObject transMappingRoot, List elementEObjs, Object txnSource) {
        IQuery query;
        IQuery newQuery;
        if (transMappingRoot == null || elementEObjs == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
        ICommand command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
        if (isValid && command instanceof IQuery && (newQuery = TransformationSqlHelper.createQueryRemoveElems(query = (IQuery)command, elementEObjs)) != null) {
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
        }
    }

    private static IQuery createQueryRemoveSqlAliasGroupElemsFromSelect(IQuery resolvedQuery, List removeSqlAliasGroups) {
        IQuery result = null;
        if (TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, removeSqlAliasGroups)) {
            result = (IQuery)resolvedQuery.clone();
            List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(removeSqlAliasGroups);
            ISelect select = resolvedQuery.getSelect();
            List currentSelectSymbols = select.getSymbols();
            IGroupsUsedByElementsVisitor groupsUsedByElementsVisitor = TransformationSqlHelper.getQueryService().getGroupsUsedByElementsVisitor();
            ArrayList<Object> newSelectSymbols = new ArrayList<Object>(currentSelectSymbols.size());
            for (IExpression selectSymbol : currentSelectSymbols) {
                Set symbolGroups = groupsUsedByElementsVisitor.findGroups((ILanguageObject)selectSymbol);
                Iterator symbolGroupIter = symbolGroups.iterator();
                boolean removeSymbol = false;
                while (symbolGroupIter.hasNext()) {
                    IGroupSymbol symbGroup = (IGroupSymbol)symbolGroupIter.next();
                    for (IGroupSymbol removeGroupSymbol : aliasGroupSymbols) {
                        if (!symbGroup.equals(removeGroupSymbol)) continue;
                        removeSymbol = true;
                        break;
                    }
                    if (removeSymbol) break;
                }
                if (removeSymbol) continue;
                newSelectSymbols.add(selectSymbol);
            }
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(TransformationSqlHelper.getQueryFactory().createMultipleElementSymbol());
                select.setSymbols(newSelectSymbols);
            } else {
                select.setSymbols(newSelectSymbols);
            }
            result.setSelect(select);
        }
        return result;
    }

    protected static IQuery createQueryRemoveElems(IQuery resolvedQuery, List removeElements) {
        IQuery result = resolvedQuery;
        ArrayList<String> removeNames = new ArrayList<String>(removeElements.size());
        for (Object remElem : removeElements) {
            if (!(remElem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)remElem))) continue;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)remElem));
            removeNames.add(columnAspect.getName((EObject)remElem));
        }
        if (TransformationSqlHelper.hasSqlElemSymbols(resolvedQuery, removeElements)) {
            result = (IQuery)resolvedQuery.clone();
            ISelect select = resolvedQuery.getSelect();
            List currentSelectSymbols = CommandHelper.getProjectedSymbols((ICommand)resolvedQuery);
            List newSelectSymbols = TransformationSqlHelper.removeSymbols(currentSelectSymbols, removeNames);
            select.setSymbols((Collection)newSelectSymbols);
            result.setSelect(select);
        }
        if (result.getGroupBy() != null) {
            IGroupBy groupBy = result.getGroupBy();
            List currentGroupBySymbols = groupBy.getSymbols();
            List newGroupBySymbols = TransformationSqlHelper.removeSymbols(currentGroupBySymbols, removeNames);
            groupBy.getSymbols().clear();
            groupBy.getSymbols().addAll(newGroupBySymbols);
            if (groupBy.getCount() == 0) {
                result.setGroupBy(null);
            } else {
                result.setGroupBy(groupBy);
            }
        }
        if (result.getOrderBy() != null) {
            IOrderBy orderBy = result.getOrderBy();
            Iterator iter2 = orderBy.getOrderByItems().iterator();
            while (iter2.hasNext()) {
                IOrderByItem next = (IOrderByItem)iter2.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(next.getSymbol(), false);
                if (!removeNames.contains(name)) continue;
                iter2.remove();
            }
            if (orderBy.getVariableCount() == 0) {
                result.setOrderBy(null);
            } else {
                result.setOrderBy(orderBy);
            }
        }
        return result;
    }

    private static List removeSymbols(List currentSymbols, List symbolNamesToRemove) {
        if (currentSymbols == null || symbolNamesToRemove == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IExpression> result = new ArrayList<IExpression>(currentSymbols.size());
        for (Object next : currentSymbols) {
            IExpression seSymbol;
            String symName;
            if (!(next instanceof IExpression) || symbolNamesToRemove.contains(symName = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (IExpression)next, false))) continue;
            result.add(seSymbol);
        }
        return result;
    }

    private static IQuery createQueryRemoveSqlAliasGroupsFromFrom(IQuery resolvedQuery, List removedSqlAliasGrps) {
        IQuery result = null;
        if (resolvedQuery != null) {
            result = (IQuery)resolvedQuery.clone();
            IFrom from = resolvedQuery.getFrom();
            List currentFromClauses = from.getClauses();
            ArrayList<IFromClause> newFromClauses = new ArrayList<IFromClause>(currentFromClauses.size());
            for (IFromClause fromClause : currentFromClauses) {
                boolean removeIt = false;
                for (EObject removeGroupEObj : removedSqlAliasGrps) {
                    if (fromClause instanceof IUnaryFromClause) {
                        IGroupSymbol gSymbol = ((IUnaryFromClause)fromClause).getGroup();
                        IGroupSymbol removeGroupSymbol = TransformationSqlHelper.createGroupSymbol(removeGroupEObj);
                        if (gSymbol == null || !gSymbol.equals(removeGroupSymbol)) continue;
                        removeIt = true;
                        break;
                    }
                    if (!(fromClause instanceof ISubqueryFromClause)) continue;
                    ISubqueryFromClause sqf = (ISubqueryFromClause)fromClause;
                    if (!(removeGroupEObj instanceof SqlAlias) || !TransformationSqlHelper.isMatch(sqf, (SqlAlias)removeGroupEObj)) continue;
                    removeIt = true;
                    break;
                }
                if (removeIt) continue;
                newFromClauses.add(fromClause);
            }
            from.setClauses(newFromClauses);
            result.setFrom(from);
        }
        return result;
    }

    private static boolean isMatch(ISubqueryFromClause subqueryFrom, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (subqueryFrom != null && sqlAlias != null) {
            ICommand fromClauseQuery = subqueryFrom.getCommand();
            String fromClauseName = subqueryFrom.getName();
            if (fromClauseQuery instanceof IStoredProcedure) {
                IStoredProcedure fromClauseProc = (IStoredProcedure)fromClauseQuery;
                String fromClauseProcName = fromClauseProc.getProcedureCallableName();
                String sqlAliasName = sqlAlias.getAlias();
                EObject sqlAliasEObj = sqlAlias.getAliasedObject();
                if (fromClauseName != null && fromClauseName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure(sqlAliasEObj)) {
                    IStoredProcedureInfo procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName(sqlAliasEObj), sqlAliasEObj);
                    String sqlAliasProcName = procInfo.getProcedureCallableName();
                    if (fromClauseProcName != null && fromClauseProcName.equalsIgnoreCase(sqlAliasProcName)) {
                        isMatch = true;
                    }
                }
            }
        }
        return isMatch;
    }

    private static IQuery createQueryRemoveSqlAliasGroups(IQuery resolvedQuery, List sqlAliasGroups, boolean removeGroupElemsFromSelect, int cmdType, TransformationValidator validator) {
        IQuery result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            if (!TransformationSqlHelper.isSelectStar(resolvedQuery.getSelect()) && TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, sqlAliasGroups)) {
                result = removeGroupElemsFromSelect ? TransformationSqlHelper.createQueryRemoveSqlAliasGroupElemsFromSelect(resolvedQuery, sqlAliasGroups) : resolvedQuery;
            }
            IQuery resultQuery = null;
            boolean isValid = false;
            if (result != null) {
                SqlTransformationResult parserResult = TransformationValidator.parseSQL(result.toString());
                resultQuery = (IQuery)parserResult.getCommand();
                boolean isResolvable = false;
                SqlTransformationResult resolverResult = validator.resolveCommand((ICommand)resultQuery, cmdType);
                isResolvable = resolverResult.isResolvable();
                if (isResolvable) {
                    SqlTransformationResult validationResult = validator.validateCommand((ICommand)resultQuery, cmdType);
                    isValid = validationResult.isValidatable();
                }
            } else {
                resultQuery = resolvedQuery;
                isValid = true;
            }
            if (isValid) {
                result = TransformationSqlHelper.createQueryRemoveSqlAliasGroupsFromFrom(resolvedQuery, sqlAliasGroups);
            }
        }
        return result;
    }

    public static IQuery createQueryFixNameConflicts(IQuery resolvedQuery, boolean addGroupElemsToSelect) {
        IQuery modifiedQuery = null;
        if (resolvedQuery != null) {
            IExpression singleSelectSymbol;
            List currentSelectSymbols;
            modifiedQuery = (IQuery)resolvedQuery.clone();
            if (TransformationSqlHelper.hasProjectedSymbolNameConflict((ICommand<IExpression, ILanguageVisitor>)resolvedQuery)) {
                List currentSymbols = resolvedQuery.getSelect().getSymbols();
                List newSymbols = TransformationSqlHelper.renameConflictingSymbols(currentSymbols);
                ISelect newSelect = TransformationSqlHelper.getQueryFactory().createSelect(newSymbols);
                modifiedQuery.setSelect(newSelect);
            } else if (addGroupElemsToSelect && (currentSelectSymbols = resolvedQuery.getSelect().getSymbols()).size() == 1 && (singleSelectSymbol = (IExpression)currentSelectSymbols.get(0)) instanceof IMultipleElementSymbol) {
                List elementSymbols = ((IMultipleElementSymbol)singleSelectSymbol).getElementSymbols();
                ISelect newSelect = TransformationSqlHelper.getQueryFactory().createSelect(elementSymbols);
                modifiedQuery.setSelect(newSelect);
            }
        }
        return modifiedQuery;
    }

    public static IQuery createDefaultQuery(EObject source) {
        IFromClause clause;
        ISelect newSelect = TransformationSqlHelper.getQueryFactory().createSelect();
        newSelect.addSymbol((ILanguageObject)TransformationSqlHelper.getQueryFactory().createMultipleElementSymbol());
        IFrom newFrom = TransformationSqlHelper.getQueryFactory().createFrom();
        if (source != null && (clause = TransformationSqlHelper.createFromClause(source)) != null) {
            newFrom.addClause(clause);
        }
        IQuery query = TransformationSqlHelper.getQueryFactory().createQuery();
        query.setSelect(newSelect);
        query.setFrom(newFrom);
        return query;
    }

    public static boolean hasProjectedSymbolNameConflict(ICommand<IExpression, ILanguageVisitor> command) {
        boolean hasConflict = false;
        if (command != null) {
            ArrayList<String> attrNames = new ArrayList<String>();
            for (IExpression seSymbol : CommandHelper.getProjectedSymbols(command)) {
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
                String uniqueName = TransformationSqlHelper.getUniqueName(name, attrNames);
                if (!uniqueName.equals(name)) {
                    hasConflict = true;
                    break;
                }
                attrNames.add(uniqueName);
            }
        }
        return hasConflict;
    }

    public static List<String> getProjectedSymbolNames(ICommand command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        List projectedSymbols = CommandHelper.getProjectedSymbols((ICommand)command);
        ArrayList<String> symbolNames = null;
        if (projectedSymbols.isEmpty()) {
            symbolNames = Collections.EMPTY_LIST;
        } else {
            symbolNames = new ArrayList<String>(projectedSymbols.size());
            for (IExpression symbol : projectedSymbols) {
                String shortName = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                if (shortName == null) continue;
                symbolNames.add(shortName);
            }
        }
        return symbolNames;
    }

    public static String getSingleElementSymbolShortName(IExpression symbol, boolean showExpression) {
        String symbolName = "";
        if (symbol != null) {
            if (symbol instanceof IExpressionSymbol) {
                IExpression expr = ((IExpressionSymbol)symbol).getExpression();
                if (expr != null && expr instanceof IFunction) {
                    IFunction func = (IFunction)expr;
                    if (func.isImplicit()) {
                        IElementCollectorVisitor elementCollectorVisitor = TransformationSqlHelper.getQueryService().getElementCollectorVisitor(true);
                        Collection elementSymbols = elementCollectorVisitor.findElements((ILanguageObject)func);
                        if (elementSymbols.size() == 1) {
                            IElementSymbol element = (IElementSymbol)elementSymbols.iterator().next();
                            symbolName = element.getShortName();
                        } else {
                            symbolName = showExpression ? symbol.toString() : TransformationSqlHelper.getQueryService().getSymbolShortName(symbol);
                        }
                    } else {
                        symbolName = showExpression ? symbol.toString() : TransformationSqlHelper.getQueryService().getSymbolShortName(symbol);
                    }
                } else {
                    symbolName = showExpression ? symbol.toString() : TransformationSqlHelper.getQueryService().getSymbolShortName(symbol);
                }
            } else {
                symbolName = symbol instanceof IConstant ? (showExpression ? symbol.toString() : TransformationSqlHelper.getQueryService().getSymbolShortName(symbol)) : TransformationSqlHelper.getQueryService().getSymbolShortName(symbol);
            }
        }
        return symbolName;
    }

    public static List<String> getProjectedSymbolUniqueNames(ICommand command) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        List<String> selectNames = TransformationSqlHelper.getProjectedSymbolNames(command);
        for (String name : selectNames) {
            if (!uniqueNames.contains(name)) {
                uniqueNames.add(name);
                continue;
            }
            String uniqueName = TransformationSqlHelper.getUniqueName(name, uniqueNames);
            uniqueNames.add(uniqueName);
        }
        return uniqueNames;
    }

    public static List getProcedureInputParams(ICommand command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList inputParams = new ArrayList();
        if (command instanceof IStoredProcedure) {
            List procInParams = ((IStoredProcedure)command).getInputParameters();
            inputParams.addAll(procInParams);
        }
        return inputParams;
    }

    public static Map getProcInputParamEObjects(IStoredProcedure storedProc) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (storedProc != null) {
            List inputParams = storedProc.getInputParameters();
            for (ISPParameter param : inputParams) {
                IElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                symbolEObjMap.put(name, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static String getUniqueName(String name, Collection collection) {
        if (collection == null) {
            collection = Collections.EMPTY_SET;
        }
        String result = name;
        int incr = 1;
        boolean nameIsInCollection = false;
        block0: do {
            nameIsInCollection = false;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!result.equalsIgnoreCase((String)i.next())) continue;
                nameIsInCollection = true;
                result = String.valueOf(name) + "_" + incr;
                ++incr;
                continue block0;
            }
        } while (nameIsInCollection);
        return result;
    }

    public static Map getProjectedSymbolUniqueTypes(ICommand command) {
        if (command != null) {
            HashMap<String, Object> symbolTypeMap = new HashMap<String, Object>();
            List symbols = CommandHelper.getProjectedSymbols((ICommand)command);
            for (IExpression symbol : symbols) {
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                Set currentNames = symbolTypeMap.size() != 0 ? symbolTypeMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                symbolTypeMap.put(uniqueName, typeObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolAndProcInputUniqueTypes(ICommand command) {
        if (command != null) {
            Map symbolTypeMap = TransformationSqlHelper.getProjectedSymbolUniqueTypes(command);
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            for (ISPParameter param : inputParams) {
                IElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                Object eObj = TransformationSqlHelper.getElementSymbolType((IExpression)symbol);
                symbolTypeMap.put(name, eObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolEObjects(ICommand command) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (command != null) {
            List symbols = CommandHelper.getProjectedSymbols((ICommand)command);
            for (IExpression symbol : symbols) {
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                EObject eObj = null;
                if (symbol instanceof IElementSymbol) {
                    eObj = TransformationSqlHelper.getElementSymbolEObject((IElementSymbol)symbol);
                }
                Set currentNames = symbolEObjMap.size() != 0 ? symbolEObjMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                if (eObj == null) continue;
                symbolEObjMap.put(uniqueName, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static Map getProjectedSymbolAndProcInputEObjects(ICommand command) {
        Map projectedSymbolEObjMap = TransformationSqlHelper.getProjectedSymbolEObjects(command);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            for (ISPParameter param : inputParams) {
                IElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                projectedSymbolEObjMap.put(name, eObj);
            }
        }
        return projectedSymbolEObjMap;
    }

    public static Map getProjectedSymbolLengths(ICommand command, boolean hasXMLDocSource) {
        HashMap symbolLengthMap = new HashMap();
        if (command != null) {
            List symbols = CommandHelper.getProjectedSymbols((ICommand)command);
            for (IExpression symbol : symbols) {
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof ICreateProcedureCommand;
                Set currentNames = symbolLengthMap.size() != 0 ? symbolLengthMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, uniqueName, typeObj, symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    public static Map getProjectedSymbolAndProcInputLengths(ICommand command, boolean hasXMLDocSource) {
        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolLengths(command, hasXMLDocSource);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            for (ISPParameter param : inputParams) {
                IElementSymbol symbol = param.getParameterSymbol();
                String name = symbol.getShortName();
                Object typeObj = TransformationSqlHelper.getElementSymbolType((IExpression)symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof ICreateProcedureCommand;
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, name, typeObj, (IExpression)symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    private static void updateTypeLengthMap(Map theMap, String name, Object typeObj, IExpression symbol, boolean xmlDocSourceCase) {
        if (typeObj != null && typeObj instanceof XSDSimpleTypeDefinition) {
            String dtName = ((XSDSimpleTypeDefinition)typeObj).getName();
            if (("string".equals(dtName) || "char".equals(dtName)) && ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)((XSDSimpleTypeDefinition)typeObj))) {
                int length = TransformationSqlHelper.getElementSymbolLength(symbol);
                theMap.put(name, new Integer(length));
            } else {
                theMap.put(name, new Integer(-1));
            }
        } else if (typeObj != null) {
            if (typeObj instanceof Class) {
                if (xmlDocSourceCase) {
                    theMap.put(name, new Integer(Integer.MAX_VALUE));
                } else if (String.class.equals(typeObj)) {
                    int stringLength = TransformationSqlHelper.getSymbolLength(symbol);
                    if (stringLength > 0) {
                        theMap.put(name, new Integer(stringLength));
                    } else {
                        theMap.put(name, new Integer(ModelerCore.getTransformationPreferences().getDefaultStringLength()));
                    }
                } else if (Character.class.equals(typeObj)) {
                    theMap.put(name, new Integer(1));
                } else {
                    theMap.put(name, new Integer(-1));
                }
            }
        } else {
            theMap.put(name, new Integer(-1));
        }
    }

    private static IFunction isStringFunction(IExpression symbol) {
        IExpressionSymbol expressionSymbol = null;
        IFunction function = null;
        if (symbol instanceof IAliasSymbol && ((IAliasSymbol)symbol).getSymbol() instanceof IExpressionSymbol) {
            expressionSymbol = (IExpressionSymbol)((IAliasSymbol)symbol).getSymbol();
        } else if (symbol instanceof IExpressionSymbol) {
            expressionSymbol = (IExpressionSymbol)symbol;
        }
        if (expressionSymbol != null && expressionSymbol.getExpression() instanceof IFunction) {
            function = (IFunction)expressionSymbol.getExpression();
            IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
            if (function.getName().equalsIgnoreCase(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CONCAT)) || function.getName().equalsIgnoreCase(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CONCAT_OPERATOR))) {
                return function;
            }
            if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                return function;
            }
            return null;
        }
        return function;
    }

    private static boolean isDecodeOrSubString(IFunction function) {
        IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
        return function.getName().equalsIgnoreCase(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.DECODESTRING)) || function.getName().equalsIgnoreCase(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.SUBSTRING));
    }

    private static int concatSymbolLength(IExpression exprObject) {
        IExpression[] args = null;
        IElementSymbol elSymbol = null;
        int stringLength = 0;
        if (exprObject != null && exprObject instanceof IFunction) {
            IFunction myFunc = (IFunction)exprObject;
            if (TransformationSqlHelper.isDecodeOrSubString(myFunc)) {
                return stringLength += TransformationSqlHelper.getMaxStringLength(myFunc);
            }
            if (myFunc.getName().equalsIgnoreCase("chr")) {
                return ++stringLength;
            }
            args = myFunc.getArgs();
            int i = 0;
            while (i < args.length) {
                IExpression symbol = args[i];
                if (symbol != null && symbol instanceof IFunction) {
                    stringLength += TransformationSqlHelper.concatSymbolLength(symbol);
                }
                if (symbol instanceof IElementSymbol) {
                    elSymbol = (IElementSymbol)symbol;
                    Object mID = elSymbol.getMetadataID();
                    if (mID != null && mID instanceof ColumnRecord) {
                        int length = ((ColumnRecord)mID).getLength();
                        stringLength += length;
                    } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                        int length = ((ProcedureParameterRecord)mID).getLength();
                        stringLength += length;
                    } else {
                        stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                    }
                }
                if (symbol instanceof IConstant) {
                    IConstant constant = (IConstant)args[i];
                    Object value = constant.getValue();
                    stringLength = value != null && value instanceof String ? (stringLength += ((String)value).length()) : (stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength());
                }
                ++i;
            }
        } else if (exprObject instanceof IElementSymbol) {
            elSymbol = (IElementSymbol)exprObject;
            Object mID = elSymbol.getMetadataID();
            if (mID != null && mID instanceof ColumnRecord) {
                int length = ((ColumnRecord)mID).getLength();
                stringLength += length;
            } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                int length = ((ProcedureParameterRecord)mID).getLength();
                stringLength += length;
            } else {
                stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
            }
        } else if (exprObject instanceof IConstant) {
            IConstant constant = (IConstant)exprObject;
            Object value = constant.getValue();
            stringLength = value != null && value instanceof String ? (stringLength += ((String)value).length()) : (stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        return stringLength += 0;
    }

    public static int getSymbolLength(IExpression symbol) {
        int stringLength = 0;
        IFunction function = null;
        function = TransformationSqlHelper.isStringFunction(symbol);
        if (function != null) {
            if (!TransformationSqlHelper.isDecodeOrSubString(function)) {
                IExpression[] args = function.getArgs();
                int i = 0;
                while (i < args.length) {
                    IExpression exprSymbol = args[i];
                    if (exprSymbol != null && exprSymbol instanceof IFunction) {
                        stringLength += TransformationSqlHelper.concatSymbolLength(exprSymbol);
                    }
                    if (exprSymbol instanceof IElementSymbol) {
                        stringLength += TransformationSqlHelper.concatSymbolLength(exprSymbol);
                    }
                    if (exprSymbol instanceof IConstant) {
                        stringLength += TransformationSqlHelper.concatSymbolLength(exprSymbol);
                    }
                    ++i;
                }
            } else if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                stringLength += TransformationSqlHelper.getMaxStringLength(function);
            }
        } else {
            stringLength += 0;
        }
        return stringLength;
    }

    private static int getMaxStringLength(IFunction function) {
        IExpression[] args = function.getArgs();
        IExpression exprSymbol = args[0];
        IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
        if (function.getName().equalsIgnoreCase(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.DECODESTRING))) {
            return TransformationSqlHelper.getDecodeLength(function);
        }
        return TransformationSqlHelper.concatSymbolLength(exprSymbol);
    }

    private static int getDecodeLength(IFunction function) {
        IConstant constSym;
        Object constObj;
        IExpression[] args = function.getArgs();
        IExpression exprSymbol = null;
        int maxLength = 0;
        exprSymbol = args[0];
        if (exprSymbol instanceof IElementSymbol) {
            int length;
            IElementSymbol elmSymbol = (IElementSymbol)exprSymbol;
            Object mID = elmSymbol.getMetadataID();
            maxLength = mID != null && mID instanceof ColumnRecord ? (length = ((ColumnRecord)mID).getLength()) : (mID != null && mID instanceof ProcedureParameterRecord ? (length = ((ProcedureParameterRecord)mID).getLength()) : ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        if ((exprSymbol = args[1]) instanceof IConstant && (constObj = (constSym = (IConstant)exprSymbol).getValue()) != null && constObj instanceof String) {
            String decodes = (String)constObj;
            String delimiter = ",";
            if (args.length == 3 && (constObj = (constSym = (IConstant)(exprSymbol = args[2])).getValue()) != null && constObj instanceof String) {
                delimiter = (String)constObj;
            }
            StringTokenizer strTok = new StringTokenizer(decodes, delimiter);
            while (strTok.hasMoreTokens()) {
                String word = strTok.nextToken().trim();
                if (word.length() <= maxLength) continue;
                maxLength = word.length();
            }
        }
        return maxLength;
    }

    public static List getProjectedSymbolTypes(ICommand command) {
        ArrayList<Object> selectTypes = new ArrayList<Object>();
        if (command != null) {
            List symbols = CommandHelper.getProjectedSymbols((ICommand)command);
            for (IExpression symbol : symbols) {
                selectTypes.add(TransformationSqlHelper.getElementSymbolType(symbol));
            }
        }
        return selectTypes;
    }

    public static Map getRenamedSymbolsMap(List<IExpression> symbols) {
        HashMap<String, IExpression> renameMap = new HashMap<String, IExpression>();
        ArrayList<Object> seSymbols = new ArrayList<Object>();
        for (IExpression sSymbol : symbols) {
            if (sSymbol instanceof IMultipleElementSymbol) {
                List list = ((IMultipleElementSymbol)sSymbol).getElementSymbols();
                if (list == null) continue;
                for (IElementSymbol eSymbol : list) {
                    if (eSymbol == null) continue;
                    seSymbols.add(eSymbol);
                }
                continue;
            }
            if (sSymbol == null) continue;
            seSymbols.add(sSymbol);
        }
        ArrayList<String> elementNames = new ArrayList<String>();
        for (IExpression iExpression : seSymbols) {
            String name;
            String uniqueName = name = TransformationSqlHelper.getSingleElementSymbolShortName(iExpression, false);
            IExpression underlyingSymbol = iExpression;
            if (iExpression instanceof IAliasSymbol) {
                underlyingSymbol = ((IAliasSymbol)iExpression).getSymbol();
            }
            if (underlyingSymbol instanceof IElementSymbol) {
                IElementSymbol eSymbol = (IElementSymbol)underlyingSymbol;
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                Object idObj = eSymbol.getMetadataID();
                if (idObj != null && idObj instanceof MetadataRecord) {
                    elementNames.add(uniqueName);
                }
            } else if (underlyingSymbol instanceof IExpressionSymbol) {
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                elementNames.add(uniqueName);
            }
            if (uniqueName.equals(name)) continue;
            renameMap.put(uniqueName, iExpression);
        }
        return renameMap;
    }

    private static List createFromClauses(List sqlAliases) {
        ArrayList<IUnaryFromClause> result = new ArrayList<IUnaryFromClause>(sqlAliases.size());
        for (SqlAlias sqlAlias : sqlAliases) {
            IGroupSymbol gSymbol = TransformationSqlHelper.createGroupSymbol((EObject)sqlAlias);
            result.add(TransformationSqlHelper.getQueryFactory().createUnaryFromClause(gSymbol));
        }
        return result;
    }

    private static IFromClause createFromClause(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        IUnaryFromClause fromClause = TransformationSqlHelper.getQueryFactory().createUnaryFromClause(TransformationSqlHelper.createGroupSymbol(eObject));
        return fromClause;
    }

    private static List createGroupSymbols(List groupEObjs) {
        ArrayList<IGroupSymbol> result = new ArrayList<IGroupSymbol>(groupEObjs.size());
        for (EObject eObj : groupEObjs) {
            IGroupSymbol gSymbol = TransformationSqlHelper.createGroupSymbol(eObj);
            if (gSymbol == null) continue;
            result.add(gSymbol);
        }
        return result;
    }

    public static IStoredProcedure createStoredProc(EObject eObj) {
        CoreArgCheck.isNotNull((Object)eObj);
        IStoredProcedure storedProc = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            eObj = sqlAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlProcedure(eObj)) {
            SqlColumnSetAspect rsAspect;
            List rsCols;
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)eObj);
            String procFullName = procedureAspect.getFullName(eObj);
            storedProc = TransformationSqlHelper.getQueryFactory().createStoredProcedure();
            storedProc.setProcedureName(procFullName);
            storedProc.setDisplayNamedParameters(true);
            List procParams = procedureAspect.getParameters(eObj);
            List spParams = TransformationSqlHelper.createSPParams(procParams);
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                storedProc.setParameter((ISPParameter)iter.next());
            }
            EObject results = (EObject)procedureAspect.getResult(eObj);
            if (SqlAspectHelper.isProcedureResultSet((EObject)results) && (rsCols = (rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)results)).getColumns(results)).size() > 0) {
                ISPParameter param = TransformationSqlHelper.getQueryFactory().createSPParameter(spParams.size(), ISPParameter.ParameterInfo.RESULT_SET, "RESULT");
                param.addResultSetColumn("RESULT", String.class, (Object)"RESULT");
                storedProc.setParameter(param);
            }
        }
        return storedProc;
    }

    public static IGroupSymbol createGroupSymbol(EObject groupEObj) {
        IGroupSymbol gSymbol = null;
        String aliasName = null;
        if (groupEObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)groupEObj;
            aliasName = sqlAlias.getAlias();
            groupEObj = sqlAlias.getAliasedObject();
        }
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            boolean hasResource = groupEObj.eResource() != null;
            String tableFullName = tableAspect.getName(groupEObj);
            if (hasResource) {
                tableFullName = tableAspect.getFullName(groupEObj);
            }
            String tableShortName = tableAspect.getName(groupEObj);
            Object groupID = null;
            if (hasResource) {
                groupID = TransformationSqlHelper.getGroupID(tableFullName, groupEObj);
            }
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(tableShortName) ? TransformationSqlHelper.getQueryFactory().createGroupSymbol(aliasName, tableFullName) : TransformationSqlHelper.getQueryFactory().createGroupSymbol(tableFullName);
            if (groupID != null) {
                gSymbol.setMetadataID(groupID);
            }
        } else if (groupEObj instanceof InputSet) {
            String inputSetFullName = "InputSet";
            String inputSetShortName = "InputSet";
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(inputSetShortName) ? TransformationSqlHelper.getQueryFactory().createGroupSymbol(aliasName, inputSetFullName) : TransformationSqlHelper.getQueryFactory().createGroupSymbol(inputSetFullName);
        } else if (SqlAspectHelper.isProcedure((EObject)groupEObj)) {
            SqlProcedureAspect procAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            String name = procAspect.getFullName(groupEObj);
            String shortName = procAspect.getName(groupEObj);
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(shortName) ? TransformationSqlHelper.getQueryFactory().createGroupSymbol(aliasName, name) : TransformationSqlHelper.getQueryFactory().createGroupSymbol(name);
        }
        return gSymbol;
    }

    private static Object getElementID(String elementFullName, EObject elmntObj) {
        ColumnRecordImpl elemID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)elmntObj);
        CoreArgCheck.isInstanceOf(SqlColumnAspect.class, (Object)sqlAspect);
        elemID = new ColumnRecordImpl((SqlColumnAspect)sqlAspect, elmntObj);
        return elemID;
    }

    private static Object getGroupID(String groupFullName, EObject grpObj) {
        TableRecordImpl groupID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)grpObj);
        CoreArgCheck.isInstanceOf(SqlTableAspect.class, (Object)sqlAspect);
        groupID = new TableRecordImpl((SqlTableAspect)sqlAspect, grpObj);
        return groupID;
    }

    private static IStoredProcedureInfo getProcInfo(String procFullName, EObject procObj) {
        IStoredProcedureInfo procInfo = null;
        try {
            IQueryMetadataInterface resolver = TransformationMetadataFactory.getInstance().getModelerMetadata(procObj);
            procInfo = resolver.getStoredProcedureInfoForProcedure(procFullName);
        }
        catch (Exception e) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e, message);
        }
        return procInfo;
    }

    private static List createElemSymbols(List sqlAliasGroups) {
        ArrayList result = new ArrayList();
        for (SqlAlias groupSqlAlias : sqlAliasGroups) {
            result.addAll(TransformationSqlHelper.createElemSymbols(groupSqlAlias));
        }
        return result;
    }

    public static List createElemSymbols(SqlAlias groupSqlAlias) {
        ArrayList<Object> result;
        block4: {
            EObject groupEObj;
            IGroupSymbol groupSymbol;
            block3: {
                result = new ArrayList<Object>();
                groupSymbol = TransformationSqlHelper.createGroupSymbol((EObject)groupSqlAlias);
                groupEObj = groupSqlAlias.getAliasedObject();
                if (!SqlAspectHelper.isTable((EObject)groupEObj)) break block3;
                SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
                List columns = tableAspect.getColumns(groupEObj);
                Iterator columnIter = columns.iterator();
                IExpression seSymbol = null;
                while (columnIter.hasNext()) {
                    EObject columnEObj = (EObject)columnIter.next();
                    seSymbol = TransformationSqlHelper.createElemSymbol(columnEObj, groupSymbol);
                    result.add(seSymbol);
                }
                break block4;
            }
            if (!SqlAspectHelper.isProcedure((EObject)groupEObj)) break block4;
            SqlProcedureAspect procAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            EObject procResultEObj = (EObject)procAspect.getResult(groupEObj);
            ArrayList allColumns = new ArrayList();
            if (procResultEObj != null) {
                SqlColumnSetAspect procResultAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect((EObject)procResultEObj);
                allColumns.addAll(procResultAspect.getColumns(procResultEObj));
            }
            allColumns.addAll(TransformationHelper.getInParameters(groupEObj));
            allColumns.addAll(TransformationHelper.getOutAndReturnParameters(groupEObj));
            List inout = TransformationHelper.getInoutParameters(groupEObj);
            allColumns.addAll(inout);
            for (EObject elemEObj : allColumns) {
                String type = TransformationHelper.getRuntimeType(elemEObj);
                IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
                Class clazz = service.getDataTypeClass(type);
                String paramName = TransformationHelper.getSqlEObjectName(elemEObj);
                IElementSymbol symbol = TransformationSqlHelper.getQueryFactory().createElementSymbol(String.valueOf(groupSymbol.getName()) + "." + paramName);
                symbol.setType(clazz);
                result.add(symbol);
                if (!inout.contains(elemEObj)) continue;
                symbol = TransformationSqlHelper.getQueryFactory().createElementSymbol(String.valueOf(groupSymbol.getName()) + "." + paramName + "_IN");
                symbol.setType(clazz);
                result.add(symbol);
            }
        }
        return result;
    }

    public static IExpression createElemSymbol(EObject elemEObj, IGroupSymbol parentGroupSymbol) {
        InputParameterSqlAspect aspect;
        IElementSymbol seSymbol = null;
        IDataTypeManagerService dataTypeService = ModelerCore.getTeiidDataTypeManagerService();
        Class nullClass = dataTypeService.getDefaultDataClass(IDataTypeManagerService.DataTypeName.NULL);
        String tableName = parentGroupSymbol.getName();
        if (tableName == null) {
            tableName = "";
        }
        String columnAliasName = null;
        if (elemEObj instanceof SqlAlias) {
            SqlAlias columnAlias = (SqlAlias)elemEObj;
            columnAliasName = columnAlias.getAlias();
            elemEObj = columnAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlInputParameter(elemEObj)) {
            aspect = (InputParameterSqlAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String fullName = String.valueOf(tableName) + "." + aspect.getName(elemEObj);
            IElementSymbol element = TransformationSqlHelper.getQueryFactory().createElementSymbol(fullName);
            element.setGroupSymbol(parentGroupSymbol);
            String rtType = aspect.getRuntimeType(elemEObj);
            if (rtType != null) {
                Class clazz = dataTypeService.getDataTypeClass(rtType);
                element.setMetadataID((Object)TransformationSqlHelper.getQueryFactory().createMetadataID(fullName.toUpperCase(), clazz));
                element.setType(clazz);
            } else {
                element.setMetadataID((Object)TransformationSqlHelper.getQueryFactory().createMetadataID(fullName.toUpperCase(), nullClass));
                element.setType(nullClass);
            }
            seSymbol = element;
        } else if (SqlAspectHelper.isColumn((EObject)elemEObj)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String colShortName = columnAspect.getName(elemEObj);
            String colUUID = TransformationHelper.getSqlEObjectUUID(elemEObj);
            Object elemID = TransformationSqlHelper.getElementID(colUUID, elemEObj);
            if (columnAliasName != null) {
                String rtType;
                IElementSymbol elemSymbol = TransformationSqlHelper.getQueryFactory().createElementSymbol(String.valueOf(tableName) + "." + colShortName);
                elemSymbol.setGroupSymbol(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.setMetadataID(elemID);
                }
                if ((rtType = columnAspect.getRuntimeType(elemEObj)) != null) {
                    Class clazz = dataTypeService.getDataTypeClass(rtType);
                    elemSymbol.setType(clazz);
                } else {
                    elemSymbol.setType(nullClass);
                }
                seSymbol = TransformationSqlHelper.getQueryFactory().createAliasSymbol(columnAliasName, (IExpression)elemSymbol);
            } else {
                String rtType;
                IElementSymbol elemSymbol = TransformationSqlHelper.getQueryFactory().createElementSymbol(String.valueOf(tableName) + "." + colShortName);
                elemSymbol.setGroupSymbol(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.setMetadataID(elemID);
                }
                if ((rtType = columnAspect.getRuntimeType(elemEObj)) != null) {
                    Class clazz = dataTypeService.getDataTypeClass(rtType);
                    elemSymbol.setType(clazz);
                } else {
                    elemSymbol.setType(nullClass);
                }
                seSymbol = elemSymbol;
            }
        } else if (TransformationHelper.isSqlProcedureParameter(elemEObj)) {
            aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String paramName = TransformationHelper.getSqlEObjectFullName(elemEObj);
            IElementSymbol element = TransformationSqlHelper.getQueryFactory().createElementSymbol(paramName);
            element.setGroupSymbol(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = dataTypeService.getDataTypeClass(rtType);
                    element.setMetadataID((Object)TransformationSqlHelper.getQueryFactory().createMetadataID(paramName.toUpperCase(), clazz));
                    element.setType(clazz);
                } else {
                    element.setMetadataID((Object)TransformationSqlHelper.getQueryFactory().createMetadataID(paramName.toUpperCase(), nullClass));
                    element.setType(nullClass);
                }
            } else {
                element.setMetadataID((Object)TransformationSqlHelper.getQueryFactory().createMetadataID(paramName.toUpperCase(), nullClass));
                element.setType(nullClass);
            }
            seSymbol = element;
        }
        return seSymbol;
    }

    public static List renameConflictingSymbols(List seSymbols) {
        ArrayList<IExpression> newSymbols = new ArrayList<IExpression>();
        Map renamedSymbolsMap = TransformationSqlHelper.getRenamedSymbolsMap(seSymbols);
        if (renamedSymbolsMap.size() != 0) {
            HashMap workingRenSymMap = new HashMap(renamedSymbolsMap);
            int i = 0;
            while (i < seSymbols.size()) {
                IExpression currentSelectSymbol = (IExpression)seSymbols.get(i);
                if (currentSelectSymbol instanceof IMultipleElementSymbol) {
                    boolean shouldExpand = TransformationSqlHelper.shouldExpand((IMultipleElementSymbol)currentSelectSymbol, workingRenSymMap);
                    if (shouldExpand) {
                        List multiElemSymbols = ((IMultipleElementSymbol)currentSelectSymbol).getElementSymbols();
                        Iterator iter = multiElemSymbols.iterator();
                        while (iter.hasNext()) {
                            IExpression renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((IExpression)iter.next(), workingRenSymMap);
                            newSymbols.add(renamedSymbol);
                        }
                    } else {
                        newSymbols.add(currentSelectSymbol);
                    }
                } else if (currentSelectSymbol != null && currentSelectSymbol instanceof IExpression) {
                    IExpression renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap(currentSelectSymbol, workingRenSymMap);
                    newSymbols.add(renamedSymbol);
                }
                ++i;
            }
        } else {
            newSymbols.addAll(seSymbols);
        }
        return newSymbols;
    }

    private static boolean shouldExpand(IMultipleElementSymbol multiElemSymbol, Map renamedSymbolsMap) {
        boolean shouldExpand = false;
        List multiElemSymbols = multiElemSymbol.getElementSymbols();
        Collection renamedSymbols = renamedSymbolsMap.values();
        Iterator iter = renamedSymbols.iterator();
        while (iter.hasNext()) {
            if (!multiElemSymbols.contains(iter.next())) continue;
            shouldExpand = true;
            break;
        }
        return shouldExpand;
    }

    private static IExpression renameSymbolUsingMap(IExpression seSymbol, Map renamedSymbolsMap) {
        IExpression resultSymbol = seSymbol;
        if (seSymbol != null) {
            for (String newName : renamedSymbolsMap.keySet()) {
                IExpression renamedSymbol = (IExpression)renamedSymbolsMap.get(newName);
                if (!renamedSymbol.equals(seSymbol)) continue;
                if (seSymbol instanceof IAliasSymbol) {
                    ((IAliasSymbol)seSymbol).setShortName(newName);
                    resultSymbol = seSymbol;
                } else {
                    resultSymbol = TransformationSqlHelper.getQueryFactory().createAliasSymbol(newName, seSymbol);
                }
                renamedSymbolsMap.remove(newName);
                break;
            }
        }
        return resultSymbol;
    }

    private static List createSPParams(List procParams) {
        ArrayList<ISPParameter> spparams = new ArrayList<ISPParameter>(procParams.size());
        int index = 0;
        int i = 0;
        while (i < procParams.size()) {
            EObject paramObject = (EObject)procParams.get(i);
            SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)paramObject);
            if (sqlAspect instanceof SqlProcedureParameterAspect) {
                SqlProcedureParameterAspect paramAspect = (SqlProcedureParameterAspect)sqlAspect;
                int direction = paramAspect.getType(paramObject);
                String name = paramAspect.getName(paramObject);
                switch (direction) {
                    case 0: {
                        ISPParameter spparam1 = TransformationSqlHelper.getQueryFactory().createSPParameter(index, (IExpression)TransformationSqlHelper.getQueryFactory().createElementSymbol(name));
                        spparam1.setName(name);
                        spparam1.setParameterType(ISPParameter.ParameterInfo.IN);
                        spparams.add(spparam1);
                        ++index;
                        break;
                    }
                    case 2: {
                        ISPParameter spparam2 = TransformationSqlHelper.getQueryFactory().createSPParameter(index, (IExpression)TransformationSqlHelper.getQueryFactory().createElementSymbol(name));
                        spparam2.setName(name);
                        spparam2.setParameterType(ISPParameter.ParameterInfo.INOUT);
                        spparams.add(spparam2);
                        ++index;
                        break;
                    }
                    case 1: {
                        ISPParameter spparam3 = TransformationSqlHelper.getQueryFactory().createSPParameter(index, (IExpression)TransformationSqlHelper.getQueryFactory().createElementSymbol(name));
                        spparam3.setName(name);
                        spparam3.setParameterType(ISPParameter.ParameterInfo.OUT);
                        spparams.add(spparam3);
                        ++index;
                        break;
                    }
                    case 3: {
                        ISPParameter spparam4 = TransformationSqlHelper.getQueryFactory().createSPParameter(index, (IExpression)TransformationSqlHelper.getQueryFactory().createElementSymbol(name));
                        spparam4.setName(name);
                        spparam4.setParameterType(ISPParameter.ParameterInfo.RETURN_VALUE);
                        spparams.add(spparam4);
                        ++index;
                    }
                }
            }
            ++i;
        }
        return spparams;
    }

    public static String getGroupSymbolShortName(IGroupSymbol gSymbol) {
        String shortName = null;
        if (gSymbol != null) {
            String symbolDefn = gSymbol.getDefinition();
            String symbolName = gSymbol.getName();
            if (symbolDefn != null) {
                shortName = symbolName;
            } else {
                EObject eObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                shortName = TransformationHelper.getSqlEObjectName(eObj);
            }
        }
        return shortName;
    }

    public static Collection<IGroupSymbol> getGroupSymbols(ICommand command) {
        IGroupCollectorVisitor groupCollectorVisitor = TransformationSqlHelper.getQueryService().getGroupCollectorVisitor(false);
        Collection allGrps = groupCollectorVisitor.findGroupsIgnoreInlineViews((ILanguageObject)command);
        ArrayList<IGroupSymbol> result = new ArrayList<IGroupSymbol>(allGrps.size());
        for (IGroupSymbol gSymbol : allGrps) {
            if (TransformationSqlHelper.containsGroupSymbol(result, gSymbol)) continue;
            result.add(gSymbol);
        }
        return result;
    }

    public static boolean containsGroupSymbol(Collection symbols, IGroupSymbol gSymbol) {
        boolean result = false;
        String gSymbName = gSymbol.getName();
        String gSymbDefn = gSymbol.getDefinition();
        for (IGroupSymbol listSymbol : symbols) {
            String lSymbName = listSymbol.getName();
            String lSymbDefn = listSymbol.getDefinition();
            if (lSymbDefn == null && gSymbDefn == null) {
                if (!lSymbName.equals(gSymbName)) continue;
                result = true;
                break;
            }
            if (lSymbDefn == null || gSymbDefn == null || !lSymbDefn.equalsIgnoreCase(gSymbDefn) || !lSymbName.equals(gSymbName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean containsElementSymbol(Collection symbols, IExpression eSymbol) {
        EObject referencedColumn = TransformationSqlHelper.getSingleElementSymbolEObject(eSymbol);
        for (IExpression next : symbols) {
            EObject nextReferencedEObject;
            if (eSymbol == next) {
                return true;
            }
            if (!TransformationSqlHelper.getQueryService().getSymbolName(eSymbol).equalsIgnoreCase(TransformationSqlHelper.getQueryService().getSymbolName(next))) continue;
            if (referencedColumn != null && (nextReferencedEObject = TransformationSqlHelper.getSingleElementSymbolEObject(next)) != null && nextReferencedEObject == referencedColumn) {
                return true;
            }
            return true;
        }
        return false;
    }

    public static EObject getSingleElementSymbolEObject(IExpression singleSymbol) {
        EObject referencedColumn = null;
        if (singleSymbol instanceof IAliasSymbol) {
            IExpression theSymbol = ((IAliasSymbol)singleSymbol).getSymbol();
            if (theSymbol instanceof IElementSymbol) {
                referencedColumn = TransformationSqlHelper.getElementSymbolEObject((IElementSymbol)theSymbol);
            }
        } else if (singleSymbol instanceof IElementSymbol) {
            referencedColumn = TransformationSqlHelper.getElementSymbolEObject((IElementSymbol)singleSymbol);
        }
        return referencedColumn;
    }

    public static int getReferenceCount(Object transMappingRoot, int type) {
        ICommand command = TransformationHelper.getCommand(transMappingRoot, type);
        int refCount = 0;
        if (command != null) {
            IReferenceCollectorVisitor referenceCollectorVisitor = TransformationSqlHelper.getQueryService().getReferenceCollectorVisitor();
            List refs = referenceCollectorVisitor.findReferences((ILanguageObject)command);
            refCount = refs.size();
        }
        return refCount;
    }

    public static EObject getElementSymbolEObject(IElementSymbol symbol) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.getMetadataID()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = (EObject)((MetadataRecord)elemObj).getEObject();
            } else if (TransformationHelper.isSqlColumn(elemObj)) {
                result = (EObject)elemObj;
            }
        }
        return result;
    }

    public static EObject getElementSymbolEObject(IElementSymbol symbol, ICommand command) {
        EObject result = null;
        if (symbol != null) {
            Object elemObj = symbol.getMetadataID();
            if (elemObj instanceof IMetadataID) {
                elemObj = ((IMetadataID)elemObj).getOriginalMetadataID();
            }
            if (elemObj instanceof MetadataRecord) {
                result = (EObject)((MetadataRecord)elemObj).getEObject();
            }
        }
        return result;
    }

    public static Object getElementSymbolType(IExpression symbol) {
        Class datatype = null;
        if (symbol instanceof IAliasSymbol) {
            symbol = ((IAliasSymbol)symbol).getSymbol();
        }
        if (symbol instanceof IElementSymbol) {
            IElementSymbol eSymbol = (IElementSymbol)symbol;
            Object idObj = eSymbol.getMetadataID();
            if (idObj instanceof MetadataRecord) {
                EObject recordEObj = (EObject)((MetadataRecord)idObj).getEObject();
                if (recordEObj != null && TransformationHelper.isSqlColumn(recordEObj)) {
                    SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)recordEObj);
                    datatype = columnAspect.getDatatype(recordEObj);
                }
            } else if (idObj instanceof IMetadataID) {
                datatype = ((IMetadataID)idObj).getType();
            } else if (idObj == null) {
                datatype = eSymbol.getType();
            }
        } else {
            datatype = symbol.getType();
        }
        return datatype;
    }

    public static int getElementSymbolLength(IExpression symbol) {
        IElementSymbol eSymbol;
        EObject eObj;
        int length = -1;
        if (symbol instanceof IAliasSymbol) {
            symbol = ((IAliasSymbol)symbol).getSymbol();
        }
        if (symbol instanceof IElementSymbol && (eObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol = (IElementSymbol)symbol)) != null) {
            length = TransformationHelper.getSqlColumnLength(eObj);
        }
        return length;
    }

    public static List<EObject> getElementSymbolEObjects(Collection elemSymbols, ICommand command) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (elemSymbols != null) {
            result = new ArrayList<EObject>(elemSymbols.size());
            for (IElementSymbol eSymbol : elemSymbols) {
                EObject elemEObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol, command);
                if (elemEObj == null) continue;
                result.add(elemEObj);
            }
        }
        return result;
    }

    public static EObject getGroupSymbolEObject(IGroupSymbol symbol) {
        Object groupObj;
        EObject result = null;
        if (symbol != null && (groupObj = symbol.getMetadataID()) != null) {
            if (symbol.isProcedure() && groupObj instanceof IMetadataID) {
                IMetadataID tid = (IMetadataID)groupObj;
                groupObj = tid.getOriginalMetadataID();
            }
            if (groupObj instanceof MetadataRecord) {
                result = (EObject)((MetadataRecord)groupObj).getEObject();
            } else if (TransformationHelper.isSqlProcedureResultSet(groupObj)) {
                result = (EObject)groupObj;
            }
        }
        return result;
    }

    public static List getGroupSymbolEObjects(Collection groupSymbols) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (groupSymbols != null) {
            result = new ArrayList<EObject>(groupSymbols.size());
            for (IGroupSymbol gSymbol : groupSymbols) {
                EObject grpEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                if (grpEObj == null) continue;
                result.add(grpEObj);
            }
        }
        return result;
    }

    public static EObject getStoredProcedureEObject(IStoredProcedure storedProc) {
        Object procID;
        EObject result = null;
        if (storedProc != null && (procID = storedProc.getProcedureID()) != null && procID instanceof MetadataRecord) {
            result = (EObject)((MetadataRecord)procID).getEObject();
        }
        return result;
    }

    public static boolean hasSqlAliasGroupAttributes(IQuery query, List sqlAliasGroups) {
        boolean result = false;
        List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(sqlAliasGroups);
        if (!TransformationSqlHelper.isSelectStar(query.getSelect())) {
            IGroupsUsedByElementsVisitor groupsUsedByElementsVisitor = TransformationSqlHelper.getQueryService().getGroupsUsedByElementsVisitor();
            IElementCollectorVisitor elementCollectorVisitor = TransformationSqlHelper.getQueryService().getElementCollectorVisitor(true);
            Collection selectElements = elementCollectorVisitor.findElements((ILanguageObject)query.getSelect());
            for (IElementSymbol selectElem : selectElements) {
                Set symbolGroups = groupsUsedByElementsVisitor.findGroups((ILanguageObject)selectElem);
                for (IGroupSymbol groupSymbol : symbolGroups) {
                    if (!aliasGroupSymbols.contains(groupSymbol)) continue;
                    result = true;
                    break;
                }
                if (result) break;
            }
        }
        return result;
    }

    public static boolean hasSqlElemSymbols(IQuery query, List elemEObjs) {
        boolean result = false;
        List<String> projSymbolNames = TransformationSqlHelper.getProjectedSymbolNames((ICommand)query);
        for (Object elem : elemEObjs) {
            SqlColumnAspect columnAspect;
            if (!(elem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)elem)) || !projSymbolNames.contains((columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)elem))).getName((EObject)elem))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isSelectStar(ISelect select) {
        IExpression singleSelectSymbol;
        boolean result = false;
        List currentSelectSymbols = select.getSymbols();
        if (currentSelectSymbols.size() == 1 && (singleSelectSymbol = (IExpression)currentSelectSymbols.get(0)) instanceof IMultipleElementSymbol) {
            result = true;
        }
        return result;
    }

    public static IExpressionSymbol convert(IExpressionSymbol exprSymbol, String newTypeName) {
        IExpressionSymbol newExpressionSymbol = (IExpressionSymbol)exprSymbol.clone();
        IExpression expr = exprSymbol.getExpression();
        Class originalTypeClass = expr.getType();
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        String originalTypeName = service.getDataTypeName(originalTypeClass);
        if (!originalTypeName.equalsIgnoreCase(newTypeName)) {
            if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
                IExpression convExpr = TransformationSqlHelper.getConvertedExpr(exprSymbol);
                Class convExprTypeClass = convExpr.getType();
                String convExprTypeName = service.getDataTypeName(convExprTypeClass);
                boolean isExplicit = service.isExplicitConversion(convExprTypeName, newTypeName);
                boolean isImplicit = service.isImplicitConversion(convExprTypeName, newTypeName);
                if (isExplicit || isImplicit) {
                    IFunction func = TransformationSqlHelper.getConversion(convExprTypeName, newTypeName, convExpr);
                    newExpressionSymbol.setExpression((IExpression)func);
                } else {
                    IFunction convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                    newExpressionSymbol.setExpression((IExpression)convertFunction);
                }
            } else {
                IFunction convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                newExpressionSymbol.setExpression((IExpression)convertFunction);
            }
        }
        return newExpressionSymbol;
    }

    public static IAliasSymbol convert(IElementSymbol elementSymbol, String newTypeName, String aliasName) {
        Class originalTypeClass = elementSymbol.getType();
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        String originalTypeName = service.getDataTypeName(originalTypeClass);
        IFunction convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, (IExpression)elementSymbol);
        IExpressionSymbol exprSymbol = TransformationSqlHelper.getQueryFactory().createExpressionSymbol(NEW_CONVERSION_NAME, (IExpression)convertFunction);
        IAliasSymbol newSymbol = null;
        newSymbol = aliasName != null ? TransformationSqlHelper.getQueryFactory().createAliasSymbol(aliasName, (IExpression)exprSymbol) : TransformationSqlHelper.getQueryFactory().createAliasSymbol(elementSymbol.getShortName(), (IExpression)exprSymbol);
        return newSymbol;
    }

    public static IFunction getConversion(String originalTypeName, String newTypeName, IExpression expression) {
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        IFunctionLibrary functionLibrary = UdfManager.getInstance().getFunctionLibrary();
        Class originalType = service.getDataTypeClass(originalTypeName);
        IFunctionLibrary library = UdfManager.getInstance().getFunctionLibrary();
        Class stringDataClass = service.getDefaultDataClass(IDataTypeManagerService.DataTypeName.STRING);
        IFunctionDescriptor fd = library.findFunction(functionLibrary.getFunctionName(IFunctionLibrary.FunctionName.CONVERT), new Class[]{originalType, stringDataClass});
        List<IExpression> expressions = Arrays.asList(expression, TransformationSqlHelper.getQueryFactory().createConstant((Object)newTypeName));
        IFunction conversion = TransformationSqlHelper.getQueryFactory().createFunction(fd.getName(), expressions);
        conversion.setType(service.getDataTypeClass(newTypeName));
        conversion.setFunctionDescriptor(fd);
        return conversion;
    }

    public static boolean isConvertFunction(IExpressionSymbol exprSymbol) {
        String fName;
        IExpression expr = exprSymbol.getExpression();
        return expr != null && expr instanceof IFunction && (fName = ((IFunction)expr).getName()).equalsIgnoreCase("CONVERT");
    }

    public static IExpression getConvertedExpr(IExpressionSymbol exprSymbol) {
        if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
            IExpression expr = exprSymbol.getExpression();
            IExpression fExp = ((IFunction)expr).getArg(0);
            return fExp;
        }
        return null;
    }

    public static IAliasSymbol convertElementSymbol(IElementSymbol symbol, String targetTypeStr, String aliasName) {
        return TransformationSqlHelper.convert(symbol, targetTypeStr, aliasName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IExpressionSymbol convertExpressionSymbol(IExpressionSymbol symbol, String targetTypeStr) {
        IAliasSymbol aSymbol;
        IExpression aseSymbol;
        if (!TransformationSqlHelper.isConvertFunction(symbol)) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        IExpression cExpr = TransformationSqlHelper.getConvertedExpr(symbol);
        if (cExpr == null || !(cExpr instanceof IExpression)) return null;
        IExpression seSymbol = cExpr;
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        String seSymbolTypeStr = service.getDataTypeName(seSymbol.getType());
        boolean isExplicitConv = service.isExplicitConversion(seSymbolTypeStr, targetTypeStr);
        boolean isImplicitConv = service.isImplicitConversion(seSymbolTypeStr, targetTypeStr);
        if (!isImplicitConv && !isExplicitConv) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        if (seSymbol instanceof IExpressionSymbol) {
            return TransformationSqlHelper.convertExpressionSymbol((IExpressionSymbol)seSymbol, targetTypeStr);
        }
        if (!(seSymbol instanceof IElementSymbol) || !((aseSymbol = (aSymbol = TransformationSqlHelper.convertElementSymbol((IElementSymbol)seSymbol, targetTypeStr, null)).getSymbol()) instanceof IExpressionSymbol)) return null;
        return (IExpressionSymbol)aseSymbol;
    }
}

