/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.query.sql.lang.ICommand;

public class SqlTransformationResult
implements QueryValidationResult {
    private boolean isParsable = false;
    private boolean isResolvable = false;
    private boolean isValidatable = false;
    private IStatus targetValidStatus = null;
    private String sqlString = null;
    private ICommand command = null;
    private Collection sourceGroups = Collections.EMPTY_LIST;
    private Collection<IStatus> statuses = null;
    private Collection<IStatus> updateStatuses = null;

    public SqlTransformationResult() {
    }

    public SqlTransformationResult(ICommand command, Collection<IStatus> statuses) {
        this.command = command;
        this.statuses = statuses;
        this.isParsable = command != null;
    }

    public SqlTransformationResult(ICommand command, Collection<IStatus> statuses, Collection<IStatus> updateStatuses) {
        this.command = command;
        this.statuses = statuses;
        this.updateStatuses = updateStatuses;
        this.isParsable = command != null;
    }

    public SqlTransformationResult(ICommand command, IStatus status) {
        this(command, new HashSet<IStatus>(1));
        if (status != null) {
            this.statuses.add(status);
        }
    }

    public void setParsable(boolean parsable) {
        this.isParsable = parsable;
    }

    public void setResolvable(boolean resolvable) {
        this.isResolvable = resolvable;
    }

    public void setValidatable(boolean validatable) {
        this.isValidatable = validatable;
    }

    public void setCommand(ICommand command) {
        this.command = command;
    }

    public void setSourceGroups(Collection sourceGroups) {
        if (sourceGroups != null) {
            this.sourceGroups = sourceGroups;
        }
    }

    public void setSqlString(String sqlString) {
        this.sqlString = sqlString;
    }

    public boolean isParsable() {
        return this.isParsable;
    }

    public boolean isResolvable() {
        return this.isResolvable;
    }

    public boolean isValidatable() {
        return this.isValidatable;
    }

    public boolean isTargetValid() {
        return this.targetValidStatus == null || this.targetValidStatus.isOK();
    }

    public IStatus getTargetValidStatus() {
        return this.targetValidStatus;
    }

    public ICommand getCommand() {
        return this.command;
    }

    public Collection getSourceGroups() {
        return this.sourceGroups;
    }

    public boolean hasSourceGroup(Object sourceGrp) {
        return this.sourceGroups != null && this.sourceGroups.contains(sourceGrp);
    }

    public boolean areSrcGroupMdlResourcesValid() {
        boolean isValid = true;
        if (this.sourceGroups == null || this.sourceGroups.isEmpty()) {
            isValid = false;
        } else {
            for (EObject sourceGrp : this.sourceGroups) {
                ModelResource mdlRsrc = ModelerCore.getModelEditor().findModelResource(sourceGrp);
                if (mdlRsrc != null && mdlRsrc.exists()) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public String getSqlString() {
        return this.sqlString;
    }

    public Collection<IStatus> getStatusList() {
        return this.statuses;
    }

    public Collection<IStatus> getUpdateStatusList() {
        return this.updateStatuses;
    }

    public void setTargetValidStatus(IStatus targetValidStatus) {
        this.targetValidStatus = targetValidStatus;
    }

    public boolean isOkToUpdate(int cmdType) {
        return this.getUpdateMaxSeverity(cmdType) < 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<IStatus> getUpdateStatusList(int cmdType) {
        if (this.getUpdateStatusList() == null || this.getUpdateStatusList().isEmpty()) {
            return this.getUpdateStatusList();
        }
        LinkedList<IStatus> cmdStatusList = new LinkedList<IStatus>();
        block5: for (IStatus status : this.getUpdateStatusList()) {
            int code = status.getCode();
            if (code != 699) {
                switch (cmdType) {
                    case 1: {
                        if (code == 700) break;
                        continue block5;
                    }
                    case 2: {
                        if (code == 701) break;
                        continue block5;
                    }
                    case 3: {
                        if (code != 702) continue block5;
                    }
                }
            }
            if (status.getSeverity() > 2) {
                cmdStatusList.addFirst(status);
                continue;
            }
            cmdStatusList.add(status);
        }
        return cmdStatusList;
    }

    public int getUpdateMaxSeverity(int cmdType) {
        if (this.getUpdateStatusList() == null || this.getUpdateStatusList().isEmpty()) {
            return 0;
        }
        int resultSeverity = 0;
        for (IStatus status : this.getUpdateStatusList(cmdType)) {
            if (status.getSeverity() <= resultSeverity) continue;
            resultSeverity = status.getSeverity();
        }
        return resultSeverity;
    }

    public int getMaxSeverity() {
        if (this.getStatusList() == null || this.getStatusList().isEmpty()) {
            return 0;
        }
        int resultSeverity = 0;
        for (IStatus status : this.getStatusList()) {
            if (status.getSeverity() <= resultSeverity) continue;
            resultSeverity = status.getSeverity();
        }
        return resultSeverity;
    }

    public String getFullMessage() {
        if (this.getStatusList() == null || this.getStatusList().isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean more = false;
        for (IStatus status : this.getStatusList()) {
            if (more) {
                sb.append('\n');
            }
            if (status.getSeverity() == 4) {
                sb.append("ERROR: ");
            } else if (status.getSeverity() == 2) {
                sb.append("WARNING: ");
            }
            sb.append(status.getMessage());
            more = true;
        }
        return sb.toString();
    }

    public String getUpdateFullMessage(int cmdType) {
        if (this.getUpdateStatusList(cmdType) == null || this.getUpdateStatusList(cmdType).isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean more = false;
        for (IStatus status : this.getUpdateStatusList(cmdType)) {
            if (more) {
                sb.append('\n');
            }
            if (status.getSeverity() == 4) {
                sb.append("ERROR: ");
            } else if (status.getSeverity() == 2) {
                sb.append("WARNING: ");
            }
            sb.append(status.getMessage());
            more = true;
        }
        return sb.toString();
    }
}

