/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.profiles.ldap.LDAPConnectionInfoProvider;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RelationalModelBuilder {
    private RelationalFactory factory = RelationalPackage.eINSTANCE.getRelationalFactory();
    private DatatypeManager datatypeManager = ModelerCore.getBuiltInTypesManager();
    private LDAPConnectionInfoProvider connProvider = new LDAPConnectionInfoProvider();

    private ModelResource createNewModelResource(IContainer modelLocation, String modelName) {
        if (!modelName.endsWith(".xmi")) {
            modelName = String.valueOf(modelName) + ".xmi";
        }
        Path modelPath = new Path(modelName);
        IFile modelFile = modelLocation.getFile((IPath)modelPath);
        ModelResource resource = ModelerCore.create((IFile)modelFile);
        return resource;
    }

    private void modelEntry(ILdapEntryNode entry, ModelResource entryModel) throws Exception {
        BaseTable entryTable = this.factory.createBaseTable();
        entryModel.getEmfResource().getContents().add((Object)entryTable);
        entryTable.setName(entry.getLabel());
        entryTable.setNameInSource(String.valueOf(entry.getSourceName()) + entry.getSourceNameSuffix());
        for (ILdapAttributeNode attribute : entry.getAttributes()) {
            Column attrColumn = this.factory.createColumn();
            entryTable.getColumns().add((Object)attrColumn);
            attrColumn.setName(attribute.getLabel());
            attrColumn.setNameInSource(attribute.getId());
            attrColumn.setNullValueCount(attribute.getNullValueCount());
            attrColumn.setDistinctValueCount(attribute.getDistinctValueCount());
            attrColumn.setLength(attribute.getMaximumValueLength());
            attrColumn.setType(this.datatypeManager.getBuiltInDatatype("string"));
            attrColumn.setNullable(NullableType.NULLABLE_UNKNOWN_LITERAL);
            attrColumn.setCaseSensitive(true);
            attrColumn.setRadix(0);
            attrColumn.setSigned(false);
        }
    }

    public ModelResource modelEntries(IContainer modelLocation, String modelName, IConnectionProfile connectionProfile, Collection<ILdapEntryNode> ldapModelEntries) throws Exception {
        final ModelResource entryModel = this.createNewModelResource(modelLocation, modelName);
        ModelAnnotation modelAnnotation = entryModel.getModelAnnotation();
        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
        for (ILdapEntryNode entry : ldapModelEntries) {
            this.modelEntry(entry, entryModel);
        }
        this.connProvider.setConnectionInfo(entryModel, connectionProfile);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    ModelUtilities.saveModelResource((ModelResource)entryModel, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                }
                catch (Exception e) {
                    ModelGeneratorLdapUiConstants.UTIL.log((Throwable)e);
                }
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        operation.run((IProgressMonitor)monitor);
        return entryModel;
    }
}

