/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;

public abstract class AbstractLdapContentProvider
implements ITreeContentProvider {
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    private static final String LDAP_AUTH_TYPE = "simple";
    private static final String LDAP_REFERRAL_MODE = "follow";
    private static Integer TIMEOUT = 3000;
    private InitialLdapContext ldapContext = null;
    private LdapImportWizardManager importManager;

    public AbstractLdapContentProvider(LdapImportWizardManager manager) {
        this.importManager = manager;
    }

    public LdapImportWizardManager getImportManager() {
        return this.importManager;
    }

    protected InitialLdapContext getLdapContext() throws NamingException {
        if (this.ldapContext == null) {
            IConnectionProfile profile = this.importManager.getConnectionProfile();
            Properties properties = profile.getBaseProperties();
            Hashtable<String, String> connenv = new Hashtable<String, String>();
            connenv.put("java.naming.factory.initial", properties.getProperty("LdapContextFactory"));
            connenv.put("java.naming.provider.url", properties.getProperty("LdapUrl"));
            connenv.put("java.naming.security.principal", properties.getProperty("LdapAdminUserDN"));
            connenv.put("java.naming.security.credentials", properties.getProperty("LdapAdminUserPassword"));
            connenv.put("java.naming.security.authentication", LDAP_AUTH_TYPE);
            connenv.put("java.naming.referral", LDAP_REFERRAL_MODE);
            connenv.put("com.sun.jndi.ldap.connect.timeout", TIMEOUT.toString());
            connenv.put("com.sun.jndi.ldap.connect.pool", "true");
            connenv.put("com.sun.jndi.ldap.connect.pool.debug", "fine");
            this.ldapContext = new InitialLdapContext(connenv, null);
        }
        return this.ldapContext;
    }

    public void dispose() {
        if (this.ldapContext != null) {
            try {
                this.ldapContext.close();
            }
            catch (NamingException namingException) {}
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

