/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BrowserConnection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.util.KeyInValueHashMap;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.datatools.profiles.ldap.LDAPConnectionFactory;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.modelgenerator.ldap.RelationalModelBuilder;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.ConnectionNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.LdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.LdapEntryNode;
import org.teiid.designer.runtime.spi.ITeiidServer;

public class LdapImportWizardManager
implements IChangeNotifier {
    private String sourceModelName;
    private boolean sourceModelExists;
    private IContainer sourceModelLocation;
    private String jbossJndiName;
    private boolean autoCreateDataSource = true;
    private IConnectionProfile connectionProfile;
    private BrowserConnection browserConnection;
    private Properties designerProperties;
    private Collection<IChangeListener> listeners;
    private Exception error = null;
    private boolean synchronising;
    private ConnectionNode connectionNode;
    private KeyInValueHashMap<Integer, ILdapEntryNode> ldapEntryNodes = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new LdapEntryKeyAdapter());

    public LdapImportWizardManager() {
        this.listeners = new ArrayList<IChangeListener>(5);
    }

    public void dispose() {
        if (this.browserConnection != null) {
            this.browserConnection.clearCaches();
            this.resetBrowserConnection();
        }
        if (this.connectionProfile != null) {
            this.connectionProfile.disconnect();
        }
    }

    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setConnectionProfile(IConnectionProfile connectionProfile) {
        if (this.connectionProfile == connectionProfile) {
            return;
        }
        this.connectionProfile = connectionProfile;
        this.resetBrowserConnection();
        this.notifyChanged();
    }

    public IBrowserConnection getBrowserConnection() {
        if (this.browserConnection == null) {
            if (this.connectionProfile == null) {
                return null;
            }
            LDAPConnectionFactory factory = new LDAPConnectionFactory();
            Connection connection = factory.convert(this.connectionProfile);
            this.browserConnection = new BrowserConnection(connection);
        }
        return this.browserConnection;
    }

    public void resetBrowserConnection() {
        Connection connection;
        if (this.browserConnection == null) {
            return;
        }
        this.browserConnection.clearCaches();
        if (this.browserConnection.getConnection() != null && (connection = this.browserConnection.getConnection()).getConnectionWrapper() != null) {
            connection.getConnectionWrapper().disconnect();
        }
        this.browserConnection = null;
    }

    public String getSourceModelName() {
        return this.sourceModelName;
    }

    public void setSourceModelName(String sourceModelName) {
        if (this.sourceModelName != null && this.sourceModelName.equals(sourceModelName)) {
            return;
        }
        this.sourceModelName = sourceModelName;
        this.notifyChanged();
    }

    public IContainer getSourceModelLocation() {
        return this.sourceModelLocation;
    }

    public void setSourceModelLocation(IContainer sourceModelLocation) {
        if (this.sourceModelLocation != null && this.sourceModelLocation.equals((Object)sourceModelLocation)) {
            return;
        }
        this.sourceModelLocation = sourceModelLocation;
        this.notifyChanged();
    }

    public void setSourceModelExists(boolean sourceModelExists) {
        if (this.sourceModelExists == sourceModelExists) {
            return;
        }
        this.sourceModelExists = sourceModelExists;
        this.notifyChanged();
    }

    public boolean sourceModelExists() {
        return this.sourceModelExists;
    }

    public ConnectionNode getConnectionNode() {
        if (this.connectionNode == null) {
            this.connectionNode = new ConnectionNode(this);
        }
        return this.connectionNode;
    }

    public ILdapEntryNode newEntry(ILdapEntryNode contextNode, IEntry entry) {
        LdapEntryNode newNode = new LdapEntryNode(contextNode, entry);
        ILdapEntryNode currNode = (ILdapEntryNode)this.ldapEntryNodes.get((Object)((Object)newNode).hashCode());
        if (currNode != null) {
            return currNode;
        }
        return newNode;
    }

    public boolean addEntry(ILdapEntryNode entryNode) {
        if (this.ldapEntryNodes.containsKey((Object)entryNode.hashCode())) {
            return false;
        }
        this.ldapEntryNodes.add((Object)entryNode);
        this.notifyChanged();
        return true;
    }

    public boolean removeEntry(ILdapEntryNode entryNode) {
        if (this.ldapEntryNodes.remove((Object)entryNode) != null) {
            this.notifyChanged();
            return true;
        }
        return false;
    }

    public boolean entrySelected(ILdapEntryNode entryNode) {
        return this.ldapEntryNodes.containsKey((Object)entryNode.hashCode());
    }

    public boolean hasSelectedEntries() {
        return this.ldapEntryNodes.isEmpty();
    }

    public Collection<ILdapEntryNode> getSelectedEntries() {
        return Collections.unmodifiableCollection(this.ldapEntryNodes.values());
    }

    public ILdapAttributeNode newAttribute(ILdapEntryNode contextNode, IAttribute attribute) {
        Collection<ILdapAttributeNode> attributeNodes;
        LdapAttributeNode newAttributeNode = new LdapAttributeNode(contextNode, attribute);
        ILdapEntryNode entryNode = (ILdapEntryNode)this.ldapEntryNodes.get((Object)contextNode.hashCode());
        if (entryNode == null) {
            entryNode = contextNode;
        }
        if ((attributeNodes = entryNode.getAttributes()).contains(newAttributeNode)) {
            for (ILdapAttributeNode attributeNode : attributeNodes) {
                if (!attributeNode.equals(newAttributeNode)) continue;
                return attributeNode;
            }
        }
        return newAttributeNode;
    }

    public void addAttribute(ILdapAttributeNode attribute) {
        ILdapEntryNode associatedEntry = attribute.getAssociatedEntry();
        if ((associatedEntry = (ILdapEntryNode)this.ldapEntryNodes.get((Object)associatedEntry.hashCode())) == null) {
            return;
        }
        associatedEntry.addAttribute(attribute);
        this.notifyChanged();
    }

    public void removeAttribute(ILdapAttributeNode attribute) {
        ILdapEntryNode associatedEntry = attribute.getAssociatedEntry();
        if ((associatedEntry = (ILdapEntryNode)this.ldapEntryNodes.get((Object)associatedEntry.hashCode())) == null) {
            return;
        }
        if (associatedEntry.removeAttribute(attribute)) {
            this.notifyChanged();
        }
    }

    public boolean attributeSelected(ILdapAttributeNode attribute) {
        ILdapEntryNode associatedEntry = attribute.getAssociatedEntry();
        if ((associatedEntry = (ILdapEntryNode)this.ldapEntryNodes.get((Object)associatedEntry.hashCode())) == null) {
            return false;
        }
        return associatedEntry.getAttributes().contains(attribute);
    }

    public boolean hasAttributesForEachSelectedEntry() {
        if (this.ldapEntryNodes.isEmpty()) {
            return false;
        }
        for (ILdapEntryNode entry : this.ldapEntryNodes.values()) {
            if (!entry.getAttributes().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<ILdapAttributeNode> getSelectedAttributes() {
        ArrayList<ILdapAttributeNode> allAttributes = new ArrayList<ILdapAttributeNode>();
        for (ILdapEntryNode entry : this.ldapEntryNodes.values()) {
            allAttributes.addAll(entry.getAttributes());
        }
        return Collections.unmodifiableCollection(allAttributes);
    }

    public void clearEntries() {
        this.ldapEntryNodes.clear();
        this.notifyChanged();
    }

    public void setDesignerProperties(Properties properties) {
        this.designerProperties = properties;
    }

    public Properties getDesignerProperties() {
        return this.designerProperties;
    }

    public void setDesignerProperty(String key, String value) {
        if (this.designerProperties != null) {
            this.designerProperties.put(key, value);
        }
    }

    void createModel() {
        RelationalModelBuilder modelBuilder = new RelationalModelBuilder();
        try {
            ModelResource model = modelBuilder.modelEntries(this.getSourceModelLocation(), this.getSourceModelName(), this.getConnectionProfile(), this.getSelectedEntries());
            String jndiName = this.getJBossJndiName();
            if (!StringUtilities.isEmpty((String)jndiName)) {
                ConnectionInfoHelper helper = new ConnectionInfoHelper();
                helper.setJNDIName(model, jndiName);
            }
            this.handleCreateDataSource(model);
        }
        catch (Exception e) {
            ModelGeneratorLdapUiConstants.UTIL.log((Throwable)e);
        }
    }

    public void notifyChanged() {
        if (this.isSynchronising()) {
            return;
        }
        for (IChangeListener listener : this.listeners) {
            listener.stateChanged((IChangeNotifier)this);
        }
    }

    public void addChangeListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }

    public Exception getError() {
        return this.error;
    }

    public void notifyError(Exception error) {
        this.error = error;
        this.notifyChanged();
        this.error = null;
    }

    public boolean isSynchronising() {
        return this.synchronising;
    }

    public void setSynchronising(boolean synchronising) {
        this.synchronising = synchronising;
    }

    public String getJBossJndiName() {
        return this.jbossJndiName;
    }

    public void setJBossJndiNameName(String jndiName) {
        this.jbossJndiName = jndiName;
    }

    public boolean doCreateDataSource() {
        return this.autoCreateDataSource;
    }

    public void setCreateDataSource(boolean value) {
        this.autoCreateDataSource = value;
    }

    protected void handleCreateDataSource(ModelResource model) {
        if (this.doCreateDataSource() && DataSourceConnectionHelper.isServerConnected()) {
            ITeiidServer teiidServer = DataSourceConnectionHelper.getServer();
            String dsName = this.getJBossJndiName();
            String jndiName = this.getJBossJndiName();
            DataSourceConnectionHelper helper = new DataSourceConnectionHelper(model, this.getConnectionProfile());
            Properties connProps = helper.getModelConnectionProperties();
            String dsType = helper.getDataSourceType();
            try {
                teiidServer.getOrCreateDataSource(dsName, jndiName, dsType, connProps);
            }
            catch (Exception e) {
                DatatoolsUiConstants.UTIL.log((Throwable)e);
            }
        }
    }

    private class LdapEntryKeyAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<Integer, ILdapEntryNode> {
        private LdapEntryKeyAdapter() {
        }

        public Integer getKey(ILdapEntryNode value) {
            return value.hashCode();
        }
    }
}

