/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;

public class ConnectionNode
implements ILdapEntryNode {
    private final LdapImportWizardManager manager;
    private final String context;

    public ConnectionNode(LdapImportWizardManager manager) {
        this.manager = manager;
        IConnectionProfile connectionProfile = manager.getConnectionProfile();
        Properties properties = connectionProfile.getBaseProperties();
        this.context = properties.getProperty("LdapUrl");
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public IEntry getEntry() {
        return this.manager.getBrowserConnection().getRootDSE();
    }

    @Override
    public ILdapEntryNode getParent() {
        return null;
    }

    @Override
    public Object[] getChildren() {
        return this.manager.getSelectedEntries().toArray();
    }

    @Override
    public boolean hasChildren() {
        return !this.manager.getSelectedEntries().isEmpty();
    }

    @Override
    public String getSourceName() {
        return this.context;
    }

    @Override
    public String getSourceBaseName() {
        return this.context;
    }

    @Override
    public String getLabel() {
        return this.context;
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public String getSourceNameSuffix() {
        return "";
    }

    @Override
    public void setSourceNameSuffix(String tableNameSuffix) {
    }

    @Override
    public boolean addAttribute(ILdapAttributeNode attribute) {
        return false;
    }

    @Override
    public boolean removeAttribute(ILdapAttributeNode attribute) {
        return false;
    }

    @Override
    public Collection<ILdapAttributeNode> getAttributes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionNode other = (ConnectionNode)obj;
        return !(this.context == null ? other.context != null : !this.context.equals(other.context));
    }
}

