/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;

public class LdapEntryNode
implements ILdapEntryNode {
    private final ILdapEntryNode parent;
    private final IEntry entry;
    private String label;
    private String sourceNameSuffix = "";
    private final Set<ILdapAttributeNode> attributes = new HashSet<ILdapAttributeNode>();

    public LdapEntryNode(ILdapEntryNode parent, IEntry entry) {
        this.parent = parent;
        this.entry = entry;
        this.setLabel(this.getSourceBaseName());
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ILdapEntryNode getParent() {
        return this.parent;
    }

    @Override
    public IEntry getEntry() {
        return this.entry;
    }

    @Override
    public Object[] getChildren() {
        return new Object[0];
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public String getSourceBaseName() {
        return this.entry.getRdn().getName();
    }

    @Override
    public String getSourceName() {
        return this.entry.getDn().getName();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getSourceNameSuffix() {
        return this.sourceNameSuffix;
    }

    @Override
    public void setSourceNameSuffix(String sourceNameSuffix) {
        this.sourceNameSuffix = sourceNameSuffix;
    }

    @Override
    public boolean addAttribute(ILdapAttributeNode attribute) {
        return this.attributes.add(attribute);
    }

    @Override
    public boolean removeAttribute(ILdapAttributeNode attribute) {
        return this.attributes.remove(attribute);
    }

    @Override
    public Collection<ILdapAttributeNode> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapEntryNode other = (LdapEntryNode)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
    }
}

