/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns;

import java.util.HashMap;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.AbstractLdapContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;

public class LdapEntryContentProvider
extends AbstractLdapContentProvider {
    public LdapEntryContentProvider(LdapImportWizardManager manager) {
        super(manager);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.getImportManager());
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LdapImportWizardManager) {
            return this.getImportManager().getSelectedEntries().toArray();
        }
        if (parentElement instanceof ILdapEntryNode) {
            IEntry[] children;
            ILdapEntryNode parentNode = (ILdapEntryNode)parentElement;
            IEntry entry = parentNode.getEntry();
            if (!entry.isChildrenInitialized()) {
                NullProgressMonitor ipm = new NullProgressMonitor();
                StudioProgressMonitor monitor = new StudioProgressMonitor((IProgressMonitor)ipm);
                try {
                    ConnectionEventRegistry.suspendEventFiringInCurrentThread();
                    InitializeChildrenRunnable runnable = new InitializeChildrenRunnable(true, new IEntry[]{entry});
                    runnable.run(monitor);
                }
                finally {
                    ConnectionEventRegistry.resumeEventFiringInCurrentThread();
                }
            }
            if ((children = entry.getChildren()) == null || children.length == 0) {
                return EMPTY_ARRAY;
            }
            HashMap<Integer, ILdapAttributeNode> childAttributes = new HashMap<Integer, ILdapAttributeNode>();
            IEntry[] iEntryArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IEntry child = iEntryArray[n2];
                if (!child.isAttributesInitialized()) {
                    NullProgressMonitor ipm = new NullProgressMonitor();
                    StudioProgressMonitor monitor = new StudioProgressMonitor((IProgressMonitor)ipm);
                    try {
                        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
                        InitializeAttributesRunnable.initializeAttributes((IEntry)child, (StudioProgressMonitor)monitor);
                    }
                    finally {
                        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
                    }
                }
                IAttribute[] iAttributeArray = child.getAttributes();
                int n3 = iAttributeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IValue[] values;
                    IAttribute attribute = iAttributeArray[n4];
                    ILdapAttributeNode newAttribute = this.getImportManager().newAttribute(parentNode, attribute);
                    ILdapAttributeNode childAttribute = (ILdapAttributeNode)childAttributes.get(newAttribute.hashCode());
                    if (childAttribute == null) {
                        childAttributes.put(newAttribute.hashCode(), newAttribute);
                        childAttribute = newAttribute;
                    }
                    if ((values = attribute.getValues()).length == 0) {
                        childAttribute.incrementNullValueCount();
                    } else {
                        IValue[] iValueArray = values;
                        int n5 = values.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IValue value = iValueArray[n6];
                            childAttribute.addValue(value);
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            return childAttributes.values().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ILdapAttributeNode) {
            return ((ILdapAttributeNode)element).getAssociatedEntry();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ILdapEntryNode;
    }
}

