/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserQuickSearchWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserUniversalListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchResult;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiPlugin;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizard;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapPageUtils;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.ConnectionNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table.LdapConnectionContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table.LdapConnectionLabelProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;

public class LdapTablesPage
extends WizardPage
implements IChangeListener,
ModelGeneratorLdapUiConstants,
ModelGeneratorLdapUiConstants.Images,
ModelGeneratorLdapUiConstants.HelpContexts,
StringConstants {
    private static final int[] SPLITTER_WEIGHTS = new int[]{50, 50};
    private final LdapImportWizardManager importManager;
    private SashForm splitter;
    private Text tableNameText;
    private Text tableSourceNameText;
    private Text tableSourceSuffixText;
    private Button validateButton;
    private boolean dirty;
    private BrowserWidget widget;
    private BrowserUniversalListener universalListener;
    private TreeViewer entryViewer;
    private LdapConnectionContentProvider entryContentProvider;
    private LdapConnectionLabelProvider entryLabelProvider;

    public LdapTablesPage(LdapImportWizardManager theImportManager) {
        super(LdapTablesPage.class.getSimpleName(), LdapTablesPage.getString("title", new Object[0]), null);
        this.importManager = theImportManager;
        this.setDescription(LdapTablesPage.getString("description", new Object[0]));
        this.setImageDescriptor(LdapImportWizard.BANNER);
        this.importManager.addChangeListener(this);
    }

    private static String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(LdapTablesPage.class.getSimpleName()) + "_" + key, properties);
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void dispose() {
        super.dispose();
        this.universalListener.dispose();
        this.widget.dispose();
        this.entryViewer.getTree().dispose();
        this.entryContentProvider.dispose();
        this.entryLabelProvider.dispose();
    }

    private void nodeSelected(ILdapEntryNode node) {
        if (node.isRoot()) {
            this.tableNameText.setText("");
            this.tableNameText.setEditable(false);
            this.tableSourceNameText.setText("");
            this.tableSourceSuffixText.setText("");
            this.tableSourceSuffixText.setEditable(false);
        } else {
            this.tableNameText.setText(node.getLabel());
            this.tableNameText.setEditable(true);
            this.tableSourceNameText.setText(node.getSourceName());
            this.tableSourceSuffixText.setText(node.getSourceNameSuffix());
            this.tableSourceSuffixText.setEditable(true);
        }
    }

    private void addNode(ILdapEntryNode entryNode) {
        if (entryNode == null || entryNode.isRoot()) {
            return;
        }
        this.importManager.setSynchronising(true);
        boolean entryAdded = this.importManager.addEntry(entryNode);
        if (!entryAdded) {
            return;
        }
        this.entryViewer.refresh();
        this.entryViewer.setExpandedElements(new Object[]{this.importManager.getConnectionNode()});
        this.setDirty(true);
        this.importManager.setSynchronising(false);
        this.setPageStatus();
    }

    private void removeNode(ILdapEntryNode entryNode) {
        if (entryNode == null || entryNode.isRoot()) {
            return;
        }
        this.importManager.setSynchronising(true);
        boolean entryRemoved = this.importManager.removeEntry(entryNode);
        if (!entryRemoved) {
            return;
        }
        this.entryViewer.refresh();
        ConnectionNode connectionNode = this.importManager.getConnectionNode();
        this.entryViewer.setExpandedElements(new Object[]{connectionNode});
        this.entryViewer.setSelection((ISelection)new StructuredSelection((Object)connectionNode));
        this.setDirty(true);
        this.importManager.setSynchronising(false);
        this.setPageStatus();
    }

    private void createEntriesView(Composite parent) {
        ToolBar bar = new ToolBar(parent, 0x800000);
        ToolBarManager toolbarManager = new ToolBarManager(bar);
        Action deleteAction = new Action(){

            public String getToolTipText() {
                return LdapTablesPage.getString("deleteTooltip", new Object[0]);
            }

            public ImageDescriptor getImageDescriptor() {
                return ModelGeneratorLdapUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/delete.gif");
            }

            public void run() {
                ISelection selection = LdapTablesPage.this.entryViewer.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sselection = (IStructuredSelection)selection;
                for (Object next : sselection) {
                    ILdapEntryNode entryNode;
                    if (!(next instanceof ILdapEntryNode) || (entryNode = (ILdapEntryNode)next).isRoot()) continue;
                    LdapTablesPage.this.removeNode(entryNode);
                }
            }
        };
        toolbarManager.add((IAction)deleteAction);
        toolbarManager.update(true);
        this.entryContentProvider = new LdapConnectionContentProvider(this.importManager);
        this.entryLabelProvider = new LdapConnectionLabelProvider(this.importManager);
        this.entryViewer = new TreeViewer(parent, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.entryViewer.getTree());
        this.entryViewer.setUseHashlookup(true);
        this.entryViewer.setContentProvider((IContentProvider)this.entryContentProvider);
        this.entryViewer.setLabelProvider((IBaseLabelProvider)this.entryLabelProvider);
        this.entryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sselection = (IStructuredSelection)selection;
                LdapTablesPage.this.importManager.setSynchronising(true);
                try {
                    for (Object object : sselection) {
                        if (!(object instanceof ILdapEntryNode)) continue;
                        LdapTablesPage.this.nodeSelected((ILdapEntryNode)object);
                    }
                }
                finally {
                    LdapTablesPage.this.importManager.setSynchronising(false);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0){

            public Point computeSize(int widthHint, int heightHint, boolean changed) {
                Point size = super.computeSize(widthHint, heightHint, changed);
                size.x = 800;
                return size;
            }
        };
        GridLayoutFactory.fillDefaults().applyTo(pg);
        this.setControl((Control)pg);
        this.splitter = WidgetFactory.createSplitter((Composite)pg);
        Group widgetComposite = new Group((Composite)this.splitter, 2048);
        widgetComposite.setText(LdapTablesPage.getString("directoryTitle", new Object[0]));
        widgetComposite.setFont(JFaceResources.getBannerFont());
        GridLayoutFactory.fillDefaults().margins(10, 5).applyTo((Composite)widgetComposite);
        BrowserConfiguration configuration = new BrowserConfiguration();
        this.widget = new BrowserWidget(configuration, null);
        this.widget.createWidget((Composite)widgetComposite);
        BrowserQuickSearchWidget quickSearchWidget = this.widget.getQuickSearchWidget();
        quickSearchWidget.setActive(true);
        this.universalListener = new BrowserUniversalListener(this.widget);
        Action refreshAction = new Action(){

            public String getToolTipText() {
                return LdapTablesPage.getString("refreshTooltip", new Object[0]);
            }

            public ImageDescriptor getImageDescriptor() {
                return ModelGeneratorLdapUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/refresh.gif");
            }

            public void run() {
                if (LdapTablesPage.this.widget == null || LdapTablesPage.this.widget.getViewer() == null) {
                    return;
                }
                LdapTablesPage.this.widget.getViewer().refresh();
            }
        };
        final Action addAction = new Action(){

            public String getToolTipText() {
                return LdapTablesPage.getString("addTooltip", new Object[0]);
            }

            public ImageDescriptor getImageDescriptor() {
                return ModelGeneratorLdapUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/add.gif");
            }

            public void run() {
                ISelection selection = LdapTablesPage.this.widget.getViewer().getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sselection = (IStructuredSelection)selection;
                for (Object next : sselection) {
                    if (next instanceof SearchResult) {
                        next = ((SearchResult)next).getEntry();
                    }
                    if (!(next instanceof IEntry)) continue;
                    IEntry entry = (IEntry)next;
                    ConnectionNode connectionNode = LdapTablesPage.this.importManager.getConnectionNode();
                    ILdapEntryNode node = LdapTablesPage.this.importManager.newEntry(connectionNode, entry);
                    LdapTablesPage.this.addNode(node);
                }
            }
        };
        this.widget.getToolBarManager().add((IAction)refreshAction);
        this.widget.getToolBarManager().add((IAction)addAction);
        this.widget.getToolBarManager().update(true);
        this.widget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                addAction.run();
            }
        });
        this.widget.getInfoText().setVisible(false);
        ViewForm composite = (ViewForm)this.widget.getControl();
        composite.setTopRight(null);
        Group selectedComposite = new Group((Composite)this.splitter, 2048);
        selectedComposite.setText(LdapTablesPage.getString("selectedEntryTitle", new Object[0]));
        selectedComposite.setFont(JFaceResources.getBannerFont());
        GridLayoutFactory.fillDefaults().margins(10, 5).applyTo((Composite)selectedComposite);
        this.createEntriesView((Composite)selectedComposite);
        Group detailsGroup = WidgetFactory.createGroup((Composite)selectedComposite, (String)LdapTablesPage.getString("tableAttributesTitle", new Object[0]), (int)0, (int)2);
        LdapPageUtils.setBackground((Control)detailsGroup, (Composite)selectedComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)detailsGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)detailsGroup);
        Label tableNameLabel = new Label((Composite)detailsGroup, 0);
        tableNameLabel.setText(LdapTablesPage.getString("detailTableNameLabel", new Object[0]));
        this.tableNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableNameText);
        this.tableNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LdapTablesPage.this.setDirty(true);
                IStructuredSelection selection = (IStructuredSelection)LdapTablesPage.this.entryViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ILdapEntryNode node = (ILdapEntryNode)selection.getFirstElement();
                String tblNameText = LdapTablesPage.this.tableNameText.getText();
                if (!tblNameText.equals(node.getLabel())) {
                    node.setLabel(tblNameText);
                }
            }
        });
        Label tableSourceNameLabel = new Label((Composite)detailsGroup, 0);
        tableSourceNameLabel.setText(LdapTablesPage.getString("detailTableSourceNameLabel", new Object[0]));
        this.tableSourceNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableSourceNameText);
        LdapPageUtils.blueForeground((Control)this.tableSourceNameText);
        LdapPageUtils.setBackground((Control)this.tableSourceNameText, (Composite)detailsGroup);
        this.tableSourceNameText.setEditable(false);
        Label tableSourceSuffixLabel = new Label((Composite)detailsGroup, 0);
        tableSourceSuffixLabel.setText(LdapTablesPage.getString("detailTableSourceSuffixLabel", new Object[0]));
        tableSourceSuffixLabel.setToolTipText(LdapTablesPage.getString("detailTableSourceSuffixToolTip", new Object[0]));
        this.tableSourceSuffixText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableSourceSuffixText);
        this.tableSourceSuffixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LdapTablesPage.this.setDirty(true);
                IStructuredSelection selection = (IStructuredSelection)LdapTablesPage.this.entryViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ILdapEntryNode node = (ILdapEntryNode)selection.getFirstElement();
                String tableSuffixText = LdapTablesPage.this.tableSourceSuffixText.getText();
                if (!tableSuffixText.equals(node.getLabel())) {
                    node.setSourceNameSuffix(tableSuffixText);
                }
            }
        });
        this.validateButton = new Button((Composite)detailsGroup, 8);
        this.validateButton.setText(LdapTablesPage.getString("validateButtonLabel", new Object[0]));
        GridDataFactory.swtDefaults().span(2, 1).align(3, 2).applyTo((Control)this.validateButton);
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapTablesPage.this.setDirty(false);
                LdapTablesPage.this.notifyChanged();
            }
        });
        this.splitter.setWeights(SPLITTER_WEIGHTS);
        this.splitter.setSashWidth(20);
    }

    private void setPageStatus() {
        if (this.getControl() != null && !this.getControl().isVisible()) {
            return;
        }
        if (this.isDirty()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapTablesPage.getString("needsValidating", new Object[0]), (int)3);
            return;
        }
        if (this.importManager.getError() != null) {
            ModelGeneratorLdapUiConstants.UTIL.log((Throwable)this.importManager.getError());
            WizardUtil.setPageComplete((WizardPage)this, (String)this.importManager.getError().getLocalizedMessage(), (int)3);
            return;
        }
        if (this.importManager.hasSelectedEntries()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapTablesPage.getString("noSourceModelTables", new Object[0]), (int)3);
            return;
        }
        for (ILdapEntryNode entry : this.importManager.getSelectedEntries()) {
            String suffix = entry.getSourceNameSuffix();
            if (suffix.length() == 0) continue;
            int qmarks = 0;
            int i = 0;
            while (i < suffix.length()) {
                char c = suffix.charAt(i);
                if (c == '?') {
                    ++qmarks;
                }
                ++i;
            }
            if (qmarks == 2) continue;
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapTablesPage.getString("invalidSourceNameSuffix", new Object[0]), (int)3);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.importManager.getConnectionProfile() == null) {
            return;
        }
        this.entryViewer.setInput((Object)this.importManager);
        this.initBrowserWidget();
        this.setPageStatus();
    }

    private void initBrowserWidget() {
        if (this.widget == null) {
            return;
        }
        if (this.widget.getViewer() == null) {
            return;
        }
        IBrowserConnection browserConnection = this.importManager.getBrowserConnection();
        if (browserConnection == null) {
            return;
        }
        if (browserConnection.equals(this.widget.getViewer().getInput())) {
            return;
        }
        this.widget.setInput((Object)browserConnection);
        BrowserQuickSearchWidget quickSearchWidget = this.widget.getQuickSearchWidget();
        quickSearchWidget.setInput(browserConnection);
        BrowserCommonActivator.getDefault().getPreferenceStore().setValue("browserShowBookmarks", false);
        BrowserCommonActivator.getDefault().getPreferenceStore().setValue("browserShowSearches", false);
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.initBrowserWidget();
        this.setPageStatus();
    }

    private void notifyChanged() {
        this.importManager.notifyChanged();
    }
}

