/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.fusesource.ide.camel.model.service.core.CamelSchemaProvider;
import org.fusesource.ide.camel.model.service.core.ICamelManagerService;
import org.fusesource.ide.camel.model.service.core.adopters.CamelModelLoader;
import org.fusesource.ide.camel.model.service.core.adopters.XmlCamelModelLoader;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.internal.CamelServiceImplementationActivator;

public class CamelService
implements ICamelManagerService {
    private CamelModelLoader loader;
    private CamelCatalog catalog;
    private static final String CATALOG_FOLDER = "catalogs";
    private static final String COMPONENTS_FILENAME = "components.xml";
    private static final String EIPS_FILENAME = "eips.xml";
    private static final String LANGUAGES_FILENAME = "languages.xml";
    private static final String DATAFORMATS_FILENAME = "dataformats.xml";
    private static final String COMPONENTS_CATALOG_FILE = String.format("%s/%s", "catalogs", "components.xml");
    private static final String EIPS_CATALOG_FILE = String.format("%s/%s", "catalogs", "eips.xml");
    private static final String LANGUAGES_CATALOG_FILE = String.format("%s/%s", "catalogs", "languages.xml");
    private static final String DATAFORMATS_CATALOG_FILE = String.format("%s/%s", "catalogs", "dataformats.xml");

    public CamelModel getCamelModel() {
        if (this.loader == null) {
            this.loader = new XmlCamelModelLoader();
        }
        try {
            return this.loader.getCamelModel(this.getComponentModelURL(), this.getEipModelURL(), this.getLanguageModelURL(), this.getDataFormatModelURL());
        }
        catch (IOException ex) {
            CamelServiceImplementationActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }

    public CamelSchemaProvider getCamelSchemaProvider() {
        if (this.catalog == null) {
            this.catalog = new DefaultCamelCatalog();
        }
        return new CamelSchemaProvider(this.catalog.blueprintSchemaAsXml(), this.catalog.springSchemaAsXml());
    }

    public String createEndpointUri(String scheme, Map<String, String> properties) throws URISyntaxException {
        if (this.catalog == null) {
            this.catalog = new DefaultCamelCatalog();
        }
        return this.catalog.asEndpointUri(scheme, properties);
    }

    public String createEndpointUri(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        if (this.catalog == null) {
            this.catalog = new DefaultCamelCatalog();
        }
        return this.catalog.asEndpointUri(scheme, properties);
    }

    public Map<String, String> getEndpointProperties(String uri) throws URISyntaxException {
        if (this.catalog == null) {
            this.catalog = new DefaultCamelCatalog();
        }
        return this.catalog.endpointProperties(uri);
    }

    public String createEndpointXml(String scheme, Map<String, String> properties) throws URISyntaxException {
        return null;
    }

    public String createEndpointXml(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return null;
    }

    public String getEndpointScheme(String uri) {
        return null;
    }

    public String testExpression(String language, String expression) {
        String result;
        block11: {
            result = null;
            DefaultCamelContext ctx = new DefaultCamelContext();
            try {
                try {
                    ctx.resolveLanguage(language).createPredicate(expression.replaceAll("\n", "").replaceAll("\r", "").trim());
                    result = null;
                }
                catch (Exception ex) {
                    result = ex.getMessage();
                    try {
                        ctx.shutdown();
                    }
                    catch (Exception exception) {}
                    ctx = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ctx.shutdown();
                }
                catch (Exception exception) {}
                ctx = null;
                throw throwable;
            }
            try {
                ctx.shutdown();
            }
            catch (Exception exception) {}
            ctx = null;
        }
        return result;
    }

    public long durationToMillis(String duration) throws IllegalArgumentException {
        return TimePatternConverter.toMilliSeconds((String)duration);
    }

    private URL getComponentModelURL() {
        return CamelServiceImplementationActivator.getDefault().getBundle().getEntry(COMPONENTS_CATALOG_FILE);
    }

    private URL getEipModelURL() {
        return CamelServiceImplementationActivator.getDefault().getBundle().getEntry(EIPS_CATALOG_FILE);
    }

    private URL getDataFormatModelURL() {
        return CamelServiceImplementationActivator.getDefault().getBundle().getEntry(DATAFORMATS_CATALOG_FILE);
    }

    private URL getLanguageModelURL() {
        return CamelServiceImplementationActivator.getDefault().getBundle().getEntry(LANGUAGES_CATALOG_FILE);
    }
}

