/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl;

import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.xslt.StyleFromResource;
import org.teiid.designer.core.xslt.StyleFromUrlStream;
import org.teiid.designer.core.xslt.StyleRegistry;
import org.teiid.designer.core.xslt.impl.StyleRegistryImpl;
import org.teiid.designer.ddl.DdlWriter;
import org.teiid.designer.ddl.DdlWriterImpl;

public class DdlPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.ddl";
    public static final String PACKAGE_ID = DdlPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final PluginUtil Util = new PluginUtilImpl("org.teiid.designer.ddl", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    public static final String DELIMITER = ".";
    static DdlPlugin INSTANCE = null;
    public static boolean DEBUG = false;
    private static final StyleRegistry STYLE_REGISTRY = new StyleRegistryImpl();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        INSTANCE = this;
        DdlPlugin.loadStyleRegistryFromExtensions(STYLE_REGISTRY);
    }

    public static DdlPlugin getInstance() {
        return INSTANCE;
    }

    public DdlWriter createDdlWriter() {
        return new DdlWriterImpl();
    }

    public static StyleRegistry getStyleRegistry() {
        return STYLE_REGISTRY;
    }

    protected static void loadStyleRegistryFromExtensions(StyleRegistry registry) {
        IExtensionPoint ddlStyleXP = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "style");
        IExtension[] extensions = ddlStyleXP.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String extensionName = extension.getLabel();
            String desc = null;
            String xsltPath = null;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                String elementName = element.getName();
                if ("description".equals(elementName)) {
                    desc = element.getValue();
                } else if ("xsltPath".equals(elementName)) {
                    xsltPath = element.getValue();
                }
                ++j;
            }
            if (extensionName != null && xsltPath != null) {
                Bundle bundle;
                StyleFromResource ddlStyle = null;
                try {
                    URL url = new URL(xsltPath);
                    String protocol = url.getProtocol();
                    if (protocol != null && protocol.trim().length() != 0) {
                        ddlStyle = new StyleFromUrlStream(extensionName, xsltPath, desc);
                    }
                }
                catch (Throwable throwable) {}
                if (ddlStyle == null && (bundle = Platform.getBundle((String)extension.getNamespaceIdentifier())) != null) {
                    ddlStyle = new StyleFromResource(bundle.getResource(xsltPath), extensionName, desc);
                }
                if (ddlStyle != null) {
                    registry.getStyles().add(ddlStyle);
                }
            }
            ++i;
        }
    }

    public static class EXTENSION_POINT {

        public static class DDL_STYLE {
            public static final String ID = "style";

            public static class ELEMENTS {
                public static final String DESCRIPTION = "description";
                public static final String XSLT_PATH = "xsltPath";
            }
        }
    }
}

