/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl;

import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceSelections;
import org.teiid.designer.ddl.DdlOptions;
import org.teiid.designer.ddl.DdlOptionsImpl;
import org.teiid.designer.ddl.DdlPlugin;
import org.teiid.designer.ddl.DdlWriter;
import org.teiid.designer.ddl.IntermediateFormat;
import org.teiid.designer.ddl.ModelWrapper;

public class DdlWriterImpl
implements DdlWriter {
    public static final int WRITTEN_WITH_NO_PROBLEMS = 4001;
    public static final int UNABLE_TO_GET_EMF_RESOURCE = 4002;
    public static final int WRITE_WITH_WARNINGS = 4003;
    public static final int WRITE_WITH_ERRORS = 4004;
    public static final int WRITE_WITH_WARNINGS_AND_ERRORS = 4005;
    public static final int WRITE_WITH_NO_WARNINGS_AND_ERRORS = 4006;
    public static final int UNEXPECTED_EXCEPTION = 4007;
    public static final int XSLT_PROBLEMS = 4008;
    public static final int UNEXPECTED_IO_EXCEPTION = 4009;
    public static final int TRANSFORMER_CONFIGURATION_EXCEPTION = 4010;
    public static final int ERROR_COMPUTING_RESOURCES_TO_BE_EXPORTED = 4011;
    private final DdlOptions options = new DdlOptionsImpl();

    @Override
    public DdlOptions getOptions() {
        return this.options;
    }

    @Override
    public IStatus write(Resource emfResource, String modelName, String modelFilename, OutputStream stream, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)emfResource);
        CoreArgCheck.isNotNull((Object)stream);
        CoreArgCheck.isNotNull((Object)modelName);
        ModelContents contents = emfResource instanceof EmfResource ? ((EmfResource)emfResource).getModelContents() : new ModelContents(emfResource);
        ModelWrapper wrapper = new ModelWrapper(emfResource, contents, null, modelName, modelFilename);
        IntermediateFormat formatter = new IntermediateFormat(wrapper, this.options, monitor);
        return this.doWrite(formatter, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    @Override
    public IStatus write(ModelResource model, OutputStream stream, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)model);
        CoreArgCheck.isNotNull((Object)stream);
        try {
            Resource emfResource = model.getEmfResource();
            ModelEditor editor = ModelerCore.getModelEditor();
            String modelName = editor.getModelName(model);
            String modelFilename = model.getPath().toString();
            ModelContents contents = ModelContents.getModelContents((ModelResource)model);
            ModelWrapper wrapper = new ModelWrapper(emfResource, contents, null, modelName, modelFilename);
            IntermediateFormat formatter = new IntermediateFormat(wrapper, this.options, monitor);
            return this.doWrite(formatter, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        }
        catch (ModelWorkspaceException e) {
            Object[] params = new Object[]{model.getPath()};
            String msg = DdlPlugin.Util.getString("DdlWriterImpl.Error_getting_EMF_resource", params);
            return new Status(4, "org.teiid.designer.ddl", 4002, msg, (Throwable)e);
        }
    }

    @Override
    public IStatus write(ModelWorkspaceSelections selections, OutputStream stream, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)selections);
        CoreArgCheck.isNotNull((Object)selections.getModelWorkspaceView());
        CoreArgCheck.isNotNull((Object)stream);
        List modelResources = null;
        try {
            modelResources = selections.getSelectedOrPartiallySelectedModelResources();
        }
        catch (ModelWorkspaceException e) {
            return new Status(4, "org.teiid.designer.ddl", 4011, e.getMessage(), (Throwable)e);
        }
        LinkedList<ModelWrapper> wrappers = new LinkedList<ModelWrapper>();
        for (ModelResource modelResource : modelResources) {
            IPath modelPath = modelResource.getPath();
            try {
                Resource emfResource = modelResource.getEmfResource();
                ModelEditor editor = ModelerCore.getModelEditor();
                String modelName = editor.getModelName(modelResource);
                String modelFilename = modelPath.toString();
                ModelContents contents = ModelContents.getModelContents((ModelResource)modelResource);
                ModelWrapper wrapper = new ModelWrapper(emfResource, contents, selections, modelName, modelFilename);
                wrappers.add(wrapper);
            }
            catch (ModelWorkspaceException e) {
                Object[] params = new Object[]{modelPath};
                String msg = DdlPlugin.Util.getString("DdlWriterImpl.Error_getting_EMF_resource", params);
                return new Status(4, "org.teiid.designer.ddl", 4002, msg, (Throwable)e);
            }
        }
        IntermediateFormat formatter = new IntermediateFormat(wrappers, this.options, monitor);
        return this.doWrite(formatter, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    /*
     * Exception decompiling
     */
    protected IStatus doWrite(IntermediateFormat formatter, OutputStream stream, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

