/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.bpel.runtimes.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;
import org.eclipse.wst.web.internal.deployables.FlatComponentDeployable;
import org.jboss.tools.bpel.runtimes.module.BPELDeployable;

public class BPELModuleFactoryDelegate
extends ProjectModuleFactoryDelegate
implements IResourceChangeListener {
    protected Map<IModule, FlatComponentDeployable> moduleDelegates = new HashMap<IModule, FlatComponentDeployable>(5);
    public static final String FACTORY_ID = "org.jboss.tools.bpel.runtimes.module.moduleFactory";
    public static BPELModuleFactoryDelegate FACTORY;

    public static BPELModuleFactoryDelegate factoryInstance() {
        if (FACTORY == null) {
            BPELModuleFactoryDelegate.ensureFactoryLoaded(FACTORY_ID);
        }
        return FACTORY;
    }

    public static void ensureFactoryLoaded(String factoryId) {
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(factoryId)) {
                factories[i].getDelegate((IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
    }

    public void initialize() {
        super.initialize();
        if (this.getId().equals((Object)FACTORY)) {
            FACTORY = this;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected IModule[] createModules(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            return this.createModuleDelegates(component);
        }
        return null;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        if (module == null) {
            return null;
        }
        ModuleDelegate md = (ModuleDelegate)this.moduleDelegates.get(module);
        if (md == null) {
            this.createModules(module.getProject());
            md = (ModuleDelegate)this.moduleDelegates.get(module);
        }
        return md;
    }

    protected boolean canHandleProject(IProject p) {
        return FacetedProjectUtilities.isProjectOfType((IProject)p, (String)"bpel.facet.core") || FacetedProjectUtilities.isProjectOfType((IProject)p, (String)"jbt.bpel.facet.core");
    }

    protected IModule[] createModuleDelegates(IVirtualComponent component) {
        ArrayList<IModule> projectModules;
        block4: {
            if (component == null) {
                return null;
            }
            projectModules = new ArrayList<IModule>();
            try {
                if (this.canHandleProject(component.getProject())) {
                    String type = "bpel.module";
                    String version = "2.0";
                    IModule module = this.createModule(component.getName(), component.getName(), type, version, component.getProject());
                    FlatComponentDeployable moduleDelegate = this.createModuleDelegate(component.getProject(), component);
                    this.moduleDelegates.put(module, moduleDelegate);
                    projectModules.add(module);
                    break block4;
                }
                return null;
            }
            catch (Exception exception) {}
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    protected FlatComponentDeployable createModuleDelegate(IProject project, IVirtualComponent component) {
        return new BPELDeployable(project, component);
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(StructureEdit.MODULE_META_FILE_NAME), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache(IProject project) {
        super.clearCache(project);
        ArrayList<IModule> modulesToRemove = null;
        for (IModule module : this.moduleDelegates.keySet()) {
            if (!module.getProject().equals((Object)project)) continue;
            if (modulesToRemove == null) {
                modulesToRemove = new ArrayList<IModule>();
            }
            modulesToRemove.add(module);
        }
        if (modulesToRemove != null) {
            for (IModule module : modulesToRemove) {
                this.moduleDelegates.remove(module);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.cleanAllDelegates();
    }

    protected void cleanAllDelegates() {
        Iterator<FlatComponentDeployable> i = this.moduleDelegates.values().iterator();
        while (i.hasNext()) {
            i.next().clearCache();
        }
        this.modulesChanged();
    }
}

