/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.bpel.runtimes.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleFullRunner;
import org.jboss.tools.as.core.server.controllable.util.PublishControllerUtility;
import org.jboss.tools.bpel.runtimes.module.BPELPublishDescriptor;
import org.jboss.tools.bpel.runtimes.module.Messages;

public class BPELPublishController
extends AbstractSubsystemController
implements IPublishControllerDelegate {
    private IFilesystemController filesystemController;

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        int publishType = PublishControllerUtility.getPublishType((IServer)this.getServer(), (IModule[])module, (int)kind, (int)deltaKind);
        int publishState = 0;
        IModule last = module[module.length - 1];
        IStatus status = null;
        if (publishType == 3) {
            if (last.getProject() != null) {
                this.removeAll(last.getProject(), monitor);
            }
        } else if (publishType == 2) {
            status = this.fullPublish(module, monitor);
            publishState = 1;
        } else if (publishType == 1) {
            publishState = 2;
        }
        if (status != null && !status.isOK()) {
            final IStatus s = status;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeployError, (String)s.getMessage());
                }
            });
        }
        return publishState;
    }

    private IStatus fullPublish(IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        ArrayList<IStatus> resultList = new ArrayList<IStatus>();
        IModule last = moduleTree[moduleTree.length - 1];
        IModuleResource[] members = ModuleResourceUtil.getResources((IModule)last, (IProgressMonitor)new NullProgressMonitor());
        IStatus hasDeployXmlStatus = this.verifyDeployXmlExists(last, members);
        if (!hasDeployXmlStatus.isOK()) {
            return hasDeployXmlStatus;
        }
        IPath targetSystemDeployPath = this.getTargetSystemDeployPath(moduleTree);
        if (this.shouldZip()) {
            String moduleName = last.getName();
            IPath temporaryArchive = this.getMetadataTemporaryLocation().append(moduleName);
            LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.getServer(), last, temporaryArchive, null);
            IStatus ret = runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
            resultList.add(ret);
            if (ret.isOK()) {
                ret = this.getFilesystemController().copyFile(temporaryArchive.toFile(), targetSystemDeployPath, monitor);
                resultList.add(ret);
            }
        } else {
            PublishModuleFullRunner runner = new PublishModuleFullRunner(this.getFilesystemController(), targetSystemDeployPath);
            IStatus[] results = runner.fullPublish(members, monitor);
            resultList.addAll(Arrays.asList(results));
        }
        BPELPublishDescriptor.addDeployedPathToDescriptor(this.getServer(), last.getProject(), targetSystemDeployPath);
        this.pruneList(resultList);
        if (resultList.size() > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x62020002, NLS.bind((String)org.jboss.ide.eclipse.as.core.Messages.FullPublishFail, (Object)last.getName()), null);
            int i = 0;
            while (i < resultList.size()) {
                ms.add(resultList.get(i));
                ++i;
            }
            return ms;
        }
        return Status.OK_STATUS;
    }

    protected IFilesystemController getFilesystemController() throws CoreException {
        if (this.filesystemController == null) {
            this.filesystemController = (IFilesystemController)this.findDependencyFromBehavior("filesystem");
        }
        return this.filesystemController;
    }

    private IStatus verifyDeployXmlExists(IModule module, IModuleResource[] members) {
        boolean hasDeployXML = false;
        int i = 0;
        while (i < members.length) {
            IModuleResource res = members[i];
            String name = res.getName();
            if ("deploy.xml".equals(name) || "bpel-deploy.xml".equals(name)) {
                hasDeployXML = true;
                break;
            }
            ++i;
        }
        if (!hasDeployXML) {
            Status ms = new Status(4, "org.jboss.ide.eclipse.as.core", 0x62020002, NLS.bind((String)Messages.MissingDeployXML, (Object)module.getName()), null);
            return ms;
        }
        return Status.OK_STATUS;
    }

    private void pruneList(ArrayList<IStatus> list) {
        Iterator<IStatus> i = list.iterator();
        while (i.hasNext()) {
            if (!i.next().isOK()) continue;
            i.remove();
        }
    }

    private boolean shouldZip() {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.getServer());
        return ds == null || ds.zipsWTPDeployments();
    }

    private IPath getTargetSystemDeployPath(IModule[] moduleTree) {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)this.getServer());
        IPath path = ds.getDeploymentLocation(moduleTree, true);
        path = path.removeLastSegments(1).append(BPELPublishController.getNewLastSegment(moduleTree));
        return path;
    }

    private static String getNewLastSegment(IModule[] moduleTree) {
        IModule last = moduleTree[moduleTree.length - 1];
        Calendar cal = Calendar.getInstance();
        StringBuffer lastSeg = new StringBuffer();
        lastSeg.append(last.getName());
        lastSeg.append("-");
        lastSeg.append(BPELPublishController.formatString(cal.get(1)));
        lastSeg.append(BPELPublishController.formatString(cal.get(2) + 1));
        lastSeg.append(BPELPublishController.formatString(cal.get(5)));
        lastSeg.append(BPELPublishController.formatString(cal.get(11)));
        lastSeg.append(BPELPublishController.formatString(cal.get(12)));
        lastSeg.append(BPELPublishController.formatString(cal.get(13)));
        lastSeg.append(".jar");
        return lastSeg.toString();
    }

    private static String formatString(int dateUnit) {
        if (String.valueOf(dateUnit).length() < 2) {
            return "0" + dateUnit;
        }
        return String.valueOf(dateUnit);
    }

    private void removeAll(IProject project, IProgressMonitor monitor) throws CoreException {
        String[] paths = BPELPublishDescriptor.getDeployedPathsFromDescriptor(this.getServer(), project);
        monitor.beginTask("Removing all bpel modules", paths.length * 100);
        IFilesystemController controller = this.getFilesystemController();
        int i = 0;
        while (i < paths.length) {
            controller.deleteResource((IPath)new Path(paths[i]), ProgressMonitorUtil.getSubMon((IProgressMonitor)monitor, (int)100));
            ++i;
        }
        BPELPublishDescriptor.removeProjectFromDescriptor(this.getServer(), project);
    }

    private IPath getMetadataTemporaryLocation() {
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation((IServer)this.getServer()).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }
}

