/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.bpel.runtimes.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;

public class BPELPublishDescriptor {
    private static final String DEPLOYMENTS = "deployments";
    private static final String PROJECT = "project";
    private static final String NAME = "name";
    private static final String VERSION = "version";

    public static String[] getDeployedPathsFromDescriptor(IServer server, IProject project) {
        File f = BPELPublishDescriptor.getDeployDetailsFile(server);
        ArrayList<String> list = new ArrayList<String>();
        if (f.exists()) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
                IMemento[] projects = memento.getChildren(PROJECT);
                int i = 0;
                while (i < projects.length) {
                    if (project.getName().equals(projects[i].getString(NAME))) {
                        IMemento[] deployments = projects[i].getChildren(VERSION);
                        int j = 0;
                        while (j < deployments.length) {
                            String s = ((XMLMemento)deployments[j]).getTextData();
                            if (s != null && !s.equals("")) {
                                list.add(s);
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return list.toArray(new String[list.size()]);
    }

    public static void removeVersionFromDescriptor(IServer server, IProject project, String path) {
        File f = BPELPublishDescriptor.getDeployDetailsFile(server);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
            IMemento[] projects = memento.getChildren(PROJECT);
            int i = 0;
            while (i < projects.length) {
                if (project.getName().equals(projects[i].getString(NAME))) {
                    IMemento[] versions = projects[i].getChildren(VERSION);
                    int j = 0;
                    while (j < versions.length) {
                        if (((XMLMemento)versions[j]).getTextData().equals(path)) {
                            ((XMLMemento)projects[i]).removeChild((XMLMemento)versions[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            BPELPublishDescriptor.save(server, memento);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void removeProjectFromDescriptor(IServer server, IProject project) {
        File f = BPELPublishDescriptor.getDeployDetailsFile(server);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
            IMemento[] projects = memento.getChildren(PROJECT);
            int i = 0;
            while (i < projects.length) {
                if (project.getName().equals(projects[i].getString(NAME))) {
                    memento.removeChild((XMLMemento)projects[i]);
                }
                ++i;
            }
            BPELPublishDescriptor.save(server, memento);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void addDeployedPathToDescriptor(IServer server, IProject project, IPath path) {
        XMLMemento child;
        File f = BPELPublishDescriptor.getDeployDetailsFile(server);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(f));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)DEPLOYMENTS);
        }
        IMemento[] projects = memento.getChildren(PROJECT);
        boolean projectFound = false;
        int i = 0;
        while (i < projects.length) {
            if (project.getName().equals(projects[i].getString(NAME))) {
                projectFound = true;
                child = (XMLMemento)projects[i].createChild(VERSION);
                child.putTextData(path.toOSString());
            }
            ++i;
        }
        if (!projectFound) {
            XMLMemento proj = (XMLMemento)memento.createChild(PROJECT);
            proj.putString(NAME, project.getName());
            child = (XMLMemento)proj.createChild(VERSION);
            child.putTextData(path.toOSString());
        }
        BPELPublishDescriptor.save(server, memento);
    }

    public static void save(IServer server, XMLMemento memento) {
        try {
            memento.save((OutputStream)new FileOutputStream(BPELPublishDescriptor.getDeployDetailsFile(server)));
        }
        catch (IOException iOException) {}
    }

    private static File getDeployDetailsFile(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation((IServer)server).append("bpel.deployment.versions").toFile();
    }
}

