/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.bpel.runtimes.ui.view.server;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.tools.bpel.runtimes.RuntimesPlugin;
import org.jboss.tools.bpel.runtimes.module.BPELPublishDescriptor;
import org.jboss.tools.bpel.runtimes.ui.view.server.BPELModuleContentProvider;

public class BPELModuleActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite actionSite;
    private Action undeployVersionAction;
    private IStructuredSelection lastSelection;

    public void dispose() {
        super.dispose();
    }

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        this.createActions(aSite);
    }

    protected void createActions(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cfr_ignored_0 = (CommonViewer)v;
            ICommonViewerWorkbenchSite cfr_ignored_1 = (ICommonViewerWorkbenchSite)site;
            this.undeployVersionAction = new Action(){

                public void run() {
                    BPELModuleActionProvider.this.runUndeployVersion();
                    BPELModuleActionProvider.this.refreshViewer(BPELModuleActionProvider.this.getLastServer());
                }
            };
            this.undeployVersionAction.setText("Undeploy Version");
            this.undeployVersionAction.setDescription("Undeploy this version of the module");
        }
    }

    protected void runUndeployVersion() {
        Object firstSel = this.lastSelection.getFirstElement();
        if (firstSel instanceof BPELModuleContentProvider.BPELVersionDeployment) {
            BPELModuleContentProvider.BPELVersionDeployment deployment = (BPELModuleContentProvider.BPELVersionDeployment)firstSel;
            BPELModuleActionProvider.removeVersion(deployment.getModuleServer().server, deployment.getProject(), deployment.getPath());
        }
    }

    public static void removeVersion(IServer server, IProject project, String path) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        CoreException ce = null;
        try {
            if (beh != null) {
                IFilesystemController filesystemController = (IFilesystemController)beh.getController("filesystem");
                if (filesystemController != null) {
                    filesystemController.deleteResource((IPath)new Path(path), (IProgressMonitor)new NullProgressMonitor());
                }
                BPELPublishDescriptor.removeVersionFromDescriptor(server, project, path);
                return;
            }
        }
        catch (CoreException ce2) {
            ce = ce2;
        }
        Status s = new Status(4, "org.jboss.tools.bpel.runtimes", "Unable to remove bpel module version", (Throwable)ce);
        RuntimesPlugin.log((Exception)((Object)new CoreException((IStatus)s)), 4);
    }

    protected IServer getLastServer() {
        Object firstSel = this.lastSelection.getFirstElement();
        if (firstSel instanceof IServer) {
            return (IServer)firstSel;
        }
        if (firstSel instanceof ModuleServer) {
            return ((ModuleServer)firstSel).getServer();
        }
        if (firstSel instanceof BPELModuleContentProvider.BPELVersionDeployment) {
            return ((BPELModuleContentProvider.BPELVersionDeployment)firstSel).getModuleServer().getServer();
        }
        return null;
    }

    protected void refreshViewer(Object o) {
        this.actionSite.getStructuredViewer().refresh(o);
    }

    public void fillContextMenu(IMenuManager menu) {
        Object sel;
        this.lastSelection = this.getSelection();
        if (this.lastSelection.size() == 1 && (sel = this.lastSelection.getFirstElement()) instanceof BPELModuleContentProvider.BPELVersionDeployment) {
            menu.add((IAction)this.undeployVersionAction);
        }
    }

    public IStructuredSelection getSelection() {
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            return selection;
        }
        return new StructuredSelection();
    }
}

