/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.comments;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.designer.util.StringConstants;

public class CommentSets
implements StringConstants {
    private Map<String, List<String>> commentsMap;

    public List<String> getElementCommentSet() {
        return this.getCommentSet("");
    }

    public List<String> getCommentSet(String key) {
        if (this.commentsMap == null) {
            return Collections.emptyList();
        }
        List<String> comments = this.commentsMap.get(key);
        if (comments == null) {
            return Collections.emptyList();
        }
        return comments;
    }

    public List<String> getCommentSet(String key, int index) {
        if (this.commentsMap == null) {
            return Collections.emptyList();
        }
        List<String> comments = this.commentsMap.get(String.valueOf(key) + "-" + index);
        if (comments == null) {
            return Collections.emptyList();
        }
        return comments;
    }

    public void addCommentSet(String key, List<String> comments) {
        List<String> commentList;
        if (this.commentsMap == null) {
            this.commentsMap = new HashMap<String, List<String>>();
        }
        if ((commentList = this.commentsMap.get(key)) == null) {
            this.commentsMap.put(key, comments);
        } else {
            commentList.addAll(comments);
        }
    }

    public void addCommentSet(String key, int index, List<String> comments) {
        if (this.commentsMap == null) {
            this.commentsMap = new HashMap<String, List<String>>();
        }
        this.commentsMap.put(String.valueOf(key) + "-" + index, comments);
    }

    public Collection<String> getCommentKeys() {
        if (this.commentsMap == null) {
            return Collections.emptySet();
        }
        return this.commentsMap.keySet();
    }

    public void add(CommentSets comments) {
        if (comments == null) {
            return;
        }
        for (String key : comments.getCommentKeys()) {
            this.addCommentSet(key, comments.getCommentSet(key));
        }
    }

    public String toString() {
        if (this.commentsMap == null) {
            return "No Comments";
        }
        StringBuffer buffer = new StringBuffer("CommentSet: \n");
        for (Map.Entry<String, List<String>> entry : this.commentsMap.entrySet()) {
            String key = entry.getKey();
            if (key.equals("")) {
                key = "<Element>";
            }
            buffer.append(key).append(":").append("\n");
            for (String comment : entry.getValue()) {
                buffer.append(comment).append("\n");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public int size() {
        if (this.commentsMap == null) {
            return 0;
        }
        return this.commentsMap.size();
    }
}

