/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles;

public class Crud {
    public Boolean c;
    public Boolean r;
    public Boolean u;
    public Boolean d;
    public Boolean e;
    public Boolean a;

    public Crud() {
    }

    public Crud(Boolean c, Boolean r, Boolean u, Boolean d, Boolean e, Boolean a) {
        this.c = c;
        this.r = r;
        this.u = u;
        this.d = d;
        this.e = e;
        this.a = a;
    }

    public Crud(Crud crud) {
        this(crud.c, crud.r, crud.u, crud.d, crud.e, crud.a);
    }

    public boolean equivalent(Object obj) {
        if (obj instanceof Crud) {
            Crud target = (Crud)obj;
            if (!this.areSameState(this.c, target.c)) {
                return false;
            }
            if (!this.areSameState(this.r, target.r)) {
                return false;
            }
            if (!this.areSameState(this.u, target.u)) {
                return false;
            }
            if (!this.areSameState(this.d, target.d)) {
                return false;
            }
            if (!this.areSameState(this.e, target.e)) {
                return false;
            }
            if (!this.areSameState(this.a, target.a)) {
                return false;
            }
        }
        return super.equals(obj);
    }

    private boolean areSameState(Boolean a, Boolean b) {
        return a == null && b == null || a == null && b == Boolean.FALSE || b == null && a == Boolean.FALSE;
    }

    private boolean areSameBooleanValues(Boolean a, Boolean b) {
        return a == null && b == null || a == Boolean.FALSE && b == Boolean.FALSE || a == Boolean.TRUE && b == Boolean.TRUE;
    }

    public boolean isSameAs(Crud target) {
        return this.areSameBooleanValues(this.c, target.c) && this.areSameBooleanValues(this.r, target.r) && this.areSameBooleanValues(this.u, target.u) && this.areSameBooleanValues(this.d, target.d) && this.areSameBooleanValues(this.e, target.e) && this.areSameBooleanValues(this.a, target.a);
    }

    public static Type getCrudType(int value) {
        if (value == 2) {
            return Type.CREATE;
        }
        if (value == 3) {
            return Type.READ;
        }
        if (value == 4) {
            return Type.UPDATE;
        }
        if (value == 5) {
            return Type.DELETE;
        }
        if (value == 6) {
            return Type.EXECUTE;
        }
        if (value == 7) {
            return Type.ALTER;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Crud: ");
        sb.append("\n\t").append("c = " + this.c);
        sb.append("\n\t").append("r = " + this.r);
        sb.append("\n\t").append("u = " + this.u);
        sb.append("\n\t").append("d = " + this.d);
        sb.append("\n\t").append("e = " + this.e);
        sb.append("\n\t").append("a = " + this.a);
        return sb.toString();
    }

    public Crud clone() {
        return new Crud(this.c, this.r, this.u, this.d, this.e, this.a);
    }

    public static enum Type {
        CREATE,
        READ,
        UPDATE,
        DELETE,
        EXECUTE,
        ALTER;

    }
}

